/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.platform.DependencySpec;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class DependencyManagementConfig {
    private List<DependencySpec> dependencies = new ArrayList<DependencySpec>();

    public void applyOverrides(DependencyManagementConfig overrides) {
        if (overrides.dependencies.isEmpty()) {
            return;
        }
        if (this.dependencies.isEmpty()) {
            this.dependencies = overrides.dependencies;
            return;
        }
        LinkedHashMap overrideSpecs = new LinkedHashMap(overrides.dependencies.size());
        overrides.dependencies.forEach(d -> overrideSpecs.put(d.getArtifact(), d));
        for (int i = 0; i < this.dependencies.size(); ++i) {
            DependencySpec override = (DependencySpec)overrideSpecs.remove(this.dependencies.get(i).getArtifact());
            if (override == null) continue;
            this.dependencies.set(i, override);
        }
        for (DependencySpec d2 : overrideSpecs.values()) {
            this.dependencies.add(d2);
        }
    }

    public void addDependency(String dependency) {
        DependencySpec dep = new DependencySpec();
        dep.setArtifact(dependency);
        this.dependencies.add(dep);
    }

    public void addDependencySpec(DependencySpec spec) {
        this.dependencies.add(spec);
    }

    public List<DependencySpec> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> toAetherDependencies() {
        if (this.dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>(this.dependencies.size());
        for (DependencySpec dep : this.dependencies) {
            ArtifactCoords coords = ArtifactCoords.fromString((String)dep.getArtifact());
            ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dep.getExclusions().size());
            for (String e : dep.getExclusions()) {
                ArtifactKey key = ArtifactKey.fromString((String)e);
                exclusions.add(new Exclusion(key.getGroupId(), key.getArtifactId(), key.getClassifier(), key.getType()));
            }
            result.add(new Dependency((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()), "compile", null, exclusions));
        }
        return result;
    }
}

