/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.platform.NotPreferredQuarkusBomConstraint;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.maven.ArtifactKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;

public class PlatformBomConfig {
    private PomResolver bomResolver;
    private Artifact bomArtifact;
    private boolean includePlatformProperties;
    private PlatformMember quarkusBom;
    private List<PlatformMember> directDeps = new ArrayList<PlatformMember>();
    private Map<ArtifactKey, Artifact> enforced = new HashMap<ArtifactKey, Artifact>(0);
    private Map<ArtifactKey, Boolean> excluded = new HashMap<ArtifactKey, Boolean>();
    private Set<String> excludedGroups = new HashSet<String>(0);
    private boolean enableNonMemberQuarkiverseExtensions;
    private ArtifactResolver artifactResolver;
    private List<String> versionConstraintPreferences = Collections.emptyList();
    private NotPreferredQuarkusBomConstraint notPreferredQuarkusBomConstraint = NotPreferredQuarkusBomConstraint.ERROR;

    public static Builder builder() {
        return new Builder();
    }

    private PlatformBomConfig() {
    }

    public PomResolver bomResolver() {
        return this.bomResolver;
    }

    public Artifact bomArtifact() {
        return this.bomArtifact;
    }

    public boolean includePlatformProperties() {
        return this.includePlatformProperties;
    }

    public PlatformMember quarkusBom() {
        return this.quarkusBom;
    }

    public List<PlatformMember> externalMembers() {
        return this.directDeps;
    }

    public boolean hasEnforced() {
        return !this.enforced.isEmpty();
    }

    public Map<ArtifactKey, Artifact> enforced() {
        return this.enforced;
    }

    public Artifact enforced(ArtifactKey key) {
        return this.enforced.get(key);
    }

    public boolean hasExcluded() {
        return !this.excluded.isEmpty();
    }

    public boolean isEnableNonMemberQuarkiverseExtensions() {
        return this.enableNonMemberQuarkiverseExtensions;
    }

    public ArtifactResolver artifactResolver() {
        return this.artifactResolver;
    }

    public List<String> versionConstraintPreferences() {
        return this.versionConstraintPreferences;
    }

    public NotPreferredQuarkusBomConstraint notPreferredQuarkusBomConstraint() {
        return this.notPreferredQuarkusBomConstraint;
    }

    boolean excluded(ArtifactKey key) {
        Boolean wildcard = this.excluded.get(key);
        if (wildcard != null) {
            return true;
        }
        if (key.getClassifier().isEmpty() || Boolean.TRUE.equals(wildcard)) {
            return false;
        }
        wildcard = this.excluded.get(PlatformBomConfig.getNonClassifiedKey(key));
        return wildcard != null && !Boolean.FALSE.equals(wildcard);
    }

    private static ArtifactKey getNonClassifiedKey(ArtifactKey key) {
        return new ArtifactKey(key.getGroupId(), key.getArtifactId(), null, "jar");
    }

    public static class Builder {
        final PlatformBomConfig config = new PlatformBomConfig();

        private Builder() {
        }

        public Builder platformBom(Artifact platformBom) {
            this.config.bomArtifact = platformBom;
            return this;
        }

        public Builder includePlatformProperties(boolean includePlatformProperties) {
            this.config.includePlatformProperties = includePlatformProperties;
            return this;
        }

        public Builder addMember(PlatformMember member) {
            if (member.originalBomCoords() != null && member.originalBomCoords().getArtifactId().equals("quarkus-bom") && member.originalBomCoords().getGroupId().equals("io.quarkus")) {
                this.config.quarkusBom = member;
            } else {
                this.config.directDeps.add(member);
            }
            return this;
        }

        public Builder pomResolver(PomResolver pomResolver) {
            this.config.bomResolver = pomResolver;
            return this;
        }

        public Builder enforce(Artifact artifact) {
            this.config.enforced.put(new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()), artifact);
            return this;
        }

        public Builder excludeGroupId(String groupId) {
            this.config.excludedGroups.add(groupId);
            return this;
        }

        public Builder exclude(String groupId, String artifactId) {
            return this.exclude(new ArtifactKey(groupId, artifactId, null, "jar"));
        }

        public Builder exclude(ArtifactKey key) {
            if (key.getClassifier().equals("*")) {
                this.config.excluded.put(PlatformBomConfig.getNonClassifiedKey(key), true);
            } else {
                this.config.excluded.put(key, false);
            }
            return this;
        }

        public Builder enableNonMemberQuarkiverseExtensions(boolean enableNonMemberQuarkiverseExtensions) {
            this.config.enableNonMemberQuarkiverseExtensions = enableNonMemberQuarkiverseExtensions;
            return this;
        }

        public Builder artifactResolver(ArtifactResolver resolver) {
            this.config.artifactResolver = resolver;
            return this;
        }

        public Builder versionConstraintPreference(List<String> preferences) {
            this.config.versionConstraintPreferences = preferences;
            return this;
        }

        public Builder notPreferredQuarkusBomConstraint(NotPreferredQuarkusBomConstraint notPreferredQuarkusBomConstraint) {
            this.config.notPreferredQuarkusBomConstraint = notPreferredQuarkusBomConstraint;
            return this;
        }

        public PlatformBomConfig build() {
            Objects.requireNonNull(this.config.bomResolver);
            if (this.config.bomArtifact == null) {
                throw new IllegalArgumentException("The platform BOM artifact has not been provided");
            }
            if (this.config.quarkusBom == null) {
                throw new IllegalArgumentException("The Quarkus BOM artifact has not been provided");
            }
            return this.config;
        }
    }
}

