/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;

public class PlatformCatalogResolver {
    private final MavenArtifactResolver resolver;
    private final Map<ArtifactKey, ExtensionCatalog> catalogCache = new HashMap<ArtifactKey, ExtensionCatalog>();

    public PlatformCatalogResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
    }

    ExtensionCatalog resolve(Artifact artifact) throws BootstrapMavenException, IOException {
        ArtifactKey key = new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension());
        ExtensionCatalog catalog = this.catalogCache.get(key);
        if (catalog == null) {
            catalog = ExtensionCatalog.fromFile((Path)this.resolver.resolve(artifact).getArtifact().getFile().toPath());
            this.catalogCache.put(key, catalog);
        }
        return catalog;
    }
}

