/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.platform.ExtensionCoordsFilter;
import io.quarkus.bom.platform.ExtensionCoordsFilterFactory;
import io.quarkus.bom.platform.ExtensionFilter;
import io.quarkus.bom.platform.ExtensionInfo;
import io.quarkus.bom.platform.NotPreferredQuarkusBomConstraint;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.bom.platform.ProjectReleaseCollector;
import io.quarkus.bom.platform.VersionConstraintComparator;
import io.quarkus.bom.resolver.ArtifactNotFoundException;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.util.GlobUtil;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class PlatformBomComposer
implements DecomposedBomTransformer,
DecomposedBomVisitor {
    private static final String LOG_COMMON_NOT_MANAGED_DEPS = "logCommonNotManagedDeps";
    private final Map<ReleaseId, ProjectRelease.Builder> quarkusBomReleaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
    private final MessageWriter logger;
    private final ExtensionCoordsFilterFactory extCoordsFilterFactory;
    private ArtifactResolver resolver;
    private Collection<ReleaseVersion> versionsInQuarkusBom = new HashSet<ReleaseVersion>();
    private LinkedHashMap<String, ReleaseId> preferredVersions;
    private Map<ReleaseOrigin, Collection<ProjectRelease>> fixedReleases = new HashMap<ReleaseOrigin, Collection<ProjectRelease>>();
    private Map<ArtifactKey, ProjectDependency> depsAlignedWithQuarkusBom = new HashMap<ArtifactKey, ProjectDependency>();
    private final ProjectReleaseCollector extReleaseCollector = new ProjectReleaseCollector();
    final Map<ArtifactKey, ProjectDependency> externalExtensionDeps = new HashMap<ArtifactKey, ProjectDependency>();
    private final DecomposedBom platformBom;
    private Map<ArtifactKey, PlatformMember> members = new HashMap<ArtifactKey, PlatformMember>();
    private PlatformBomConfig config;
    private VersionConstraintComparator versionComparator;
    private PlatformMember memberBeingProcessed;
    private Map<ArtifactKey, Map<String, Set<String>>> commonNotManagedDeps;
    private Artifact extBom;

    public static DecomposedBom compose(PlatformBomConfig config) throws BomDecomposerException {
        return new PlatformBomComposer(config).platformBom();
    }

    public PlatformBomComposer(PlatformBomConfig config) throws BomDecomposerException {
        this(config, MessageWriter.info());
    }

    public PlatformBomComposer(PlatformBomConfig config, MessageWriter logger) throws BomDecomposerException {
        this.config = config;
        this.logger = logger;
        this.resolver = config.artifactResolver();
        this.extCoordsFilterFactory = ExtensionCoordsFilterFactory.newInstance(config, logger);
        DecomposedBom originalQuarkusBom = BomDecomposer.config().logger(logger).mavenArtifactResolver(this.resolver()).dependencies(this.getOriginalConstraints(config.quarkusBom(), false)).bomArtifact(config.quarkusBom().originalBomCoords() == null ? config.quarkusBom().generatedBomCoords() : config.quarkusBom().originalBomCoords()).decompose();
        config.quarkusBom().setOriginalDecomposedBom(originalQuarkusBom);
        this.initQuarkusBomReleaseBuilders(originalQuarkusBom);
        for (ProjectRelease projectRelease : this.quarkusBomReleaseBuilders.values()) {
            this.fixedReleases.computeIfAbsent(projectRelease.id().origin(), k -> new ArrayList()).add(projectRelease);
        }
        for (PlatformMember platformMember : config.externalMembers()) {
            logger.info("Decomposing " + (platformMember.originalBomCoords() == null ? platformMember.generatedBomCoords() : platformMember.originalBomCoords()));
            this.members.put(platformMember.key(), platformMember);
            DecomposedBom originalBom = BomDecomposer.config().logger(logger).mavenArtifactResolver(this.resolver()).dependencies(this.getOriginalConstraints(platformMember, true)).bomArtifact(platformMember.originalBomCoords() == null ? platformMember.generatedBomCoords() : platformMember.originalBomCoords()).decompose();
            originalBom = ExtensionFilter.getInstance(this.resolver(), logger, platformMember).transform(originalBom);
            platformMember.setOriginalDecomposedBom(originalBom);
            if (platformMember.getOwnGroupIds().isEmpty()) continue;
            block2: for (ProjectRelease r : originalBom.releases()) {
                for (String groupId : r.groupIds()) {
                    if (!platformMember.getOwnGroupIds().contains(groupId)) continue;
                    this.fixedReleases.computeIfAbsent(r.id().origin(), k -> new ArrayList()).add(r);
                    continue block2;
                }
            }
        }
        for (PlatformMember platformMember : config.externalMembers()) {
            logger.info("Aligning " + (platformMember.originalBomCoords() == null ? platformMember.generatedBomCoords() : platformMember.originalBomCoords()));
            this.memberBeingProcessed = platformMember;
            platformMember.originalDecomposedBom().visit((DecomposedBomVisitor)this);
        }
        logger.info("Generating " + config.bomArtifact());
        this.platformBom = this.generatePlatformBom();
        config.quarkusBom().setAlignedDecomposedBom(this.generateQuarkusBom());
        this.updateMemberBoms();
    }

    private void initQuarkusBomReleaseBuilders(DecomposedBom originalQuarkusBom) throws BomDecomposerException {
        PlatformMember quarkusBom = this.config.quarkusBom();
        ExtensionFilter coreFilter = ExtensionFilter.getInstance(this.resolver(), this.logger, quarkusBom);
        DecomposedBom filteredQuarkusBom = coreFilter.transform(originalQuarkusBom);
        filteredQuarkusBom.releases().forEach(r -> {
            ProjectRelease.Builder releaseBuilder = null;
            for (ProjectDependency d : r.dependencies()) {
                ProjectDependency effectiveDep = this.effectiveDep(d);
                if (effectiveDep != null) {
                    if (releaseBuilder == null) {
                        releaseBuilder = this.quarkusBomReleaseBuilders.computeIfAbsent(d.releaseId(), i -> ProjectRelease.builder((ReleaseId)i));
                    }
                    releaseBuilder.add(effectiveDep);
                    this.depsAlignedWithQuarkusBom.put(effectiveDep.key(), effectiveDep);
                    continue;
                }
                this.depsAlignedWithQuarkusBom.put(d.key(), d);
            }
        });
    }

    private DecomposedBom generateQuarkusBom() throws BomDecomposerException {
        DecomposedBom.Builder quarkusBomBuilder = DecomposedBom.builder().bomArtifact(this.config.quarkusBom().generatedBomCoords()).bomSource(PomSource.of((Artifact)this.config.quarkusBom().generatedBomCoords()));
        this.addPlatformArtifacts(this.config.quarkusBom(), quarkusBomBuilder);
        for (ProjectRelease.Builder rb : this.quarkusBomReleaseBuilders.values()) {
            quarkusBomBuilder.addRelease(rb.build());
        }
        return quarkusBomBuilder.build();
    }

    public DecomposedBom platformBom() {
        return this.platformBom;
    }

    private void updateMemberBoms() {
        HashMap releaseBuilders = new HashMap();
        for (PlatformMember member : this.members.values()) {
            releaseBuilders.clear();
            this.acceptOriginalMemberConstraints(member, dep -> {
                ProjectDependency platformDep = this.depsAlignedWithQuarkusBom.get(dep.key());
                if (platformDep == null) {
                    platformDep = this.externalExtensionDeps.get(dep.key());
                }
                if (platformDep == null) {
                    throw new IllegalStateException("Failed to locate " + dep.key() + " in the generated platform BOM");
                }
                if (member.config().isKeepThirpartyExclusions() && !dep.dependency().getExclusions().equals(platformDep.dependency().getExclusions())) {
                    platformDep = ProjectDependency.create((ReleaseId)dep.releaseId(), (Dependency)new Dependency(platformDep.artifact(), dep.dependency().getScope(), Boolean.valueOf(dep.dependency().isOptional()), dep.dependency().getExclusions()));
                }
                releaseBuilders.computeIfAbsent(platformDep.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(platformDep);
            });
            Artifact generatedBomArtifact = member.generatedBomCoords();
            DecomposedBom.Builder updatedBom = DecomposedBom.builder().bomArtifact(generatedBomArtifact).bomSource(PomSource.of((Artifact)generatedBomArtifact));
            for (ProjectRelease.Builder releaseBuilder : releaseBuilders.values()) {
                updatedBom.addRelease(releaseBuilder.build());
            }
            this.addPlatformArtifacts(member, updatedBom);
            member.setAlignedDecomposedBom(updatedBom.build());
        }
    }

    private void acceptOriginalMemberConstraints(PlatformMember member, Consumer<ProjectDependency> consumer) {
        for (ProjectRelease release : member.originalDecomposedBom().releases()) {
            for (ProjectDependency dep : release.dependencies()) {
                if (this.config.excluded(dep.key())) continue;
                consumer.accept(dep);
            }
        }
    }

    private void acceptConstraints(Collection<ProjectRelease.Builder> releaseBuilders, Consumer<ProjectDependency> consumer) throws BomDecomposerException {
        for (ProjectRelease.Builder b : releaseBuilders) {
            for (ProjectDependency dep : b.dependencies()) {
                consumer.accept(dep);
            }
        }
    }

    private void addPlatformArtifacts(PlatformMember memberConfig, DecomposedBom.Builder updatedBom) {
        Artifact generatedBomArtifact = memberConfig.generatedBomCoords();
        if (!generatedBomArtifact.equals(memberConfig.originalBomCoords())) {
            ReleaseId memberReleaseId = ReleaseIdFactory.create((ReleaseOrigin)ReleaseOrigin.Factory.ga((String)generatedBomArtifact.getGroupId(), (String)generatedBomArtifact.getArtifactId()), (ReleaseVersion)ReleaseVersion.Factory.version((String)generatedBomArtifact.getVersion()));
            ProjectRelease memberRelease = ProjectRelease.builder((ReleaseId)memberReleaseId).add(ProjectDependency.create((ReleaseId)memberReleaseId, (Artifact)new DefaultArtifact(generatedBomArtifact.getGroupId(), generatedBomArtifact.getArtifactId() + "-quarkus-platform-descriptor", generatedBomArtifact.getVersion(), "json", generatedBomArtifact.getVersion()))).add(ProjectDependency.create((ReleaseId)memberReleaseId, (Artifact)new DefaultArtifact(generatedBomArtifact.getGroupId(), generatedBomArtifact.getArtifactId() + "-quarkus-platform-properties", null, "properties", generatedBomArtifact.getVersion()))).build();
            updatedBom.addRelease(memberRelease);
        }
    }

    private ExtensionInfo getExtensionInfoOrNull(Artifact a) {
        Properties props;
        File f = a.getFile();
        if (f == null) {
            try {
                f = this.resolver().resolve(a).getArtifact().getFile();
            }
            catch (ArtifactNotFoundException e) {
                return null;
            }
        }
        if (f.isDirectory()) {
            props = PlatformBomComposer.loadPropertiesOrNull(f.toPath().resolve("META-INF/quarkus-extension.properties"));
        } else {
            try (FileSystem fs = FileSystems.newFileSystem(f.toPath(), (ClassLoader)null);){
                props = PlatformBomComposer.loadPropertiesOrNull(fs.getPath("META-INF/quarkus-extension.properties", new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read " + f, e);
            }
        }
        if (props == null) {
            return null;
        }
        String deploymentStr = props.getProperty("deployment-artifact");
        if (deploymentStr == null) {
            throw new IllegalStateException(a + " does not include the corresponding deployment artifact coordinates in its META-INF/quarkus-extension.properties");
        }
        ArtifactCoords deploymentCoords = ArtifactCoords.fromString((String)deploymentStr);
        return new ExtensionInfo(a, (Artifact)new DefaultArtifact(deploymentCoords.getGroupId(), deploymentCoords.getArtifactId(), deploymentCoords.getClassifier(), deploymentCoords.getType(), deploymentCoords.getVersion()));
    }

    private static Properties loadPropertiesOrNull(Path p) {
        Properties properties;
        block9: {
            if (!Files.exists(p, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(p);
            try {
                Properties props = new Properties();
                props.load(reader);
                properties = props;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read " + p, e);
                }
            }
            reader.close();
        }
        return properties;
    }

    private DecomposedBom generatePlatformBom() throws BomDecomposerException {
        HashMap<ReleaseId, ProjectRelease.Builder> platformReleaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        ReleaseId bomReleaseId = ReleaseIdFactory.create((ReleaseOrigin)ReleaseOrigin.Factory.ga((String)this.config.bomArtifact().getGroupId(), (String)this.config.bomArtifact().getArtifactId()), (ReleaseVersion)ReleaseVersion.Factory.version((String)this.config.bomArtifact().getVersion()));
        ProjectRelease.Builder bomReleaseBuilder = ProjectRelease.builder((ReleaseId)bomReleaseId).add(ProjectDependency.create((ReleaseId)bomReleaseId, (Artifact)new DefaultArtifact(this.config.bomArtifact().getGroupId(), this.config.bomArtifact().getArtifactId() + "-quarkus-platform-descriptor", this.config.bomArtifact().getVersion(), "json", this.config.bomArtifact().getVersion())));
        if (this.config.includePlatformProperties()) {
            bomReleaseBuilder.add(ProjectDependency.create((ReleaseId)bomReleaseId, (Artifact)new DefaultArtifact(this.config.bomArtifact().getGroupId(), this.config.bomArtifact().getArtifactId() + "-quarkus-platform-properties", null, "properties", this.config.bomArtifact().getVersion())));
        }
        platformReleaseBuilders.put(bomReleaseId, bomReleaseBuilder);
        for (ProjectDependency projectDependency : this.depsAlignedWithQuarkusBom.values()) {
            ProjectDependency projectDependency2 = this.effectiveDep(projectDependency);
            if (projectDependency2 == null) continue;
            platformReleaseBuilders.computeIfAbsent(projectDependency2.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency2);
        }
        for (Collection collection : this.extReleaseCollector.getOriginReleaseBuilders()) {
            if (collection.size() == 1) {
                this.mergeExtensionDeps((ProjectRelease)collection.iterator().next(), this.externalExtensionDeps);
                continue;
            }
            LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions(collection);
            block2: for (ProjectRelease release : collection) {
                for (Map.Entry<String, ReleaseId> preferred : preferredVersions.entrySet()) {
                    if (release.id().equals(preferred.getValue())) {
                        this.mergeExtensionDeps(release, this.externalExtensionDeps);
                        continue block2;
                    }
                    for (ProjectDependency dep : release.dependencies()) {
                        if (this.depsAlignedWithQuarkusBom.containsKey(dep.key())) continue;
                        String depVersion = dep.artifact().getVersion();
                        if (!preferred.getKey().equals(depVersion)) {
                            for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                                Artifact artifact = dep.artifact().setVersion(preferredVersion.getKey());
                                if (this.resolver().resolveOrNull(artifact) == null) continue;
                                dep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)dep.dependency().setArtifact(artifact));
                                break;
                            }
                        }
                        this.addNonQuarkusDep(dep, this.externalExtensionDeps);
                    }
                }
            }
        }
        for (ProjectDependency projectDependency : this.externalExtensionDeps.values()) {
            platformReleaseBuilders.computeIfAbsent(projectDependency.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency);
        }
        this.logCommonNotManagedDeps(platformReleaseBuilders);
        DecomposedBom.Builder platformBuilder = DecomposedBom.builder().bomArtifact(this.config.bomArtifact()).bomSource(this.config.bomResolver());
        for (ProjectRelease.Builder builder : platformReleaseBuilders.values()) {
            platformBuilder.addRelease(builder.build());
        }
        return platformBuilder.build();
    }

    private void logCommonNotManagedDeps(Map<ReleaseId, ProjectRelease.Builder> releaseBuilders) throws BomDecomposerException {
        String logCommonNotManagedDeps = System.getProperty(LOG_COMMON_NOT_MANAGED_DEPS);
        if (logCommonNotManagedDeps == null || !logCommonNotManagedDeps.isEmpty() && !Boolean.parseBoolean(logCommonNotManagedDeps)) {
            return;
        }
        this.logger.info("Collecting extension common not managed dependencies");
        this.commonNotManagedDeps = new HashMap<ArtifactKey, Map<String, Set<String>>>();
        HashMap<ArtifactKey, ProjectDependency> universeConstraints = new HashMap<ArtifactKey, ProjectDependency>();
        for (ProjectRelease.Builder r : releaseBuilders.values()) {
            r.dependencies().forEach(d -> universeConstraints.put(new ArtifactKey(d.artifact().getGroupId(), d.artifact().getArtifactId(), d.artifact().getClassifier(), d.artifact().getExtension()), (ProjectDependency)d));
        }
        this.collectNotManagedExtensionDeps(this.config.quarkusBom(), universeConstraints);
        for (PlatformMember member : this.config.externalMembers()) {
            this.collectNotManagedExtensionDeps(member, universeConstraints);
        }
        HashMap<ReleaseOrigin, ProjectRelease.Builder> releaseBuildersByOrigin = new HashMap<ReleaseOrigin, ProjectRelease.Builder>(releaseBuilders.size());
        for (Map.Entry<ReleaseId, ProjectRelease.Builder> entry : releaseBuilders.entrySet()) {
            releaseBuildersByOrigin.put(entry.getKey().origin(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.commonNotManagedDeps.entrySet()) {
            if (((Map)entry.getValue()).size() == 1 || universeConstraints.containsKey(entry.getKey())) continue;
            Set strVersions = ((Map)entry.getValue()).keySet();
            ArrayList<DefaultArtifactVersion> versions = new ArrayList<DefaultArtifactVersion>(strVersions.size());
            for (String string : strVersions) {
                versions.add(new DefaultArtifactVersion(string));
            }
            Collections.sort(versions);
            for (ArtifactVersion artifactVersion : versions) {
                ReleaseId releaseId;
                Path pom = this.resolver().resolve((Artifact)new DefaultArtifact(((ArtifactKey)entry.getKey()).getGroupId(), ((ArtifactKey)entry.getKey()).getArtifactId(), null, "pom", artifactVersion.toString())).getArtifact().getFile().toPath();
                try {
                    releaseId = ReleaseIdFactory.forModel((Model)ModelUtils.readModel((Path)pom));
                }
                catch (IOException e1) {
                    throw new BomDecomposerException("Failed to determine the release ID for " + pom, (Throwable)e1);
                }
                ProjectRelease.Builder rb = (ProjectRelease.Builder)releaseBuildersByOrigin.get(releaseId.origin());
                if (rb == null) continue;
                this.logger.info("NON-MANAGED FAMILY " + entry.getKey() + ":" + artifactVersion);
                if (rb.id().equals(releaseId)) {
                    this.logger.info("  release id match");
                    break;
                }
                if (rb.artifactVersions().contains(artifactVersion.toString())) {
                    this.logger.info("  version match");
                    break;
                }
                this.logger.info("  not matched " + rb.artifactVersions());
            }
            this.logger.info(((ArtifactKey)entry.getKey()).toGacString());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                StringBuilder buf = new StringBuilder();
                buf.append("  ").append((String)entry2.getKey()).append(": ");
                ArrayList list = new ArrayList((Collection)entry2.getValue());
                Collections.sort(list);
                buf.append((String)list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    buf.append(", ").append((String)list.get(i));
                }
                this.logger.info(buf.toString());
            }
        }
    }

    private void collectNotManagedExtensionDeps(final PlatformMember member, Map<ArtifactKey, ProjectDependency> universalConstraints) throws BomDecomposerException {
        final ArrayList combinedConstraints = new ArrayList();
        ArrayList memberSpecificConstraints = new ArrayList();
        final HashSet constraintKeys = new HashSet();
        for (ProjectRelease.Builder r : this.quarkusBomReleaseBuilders.values()) {
            r.dependencies().forEach(d -> {
                combinedConstraints.add(d.dependency());
                constraintKeys.add(new ArtifactKey(d.artifact().getGroupId(), d.artifact().getArtifactId(), d.artifact().getClassifier(), d.artifact().getExtension()));
            });
        }
        final List<String> extensionGroupIds = member.getExtensionGroupIds();
        Consumer<ProjectDependency> c = new Consumer<ProjectDependency>(){

            @Override
            public void accept(ProjectDependency dep) {
                Artifact a = dep.artifact();
                if (!extensionGroupIds.isEmpty() && !extensionGroupIds.contains(a.getGroupId()) || !a.getExtension().equals("jar") || a.getArtifactId().endsWith("-deployment") || a.getClassifier().equals("javadoc") || a.getClassifier().equals("sources") || a.getClassifier().equals("tests") || dep.dependency().getScope().equals("test")) {
                    return;
                }
                ExtensionInfo ext = PlatformBomComposer.this.getExtensionInfoOrNull(a);
                if (ext == null) {
                    return;
                }
                PlatformBomComposer.this.collectNotManagedDependencies(PlatformBomComposer.this.collectDependencies(a, combinedConstraints).getChildren(), constraintKeys, member, a);
                PlatformBomComposer.this.collectNotManagedDependencies(PlatformBomComposer.this.collectDependencies(ext.getDeployment(), combinedConstraints).getChildren(), constraintKeys, member, ext.getDeployment());
            }
        };
        if (this.config.quarkusBom() != member) {
            this.acceptOriginalMemberConstraints(member, d -> {
                if (constraintKeys.add(d.key())) {
                    ProjectDependency alignedDep = (ProjectDependency)universalConstraints.get(d.key());
                    combinedConstraints.add(alignedDep.dependency());
                    memberSpecificConstraints.add(alignedDep);
                }
            });
            memberSpecificConstraints.forEach(c);
        } else {
            this.acceptConstraints(this.quarkusBomReleaseBuilders.values(), c);
        }
    }

    private void collectNotManagedDependencies(Collection<DependencyNode> depNodes, Set<ArtifactKey> constraints, PlatformMember member, Artifact root) {
        for (DependencyNode node : depNodes) {
            this.collectNotManagedDependencies(node.getChildren(), constraints, member, root);
            Artifact a = node.getArtifact();
            ArtifactKey key = new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
            if (a == null || constraints.contains(key)) continue;
            this.commonNotManagedDeps.computeIfAbsent(key, k -> new HashMap()).computeIfAbsent(a.getVersion(), k -> new HashSet()).add(member.config().getName());
        }
    }

    private DependencyNode collectDependencies(Artifact a, List<Dependency> constraints) {
        DependencyNode root;
        try {
            root = this.resolver().underlyingResolver().collectManagedDependencies(a, Collections.emptyList(), constraints, Collections.emptyList(), Collections.emptyList(), new String[]{"test", "provided"}).getRoot();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to collect dependencies of " + a, e);
        }
        return root;
    }

    private ProjectDependency effectiveDep(ProjectDependency dep) {
        if (this.config.excluded(dep.key())) {
            return null;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced == null) {
            return dep;
        }
        return ProjectDependency.create((ReleaseId)dep.releaseId(), (Dependency)dep.dependency().setArtifact(enforced));
    }

    private void mergeExtensionDeps(ProjectRelease release, Map<ArtifactKey, ProjectDependency> extensionDeps) throws BomDecomposerException {
        for (ProjectDependency dep : release.dependencies()) {
            ProjectDependency quarkusBomDep = this.depsAlignedWithQuarkusBom.get(dep.key());
            if (quarkusBomDep != null) {
                this.quarkusBomDependencyInMemberBom(quarkusBomDep, dep);
                return;
            }
            this.addNonQuarkusDep(dep, extensionDeps);
        }
    }

    private void addNonQuarkusDep(ProjectDependency dep, Map<ArtifactKey, ProjectDependency> extensionDeps) {
        if (this.config.excluded(dep.key())) {
            return;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced != null) {
            if (!extensionDeps.containsKey(dep.key())) {
                extensionDeps.put(dep.key(), ProjectDependency.create((ReleaseId)dep.releaseId(), (Artifact)enforced));
            }
            return;
        }
        ProjectDependency currentDep = extensionDeps.get(dep.key());
        if (currentDep != null) {
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(currentDep.artifact().getVersion());
            DefaultArtifactVersion newVersion = new DefaultArtifactVersion(dep.artifact().getVersion());
            if (this.versionConstraintComparator().compare((ArtifactVersion)currentVersion, (ArtifactVersion)newVersion) < 0) {
                extensionDeps.put(dep.key(), dep);
            }
        } else {
            extensionDeps.put(dep.key(), dep);
        }
    }

    public DecomposedBom transform(DecomposedBom decomposedBom) throws BomDecomposerException {
        decomposedBom.visit((DecomposedBomVisitor)this);
        return decomposedBom;
    }

    public void enterBom(Artifact bomArtifact) {
        this.extBom = bomArtifact;
    }

    public boolean enterReleaseOrigin(ReleaseOrigin releaseOrigin, int versions) {
        this.preferredVersions = null;
        this.versionsInQuarkusBom.clear();
        Collection<ProjectRelease> releases = this.fixedReleases.get(releaseOrigin);
        if (releases != null) {
            releases.forEach(r -> this.versionsInQuarkusBom.add(r.id().version()));
        }
        return true;
    }

    public void leaveReleaseOrigin(ReleaseOrigin releaseOrigin) throws BomDecomposerException {
    }

    public void visitProjectRelease(ProjectRelease release) throws BomDecomposerException {
        if (this.versionsInQuarkusBom.isEmpty()) {
            ProjectRelease.Builder releaseBuilder = this.extReleaseCollector.getOrCreateReleaseBuilder(release.id(), this.memberBeingProcessed);
            for (ProjectDependency dep : release.dependencies()) {
                releaseBuilder.add(dep);
            }
            return;
        }
        if (this.versionsInQuarkusBom.contains(release.id().version())) {
            for (ProjectDependency dep : release.dependencies()) {
                ProjectDependency quarkusBomDep = this.depsAlignedWithQuarkusBom.putIfAbsent(dep.key(), dep);
                if (quarkusBomDep == null) continue;
                this.quarkusBomDependencyInMemberBom(quarkusBomDep, dep);
            }
            return;
        }
        LinkedHashMap<String, ReleaseId> preferredVersions = this.getPreferredVersions(release.id().origin());
        Iterator iterator = release.dependencies().iterator();
        while (iterator.hasNext()) {
            ProjectDependency quarkusBomDep;
            ProjectDependency memberDep;
            ProjectDependency preferredDep = memberDep = (ProjectDependency)iterator.next();
            if (!preferredVersions.containsKey(memberDep.artifact().getVersion())) {
                for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                    Artifact artifact = memberDep.artifact().setVersion(preferredVersion.getKey());
                    if (this.resolver().resolveOrNull(artifact) == null) continue;
                    preferredDep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)memberDep.dependency().setArtifact(artifact));
                    break;
                }
            }
            if ((quarkusBomDep = this.depsAlignedWithQuarkusBom.putIfAbsent(preferredDep.key(), preferredDep)) == null) continue;
            this.quarkusBomDependencyInMemberBom(quarkusBomDep, memberDep);
        }
    }

    private LinkedHashMap<String, ReleaseId> getPreferredVersions(ReleaseOrigin origin) {
        Collection<ProjectRelease> releases;
        if (this.preferredVersions == null && (releases = this.fixedReleases.get(origin)) != null) {
            this.preferredVersions = this.preferredVersions(releases);
        }
        return this.preferredVersions;
    }

    private void quarkusBomDependencyInMemberBom(ProjectDependency quarkusBomDep, ProjectDependency memberDep) throws BomDecomposerException {
        if (!quarkusBomDep.artifact().getVersion().equals(memberDep.artifact().getVersion()) && this.versionConstraintComparator().hasVersionPreferences() && this.versionConstraintComparator().isPreferredVersion((ArtifactVersion)new DefaultArtifactVersion(memberDep.artifact().getVersion())) && !this.versionConstraintComparator().isPreferredVersion((ArtifactVersion)new DefaultArtifactVersion(quarkusBomDep.artifact().getVersion()))) {
            StringBuilder buf = new StringBuilder();
            buf.append("Preferred constraint ").append(memberDep.artifact()).append(" was rejected in favor of ").append(quarkusBomDep.artifact()).append(" managed by the quarkus-bom");
            if (this.config.notPreferredQuarkusBomConstraint() == NotPreferredQuarkusBomConstraint.ERROR) {
                throw new BomDecomposerException(buf.toString());
            }
            if (this.config.notPreferredQuarkusBomConstraint() == NotPreferredQuarkusBomConstraint.WARN) {
                this.logger.warn(buf.toString());
            }
        }
    }

    public void leaveBom() throws BomDecomposerException {
    }

    private VersionConstraintComparator versionConstraintComparator() {
        if (this.versionComparator == null) {
            List<Pattern> preferences;
            if (this.config.versionConstraintPreferences().isEmpty()) {
                preferences = Collections.emptyList();
            } else {
                preferences = new ArrayList<Pattern>(this.config.versionConstraintPreferences().size());
                for (String expr : this.config.versionConstraintPreferences()) {
                    preferences.add(Pattern.compile(GlobUtil.toRegexPattern((String)expr)));
                }
            }
            this.versionComparator = new VersionConstraintComparator(preferences);
        }
        return this.versionComparator;
    }

    private LinkedHashMap<String, ReleaseId> preferredVersions(Collection<ProjectRelease> releases) {
        TreeMap<ArtifactVersion, ReleaseId> treeMap = new TreeMap<ArtifactVersion, ReleaseId>(Collections.reverseOrder(this.versionConstraintComparator()));
        for (ProjectRelease release : releases) {
            for (String versionStr : release.artifactVersions()) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(versionStr);
                ReleaseId prevReleaseId = treeMap.put((ArtifactVersion)version, release.id());
                if (prevReleaseId == null || new DefaultArtifactVersion(prevReleaseId.version().asString()).compareTo((ArtifactVersion)new DefaultArtifactVersion(release.id().version().asString())) <= 0) continue;
                treeMap.put((ArtifactVersion)version, prevReleaseId);
            }
        }
        LinkedHashMap<String, ReleaseId> result = new LinkedHashMap<String, ReleaseId>(treeMap.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            result.put(entry.getKey().toString(), (ReleaseId)entry.getValue());
        }
        return result;
    }

    private Collection<Dependency> getOriginalConstraints(PlatformMember member, boolean filtered) throws BomDecomposerException {
        HashMap<ArtifactKey, Dependency> result = null;
        ArrayList<DefaultArtifact> importedPlatformBoms = new ArrayList<DefaultArtifact>(0);
        ExtensionCoordsFilter extCoordsFilter = this.extCoordsFilterFactory.forMember(member);
        for (Dependency d : member.inputConstraints()) {
            if ("import".equals(d.getScope())) {
                Artifact bom = d.getArtifact();
                ArtifactDescriptorResult bomDescr = this.describe(bom);
                importedPlatformBoms.clear();
                List allDeps = bomDescr.getManagedDependencies();
                HashMap<ArtifactKey, Dependency> bomConstraints = new HashMap<ArtifactKey, Dependency>(allDeps.size());
                for (Dependency dependency : allDeps) {
                    Artifact artifact = dependency.getArtifact();
                    if (filtered && PlatformArtifacts.isCatalogArtifactId((String)artifact.getArtifactId())) {
                        importedPlatformBoms.add(new DefaultArtifact(artifact.getGroupId(), PlatformArtifacts.ensureBomArtifactId((String)artifact.getArtifactId()), "pom", artifact.getVersion()));
                    }
                    if (filtered && extCoordsFilter.isExcludeFromBom(artifact)) continue;
                    bomConstraints.put(PlatformBomComposer.key(artifact), dependency);
                }
                for (Artifact artifact : importedPlatformBoms) {
                    this.subtractPlatformBom(bomConstraints, artifact);
                }
                if (result == null) {
                    result = bomConstraints;
                    continue;
                }
                for (Map.Entry entry : bomConstraints.entrySet()) {
                    result.putIfAbsent((ArtifactKey)entry.getKey(), (Dependency)entry.getValue());
                }
                continue;
            }
            if (result == null) {
                result = new HashMap<ArtifactKey, Dependency>();
            }
            result.put(PlatformBomComposer.key(d.getArtifact()), d);
        }
        return result.values();
    }

    private static ArtifactKey key(Artifact artifact) {
        return new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension());
    }

    private void subtractPlatformBom(Map<ArtifactKey, Dependency> result, Artifact quarkusCoreBom) throws BomDecomposerException {
        try {
            ArtifactDescriptorResult quarkusBomDescr = this.describe(quarkusCoreBom);
            for (Dependency quarkusBomDep : quarkusBomDescr.getManagedDependencies()) {
                result.remove(PlatformBomComposer.key(quarkusBomDep.getArtifact()));
            }
        }
        catch (BomDecomposerException e) {
            this.logger.debug("Failed to subtract %s: %s", new Object[]{quarkusCoreBom, e.getLocalizedMessage()});
            throw e;
        }
    }

    private ArtifactDescriptorResult describe(Artifact artifact) throws BomDecomposerException {
        return this.resolver().describe(artifact);
    }

    private ArtifactResolver resolver() {
        return this.resolver == null ? (this.resolver = ArtifactResolverProvider.get()) : this.resolver;
    }
}

