/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ProjectReleaseCollector {
    private Map<ReleaseOrigin, ReleaseOriginBuilder> originBuilders = new HashMap<ReleaseOrigin, ReleaseOriginBuilder>();

    ProjectReleaseCollector() {
    }

    ProjectRelease.Builder getOrCreateReleaseBuilder(ReleaseId releaseId, PlatformMember member) {
        ReleaseOriginBuilder releaseBuilder = this.originBuilders.computeIfAbsent(releaseId.origin(), id -> new ReleaseOriginBuilder());
        releaseBuilder.members.putIfAbsent(member.key(), member);
        return releaseBuilder.builders.computeIfAbsent(releaseId.version(), id -> ProjectRelease.builder((ReleaseId)releaseId));
    }

    Collection<Collection<ProjectRelease>> getOriginReleaseBuilders() {
        ArrayList<Collection<ProjectRelease>> result = new ArrayList<Collection<ProjectRelease>>(this.originBuilders.size());
        for (ReleaseOriginBuilder originReleases : this.originBuilders.values()) {
            if (originReleases.isAlignConstraints()) {
                ArrayList<ProjectRelease> releases = new ArrayList<ProjectRelease>(originReleases.builders.size());
                for (ProjectRelease.Builder builder : originReleases.builders.values()) {
                    releases.add(builder.build());
                }
                result.add(releases);
                continue;
            }
            for (ProjectRelease.Builder builder : originReleases.builders.values()) {
                result.add(Collections.singletonList(builder.build()));
            }
        }
        return result;
    }

    private static class ReleaseOriginBuilder {
        final Map<ArtifactKey, PlatformMember> members = new HashMap<ArtifactKey, PlatformMember>();
        final Map<ReleaseVersion, ProjectRelease.Builder> builders = new HashMap<ReleaseVersion, ProjectRelease.Builder>();

        private ReleaseOriginBuilder() {
        }

        boolean isAlignConstraints() {
            return this.members.size() > 1 || this.members.values().iterator().next().config().isAlignOwnConstraints();
        }
    }
}

