/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.DefaultMessageWriter;
import io.quarkus.bom.decomposer.MessageWriter;
import io.quarkus.bom.decomposer.PomUtils;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.HtmlBomDiffReportGenerator;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

public class PlatformBomComposer
implements DecomposedBomTransformer,
DecomposedBomVisitor {
    private final DecomposedBom quarkusBom;
    private final MessageWriter logger = new DefaultMessageWriter();
    private MavenArtifactResolver resolver;
    private Collection<ReleaseVersion> quarkusVersions;
    private LinkedHashMap<String, ReleaseId> preferredVersions;
    private boolean transformingBom;
    private Map<AppArtifactKey, ProjectDependency> quarkusBomDeps = new HashMap<AppArtifactKey, ProjectDependency>();
    private Map<ReleaseOrigin, Map<ReleaseVersion, ProjectRelease.Builder>> externalReleaseDeps = new HashMap<ReleaseOrigin, Map<ReleaseVersion, ProjectRelease.Builder>>();
    final Map<AppArtifactKey, ProjectDependency> externalExtensionDeps = new HashMap<AppArtifactKey, ProjectDependency>();
    private List<DecomposedBom> importedBoms = new ArrayList<DecomposedBom>();
    private Map<Artifact, DecomposedBom> originalImportedBoms = new HashMap<Artifact, DecomposedBom>();
    private Set<Artifact> bomsNotImportingQuarkusBom = new HashSet<Artifact>();
    private final DecomposedBom platformBom;
    private final DecomposedBom originalPlatformBom;
    private PlatformBomConfig config;
    private Artifact extBom;

    public static DecomposedBom compose(PlatformBomConfig config) throws BomDecomposerException {
        return new PlatformBomComposer(config).platformBom();
    }

    public PlatformBomComposer(PlatformBomConfig config) throws BomDecomposerException {
        this.config = config;
        this.originalPlatformBom = BomDecomposer.config().mavenArtifactResolver(this.resolver()).logger(this.logger).bomArtifact(config.bomArtifact()).checkForUpdates().decompose();
        this.quarkusBom = BomDecomposer.config().logger(this.logger).mavenArtifactResolver(this.resolver()).bomArtifact(config.quarkusBom()).decompose();
        this.quarkusBom.releases().forEach(r -> r.dependencies().forEach(d -> this.quarkusBomDeps.put(d.key(), (ProjectDependency)d)));
        for (Dependency directDep : config.directDeps()) {
            Collection<Dependency> bomDeps;
            this.transformingBom = "import".equals(directDep.getScope());
            if (this.transformingBom) {
                bomDeps = this.managedDepsExcludingQuarkusBom(directDep.getArtifact());
                DecomposedBom originalBom = BomDecomposer.config().mavenArtifactResolver(this.resolver()).logger(this.logger).bomArtifact(directDep.getArtifact()).checkForUpdates().decompose();
                this.originalImportedBoms.put(originalBom.bomArtifact(), originalBom);
            } else {
                bomDeps = Collections.singleton(directDep);
            }
            BomDecomposer.config().mavenArtifactResolver(this.resolver()).logger(this.logger).bomArtifact(directDep.getArtifact()).checkForUpdates().dependencies(bomDeps).transform((DecomposedBomTransformer)this).decompose();
        }
        this.platformBom = this.generatePlatformBom();
        this.generatedUpdatedImportedBoms();
    }

    public DecomposedBom originalPlatformBom() {
        return this.originalPlatformBom;
    }

    public DecomposedBom platformBom() {
        return this.platformBom;
    }

    public List<DecomposedBom> upgradedImportedBoms() {
        return this.importedBoms;
    }

    public DecomposedBom originalImportedBom(Artifact artifact) {
        return this.originalImportedBoms.get(artifact);
    }

    private void generatedUpdatedImportedBoms() {
        HashSet<AppArtifactKey> bomDeps = new HashSet<AppArtifactKey>();
        HashMap<ReleaseId, ProjectRelease.Builder> releaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        int i = 0;
        while (i < this.importedBoms.size()) {
            bomDeps.clear();
            releaseBuilders.clear();
            DecomposedBom importedBomMinusQuarkusBom = this.importedBoms.get(i);
            if (!this.bomsNotImportingQuarkusBom.contains(importedBomMinusQuarkusBom.bomArtifact())) {
                this.quarkusBom.releases().forEach(r -> r.dependencies().forEach(d -> {
                    if (!this.config.excluded(d.key())) {
                        bomDeps.add(d.key());
                        releaseBuilders.computeIfAbsent(d.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(d);
                    }
                }));
            }
            for (ProjectRelease release : importedBomMinusQuarkusBom.releases()) {
                for (ProjectDependency dep : release.dependencies()) {
                    if (!bomDeps.add(dep.key()) || this.config.excluded(dep.key())) continue;
                    ProjectDependency platformDep = this.quarkusBomDeps.get(dep.key());
                    if (platformDep == null) {
                        platformDep = this.externalExtensionDeps.get(dep.key());
                    }
                    if (platformDep == null) {
                        throw new IllegalStateException("Failed to locate " + dep.key() + " in the generated platform BOM");
                    }
                    releaseBuilders.computeIfAbsent(platformDep.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(platformDep);
                }
            }
            DecomposedBom.Builder updatedBom = DecomposedBom.builder().bomArtifact(importedBomMinusQuarkusBom.bomArtifact()).bomSource(PomSource.of((Artifact)importedBomMinusQuarkusBom.bomArtifact()));
            for (ProjectRelease.Builder releaseBuilder : releaseBuilders.values()) {
                updatedBom.addRelease(releaseBuilder.build());
            }
            this.importedBoms.set(i++, updatedBom.build());
        }
    }

    private DecomposedBom generatePlatformBom() throws BomDecomposerException {
        HashMap<ReleaseId, ProjectRelease.Builder> platformReleaseBuilders = new HashMap<ReleaseId, ProjectRelease.Builder>();
        for (ProjectDependency projectDependency : this.quarkusBomDeps.values()) {
            ProjectDependency projectDependency2 = this.effectiveDep(projectDependency);
            if (projectDependency2 == null) continue;
            platformReleaseBuilders.computeIfAbsent(projectDependency2.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency2);
        }
        for (Map map : this.externalReleaseDeps.values()) {
            ArrayList<ProjectRelease> releases = new ArrayList<ProjectRelease>(map.size());
            map.values().forEach(b -> releases.add(b.build()));
            if (map.size() == 1) {
                this.mergeExtensionDeps((ProjectRelease)releases.get(0), this.externalExtensionDeps);
                continue;
            }
            LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions(releases);
            block4: for (ProjectRelease release : releases) {
                for (Map.Entry<String, ReleaseId> preferred : preferredVersions.entrySet()) {
                    if (release.id().equals(preferred.getValue())) {
                        this.mergeExtensionDeps(release, this.externalExtensionDeps);
                        continue block4;
                    }
                    for (ProjectDependency dep : release.dependencies()) {
                        if (this.quarkusBomDeps.containsKey(dep.key())) continue;
                        String depVersion = dep.artifact().getVersion();
                        if (!preferred.getKey().equals(depVersion)) {
                            for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                                Artifact artifact = dep.artifact().setVersion(preferredVersion.getKey());
                                try {
                                    this.resolver().resolve(artifact);
                                    dep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)dep.dependency().setArtifact(artifact));
                                    break;
                                }
                                catch (BootstrapMavenException bootstrapMavenException) {
                                }
                            }
                        }
                        this.addNonQuarkusDep(dep, this.externalExtensionDeps);
                    }
                }
            }
        }
        for (ProjectDependency projectDependency : this.externalExtensionDeps.values()) {
            platformReleaseBuilders.computeIfAbsent(projectDependency.releaseId(), id -> ProjectRelease.builder((ReleaseId)id)).add(projectDependency);
        }
        DecomposedBom.Builder platformBuilder = DecomposedBom.builder().bomArtifact(this.config.bomArtifact()).bomSource(this.config.bomResolver());
        for (ProjectRelease.Builder builder : platformReleaseBuilders.values()) {
            platformBuilder.addRelease(builder.build());
        }
        return platformBuilder.build();
    }

    private ProjectDependency effectiveDep(ProjectDependency dep) {
        if (this.config.excluded(dep.key())) {
            return null;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced == null) {
            return dep;
        }
        return ProjectDependency.create((ReleaseId)dep.releaseId(), (Dependency)dep.dependency().setArtifact(enforced));
    }

    private void mergeExtensionDeps(ProjectRelease release, Map<AppArtifactKey, ProjectDependency> extensionDeps) {
        for (ProjectDependency dep : release.dependencies()) {
            if (this.quarkusBomDeps.containsKey(dep.key())) {
                return;
            }
            this.addNonQuarkusDep(dep, extensionDeps);
        }
    }

    private void addNonQuarkusDep(ProjectDependency dep, Map<AppArtifactKey, ProjectDependency> extensionDeps) {
        if (this.config.excluded(dep.key())) {
            return;
        }
        Artifact enforced = this.config.enforced(dep.key());
        if (enforced != null) {
            if (!extensionDeps.containsKey(dep.key())) {
                extensionDeps.put(dep.key(), ProjectDependency.create((ReleaseId)dep.releaseId(), (Artifact)enforced));
            }
            return;
        }
        ProjectDependency currentDep = extensionDeps.get(dep.key());
        if (currentDep != null) {
            DefaultArtifactVersion newVersion;
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(currentDep.artifact().getVersion());
            if (currentVersion.compareTo((Object)(newVersion = new DefaultArtifactVersion(dep.artifact().getVersion()))) < 0) {
                extensionDeps.put(dep.key(), dep);
            }
        } else {
            extensionDeps.put(dep.key(), dep);
        }
    }

    public DecomposedBom transform(BomDecomposer decomposer, DecomposedBom decomposedBom) throws BomDecomposerException {
        if (this.transformingBom) {
            this.importedBoms.add(decomposedBom);
        }
        decomposedBom.visit((DecomposedBomVisitor)this);
        return decomposedBom;
    }

    public void enterBom(Artifact bomArtifact) {
        this.extBom = bomArtifact;
    }

    public boolean enterReleaseOrigin(ReleaseOrigin releaseOrigin, int versions) {
        this.preferredVersions = null;
        this.quarkusVersions = this.quarkusBom.releaseVersions(releaseOrigin);
        return true;
    }

    public void leaveReleaseOrigin(ReleaseOrigin releaseOrigin) throws BomDecomposerException {
    }

    public void visitProjectRelease(ProjectRelease release) throws BomDecomposerException {
        if (this.quarkusVersions.isEmpty()) {
            ProjectRelease.Builder releaseBuilder = this.externalReleaseDeps.computeIfAbsent(release.id().origin(), id -> new HashMap()).computeIfAbsent(release.id().version(), id -> ProjectRelease.builder((ReleaseId)release.id()));
            for (ProjectDependency dep : release.dependencies()) {
                releaseBuilder.add(dep);
            }
            return;
        }
        if (this.quarkusVersions.contains(release.id().version())) {
            for (ProjectDependency dep : release.dependencies()) {
                this.quarkusBomDeps.putIfAbsent(dep.key(), dep);
            }
            return;
        }
        LinkedHashMap<String, ReleaseId> preferredVersions = this.preferredVersions == null ? (this.preferredVersions = this.preferredVersions(this.quarkusBom.releases(release.id().origin()))) : this.preferredVersions;
        for (ProjectDependency dep : release.dependencies()) {
            String depVersion = dep.artifact().getVersion();
            if (!preferredVersions.containsKey(depVersion)) {
                for (Map.Entry<String, ReleaseId> preferredVersion : preferredVersions.entrySet()) {
                    Artifact artifact = dep.artifact().setVersion(preferredVersion.getKey());
                    try {
                        this.resolver().resolve(artifact);
                        dep = ProjectDependency.create((ReleaseId)preferredVersion.getValue(), (Dependency)dep.dependency().setArtifact(artifact));
                        break;
                    }
                    catch (BootstrapMavenException bootstrapMavenException) {
                    }
                }
            }
            this.quarkusBomDeps.putIfAbsent(dep.key(), dep);
        }
    }

    public void leaveBom() throws BomDecomposerException {
    }

    private LinkedHashMap<String, ReleaseId> preferredVersions(Collection<ProjectRelease> releases) {
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (ProjectRelease release : releases) {
            for (String versionStr : release.artifactVersions()) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(versionStr);
                ReleaseId prevReleaseId = treeMap.put(version, release.id());
                if (prevReleaseId == null || new DefaultArtifactVersion(prevReleaseId.version().asString()).compareTo((ArtifactVersion)new DefaultArtifactVersion(release.id().version().asString())) <= 0) continue;
                treeMap.put(version, prevReleaseId);
            }
        }
        LinkedHashMap<String, ReleaseId> result = new LinkedHashMap<String, ReleaseId>(treeMap.size());
        for (Map.Entry entry : treeMap.entrySet()) {
            result.put(((ArtifactVersion)entry.getKey()).toString(), (ReleaseId)entry.getValue());
        }
        return result;
    }

    private Collection<Dependency> managedDepsExcludingQuarkusBom(Artifact bom) throws BomDecomposerException {
        HashMap<AppArtifactKey, Dependency> result;
        Artifact quarkusCore;
        block7: {
            ArtifactDescriptorResult bomDescr = this.describe(bom);
            quarkusCore = null;
            Artifact quarkusCoreDeployment = null;
            List allDeps = bomDescr.getManagedDependencies();
            result = new HashMap<AppArtifactKey, Dependency>(allDeps.size());
            for (Dependency dep : allDeps) {
                Artifact artifact = dep.getArtifact();
                result.put(PlatformBomComposer.key(artifact), dep);
                if (quarkusCoreDeployment != null) continue;
                if (artifact.getArtifactId().equals("quarkus-core-deployment") && artifact.getGroupId().equals("io.quarkus")) {
                    quarkusCoreDeployment = artifact;
                    continue;
                }
                if (quarkusCore != null || !artifact.getArtifactId().equals("quarkus-core") || !artifact.getGroupId().equals("io.quarkus")) continue;
                quarkusCore = artifact;
            }
            if (quarkusCoreDeployment != null) {
                try {
                    this.subtractQuarkusBom(result, (Artifact)new DefaultArtifact("io.quarkus", "quarkus-bom-deployment", null, "pom", quarkusCoreDeployment.getVersion()));
                    return result.values();
                }
                catch (BomDecomposerException e) {
                    if (quarkusCore != null) break block7;
                    throw e;
                }
            }
        }
        if (quarkusCore != null) {
            this.subtractQuarkusBom(result, (Artifact)new DefaultArtifact("io.quarkus", "quarkus-bom", null, "pom", quarkusCore.getVersion()));
        } else {
            this.bomsNotImportingQuarkusBom.add(bom);
        }
        return result.values();
    }

    private static AppArtifactKey key(Artifact artifact) {
        return new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension());
    }

    private void subtractQuarkusBom(Map<AppArtifactKey, Dependency> result, Artifact quarkusCoreBom) throws BomDecomposerException {
        try {
            ArtifactDescriptorResult quarkusBomDescr = this.describe(quarkusCoreBom);
            for (Dependency quarkusBomDep : quarkusBomDescr.getManagedDependencies()) {
                result.remove(PlatformBomComposer.key(quarkusBomDep.getArtifact()));
            }
        }
        catch (BomDecomposerException e) {
            this.logger.debug("Failed to subtract %s: %s", new Object[]{quarkusCoreBom, e.getLocalizedMessage()});
            throw e;
        }
    }

    private ArtifactDescriptorResult describe(Artifact artifact) throws BomDecomposerException {
        ArtifactDescriptorResult descr;
        try {
            descr = this.resolver().resolveDescriptor(artifact);
        }
        catch (BootstrapMavenException e) {
            throw new BomDecomposerException("Failed to describe " + artifact, (Throwable)e);
        }
        File file = new File(this.resolver().getSession().getLocalRepository().getBasedir(), this.resolver().getSession().getLocalRepositoryManager().getPathForLocalArtifact(artifact));
        if (!file.exists()) {
            throw new BomDecomposerException(artifact + " was not found in the local repository at " + file);
        }
        return descr;
    }

    private MavenArtifactResolver resolver() {
        try {
            return this.resolver == null ? (this.resolver = MavenArtifactResolver.builder().build()) : this.resolver;
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to initialize Maven artifact resolver", e);
        }
    }

    public static void main(String[] args) throws Exception {
        Path srcPomDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("git").resolve("quarkus-platform").resolve("bom");
        Path outputDir = Paths.get("target", new String[0]).resolve("boms");
        PlatformBomConfig config = PlatformBomConfig.builder().pomResolver(PomSource.of((Path)srcPomDir.resolve("pom.xml"))).build();
        try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(outputDir.resolve("index.html"));){
            PlatformBomComposer bomComposer = new PlatformBomComposer(config);
            DecomposedBom generatedBom = bomComposer.platformBom();
            PlatformBomComposer.report(bomComposer.originalPlatformBom(), generatedBom, outputDir, index);
            for (DecomposedBom importedBom : bomComposer.upgradedImportedBoms()) {
                PlatformBomComposer.report(bomComposer.originalImportedBom(importedBom.bomArtifact()), importedBom, outputDir, index);
            }
        }
    }

    private static void report(DecomposedBom originalBom, DecomposedBom generatedBom, Path outputDir, ReportIndexPageGenerator index) throws IOException, BomDecomposerException {
        outputDir = outputDir.resolve(PlatformBomComposer.bomDirName(generatedBom.bomArtifact()));
        Path platformBomXml = outputDir.resolve("pom.xml");
        PomUtils.toPom((DecomposedBom)generatedBom, (Path)platformBomXml);
        BomDiff.Config config = BomDiff.config();
        if (generatedBom.bomResolver().isResolved()) {
            config.compare(generatedBom.bomResolver().pomPath());
        } else {
            config.compare(generatedBom.bomArtifact());
        }
        BomDiff bomDiff = config.to(platformBomXml);
        Path diffFile = outputDir.resolve("diff.html");
        HtmlBomDiffReportGenerator.config((Path)diffFile).report(bomDiff);
        Path generatedReleasesFile = outputDir.resolve("generated-releases.html");
        generatedBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)generatedReleasesFile).skipOriginsWithSingleRelease().build());
        Path originalReleasesFile = outputDir.resolve("original-releases.html");
        originalBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)originalReleasesFile).skipOriginsWithSingleRelease().build());
        index.bomReport(bomDiff.mainUrl(), bomDiff.toUrl(), generatedBom, originalReleasesFile, generatedReleasesFile, diffFile);
    }

    private static String bomDirName(Artifact a) {
        return a.getGroupId() + "." + a.getArtifactId() + "-" + a.getVersion();
    }
}

