/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.PomResolver;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class PlatformBomConfig {
    private PomResolver bomResolver;
    private Artifact bomArtifact;
    private Artifact quarkusBom;
    private List<Dependency> directDeps = new ArrayList<Dependency>();
    private Map<AppArtifactKey, Artifact> enforced;
    private Set<AppArtifactKey> excluded;
    private Set<String> excludedGroups;
    private MavenArtifactResolver artifactResolver;

    public static Builder builder() {
        return new Builder();
    }

    public static PlatformBomConfig forPom(PomResolver pomResolver) {
        return PlatformBomConfig.builder().pomResolver(pomResolver).build();
    }

    private PlatformBomConfig() {
    }

    public PomResolver bomResolver() {
        return this.bomResolver;
    }

    public Artifact bomArtifact() {
        return this.bomArtifact;
    }

    public Artifact quarkusBom() {
        return this.quarkusBom;
    }

    public List<Dependency> directDeps() {
        return this.directDeps;
    }

    public boolean hasEnforced() {
        return !this.enforced.isEmpty();
    }

    public Map<AppArtifactKey, Artifact> enforced() {
        return this.enforced;
    }

    public Artifact enforced(AppArtifactKey key) {
        return this.enforced.get(key);
    }

    public boolean hasExcluded() {
        return !this.excluded.isEmpty();
    }

    public Set<AppArtifactKey> excluded() {
        return this.excluded;
    }

    public MavenArtifactResolver artifactResolver() {
        return this.artifactResolver;
    }

    boolean excluded(AppArtifactKey key) {
        return this.excluded.contains(key) ? true : this.excludedGroups.contains(key.getGroupId());
    }

    public static class Builder {
        private PomResolver pomResolver;
        private Map<AppArtifactKey, Artifact> enforced = new HashMap<AppArtifactKey, Artifact>(0);
        private Set<AppArtifactKey> excluded = new HashSet<AppArtifactKey>(0);
        private Set<String> excludedGroups = new HashSet<String>(0);
        private MavenArtifactResolver artifactResolver;

        private Builder() {
        }

        public Builder pomResolver(PomResolver pomResolver) {
            this.pomResolver = pomResolver;
            return this;
        }

        public Builder enforce(String groupId, String artifactId, String version) {
            return this.enforce((Artifact)new DefaultArtifact(groupId, artifactId, null, "jar", version));
        }

        public Builder enforce(Artifact artifact) {
            this.enforced.put(new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()), artifact);
            return this;
        }

        public Builder excludeGroupId(String groupId) {
            this.excludedGroups.add(groupId);
            return this;
        }

        public Builder exclude(String groupId, String artifactId) {
            return this.exclude(new AppArtifactKey(groupId, artifactId, null, "jar"));
        }

        public Builder exclude(AppArtifactKey key) {
            this.excluded.add(key);
            return this;
        }

        public Builder artifactResolver(MavenArtifactResolver resolver) {
            this.artifactResolver = resolver;
            return this;
        }

        public PlatformBomConfig build() {
            Objects.requireNonNull(this.pomResolver);
            Path pom = this.pomResolver.pomPath();
            try {
                Path parentPom;
                Model parentModel;
                String relativePath;
                Model model = this.pomResolver.readLocalModel(pom);
                DependencyManagement dm = model.getDependencyManagement();
                if (dm == null) {
                    throw new Exception(pom + " does not include managed dependencies");
                }
                Properties allProps = new Properties();
                allProps.putAll((Map<?, ?>)model.getProperties());
                Parent parent = model.getParent();
                while (parent != null && (relativePath = parent.getRelativePath()) != null && !relativePath.isEmpty() && (parentModel = this.pomResolver.readLocalModel(parentPom = pom.getParent().resolve(relativePath).normalize().toAbsolutePath())) != null) {
                    allProps.putAll((Map<?, ?>)parentModel.getProperties());
                    parent = parentModel.getParent();
                    pom = parentPom;
                }
                allProps.setProperty("project.version", ModelUtils.getVersion((Model)model));
                PlatformBomConfig config = new PlatformBomConfig();
                config.bomResolver = this.pomResolver;
                config.bomArtifact = (Artifact)Objects.requireNonNull(new DefaultArtifact(ModelUtils.getGroupId((Model)model), model.getArtifactId(), null, "pom", ModelUtils.getVersion((Model)model)));
                for (org.apache.maven.model.Dependency dep : dm.getDependencies()) {
                    DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), Builder.resolveExpr(allProps, dep.getClassifier()), dep.getType(), Builder.resolveExpr(allProps, dep.getVersion()));
                    if (config.quarkusBom == null && dep.getArtifactId().equals("quarkus-bom") && dep.getGroupId().equals("io.quarkus")) {
                        config.quarkusBom = (Artifact)artifact;
                        continue;
                    }
                    ArrayList<Exclusion> aetherExclusions = null;
                    if (!dep.getExclusions().isEmpty()) {
                        aetherExclusions = new ArrayList<Exclusion>(dep.getExclusions().size());
                        for (org.apache.maven.model.Exclusion e : dep.getExclusions()) {
                            aetherExclusions.add(new Exclusion(e.getGroupId(), e.getArtifactId(), null, null));
                        }
                    }
                    Dependency aetherDep = new Dependency((Artifact)artifact, dep.getScope(), Boolean.valueOf(dep.getOptional() != null && Boolean.parseBoolean(dep.getOptional())), aetherExclusions);
                    config.directDeps.add(aetherDep);
                }
                if (config.quarkusBom == null) {
                    throw new RuntimeException("Failed to locate io.quarkus:quarkus-bom among the dependencies");
                }
                config.enforced = this.enforced;
                config.excluded = this.excluded;
                config.excludedGroups = this.excludedGroups;
                config.artifactResolver = this.artifactResolver;
                return config;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize platform BOM config", e);
            }
        }

        private static String resolveExpr(Properties allProps, String expr) {
            String prop;
            String value;
            if (expr != null && expr.startsWith("${") && expr.endsWith("}") && (value = allProps.getProperty(prop = expr.substring(2, expr.length() - 1))) != null) {
                return value;
            }
            return expr;
        }
    }
}

