/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.PomUtils;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.platform.PlatformCatalogResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;

public class PlatformBomUtils {
    public static void toPom(DecomposedBom decomposed, Path file, Model baseModel, PlatformCatalogResolver resolver) throws IOException {
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        ModelUtils.persistModel((Path)file, (Model)PlatformBomUtils.toPlatformModel(decomposed, baseModel, resolver));
    }

    public static Model toPlatformModel(DecomposedBom decomposed, Model baseModel, PlatformCatalogResolver resolver) {
        Artifact bomArtifact = decomposed.bomArtifact();
        HashMap<String, PlatformInfo> platforms = new HashMap<String, PlatformInfo>();
        PlatformInfo currentPlatformInfo = null;
        HashMap<String, Dependency> artifacts = new HashMap<String, Dependency>();
        for (Object release : decomposed.releases()) {
            for (ProjectDependency dep : release.dependencies()) {
                PlatformInfo platform;
                boolean currentPlatform;
                String id;
                Artifact depArtifact = dep.artifact();
                if (dep.key().getArtifactId().endsWith("-quarkus-platform-descriptor")) {
                    id = depArtifact.getGroupId() + ":" + depArtifact.getArtifactId() + ":" + depArtifact.getClassifier() + ":" + depArtifact.getExtension() + ":" + depArtifact.getVersion();
                    currentPlatform = bomArtifact.getGroupId().equals(depArtifact.getGroupId()) && bomArtifact.getArtifactId().equals(depArtifact.getArtifactId().substring(0, depArtifact.getArtifactId().length() - "-quarkus-platform-descriptor".length()));
                    platform = platforms.computeIfAbsent(id, k -> new PlatformInfo(id, currentPlatform));
                    if (platform.descriptor != null) {
                        throw new IllegalStateException("Platform version conflict: " + platform.descriptor + " vs " + depArtifact);
                    }
                    platform.descriptor = dep;
                    if (currentPlatform) {
                        currentPlatformInfo = platform;
                        continue;
                    }
                    try {
                        platform.catalog = resolver.resolve(depArtifact);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Failed to resolve platform descriptor " + depArtifact, e);
                    }
                }
                if (dep.key().getArtifactId().endsWith("-quarkus-platform-properties")) {
                    id = depArtifact.getGroupId() + ":" + depArtifact.getArtifactId().substring(0, depArtifact.getArtifactId().length() - "-quarkus-platform-properties".length()) + "-quarkus-platform-descriptor" + ":" + depArtifact.getVersion() + ":json:" + depArtifact.getVersion();
                    currentPlatform = bomArtifact.getGroupId().equals(depArtifact.getGroupId()) && bomArtifact.getArtifactId().equals(depArtifact.getArtifactId().substring(0, depArtifact.getArtifactId().length() - "-quarkus-platform-properties".length()));
                    platform = platforms.computeIfAbsent(id, k -> new PlatformInfo(id, currentPlatform));
                    if (currentPlatform) {
                        currentPlatformInfo = platform;
                    }
                    if (platform.properties != null) {
                        throw new IllegalStateException("Platform version conflict: " + platform.properties + " vs " + depArtifact);
                    }
                    platform.properties = dep;
                    continue;
                }
                artifacts.put(dep.key().toString(), PomUtils.toModelDep((ProjectDependency)dep));
            }
        }
        DependencyManagement dm = new DependencyManagement();
        if (currentPlatformInfo != null) {
            PlatformBomUtils.add(dm, currentPlatformInfo);
        }
        for (PlatformInfo platformInfo : PlatformBomUtils.getTopPlatforms(platforms, decomposed.bomArtifact())) {
            PlatformBomUtils.add(dm, platformInfo);
        }
        ArrayList keys = new ArrayList(artifacts.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            dm.addDependency((Dependency)artifacts.get(key));
        }
        Model model = PomUtils.initModel((Model)baseModel);
        model.setGroupId(decomposed.bomArtifact().getGroupId());
        model.setArtifactId(decomposed.bomArtifact().getArtifactId());
        model.setVersion(decomposed.bomArtifact().getVersion());
        model.setDependencyManagement(dm);
        return model;
    }

    private static void add(DependencyManagement dm, PlatformInfo platform) {
        if (platform.addedToBom) {
            return;
        }
        platform.addedToBom = true;
        dm.addDependency(PomUtils.toModelDep((ProjectDependency)platform.descriptor));
        if (platform.properties != null) {
            dm.addDependency(PomUtils.toModelDep((ProjectDependency)platform.properties));
        }
        if (platform.imports.isEmpty()) {
            for (PlatformInfo imported : platform.imports) {
                PlatformBomUtils.add(dm, imported);
            }
        }
    }

    private static List<PlatformInfo> getTopPlatforms(Map<String, PlatformInfo> platforms, Artifact currentBom) {
        HashSet<String> allDerivedFrom = new HashSet<String>(platforms.size());
        for (PlatformInfo platform : platforms.values()) {
            if (platform.currentPlatform) continue;
            if (platform.catalog == null) {
                throw new IllegalStateException("Failed to locate platform descriptor artifact " + platform.id + " among the managed dependencies of " + currentBom);
            }
            for (ExtensionOrigin o : platform.catalog.getDerivedFrom()) {
                allDerivedFrom.add(o.getId());
                platform.imports.add(platforms.get(o.getId()));
            }
        }
        ArrayList<PlatformInfo> roots = new ArrayList<PlatformInfo>(platforms.size());
        for (PlatformInfo platform : platforms.values()) {
            if (platform.currentPlatform || allDerivedFrom.contains(platform.catalog.getId())) continue;
            roots.add(platform);
        }
        return roots;
    }

    private static class PlatformInfo {
        final String id;
        final boolean currentPlatform;
        ExtensionCatalog catalog;
        ProjectDependency descriptor;
        ProjectDependency properties;
        final List<PlatformInfo> imports = new ArrayList<PlatformInfo>(2);
        boolean addedToBom;

        PlatformInfo(String id, boolean currentPlatform) {
            this.id = id;
            this.currentPlatform = currentPlatform;
        }
    }
}

