/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.FileReportWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ReportIndexPageGenerator
extends FileReportWriter
implements AutoCloseable {
    private static final String[] listBackground = new String[]{"background-color:#EBF4FA", "background-color:#FFFFFF"};
    private List<URL> mainUrl = new ArrayList<URL>();
    private List<URL> toUrl = new ArrayList<URL>();
    private List<DecomposedBom> toBoms = new ArrayList<DecomposedBom>();
    private List<Path> mainReleasesHtml = new ArrayList<Path>();
    private List<Path> toReleasesHtml = new ArrayList<Path>();
    private List<Path> diffHtml = new ArrayList<Path>();

    public ReportIndexPageGenerator(String name) throws IOException {
        super(name);
        this.initHtmlBody();
    }

    public ReportIndexPageGenerator(Path file) throws IOException {
        super(file);
        this.initHtmlBody();
    }

    private void completeHtmlBody() throws IOException {
        this.generateContents();
        this.closeTag("body");
        this.closeTag("html");
    }

    private void initHtmlBody() throws IOException {
        try {
            this.writeLine("<!DOCTYPE html>");
            this.openTag("html");
            this.openTag("head");
            this.offsetLine("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            this.closeTag("head");
            this.openTag("body");
            this.writeTag("h1", "Platform BOM Summary");
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private void generateContents() throws IOException {
        this.writeTag("p", "");
        this.writeTag("h2", "Platform BOM");
        int i = 0;
        int backgroundIndex = 1;
        this.openTag("table");
        this.openTag("tr", listBackground[backgroundIndex]);
        this.writeTag("td", "text-align:left;font-weight:bold;color:gray", this.toBoms.get(i).bomArtifact());
        this.writeTag("td", "text-align:left", this.generateAnchor(this.mainUrl.get(i).toExternalForm(), "original"));
        this.writeTag("td", "text-align:left", this.generateAnchor(this.mainReleasesHtml.get(i).toUri().toURL().toExternalForm(), "decomposed"));
        this.writeTag("td", "text-align:left", this.generateAnchor(this.toUrl.get(i).toExternalForm(), "generated"));
        this.writeTag("td", "text-align:left", this.generateAnchor(this.toReleasesHtml.get(i).toUri().toURL().toExternalForm(), "decomposed"));
        this.writeTag("td", "text-align:left", this.generateAnchor(this.diffHtml.get(i).toUri().toURL().toExternalForm(), "diff"));
        this.closeTag("tr");
        this.closeTag("table");
        this.writeTag("p", "");
        this.openTag("table");
        this.writeTag("caption", "text-align:left;font-weight:bold", "Extension BOMs");
        while (++i < this.toBoms.size()) {
            this.openTag("tr", listBackground[backgroundIndex ^= 1]);
            this.writeTag("td", "text-align:left;font-weight:bold;color:gray", this.toBoms.get(i).bomArtifact());
            this.writeTag("td", "text-align:left", this.generateAnchor(this.mainUrl.get(i).toExternalForm(), "original"));
            this.writeTag("td", "text-align:left", this.generateAnchor(this.mainReleasesHtml.get(i).toUri().toURL().toExternalForm(), "decomposed"));
            this.writeTag("td", "text-align:left", this.generateAnchor(this.toUrl.get(i).toExternalForm(), "generated"));
            this.writeTag("td", "text-align:left", this.generateAnchor(this.toReleasesHtml.get(i).toUri().toURL().toExternalForm(), "decomposed"));
            this.writeTag("td", "text-align:left", this.generateAnchor(this.diffHtml.get(i).toUri().toURL().toExternalForm(), "diff"));
            this.closeTag("tr");
        }
        this.closeTag("table");
    }

    public void bomReport(URL mainUrl, URL toUrl, DecomposedBom toBom, Path mainReleasesHtml, Path toReleasesHtml, Path diffHtml) {
        this.mainUrl.add(mainUrl);
        this.toUrl.add(toUrl);
        this.toBoms.add(toBom);
        this.mainReleasesHtml.add(mainReleasesHtml);
        this.toReleasesHtml.add(toReleasesHtml);
        this.diffHtml.add(diffHtml);
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                this.completeHtmlBody();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.close();
    }
}

