/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.platform;

import io.quarkus.domino.ProductInfo;
import io.quarkus.domino.ProductReleaseNotes;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SbomConfig {
    public static final String ALL = "ALL";
    public static final String INCLUSIONS = "INCLUSIONS";
    public static final String NONE = "NONE";
    private static final Set<String> DEPS_TO_BUILD_VALUES = Set.of("ALL", "INCLUSIONS", "NONE");
    private ProductConfig product;
    private boolean supportedExtensionsOnly;
    private String applyDependenciesToBuildConfig;

    public ProductConfig getProductInfo() {
        return this.product;
    }

    public void setProductInfo(ProductConfig product) {
        this.product = product;
    }

    public boolean isSupportedExtensionsOnly() {
        return this.supportedExtensionsOnly;
    }

    public void setSupportedExtensionsOnly(boolean supportedExtensionsOnly) {
        this.supportedExtensionsOnly = supportedExtensionsOnly;
    }

    public String getApplyDependenciesToBuildConfig() {
        return this.applyDependenciesToBuildConfig;
    }

    public void setApplyDependenciesToBuildConfig(String applyDependenciesToBuildConfig) {
        SbomConfig.ensureValidDepsToBuildConfig(applyDependenciesToBuildConfig);
        this.applyDependenciesToBuildConfig = applyDependenciesToBuildConfig;
    }

    public boolean isApplyCompleteDependenciesToBuildConfig() {
        SbomConfig.ensureValidDepsToBuildConfig(this.applyDependenciesToBuildConfig);
        return ALL.equalsIgnoreCase(this.applyDependenciesToBuildConfig);
    }

    public boolean isApplyDependenciesToBuildInclusions() {
        SbomConfig.ensureValidDepsToBuildConfig(this.applyDependenciesToBuildConfig);
        return this.applyDependenciesToBuildConfig == null || INCLUSIONS.equalsIgnoreCase(this.applyDependenciesToBuildConfig);
    }

    private static void ensureValidDepsToBuildConfig(String applyDependenciesToBuildConfig) {
        if (applyDependenciesToBuildConfig != null && !DEPS_TO_BUILD_VALUES.contains(applyDependenciesToBuildConfig)) {
            throw new IllegalArgumentException("applyDependenciesToBuildConfig allows one of " + DEPS_TO_BUILD_VALUES + " but got " + applyDependenciesToBuildConfig);
        }
    }

    public static class ReleaseNotes {
        private String type;
        private String title;
        private List<String> aliases = List.of();
        private Map<String, String> properties = Map.of();

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    public static class ProductConfig {
        private String id;
        private String stream;
        private String group;
        private String name;
        private String type = "FRAMEWORK";
        private String version;
        private String purl;
        private String cpe;
        private String description;
        private ReleaseNotes releaseNotes;

        public static ProductInfo toProductInfo(ProductConfig productConfig) {
            if (productConfig == null) {
                return null;
            }
            ProductInfo.Mutable pi = ProductInfo.builder().setId(productConfig.getId()).setStream(productConfig.getStream()).setGroup(productConfig.getGroup()).setName(productConfig.getName()).setType(productConfig.getType()).setVersion(productConfig.getVersion()).setPurl(productConfig.getPurl()).setDescription(productConfig.getDescription()).setCpe(productConfig.getCpe());
            if (productConfig.getReleaseNotes() != null) {
                ReleaseNotes rnConfig = productConfig.getReleaseNotes();
                pi.setReleaseNotes(ProductReleaseNotes.builder().setTitle(rnConfig.getTitle()).setType(rnConfig.getType()).setAliases(rnConfig.getAliases()).setProperties(rnConfig.getProperties()).build());
            }
            return pi;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStream() {
            return this.stream;
        }

        public void setStream(String stream) {
            this.stream = stream;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPurl() {
            return this.purl;
        }

        public void setPurl(String purl) {
            this.purl = purl;
        }

        public String getCpe() {
            return this.cpe;
        }

        public void setCpe(String cpe) {
            this.cpe = cpe;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public ReleaseNotes getReleaseNotes() {
            return this.releaseNotes;
        }

        public void setReleaseNotes(ReleaseNotes releaseNotes) {
            this.releaseNotes = releaseNotes;
        }
    }
}

