/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.HtmlBomDiffReportGenerator;
import io.quarkus.bom.platform.PlatformBomComposer;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomUtils;
import io.quarkus.bom.platform.PlatformCatalogResolver;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-platform-bom", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE)
public class GeneratePlatformBomMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${skipPlatformBom}")
    protected boolean skip;
    @Parameter
    protected Set<String> enforcedDependencies = new HashSet<String>(0);
    @Parameter
    protected Set<String> excludedDependencies = new HashSet<String>(0);
    @Parameter
    protected Set<String> excludedGroups = new HashSet<String>(0);
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="recordNotFoundArtifacts")
    boolean recordNotFoundArtifacts;
    MavenArtifactResolver mavenResolver;
    ArtifactResolver artifactResolver;
    PlatformCatalogResolver catalogs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to analyze managed dependencies of " + this.project.getArtifact(), e);
        }
    }

    private void doExecute() throws Exception {
        Path outputDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("boms");
        PlatformBomConfig.Builder configBuilder = PlatformBomConfig.builder().pomResolver(PomSource.of((Path)this.project.getFile().toPath()));
        if (this.enforcedDependencies != null) {
            for (String enforced : this.enforcedDependencies) {
                AppArtifactCoords coords = AppArtifact.fromString((String)enforced);
                configBuilder.enforce((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
            }
        }
        if (this.excludedDependencies != null) {
            for (String excluded : this.excludedDependencies) {
                configBuilder.exclude(AppArtifactKey.fromString((String)excluded));
            }
        }
        if (this.excludedGroups != null) {
            for (String excluded : this.excludedGroups) {
                configBuilder.excludeGroupId(excluded);
            }
        }
        PlatformBomConfig config = configBuilder.artifactResolver(this.artifactResolver()).build();
        try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(outputDir.resolve("index.html"));){
            PlatformBomComposer bomComposer = new PlatformBomComposer(config, (MessageWriter)new MojoMessageWriter(this.getLog()));
            DecomposedBom generatedBom = bomComposer.platformBom();
            Path platformBomXml = outputDir.resolve(GeneratePlatformBomMojo.bomDirName(generatedBom.bomArtifact())).resolve("pom.xml");
            PlatformBomUtils.toPom((DecomposedBom)generatedBom, (Path)platformBomXml, (Model)this.project.getModel(), (PlatformCatalogResolver)this.catalogResolver());
            this.project.setPomFile(platformBomXml.toFile());
            Path generatedReleasesFile = outputDir.resolve(GeneratePlatformBomMojo.bomDirName(generatedBom.bomArtifact())).resolve("generated-releases.html");
            GeneratePlatformBomMojo.generateReleasesReport(generatedBom, generatedReleasesFile);
            index.mainBom(platformBomXml.toUri().toURL(), generatedBom, generatedReleasesFile);
            for (DecomposedBom importedBom : bomComposer.alignedMemberBoms()) {
                this.generateBomReports(bomComposer.originalMemberBom(importedBom.bomArtifact()), importedBom, null, outputDir, index);
            }
        }
    }

    private Path generateBomReports(DecomposedBom originalBom, DecomposedBom generatedBom, Model baseModel, Path outputDir, ReportIndexPageGenerator index) throws IOException, BomDecomposerException, MojoExecutionException {
        outputDir = outputDir.resolve(GeneratePlatformBomMojo.bomDirName(generatedBom.bomArtifact()));
        Path platformBomXml = outputDir.resolve("pom.xml");
        PlatformBomUtils.toPom((DecomposedBom)generatedBom, (Path)platformBomXml, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        GeneratePlatformBomMojo.generateBomReports(originalBom, generatedBom, outputDir, index, platformBomXml, this.artifactResolver());
        return platformBomXml;
    }

    public static void generateBomReports(DecomposedBom originalBom, DecomposedBom generatedBom, Path outputDir, ReportIndexPageGenerator index, Path platformBomXml, ArtifactResolver resolver) throws BomDecomposerException {
        BomDiff.Config config = BomDiff.config();
        config.resolver(resolver);
        if (originalBom.bomResolver() != null && originalBom.bomResolver().isResolved()) {
            config.compare(originalBom.bomResolver().pomPath());
        } else {
            config.compare(originalBom.bomArtifact());
        }
        BomDiff bomDiff = config.to(platformBomXml);
        Path diffFile = outputDir.resolve("diff.html");
        HtmlBomDiffReportGenerator.config((Path)diffFile).report(bomDiff);
        Path generatedReleasesFile = outputDir.resolve("generated-releases.html");
        GeneratePlatformBomMojo.generateReleasesReport(generatedBom, generatedReleasesFile);
        Path originalReleasesFile = outputDir.resolve("original-releases.html");
        GeneratePlatformBomMojo.generateReleasesReport(originalBom, originalReleasesFile);
        index.bomReport(bomDiff.mainUrl(), bomDiff.toUrl(), generatedBom, originalReleasesFile, generatedReleasesFile, diffFile);
    }

    public static void generateReleasesReport(DecomposedBom originalBom, Path outputFile) throws BomDecomposerException {
        originalBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)outputFile).skipOriginsWithSingleRelease().build());
    }

    private static String bomDirName(Artifact a) {
        return a.getGroupId() + "." + a.getArtifactId() + "-" + a.getVersion();
    }

    private PlatformCatalogResolver catalogResolver() throws MojoExecutionException {
        return this.catalogs == null ? (this.catalogs = new PlatformCatalogResolver(this.mavenArtifactResolver())) : this.catalogs;
    }

    private ArtifactResolver artifactResolver() throws MojoExecutionException {
        if (this.artifactResolver == null) {
            MavenArtifactResolver mavenResolver = this.mavenArtifactResolver();
            Path baseDir = null;
            if (this.recordNotFoundArtifacts) {
                LocalProject project = mavenResolver.getMavenContext().getCurrentProject();
                if (project != null) {
                    LocalProject parent;
                    while ((parent = project.getLocalParent()) != null) {
                        project = parent;
                    }
                }
                baseDir = project == null ? this.session.getTopLevelProject().getBasedir().toPath() : project.getDir();
            }
            this.artifactResolver = ArtifactResolverProvider.get((MavenArtifactResolver)mavenResolver, baseDir);
        }
        return this.artifactResolver;
    }

    private MavenArtifactResolver mavenArtifactResolver() throws MojoExecutionException {
        try {
            return this.mavenResolver == null ? (this.mavenResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).build()) : this.mavenResolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }
}

