/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.maven.GeneratePlatformBomMojo;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformMemberConfig;
import io.quarkus.bom.platform.PlatformBomComposer;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomMemberConfig;
import io.quarkus.bom.platform.PlatformBomUtils;
import io.quarkus.bom.platform.PlatformCatalogResolver;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-platform-project", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE)
public class GeneratePlatformProjectMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(required=true, defaultValue="${basedir}/generated-platform-project")
    File outputDir;
    @Parameter(required=true, defaultValue="${project.build.directory}/reports")
    File reportsDir;
    @Parameter(required=true)
    PlatformConfig platformConfig;
    Artifact mainBom;
    MavenArtifactResolver nonWorkspaceResolver;
    MavenArtifactResolver mavenResolver;
    ArtifactResolver artifactResolver;
    PlatformCatalogResolver catalogs;
    Map<ArtifactKey, PlatformMember> members = new HashMap<ArtifactKey, PlatformMember>();
    private PlatformMember quarkusCore;
    private DecomposedBom mainGeneratedBom;
    private Path mainPlatformBomXml;
    private PluginDescriptor pluginDescr;
    private List<String> pomLines;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.quarkusCore = new PlatformMember(this.platformConfig.core);
        this.members.put(this.quarkusCore.key(), this.quarkusCore);
        for (PlatformMemberConfig memberConfig : this.platformConfig.members) {
            if (memberConfig.disabled) continue;
            PlatformMember member = new PlatformMember(memberConfig);
            this.members.put(member.key(), member);
        }
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        if (!this.getMainBomArtifact().getGroupId().equals(this.project.getGroupId())) {
            pom.setGroupId(this.getMainBomArtifact().getGroupId());
        }
        pom.setArtifactId(this.getMainBomArtifact().getArtifactId() + "-parent");
        if (!this.getMainBomArtifact().getVersion().equals(this.project.getVersion())) {
            pom.setVersion(this.getMainBomArtifact().getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.artifactIdToName(this.getMainBomArtifact().getArtifactId()) + " - Parent");
        File pomXml = new File(this.outputDir, "pom.xml");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(this.project.getGroupId());
        parent.setArtifactId(this.project.getArtifactId());
        parent.setVersion(this.project.getVersion());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(this.project.getFile().getParentFile().toPath()).toString());
        pom.setParent(parent);
        Build build = new Build();
        pom.setBuild(build);
        PluginManagement pm = new PluginManagement();
        pom.getBuild().setPluginManagement(pm);
        Plugin plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        plugin.setVersion(this.pluginDescriptor().getVersion());
        plugin.setExtensions(true);
        this.generateMainPlatformModule(pom);
        for (PlatformMember member : this.members.values()) {
            this.generateMemberModule(member, pom);
        }
        for (PlatformMember member : this.members.values()) {
            this.generatePlatformDescriptorModule(member.descriptorCoords(), member.baseModel, true);
            this.persistPom(member.baseModel);
        }
        this.persistPom(pom);
        for (PlatformMember member : this.members.values()) {
            if (member.skipDeploy) continue;
            int lineIndex = this.pomLineContaining("<platformStack>", 0);
            lineIndex = this.pomLineContaining("<version>", lineIndex + 1);
            String versionLine = this.pomLines().get(lineIndex);
            String versionStr = versionLine.substring(versionLine.indexOf("<version>") + "<version>".length(), versionLine.lastIndexOf("</version>"));
            int version = Integer.parseInt(versionStr);
            StringBuilder buf = new StringBuilder();
            buf.append(versionLine.substring(0, versionLine.indexOf("<version>") + "<version>".length())).append(version + 1).append("</version>");
            this.pomLines.set(lineIndex, buf.toString());
            break;
        }
        if (this.pomLines != null) {
            try {
                Files.write(this.project.getFile().toPath(), this.pomLines, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to persist changes to " + this.project.getFile(), (Exception)e);
            }
        }
        Path reportsOutputDir = this.reportsDir.toPath();
        this.resetResolver();
        try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(reportsOutputDir.resolve("index.html"));){
            Path releasesReport = reportsOutputDir.resolve("main").resolve("generated-releases.html");
            GeneratePlatformBomMojo.generateReleasesReport(this.mainGeneratedBom, releasesReport);
            index.mainBom(this.mainPlatformBomXml.toUri().toURL(), this.mainGeneratedBom, releasesReport);
            for (PlatformMember member : this.members.values()) {
                GeneratePlatformBomMojo.generateBomReports(member.originalBom, member.generatedBom, reportsOutputDir.resolve(member.config.name.toLowerCase()), index, member.generatedPomFile, this.artifactResolver());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate platform member BOM reports", e);
        }
    }

    private void generateMemberModule(PlatformMember member, Model parentPom) throws MojoExecutionException {
        String moduleName = member.config.name.toLowerCase();
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        pom.setArtifactId(GeneratePlatformProjectMojo.getArtifactIdBase(parentPom) + moduleName + "-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + member.config.name + " - Parent");
        parentPom.addModule(moduleName);
        File pomXml = new File(new File(parentPom.getProjectDirectory(), moduleName), "pom.xml");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        member.baseModel = pom;
        this.generateMemberBom(member);
        if (member.skipDeploy) {
            GeneratePlatformProjectMojo.skipInstall(pom);
        }
        if (!member.config.tests.isEmpty()) {
            this.generateMemberIntegrationTestsModule(member);
        }
        this.persistPom(pom);
    }

    private static void skipInstall(Model pom) {
        PluginManagement pm;
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        if ((pm = build.getPluginManagement()) == null) {
            pm = new PluginManagement();
            build.setPluginManagement(pm);
        }
        Plugin plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-install-plugin");
        PluginExecution e = new PluginExecution();
        plugin.addExecution(e);
        e.setId("default-install");
        e.setPhase("none");
    }

    private void generateMemberBom(PlatformMember member) throws MojoExecutionException {
        Model baseModel = this.project.getModel().clone();
        baseModel.setName(GeneratePlatformProjectMojo.getNameBase(member.baseModel) + " Quarkus Platform BOM");
        String moduleName = "bom";
        member.baseModel.addModule("bom");
        Path platformBomXml = member.baseModel.getProjectDirectory().toPath().resolve("bom").resolve("pom.xml");
        Model platformModel = PlatformBomUtils.toPlatformModel((DecomposedBom)member.generatedBom, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        try {
            Files.createDirectories(platformBomXml.getParent(), new FileAttribute[0]);
            ModelUtils.persistModel((Path)platformBomXml, (Model)platformModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist generated BOM to " + platformBomXml, (Exception)e);
        }
        member.generatedPomFile = platformBomXml;
        if (member.config.release.previous != null) {
            Model previousModel;
            Path previousPom;
            try {
                previousPom = this.mavenArtifactResolver().resolve((Artifact)GeneratePlatformProjectMojo.toPomArtifact(member.config.release.previous)).getArtifact().getFile().toPath();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to resolve " + member.config.release.previous, (Exception)((Object)e));
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            try {
                previousModel = ModelUtils.readModel((Path)previousPom);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read " + previousPom, (Exception)e);
            }
            if (GeneratePlatformProjectMojo.match(platformModel.getDependencyManagement().getDependencies(), previousModel.getDependencyManagement().getDependencies())) {
                member.skipDeploy = true;
            } else {
                int i = this.pomLineContaining("<name>" + member.config.name + "</name>", 0);
                int releasesI = this.pomLineContaining("<release>", i + 1);
                int previousLineIndex = this.pomLineContaining("<previous>", releasesI + 1);
                int offset = this.pomLines().get(previousLineIndex).indexOf("<previous>");
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < offset; ++j) {
                    buf.append(' ');
                }
                buf.append("<previous>").append(member.config.release.upcoming).append("</previous>");
                this.pomLines().set(previousLineIndex, buf.toString());
                this.increaseUpcomingVersion(this.pomLineContaining("<upcoming>", releasesI + 1));
            }
        } else {
            int i = this.pomLineContaining("<name>" + member.config.name + "</name>", 0);
            i = this.pomLineContaining("<release>", i + 1);
            i = this.pomLineContaining("<upcoming>", i + 1);
            int offset = this.pomLines().get(i).indexOf("<upcoming>");
            StringBuilder buf = new StringBuilder();
            for (int j = 0; j < offset; ++j) {
                buf.append(' ');
            }
            buf.append("<previous>").append(member.config.release.upcoming).append("</previous>");
            this.pomLines().add(i++, buf.toString());
            this.increaseUpcomingVersion(i);
        }
    }

    private void increaseUpcomingVersion(int upcomingLineIndex) throws MojoExecutionException {
        String upcomingLine = this.pomLines().get(upcomingLineIndex);
        int counterStart = upcomingLine.lastIndexOf(45);
        int counterEnd = upcomingLine.lastIndexOf("</upcoming>");
        String currentCounterStr = upcomingLine.substring(counterStart + 1, counterEnd);
        int currentCounter = Integer.parseInt(currentCounterStr);
        String increasedCounterStr = String.valueOf(currentCounter + 1);
        StringBuilder buf = new StringBuilder();
        buf.append(upcomingLine.substring(0, counterStart + 1));
        for (int j = increasedCounterStr.length(); j < currentCounterStr.length(); ++j) {
            buf.append('0');
        }
        buf.append(increasedCounterStr);
        buf.append("</upcoming>");
        this.pomLines().set(upcomingLineIndex, buf.toString());
    }

    private static boolean match(List<Dependency> left, List<Dependency> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            Dependency l = left.get(i);
            Dependency r = right.get(i);
            if (!l.getManagementKey().equals(r.getManagementKey()) || !l.getVersion().equals(r.getVersion()) || l.isOptional() != r.isOptional()) {
                if (PlatformArtifacts.isCatalogArtifactId((String)l.getArtifactId()) && PlatformArtifacts.isCatalogArtifactId((String)r.getArtifactId()) || l.getArtifactId().endsWith("-quarkus-platform-properties") && r.getArtifactId().endsWith("-quarkus-platform-properties")) continue;
                return false;
            }
            if (l.getScope() == null ? r.getScope() != null : !l.getScope().equals(r.getScope())) {
                return false;
            }
            List le = l.getExclusions();
            List re = r.getExclusions();
            if (le.size() != re.size()) {
                return false;
            }
            Set ls = le.stream().map(e -> e.getGroupId() + ":" + e.getArtifactId()).collect(Collectors.toSet());
            for (Exclusion e2 : re) {
                if (ls.contains(e2.getGroupId() + ":" + e2.getArtifactId())) continue;
                return false;
            }
        }
        return true;
    }

    private List<String> pomLines() throws MojoExecutionException {
        if (this.pomLines != null) {
            return this.pomLines;
        }
        try {
            this.pomLines = Files.readAllLines(this.project.getFile().toPath());
            return this.pomLines;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + this.project.getFile(), (Exception)e);
        }
    }

    private int pomLineContaining(String text, int fromLine) throws MojoExecutionException {
        List<String> lines = this.pomLines();
        while (fromLine < lines.size() && !lines.get(fromLine).contains(text)) {
            ++fromLine;
        }
        if (fromLine == lines.size()) {
            throw new MojoExecutionException("Failed to locate " + text + " in " + this.project.getFile());
        }
        return fromLine;
    }

    private void generateMemberIntegrationTestsModule(PlatformMember member) throws MojoExecutionException {
        Model parentPom = member.baseModel;
        String moduleName = "integration-tests";
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        pom.setArtifactId(GeneratePlatformProjectMojo.getArtifactIdBase(parentPom) + "integration-tests");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("integration-tests") + " - Parent");
        parentPom.addModule("integration-tests");
        File pomXml = new File(new File(parentPom.getProjectDirectory(), "integration-tests"), "pom.xml");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        DependencyManagement dm = new DependencyManagement();
        pom.setDependencyManagement(dm);
        Dependency bomDep = new Dependency();
        Artifact bom = this.getMainBomArtifact();
        bomDep.setGroupId(bom.getGroupId());
        bomDep.setArtifactId(bom.getArtifactId());
        bomDep.setVersion(bom.getVersion());
        bomDep.setType("pom");
        bomDep.setScope("import");
        dm.addDependency(bomDep);
        bomDep = new Dependency();
        bomDep.setGroupId("io.quarkus");
        bomDep.setArtifactId("quarkus-integration-test-class-transformer");
        bomDep.setVersion(this.quarkusCoreVersion());
        dm.addDependency(bomDep);
        bomDep = new Dependency();
        bomDep.setGroupId("io.quarkus");
        bomDep.setArtifactId("quarkus-integration-test-class-transformer-deployment");
        bomDep.setVersion(this.quarkusCoreVersion());
        dm.addDependency(bomDep);
        for (String test : member.config.tests) {
            this.generateIntegrationTestModule(test, pom);
        }
        this.persistPom(pom);
    }

    private void generateIntegrationTestModule(String test, Model parentPom) throws MojoExecutionException {
        Model testModel;
        Path pomFile;
        ArtifactCoords testArtifact = ArtifactCoords.fromString((String)test);
        String moduleName = testArtifact.getArtifactId();
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        pom.setArtifactId(moduleName);
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + moduleName);
        parentPom.addModule(moduleName);
        File pomXml = new File(new File(parentPom.getProjectDirectory(), moduleName), "pom.xml");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        Dependency dep = new Dependency();
        dep.setGroupId(testArtifact.getGroupId());
        dep.setArtifactId(testArtifact.getArtifactId());
        if (!testArtifact.getClassifier().isEmpty()) {
            dep.setClassifier(testArtifact.getClassifier());
        }
        dep.setType(testArtifact.getType());
        dep.setVersion(testArtifact.getVersion());
        pom.addDependency(dep);
        dep = new Dependency();
        dep.setGroupId(testArtifact.getGroupId());
        dep.setArtifactId(testArtifact.getArtifactId());
        dep.setClassifier("tests");
        dep.setType("test-jar");
        dep.setVersion(testArtifact.getVersion());
        dep.setScope("test");
        pom.addDependency(dep);
        Build build = new Build();
        pom.setBuild(build);
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-surefire-plugin");
        Xpp3Dom config = new Xpp3Dom("configuration");
        plugin.setConfiguration((Object)config);
        Xpp3Dom depsToScan = new Xpp3Dom("dependenciesToScan");
        config.addChild(depsToScan);
        Xpp3Dom testDep = new Xpp3Dom("dependency");
        depsToScan.addChild(testDep);
        testDep.setValue(testArtifact.getGroupId() + ":" + testArtifact.getArtifactId());
        try {
            pomFile = this.nonWorkspaceResolver().resolve((Artifact)GeneratePlatformProjectMojo.toPomArtifact(testArtifact)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve " + GeneratePlatformProjectMojo.toPomArtifact(testArtifact), (Exception)((Object)e));
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        try {
            testModel = ModelUtils.readModel((Path)pomFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + pomFile, (Exception)e);
        }
        for (Dependency d : testModel.getDependencies()) {
            if (!"test".equals(d.getScope())) continue;
            pom.addDependency(d);
        }
        Profile profile = new Profile();
        pom.addProfile(profile);
        profile.setId("native-image");
        Activation activation = new Activation();
        profile.setActivation(activation);
        ActivationProperty prop = new ActivationProperty();
        activation.setProperty(prop);
        prop.setName("native");
        profile.addProperty("quarkus.package.type", "native");
        BuildBase buildBase = new BuildBase();
        profile.setBuild(buildBase);
        plugin = new Plugin();
        buildBase.addPlugin(plugin);
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-failsafe-plugin");
        plugin.setConfiguration((Object)config);
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.addGoal("integration-test");
        exec.addGoal("verify");
        config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        Xpp3Dom sysProps = new Xpp3Dom("systemProperties");
        config.addChild(sysProps);
        Xpp3Dom nativeImagePath = new Xpp3Dom("native.image.path");
        sysProps.addChild(nativeImagePath);
        nativeImagePath.setValue("${project.build.directory}/${project.build.finalName}-runner");
        plugin = new Plugin();
        buildBase.addPlugin(plugin);
        plugin.setGroupId("io.quarkus");
        plugin.setArtifactId("quarkus-maven-plugin");
        plugin.setVersion(this.quarkusCoreVersion());
        plugin.setConfiguration((Object)config);
        exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setId("native-image");
        exec.addGoal("build");
        config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        Xpp3Dom appArtifact = new Xpp3Dom("appArtifact");
        config.addChild(appArtifact);
        appArtifact.setValue(testArtifact.toString());
        this.persistPom(pom);
        Path seed = pom.getProjectDirectory().toPath().resolve("src").resolve("main").resolve("resources").resolve("seed");
        try {
            Files.createDirectories(seed.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(seed, new OpenOption[0]);){
                writer.write("seed");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create file " + seed, (Exception)e);
        }
    }

    private void generateMainPlatformModule(Model parentPom) throws MojoExecutionException {
        String moduleName = "main";
        Artifact bomArtifact = this.getMainBomArtifact();
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        pom.setArtifactId(GeneratePlatformProjectMojo.getArtifactIdBase(parentPom) + "main" + "-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("main") + " - Parent");
        parentPom.addModule("main");
        File pomXml = new File(new File(parentPom.getProjectDirectory(), "main"), "pom.xml");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        this.generatePlatformDescriptorModule(new ArtifactCoords(bomArtifact.getGroupId(), PlatformArtifacts.ensureCatalogArtifactId((String)bomArtifact.getArtifactId()), bomArtifact.getVersion(), "json", bomArtifact.getVersion()), pom, false);
        this.persistPom(pom);
        this.persistPom(parentPom);
        this.generateAllInclusivePlatformBomModule(pom);
        if (this.platformConfig.skipInstall) {
            GeneratePlatformProjectMojo.skipInstall(pom);
        }
        this.persistPom(pom);
    }

    private void generatePlatformDescriptorModule(ArtifactCoords descriptorCoords, Model parentPom, boolean addPlatformStack) throws MojoExecutionException {
        String moduleName = "descriptor";
        parentPom.addModule("descriptor");
        Path moduleDir = parentPom.getProjectDirectory().toPath().resolve("descriptor");
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        if (!descriptorCoords.getGroupId().equals(ModelUtils.getGroupId((Model)parentPom))) {
            pom.setGroupId(descriptorCoords.getGroupId());
        }
        pom.setArtifactId(descriptorCoords.getArtifactId());
        if (!descriptorCoords.getVersion().equals(ModelUtils.getVersion((Model)parentPom))) {
            pom.setVersion(descriptorCoords.getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform Descriptor");
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)parentPom));
        parent.setRelativePath(moduleDir.relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        Build build = new Build();
        pom.setBuild(build);
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("generate-platform-descriptor");
        Xpp3Dom config = new Xpp3Dom("configuration");
        Xpp3Dom bomArtifactId = new Xpp3Dom("bomArtifactId");
        String bomArtifact = PlatformArtifacts.ensureBomArtifactId((String)descriptorCoords.getArtifactId());
        bomArtifactId.setValue(bomArtifact);
        config.addChild(bomArtifactId);
        Xpp3Dom e = new Xpp3Dom("quarkusCoreVersion");
        e.setValue(this.quarkusCoreVersion());
        config.addChild(e);
        if (addPlatformStack && this.platformConfig.platformStack != null) {
            Xpp3Dom stackConfig = new Xpp3Dom("platformStack");
            config.addChild(stackConfig);
            e = new Xpp3Dom("key");
            e.setValue(this.platformConfig.platformStack.key);
            stackConfig.addChild(e);
            e = new Xpp3Dom("version");
            e.setValue(this.platformConfig.platformStack.version);
            stackConfig.addChild(e);
            Xpp3Dom membersConfig = new Xpp3Dom("members");
            stackConfig.addChild(membersConfig);
            for (PlatformMember m : this.members.values()) {
                e = new Xpp3Dom("member");
                e.setValue(m.stackDescriptorCoords().toString());
                membersConfig.addChild(e);
            }
        }
        if (this.platformConfig.descriptorGenerator != null && this.platformConfig.descriptorGenerator.overridesFile != null) {
            e = new Xpp3Dom("overridesFile");
            e.setValue(this.platformConfig.descriptorGenerator.overridesFile);
            config.addChild(e);
        }
        if (this.platformConfig.descriptorGenerator != null && this.platformConfig.descriptorGenerator.skipCategoryCheck) {
            e = new Xpp3Dom("skipCategoryCheck");
            e.setValue("true");
            config.addChild(e);
            plugin.setConfiguration((Object)config);
        }
        if (this.platformConfig.descriptorGenerator != null && this.platformConfig.descriptorGenerator.resolveDependencyManagement) {
            e = new Xpp3Dom("resolveDependencyManagement");
            e.setValue("true");
            config.addChild(e);
            plugin.setConfiguration((Object)config);
        }
        Dependency dep = new Dependency();
        dep.setGroupId(descriptorCoords.getGroupId());
        dep.setArtifactId(bomArtifact);
        dep.setType("pom");
        dep.setVersion(descriptorCoords.getVersion());
        pom.addDependency(dep);
        Path pomXml = moduleDir.resolve("pom.xml");
        pom.setPomFile(pomXml.toFile());
        this.persistPom(pom);
    }

    private String quarkusCoreVersion() {
        return this.quarkusCore.originalBomCoords().getVersion();
    }

    private PluginDescriptor pluginDescriptor() {
        return this.pluginDescr == null ? (this.pluginDescr = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor")) : this.pluginDescr;
    }

    private void generateAllInclusivePlatformBomModule(Model parentPom) throws MojoExecutionException {
        PlatformBomComposer bomComposer;
        Artifact bomArtifact = this.getMainBomArtifact();
        PlatformBomConfig.Builder configBuilder = PlatformBomConfig.builder().pomResolver(PomSource.of((Artifact)bomArtifact)).platformBom(bomArtifact);
        for (PlatformMember member : this.members.values()) {
            configBuilder.importBom(member.bomGeneratorMemberConfig());
        }
        if (this.platformConfig.bomGenerator != null && this.platformConfig.bomGenerator.enforcedDependencies != null) {
            for (String enforced : this.platformConfig.bomGenerator.enforcedDependencies) {
                AppArtifactCoords coords = AppArtifact.fromString((String)enforced);
                configBuilder.enforce((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
            }
        }
        if (this.platformConfig.bomGenerator != null && this.platformConfig.bomGenerator.excludedDependencies != null) {
            for (String excluded : this.platformConfig.bomGenerator.excludedDependencies) {
                configBuilder.exclude(AppArtifactKey.fromString((String)excluded));
            }
        }
        if (this.platformConfig.bomGenerator != null && this.platformConfig.bomGenerator.excludedGroups != null) {
            for (String excluded : this.platformConfig.bomGenerator.excludedGroups) {
                configBuilder.excludeGroupId(excluded);
            }
        }
        PlatformBomConfig config = configBuilder.artifactResolver(this.artifactResolver()).build();
        try {
            bomComposer = new PlatformBomComposer(config);
        }
        catch (BomDecomposerException e) {
            throw new MojoExecutionException("Failed to generate the platform BOM", (Exception)((Object)e));
        }
        this.mainGeneratedBom = bomComposer.platformBom();
        Model baseModel = this.project.getModel().clone();
        baseModel.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform BOM");
        String moduleName = "bom";
        parentPom.addModule("bom");
        this.mainPlatformBomXml = parentPom.getProjectDirectory().toPath().resolve("bom").resolve("pom.xml");
        try {
            PlatformBomUtils.toPom((DecomposedBom)this.mainGeneratedBom, (Path)this.mainPlatformBomXml, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist generated BOM to " + this.mainPlatformBomXml, (Exception)e);
        }
        this.quarkusCore.originalBom = bomComposer.originalQuarkusCoreBom();
        this.quarkusCore.generatedBom = bomComposer.generatedQuarkusCoreBom();
        for (DecomposedBom importedBom : bomComposer.alignedMemberBoms()) {
            PlatformMember member = this.members.get(GeneratePlatformProjectMojo.toKey(importedBom.bomArtifact()));
            member.originalBom = bomComposer.originalMemberBom(member.originalBomCoords);
            member.generatedBom = importedBom;
        }
    }

    private Artifact getMainBomArtifact() {
        return this.mainBom == null ? (this.mainBom = GeneratePlatformProjectMojo.toPomArtifact(this.platformConfig.bom)) : this.mainBom;
    }

    private PlatformCatalogResolver catalogResolver() throws MojoExecutionException {
        return this.catalogs == null ? (this.catalogs = new PlatformCatalogResolver(this.mavenArtifactResolver())) : this.catalogs;
    }

    private MavenArtifactResolver nonWorkspaceResolver() throws MojoExecutionException {
        if (this.nonWorkspaceResolver != null) {
            return this.nonWorkspaceResolver;
        }
        try {
            this.nonWorkspaceResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(false)).build();
            return this.nonWorkspaceResolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }

    private void resetResolver() {
        this.mavenResolver = null;
        this.artifactResolver = null;
    }

    private ArtifactResolver artifactResolver() throws MojoExecutionException {
        if (this.mavenResolver == null) {
            this.artifactResolver = null;
        }
        return this.artifactResolver == null ? (this.artifactResolver = ArtifactResolverProvider.get((MavenArtifactResolver)this.mavenArtifactResolver(), (Path)this.session.getTopLevelProject().getBasedir().toPath())) : this.artifactResolver;
    }

    private MavenArtifactResolver mavenArtifactResolver() throws MojoExecutionException {
        if (this.mavenResolver != null) {
            return this.mavenResolver;
        }
        try {
            this.mavenResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setCurrentProject(new File(this.outputDir, "pom.xml").toString())).build();
            return this.mavenResolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }

    private static ArtifactKey toKey(Artifact a) {
        return new ArtifactKey(a.getGroupId(), a.getArtifactId());
    }

    private static DefaultArtifact toPomArtifact(String coords) {
        return GeneratePlatformProjectMojo.toPomArtifact(ArtifactCoords.fromString((String)coords));
    }

    private static DefaultArtifact toPomArtifact(ArtifactCoords coords) {
        return new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), null, "pom", coords.getVersion());
    }

    private void persistPom(Model pom) throws MojoExecutionException {
        try {
            pom.getPomFile().getParentFile().mkdirs();
            ModelUtils.persistModel((Path)pom.getPomFile().toPath(), (Model)pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate the platform BOM " + pom.getPomFile(), (Exception)e);
        }
    }

    private static String getArtifactIdBase(Model pom) {
        String s = pom.getArtifactId();
        int i = s.lastIndexOf(45);
        return i > 0 ? s.substring(0, i + 1) : s;
    }

    private static String getNameBase(Model pom) {
        String s = pom.getName();
        int i = s.lastIndexOf(45);
        return i > 0 ? s.substring(0, i + 1) : s;
    }

    private static String artifactIdToName(String artifactId) {
        String[] parts = artifactId.split("-");
        StringBuilder buf = new StringBuilder(artifactId.length() + parts.length);
        String part = parts[0];
        buf.append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        for (int i = 1; i < parts.length; ++i) {
            part = parts[i];
            buf.append(' ').append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        }
        return buf.toString();
    }

    private class PlatformMember {
        public boolean skipDeploy;
        final PlatformMemberConfig config;
        private Artifact originalBomCoords;
        private Artifact generatedBomCoords;
        private ArtifactCoords descriptorCoords;
        private ArtifactCoords stackDescriptorCoords;
        private ArtifactKey key;
        private Model baseModel;
        private DecomposedBom originalBom;
        private DecomposedBom generatedBom;
        private Path generatedPomFile;

        PlatformMember(PlatformMemberConfig config) {
            this.config = config;
        }

        Artifact originalBomCoords() {
            return this.originalBomCoords == null ? (this.originalBomCoords = GeneratePlatformProjectMojo.toPomArtifact(this.config.bom)) : this.originalBomCoords;
        }

        Artifact generatedBomCoords() {
            if (this.generatedBomCoords == null) {
                this.generatedBomCoords = this.config.release == null || this.config.release.upcoming == null ? new DefaultArtifact(GeneratePlatformProjectMojo.this.getMainBomArtifact().getGroupId(), this.originalBomCoords().getArtifactId(), null, "pom", this.originalBomCoords().getVersion()) : GeneratePlatformProjectMojo.toPomArtifact(this.config.release.upcoming);
            }
            return this.generatedBomCoords;
        }

        ArtifactKey key() {
            return this.key == null ? (this.key = GeneratePlatformProjectMojo.toKey(this.generatedBomCoords())) : this.key;
        }

        PlatformBomMemberConfig bomGeneratorMemberConfig() {
            PlatformBomMemberConfig bomMember = new PlatformBomMemberConfig(new org.eclipse.aether.graph.Dependency(this.originalBomCoords(), "import"));
            bomMember.setGeneratedBomArtifact(this.generatedBomCoords());
            return bomMember;
        }

        ArtifactCoords stackDescriptorCoords() {
            String currentCoords;
            if (this.stackDescriptorCoords != null) {
                return this.stackDescriptorCoords;
            }
            String string = currentCoords = this.skipDeploy ? this.config.release.previous : this.config.release.upcoming;
            if (currentCoords == null) {
                currentCoords = this.config.release.upcoming;
            }
            String currentVersion = ArtifactCoords.fromString((String)currentCoords).getVersion();
            this.stackDescriptorCoords = new ArtifactCoords(this.generatedBomCoords().getGroupId(), this.generatedBomCoords().getArtifactId() + "-quarkus-platform-descriptor", currentVersion, "json", currentVersion);
            return this.stackDescriptorCoords;
        }

        ArtifactCoords descriptorCoords() {
            return this.descriptorCoords == null ? (this.descriptorCoords = new ArtifactCoords(this.generatedBomCoords().getGroupId(), this.generatedBomCoords().getArtifactId() + "-quarkus-platform-descriptor", this.generatedBomCoords().getVersion(), "json", this.generatedBomCoords().getVersion())) : this.descriptorCoords;
        }
    }
}

