/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.maven.GenerateMavenRepoZip;
import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bom.decomposer.maven.QuarkusWorkspaceProvider;
import io.quarkus.bom.decomposer.maven.platformgen.AttachedMavenPluginConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformBomGeneratorConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformDescriptorGeneratorConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformReleaseConfig;
import io.quarkus.bom.decomposer.maven.util.Utils;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.HtmlBomDiffReportGenerator;
import io.quarkus.bom.platform.ForeignPreferredConstraint;
import io.quarkus.bom.platform.PlatformBomComposer;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomUtils;
import io.quarkus.bom.platform.PlatformCatalogResolver;
import io.quarkus.bom.platform.PlatformMember;
import io.quarkus.bom.platform.PlatformMemberConfig;
import io.quarkus.bom.platform.PlatformMemberTestConfig;
import io.quarkus.bom.platform.ProjectDependencyFilterConfig;
import io.quarkus.bom.platform.RedHatExtensionDependencyCheck;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bom.platform.SbomConfig;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bom.resolver.EffectiveModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.ArtifactCoordsPattern;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.PathTree;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.studer.java.util.OrderedProperties;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-platform-project", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE)
public class GeneratePlatformProjectMojo
extends AbstractMojo {
    private static final String POM_XML = "pom.xml";
    private static final String LAST_BOM_UPDATE = "last-bom-update";
    private static final String MEMBER_LAST_BOM_UPDATE_PROP = "member.last-bom-update";
    private static final String PLATFORM_KEY_PROP = "platform.key";
    private static final String PLATFORM_STREAM_PROP = "platform.stream";
    private static final String PLATFORM_RELEASE_PROP = "platform.release";
    private static final String DEPENDENCIES_TO_BUILD = "dependenciesToBuild";
    @Component
    RepositorySystem repoSystem;
    @Component
    QuarkusWorkspaceProvider mvnProvider;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(defaultValue="${project}")
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter(required=true, defaultValue="${basedir}/generated-platform-project")
    File outputDir;
    @Parameter(required=true, defaultValue="${project.build.directory}/reports")
    File reportsDir;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    File buildDir;
    @Parameter(required=true)
    PlatformConfig platformConfig;
    private PlatformReleaseConfig platformReleaseConfig;
    @Parameter(required=false)
    ProjectDependencyFilterConfig dependenciesToBuild;
    @Parameter(required=true, defaultValue="${project.build.directory}/updated-pom.xml")
    File updatedPom;
    @Parameter(property="recordUpdatedBoms")
    boolean recordUpdatedBoms;
    Artifact universalBom;
    MavenArtifactResolver nonWsResolver;
    MavenArtifactResolver wsAwareResolver;
    PlatformCatalogResolver catalogs;
    final Map<ArtifactKey, PlatformMemberImpl> members = new LinkedHashMap<ArtifactKey, PlatformMemberImpl>();
    private PlatformMemberImpl quarkusCore;
    private DecomposedBom universalGeneratedBom;
    private Path universalPlatformBomXml;
    private PluginDescriptor pluginDescr;
    private List<String> pomLines;
    private final Map<ArtifactKey, String> universalBomDepKeys = new HashMap<ArtifactKey, String>();
    private TransformerFactory transformerFactory;
    private final Map<String, String> pomPropsByValues = new HashMap<String, String>();
    private List<Profile> generatedBomReleaseProfile;

    private boolean isClean() {
        List<String> goals;
        if (this.session.getGoals().isEmpty()) {
            if (this.project.getDefaultGoal() == null) {
                return false;
            }
            goals = Arrays.asList(this.project.getDefaultGoal().split("\\s+"));
        } else {
            goals = this.session.getGoals();
        }
        return goals.contains("clean");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isClean()) {
            this.getLog().info((CharSequence)("Deleting " + this.outputDir));
            IoUtils.recursiveDelete((Path)this.outputDir.toPath());
        }
        this.quarkusCore = new PlatformMemberImpl(this.platformConfig.getCore());
        this.members.put(this.quarkusCore.key(), this.quarkusCore);
        for (PlatformMemberConfig memberConfig : this.platformConfig.getMembers()) {
            if (!memberConfig.isEnabled()) continue;
            PlatformMemberImpl member = new PlatformMemberImpl(memberConfig);
            this.members.put(member.key(), member);
        }
        Model pom = Utils.newModel();
        String rootArtifactIdBase = GeneratePlatformProjectMojo.getArtifactIdBase(this.project.getModel());
        pom.setArtifactId(rootArtifactIdBase + "-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.artifactIdToName(rootArtifactIdBase) + " - Parent");
        File pomXml = new File(this.outputDir, POM_XML);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(this.project.getGroupId());
        parent.setArtifactId(this.project.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(this.project.getFile().getParentFile().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, this.project.getOriginalModel());
        if (parent.getVersion().equals("${revision}")) {
            pom.addProperty("revision", this.project.getVersion());
        }
        Build build = new Build();
        pom.setBuild(build);
        PluginManagement pm = new PluginManagement();
        pom.getBuild().setPluginManagement(pm);
        Plugin plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        plugin.setVersion(this.getTestArtifactVersion(this.pluginDescriptor().getGroupId(), this.pluginDescriptor().getVersion()));
        plugin.setExtensions(true);
        GeneratePlatformProjectMojo.persistPom(pom);
        this.generateUniversalPlatformModule(pom);
        for (PlatformMemberImpl member : this.members.values()) {
            this.generateMemberModule(member, pom);
        }
        for (PlatformMemberImpl member : this.members.values()) {
            this.generatePlatformDescriptorModule(member.descriptorCoords(), member.baseModel, this.quarkusCore.getInputBom().equals(member.getInputBom()), this.platformConfig.getAttachedMavenPlugin(), member);
            this.generatePlatformPropertiesModule(member, true);
            GeneratePlatformProjectMojo.persistPom(member.baseModel);
        }
        if (this.dependenciesToBuild != null) {
            this.generateDepsToBuildModule(pom);
            this.generateSbomModule(pom);
        }
        if (this.platformConfig.getGenerateMavenRepoZip() != null) {
            this.generateMavenRepoZipModule(pom);
        }
        this.generateExtensionChangesModule(pom);
        if (this.platformConfig.getAttachedMavenPlugin() != null) {
            this.generateMavenPluginModule(pom);
        }
        this.addReleaseProfile(pom);
        pom.getProperties().setProperty(PLATFORM_KEY_PROP, this.releaseConfig().getPlatformKey());
        pom.getProperties().setProperty(PLATFORM_STREAM_PROP, this.releaseConfig().getStream());
        pom.getProperties().setProperty(PLATFORM_RELEASE_PROP, this.releaseConfig().getVersion());
        GeneratePlatformProjectMojo.persistPom(pom);
        this.recordUpdatedBoms();
        this.generateBomReports();
        this.generateDominoCliConfig();
    }

    private static void setParentVersion(Model model, Model parentModel) {
        Parent parent = model.getParent();
        String version = parentModel.getVersion();
        if (version == null) {
            Parent pp = parentModel.getParent();
            if (pp == null) {
                throw new IllegalArgumentException("Failed to determine the version for the parent model");
            }
            version = pp.getVersion();
        }
        parent.setVersion(version);
    }

    private void generateBomReports() throws MojoExecutionException {
        if (!this.platformConfig.isGenerateBomReports() && this.platformConfig.getGenerateBomReportsZip() == null) {
            return;
        }
        Path reportsOutputDir = this.reportsDir.toPath();
        try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(reportsOutputDir.resolve("index.html"));){
            Path releasesReport = reportsOutputDir.resolve("main").resolve("generated-releases.html");
            GeneratePlatformProjectMojo.generateReleasesReport(this.universalGeneratedBom, releasesReport);
            index.universalBom(this.universalPlatformBomXml.toUri().toURL(), this.universalGeneratedBom, releasesReport);
            ArtifactResolver artifactResolver = ArtifactResolverProvider.get((MavenArtifactResolver)this.getWorkspaceAwareMavenResolver());
            for (PlatformMemberImpl member : this.members.values()) {
                if (member.getInputBom() == null) continue;
                GeneratePlatformProjectMojo.generateBomReports(member.originalBom, member.generatedBom, reportsOutputDir.resolve(member.config().getName().toLowerCase()), index, member.generatedPomFile, artifactResolver);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to generate platform member BOM reports", e);
        }
        if (this.platformConfig.getGenerateBomReportsZip() != null) {
            Path zip = Paths.get(this.platformConfig.getGenerateBomReportsZip(), new String[0]);
            if (!zip.isAbsolute()) {
                zip = reportsOutputDir.getParent().resolve(zip);
            }
            try {
                Files.createDirectories(zip.getParent(), new FileAttribute[0]);
                ZipUtils.zip((Path)reportsOutputDir, (Path)zip);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to ZIP platform member BOM reports", e);
            }
        }
    }

    private void generateDominoCliConfig() throws MojoExecutionException {
        if (!Boolean.parseBoolean(this.project.getProperties().getProperty("generate-domino-cli-config"))) {
            return;
        }
        Path dominoDir = Path.of(".domino", new String[0]).normalize().toAbsolutePath().resolve("manifest");
        IoUtils.recursiveDelete((Path)dominoDir);
        try {
            Files.createDirectories(dominoDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create " + dominoDir, (Exception)e);
        }
        for (PlatformMember platformMember : this.members.values()) {
            ProjectDependencyFilterConfig depsToBuild;
            if (!platformMember.config().isEnabled() || platformMember.config().isHidden()) continue;
            this.getLog().info((CharSequence)("Generating Domino CLI SBOM generator config for " + platformMember.getGeneratedPlatformBom().getArtifactId()));
            ProjectDependencyConfig.Mutable dominoConfig = ProjectDependencyConfig.builder().setProjectBom(PlatformArtifacts.ensureBomArtifact((ArtifactCoords)platformMember.descriptorCoords())).setProductInfo(SbomConfig.ProductConfig.toProductInfo((SbomConfig.ProductConfig)GeneratePlatformProjectMojo.getProductInfo(platformMember)));
            if (!this.quarkusCore.descriptorCoords().equals(platformMember.descriptorCoords())) {
                Artifact quarkusBom = this.quarkusCore.getGeneratedPlatformBom();
                dominoConfig.setNonProjectBoms(List.of(ArtifactCoords.pom((String)quarkusBom.getGroupId(), (String)quarkusBom.getArtifactId(), (String)quarkusBom.getVersion())));
            }
            SbomConfig sbomConfig = platformMember.config().getSbom();
            List excludePatterns = List.of();
            if (sbomConfig == null || sbomConfig.isApplyDependenciesToBuildInclusions()) {
                depsToBuild = this.effectiveMemberDepsToBuildConfig(platformMember.config());
                dominoConfig.setIncludeArtifacts((Collection)depsToBuild.getIncludeArtifacts()).setIncludeGroupIds((Collection)depsToBuild.getIncludeGroupIds()).setIncludeKeys((Collection)depsToBuild.getIncludeKeys());
            } else if (sbomConfig.isApplyCompleteDependenciesToBuildConfig()) {
                depsToBuild = this.effectiveMemberDepsToBuildConfig(platformMember.config());
                dominoConfig.setIncludeArtifacts((Collection)depsToBuild.getIncludeArtifacts()).setIncludeGroupIds((Collection)depsToBuild.getIncludeGroupIds()).setIncludeKeys((Collection)depsToBuild.getIncludeKeys()).setExcludePatterns((Collection)depsToBuild.getExcludeArtifacts()).setExcludeGroupIds((Collection)depsToBuild.getExcludeGroupIds()).setExcludeKeys((Collection)depsToBuild.getExcludeKeys());
                excludePatterns = ArtifactCoordsPattern.toPatterns((Collection)dominoConfig.getExcludePatterns());
            }
            if (sbomConfig != null && sbomConfig.isSupportedExtensionsOnly()) {
                ArrayList metadataOverrides = new ArrayList();
                for (String s : platformMember.config().getMetadataOverrideFiles()) {
                    metadataOverrides.add(Path.of(s, new String[0]));
                }
                for (String s : platformMember.config().getMetadataOverrideArtifacts()) {
                    try {
                        metadataOverrides.add(this.getNonWorkspaceResolver().resolve(GeneratePlatformProjectMojo.toAetherArtifact(s)).getArtifact().getFile().toPath());
                    }
                    catch (BootstrapMavenException e) {
                        throw new MojoExecutionException("Failed to resolve " + s, (Exception)((Object)e));
                    }
                }
                if (metadataOverrides.isEmpty()) {
                    throw new IllegalStateException("The SBOM generator for member " + platformMember.config().getName() + " is configured to include only supported extensions but no support metadata override sources were provided");
                }
                HashSet<ArtifactKey> selectedKeys = new HashSet<ArtifactKey>(metadataOverrides.size());
                ArrayList<ExtensionCatalog> overrides = new ArrayList<ExtensionCatalog>(metadataOverrides.size());
                Iterator e = metadataOverrides.iterator();
                while (e.hasNext()) {
                    Iterator p = (Path)e.next();
                    try {
                        overrides.add(ExtensionCatalog.fromFile((Path)((Object)p)));
                    }
                    catch (IOException e2) {
                        throw new MojoExecutionException("Failed to deserialize " + (Path)((Object)p), (Exception)e2);
                    }
                }
                ExtensionCatalog catalog = CatalogMergeUtility.merge(overrides);
                for (Extension e3 : catalog.getExtensions()) {
                    if (!e3.getMetadata().containsKey("redhat-support")) continue;
                    ArtifactKey key = e3.getArtifact().getKey();
                    selectedKeys.add(key);
                    selectedKeys.add(ArtifactKey.of((String)key.getGroupId(), (String)(key.getArtifactId() + "-deployment"), (String)key.getClassifier(), (String)key.getType()));
                }
                for (ProjectRelease r : platformMember.getAlignedDecomposedBom().releases()) {
                    for (ProjectDependency d : r.dependencies()) {
                        Artifact a = d.artifact();
                        if (!selectedKeys.contains(d.key()) || !GeneratePlatformProjectMojo.isExtensionCandidate(a, platformMember.config().getExtensionGroupIds(), excludePatterns)) continue;
                        dominoConfig.addProjectArtifacts(ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion()));
                        dominoConfig.addProjectArtifacts(ArtifactCoords.of((String)a.getGroupId(), (String)(a.getArtifactId() + "-deployment"), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion()));
                    }
                }
            } else {
                for (ProjectRelease r : platformMember.getAlignedDecomposedBom().releases()) {
                    for (ProjectDependency d : r.dependencies()) {
                        Artifact a = d.artifact();
                        if (!GeneratePlatformProjectMojo.isExtensionCandidate(a, platformMember.getExtensionGroupIds(), excludePatterns)) continue;
                        if (a.getFile() == null) {
                            try {
                                a = this.getNonWorkspaceResolver().resolve(a).getArtifact();
                            }
                            catch (BootstrapMavenException e) {
                                throw new RuntimeException("Failed to resolve " + a, e);
                            }
                        }
                        Artifact resolvedArtifact = a;
                        PathTree.ofArchive((Path)a.getFile().toPath()).accept("META-INF/quarkus-extension.properties", visit -> {
                            if (visit != null) {
                                Properties props = new Properties();
                                try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                                    props.load(reader);
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                                dominoConfig.addProjectArtifacts(ArtifactCoords.of((String)resolvedArtifact.getGroupId(), (String)resolvedArtifact.getArtifactId(), (String)resolvedArtifact.getClassifier(), (String)resolvedArtifact.getExtension(), (String)resolvedArtifact.getVersion()));
                                String deploymentArtifact = props.getProperty("deployment-artifact");
                                if (deploymentArtifact == null) {
                                    this.getLog().warn((CharSequence)("Failed to identify the deployment artifact for " + resolvedArtifact + " in " + visit.getUrl()));
                                } else {
                                    dominoConfig.addProjectArtifacts(ArtifactCoords.fromString((String)deploymentArtifact));
                                }
                            }
                        });
                    }
                }
            }
            try {
                dominoConfig.build().persist(dominoDir.resolve(platformMember.getGeneratedPlatformBom().getArtifactId() + "-config.json"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to persist Domino config", (Exception)e);
            }
        }
    }

    private static boolean isExtensionCandidate(Artifact a, Collection<String> extensionGroupIds, Collection<ArtifactCoordsPattern> excludePatterns) {
        if (!a.getExtension().equals("jar") || "javadoc".equals(a.getClassifier()) || "tests".equals(a.getClassifier()) || "sources".equals(a.getClassifier()) || a.getArtifactId().endsWith("-deployment") || !extensionGroupIds.isEmpty() && !extensionGroupIds.contains(a.getGroupId())) {
            return false;
        }
        for (ArtifactCoordsPattern pattern : excludePatterns) {
            if (!pattern.matches(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion())) continue;
            return false;
        }
        return true;
    }

    private void generateExtensionChangesModule(Model parentPom) throws MojoExecutionException {
        String artifactId = "quarkus-extension-changes";
        Model pom = Utils.newModel();
        pom.setArtifactId("quarkus-extension-changes");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("quarkus-extension-changes"));
        parentPom.addModule("quarkus-extension-changes");
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, "quarkus-extension-changes");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        Utils.skipInstallAndDeploy(pom);
        Plugin plugin = new Plugin();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        String profileId = "extensionChanges";
        Profile profile = new Profile();
        profile.setId("extensionChanges");
        pom.addProfile(profile);
        Activation activation = new Activation();
        profile.setActivation(activation);
        ActivationProperty ap = new ActivationProperty();
        activation.setProperty(ap);
        ap.setName("extensionChanges");
        build = new Build();
        profile.setBuild((BuildBase)build);
        PluginManagement pm = new PluginManagement();
        build.setPluginManagement(pm);
        plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        StringBuilder sb = new StringBuilder();
        for (PlatformMemberImpl m : this.members.values()) {
            if (m.config.isHidden() || !m.config.isEnabled()) continue;
            sb.append("quarkus-platform-bom:extension-changes@").append(m.getConfiguredPlatformBom().getArtifactId()).append(' ');
        }
        build.setDefaultGoal(sb.toString());
        Path outputDir = this.buildDir.toPath().resolve("extension-changes");
        String prefix = pomXml.toPath().getParent().relativize(outputDir).toString();
        for (PlatformMemberImpl m : this.members.values()) {
            if (m.config.isHidden() || !m.config.isEnabled()) continue;
            PluginExecution exec = new PluginExecution();
            plugin.addExecution(exec);
            exec.setId(m.getConfiguredPlatformBom().getArtifactId());
            exec.setPhase("process-resources");
            exec.addGoal("extension-changes");
            Xpp3Dom config = new Xpp3Dom("configuration");
            exec.setConfiguration((Object)config);
            config.addChild(GeneratePlatformProjectMojo.textDomElement("bom", m.getConfiguredPlatformBom().getGroupId() + ":" + m.getConfiguredPlatformBom().getArtifactId() + ":" + GeneratePlatformProjectMojo.getDependencyVersion(pom, m.descriptorCoords())));
            config.addChild(GeneratePlatformProjectMojo.textDomElement("outputFile", prefix + "/" + m.getConfiguredPlatformBom().getArtifactId() + "-extension-changes.json"));
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateDepsToBuildModule(Model parentPom) throws MojoExecutionException {
        this.generateDepsToBuildModule(parentPom, "quarkus-dependencies-to-build", "depsToBuild", "dependencies-to-build", "-deps-to-build.txt", false);
    }

    private void generateSbomModule(Model parentPom) throws MojoExecutionException {
        this.generateDepsToBuildModule(parentPom, "quarkus-sbom", "sbom", "sbom", "-sbom.json", true);
    }

    private void generateDepsToBuildModule(Model parentPom, String artifactId, String profileId, String outputDirName, String outputFileSuffix, boolean forSbom) throws MojoExecutionException {
        Model pom = Utils.newModel();
        pom.setArtifactId(artifactId);
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(artifactId));
        parentPom.addModule(artifactId);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, artifactId);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        Utils.skipInstallAndDeploy(pom);
        Plugin plugin = new Plugin();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        Profile profile = new Profile();
        profile.setId(profileId);
        pom.addProfile(profile);
        Activation activation = new Activation();
        profile.setActivation(activation);
        ActivationProperty ap = new ActivationProperty();
        activation.setProperty(ap);
        ap.setName(profileId);
        build = new Build();
        profile.setBuild((BuildBase)build);
        PluginManagement pm = new PluginManagement();
        build.setPluginManagement(pm);
        plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        StringBuilder sb = new StringBuilder();
        for (PlatformMemberImpl m : this.members.values()) {
            if (m.config.isHidden() || !m.config.isEnabled()) continue;
            sb.append("quarkus-platform-bom:dependencies-to-build@").append(m.getConfiguredPlatformBom().getArtifactId()).append(' ');
        }
        build.setDefaultGoal(sb.toString());
        Path outputDir = this.buildDir.toPath().resolve(outputDirName);
        String prefix = pomXml.toPath().getParent().relativize(outputDir).toString();
        for (PlatformMemberImpl m : this.members.values()) {
            SbomConfig sbomConfig;
            if (m.config.isHidden() || !m.config.isEnabled()) continue;
            PluginExecution exec = new PluginExecution();
            plugin.addExecution(exec);
            exec.setId(m.getConfiguredPlatformBom().getArtifactId());
            exec.setPhase("process-resources");
            exec.addGoal("dependencies-to-build");
            Xpp3Dom config = new Xpp3Dom("configuration");
            exec.setConfiguration((Object)config);
            config.addChild(GeneratePlatformProjectMojo.textDomElement("bom", m.getConfiguredPlatformBom().getGroupId() + ":" + m.getConfiguredPlatformBom().getArtifactId() + ":" + GeneratePlatformProjectMojo.getDependencyVersion(pom, m.descriptorCoords())));
            config.addChild(GeneratePlatformProjectMojo.textDomElement("outputFile", prefix + "/" + m.getConfiguredPlatformBom().getArtifactId() + outputFileSuffix));
            SbomConfig sbomConfig2 = sbomConfig = forSbom ? m.config().getSbom() : null;
            if (sbomConfig != null) {
                SbomConfig.ProductConfig productConfig = GeneratePlatformProjectMojo.getProductInfo(m);
                if (productConfig != null) {
                    SbomConfig.ReleaseNotes rn;
                    Xpp3Dom productInfoDom = GeneratePlatformProjectMojo.newDomSelfAppend("productInfo");
                    config.addChild(productInfoDom);
                    if (productConfig.getId() != null) {
                        productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("id", productConfig.getId()));
                    }
                    if (productConfig.getStream() != null) {
                        productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("stream", productConfig.getStream()));
                    }
                    productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("type", productConfig.getType().toUpperCase()));
                    productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("group", productConfig.getGroup()));
                    productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("name", productConfig.getName()));
                    productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("version", productConfig.getVersion()));
                    if (productConfig.getPurl() != null) {
                        productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("purl", productConfig.getPurl()));
                    }
                    if (productConfig.getCpe() != null) {
                        productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("cpe", productConfig.getCpe()));
                    }
                    if (productConfig.getDescription() != null) {
                        productInfoDom.addChild(GeneratePlatformProjectMojo.textDomElement("description", productConfig.getDescription()));
                    }
                    if ((rn = productConfig.getReleaseNotes()) != null) {
                        Xpp3Dom releaseNotesDom = GeneratePlatformProjectMojo.newDomSelfAppend("releaseNotes");
                        productInfoDom.addChild(releaseNotesDom);
                        if (rn.getType() != null) {
                            releaseNotesDom.addChild(GeneratePlatformProjectMojo.textDomElement("type", rn.getType()));
                        }
                        if (rn.getTitle() != null) {
                            releaseNotesDom.addChild(GeneratePlatformProjectMojo.textDomElement("title", rn.getTitle()));
                        }
                        if (!rn.getAliases().isEmpty()) {
                            Xpp3Dom aliasesDom = GeneratePlatformProjectMojo.newDomSelfAppend("aliases");
                            releaseNotesDom.addChild(aliasesDom);
                            for (String a : rn.getAliases()) {
                                aliasesDom.addChild(GeneratePlatformProjectMojo.textDomElement("alias", a));
                            }
                        }
                        if (!rn.getProperties().isEmpty()) {
                            Xpp3Dom propsDom = GeneratePlatformProjectMojo.newDomSelfAppend("properties");
                            releaseNotesDom.addChild(propsDom);
                            ArrayList names = new ArrayList(rn.getProperties().keySet());
                            Collections.sort(names);
                            for (String name : names) {
                                propsDom.addChild(GeneratePlatformProjectMojo.textDomElement(name, (String)rn.getProperties().get(name)));
                            }
                        }
                    }
                }
                if (sbomConfig.isSupportedExtensionsOnly()) {
                    config.addChild(GeneratePlatformProjectMojo.textDomElement("redhatSupported", "true"));
                }
            }
            if (!forSbom || sbomConfig != null && sbomConfig.isApplyCompleteDependenciesToBuildConfig()) {
                ProjectDependencyFilterConfig depsToBuildConfig = m.config().getDependenciesToBuild();
                if (depsToBuildConfig == null) continue;
                Xpp3Dom depsToBuildDom = GeneratePlatformProjectMojo.newDomSelfAppend(DEPENDENCIES_TO_BUILD);
                config.addChild(depsToBuildDom);
                if (!depsToBuildConfig.getExcludeArtifacts().isEmpty()) {
                    Xpp3Dom excludeArtifactsDom = GeneratePlatformProjectMojo.newDomChildrenAppend("excludeArtifacts");
                    depsToBuildDom.addChild(excludeArtifactsDom);
                    for (String artifact : GeneratePlatformProjectMojo.sortAsString(depsToBuildConfig.getExcludeArtifacts())) {
                        excludeArtifactsDom.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", artifact));
                    }
                }
                if (!depsToBuildConfig.getExcludeGroupIds().isEmpty()) {
                    Xpp3Dom excludeGroupIdsDom = GeneratePlatformProjectMojo.newDomChildrenAppend("excludeGroupIds");
                    depsToBuildDom.addChild(excludeGroupIdsDom);
                    for (String groupId : GeneratePlatformProjectMojo.sortAsString(depsToBuildConfig.getExcludeGroupIds())) {
                        excludeGroupIdsDom.addChild(GeneratePlatformProjectMojo.textDomElement("groupId", groupId));
                    }
                }
                if (!depsToBuildConfig.getExcludeKeys().isEmpty()) {
                    Xpp3Dom excludeKeysDom = GeneratePlatformProjectMojo.newDomChildrenAppend("excludeKeys");
                    depsToBuildDom.addChild(excludeKeysDom);
                    for (String key : GeneratePlatformProjectMojo.sortAsString(depsToBuildConfig.getExcludeKeys())) {
                        Xpp3Dom keyDom = GeneratePlatformProjectMojo.newDom("key");
                        excludeKeysDom.addChild(keyDom);
                        keyDom.setValue(key);
                    }
                }
                GeneratePlatformProjectMojo.configureInclusions(depsToBuildConfig, depsToBuildDom);
                continue;
            }
            if (sbomConfig == null || sbomConfig.isApplyDependenciesToBuildInclusions()) {
                Xpp3Dom depsToBuildDom = GeneratePlatformProjectMojo.newDomSelfOverride(DEPENDENCIES_TO_BUILD);
                config.addChild(depsToBuildDom);
                ProjectDependencyFilterConfig depsToBuild = this.effectiveMemberDepsToBuildConfig(m.config());
                GeneratePlatformProjectMojo.configureInclusions(depsToBuild, depsToBuildDom);
                continue;
            }
            config.addChild(GeneratePlatformProjectMojo.newDomSelfOverride(DEPENDENCIES_TO_BUILD));
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private static SbomConfig.ProductConfig getProductInfo(PlatformMember member) {
        SbomConfig.ProductConfig productConfig;
        SbomConfig.ProductConfig productConfig2 = productConfig = member.config().getSbom() == null ? null : member.config().getSbom().getProductInfo();
        if (productConfig == null) {
            return null;
        }
        if (GeneratePlatformProjectMojo.isBlank(productConfig.getType())) {
            productConfig.setType("FRAMEWORK");
        }
        if (GeneratePlatformProjectMojo.isBlank(productConfig.getGroup())) {
            productConfig.setGroup(member.getGeneratedPlatformBom().getGroupId());
        }
        if (GeneratePlatformProjectMojo.isBlank(productConfig.getName())) {
            productConfig.setName(member.getGeneratedPlatformBom().getArtifactId());
        }
        if (GeneratePlatformProjectMojo.isBlank(productConfig.getVersion())) {
            productConfig.setVersion(member.getGeneratedPlatformBom().getVersion());
        }
        return productConfig;
    }

    private ProjectDependencyFilterConfig effectiveMemberDepsToBuildConfig(PlatformMemberConfig member) {
        ProjectDependencyFilterConfig depsToBuild = new ProjectDependencyFilterConfig();
        if (this.dependenciesToBuild != null) {
            depsToBuild.merge(this.dependenciesToBuild);
        }
        if (member.getDependenciesToBuild() != null) {
            depsToBuild.merge(member.getDependenciesToBuild());
        }
        return depsToBuild;
    }

    private static void configureInclusions(ProjectDependencyFilterConfig depsToBuildConfig, Xpp3Dom depsToBuildDom) {
        if (depsToBuildConfig.getIncludeArtifacts().isEmpty() && depsToBuildConfig.getIncludeGroupIds().isEmpty() && depsToBuildConfig.getIncludeKeys().isEmpty()) {
            return;
        }
        Xpp3Dom includeArtifactsDom = GeneratePlatformProjectMojo.newDom("includeArtifacts");
        depsToBuildDom.addChild(includeArtifactsDom);
        if (!depsToBuildConfig.getIncludeArtifacts().isEmpty()) {
            for (String artifact : GeneratePlatformProjectMojo.sortAsString(depsToBuildConfig.getIncludeArtifacts())) {
                includeArtifactsDom.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", artifact));
            }
        }
        if (!depsToBuildConfig.getIncludeGroupIds().isEmpty()) {
            Xpp3Dom includeGroupIdsDom = GeneratePlatformProjectMojo.newDom("includeGroupIds");
            depsToBuildDom.addChild(includeGroupIdsDom);
            for (String groupId : GeneratePlatformProjectMojo.sortAsString(depsToBuildConfig.getIncludeGroupIds())) {
                includeGroupIdsDom.addChild(GeneratePlatformProjectMojo.textDomElement("groupId", groupId));
            }
        }
        if (!depsToBuildConfig.getIncludeKeys().isEmpty()) {
            Xpp3Dom includeKeysDom = GeneratePlatformProjectMojo.newDom("includeKeys");
            depsToBuildDom.addChild(includeKeysDom);
            for (String key : GeneratePlatformProjectMojo.sortAsString(depsToBuildConfig.getIncludeKeys())) {
                includeKeysDom.addChild(GeneratePlatformProjectMojo.textDomElement("key", key));
            }
        }
    }

    private static <T> List<String> sortAsString(Collection<T> col) {
        ArrayList<String> list = new ArrayList<String>(col.size());
        for (T o : col) {
            list.add(String.valueOf(o));
        }
        Collections.sort(list);
        return list;
    }

    private static void generateReleasesReport(DecomposedBom originalBom, Path outputFile) throws BomDecomposerException {
        originalBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)outputFile).skipOriginsWithSingleRelease().build());
    }

    private static void generateBomReports(DecomposedBom originalBom, DecomposedBom generatedBom, Path outputDir, ReportIndexPageGenerator index, Path platformBomXml, ArtifactResolver resolver) throws BomDecomposerException {
        BomDiff.Config config = BomDiff.config();
        config.resolver(resolver);
        if (originalBom.bomResolver() != null && originalBom.bomResolver().isResolved()) {
            config.compare(originalBom.bomResolver().pomPath());
        } else {
            config.compare(originalBom.bomArtifact());
        }
        BomDiff bomDiff = config.to(platformBomXml);
        Path diffFile = outputDir.resolve("diff.html");
        HtmlBomDiffReportGenerator.config((Path)diffFile).report(bomDiff);
        Path generatedReleasesFile = outputDir.resolve("generated-releases.html");
        GeneratePlatformProjectMojo.generateReleasesReport(generatedBom, generatedReleasesFile);
        Path originalReleasesFile = outputDir.resolve("original-releases.html");
        GeneratePlatformProjectMojo.generateReleasesReport(originalBom, originalReleasesFile);
        index.bomReport(bomDiff.mainUrl(), bomDiff.toUrl(), generatedBom, originalReleasesFile, generatedReleasesFile, diffFile);
    }

    private void addReleaseProfile(Model pom) {
        List<Profile> releaseProfiles = this.getGeneratedBomReleaseProfile();
        for (Profile p : releaseProfiles) {
            pom.addProfile(p);
        }
    }

    private void recordUpdatedBoms() throws MojoExecutionException {
        if (!this.recordUpdatedBoms) {
            return;
        }
        int configIndex = this.pomLineContaining("platformConfig", 0);
        if (configIndex < 0) {
            throw new MojoExecutionException("Failed to locate <platformConfig> configuration in " + this.project.getFile());
        }
        int coreIndex = this.pomLineContaining("<core>", configIndex);
        if (coreIndex < 0) {
            throw new MojoExecutionException("Failed to locate <core> configuration in " + this.project.getFile());
        }
        this.updatePreviousMemberRelease(this.quarkusCore, coreIndex);
        int membersIndex = this.pomLineContaining("<members>", configIndex);
        if (membersIndex < 0) {
            throw new MojoExecutionException("Failed to locate <members> configuration in " + this.project.getFile());
        }
        for (PlatformMemberImpl member : this.members.values()) {
            if (member.config().getName().equals(this.quarkusCore.config().getName())) continue;
            this.updatePreviousMemberRelease(member, membersIndex);
        }
        if (this.pomLines != null) {
            File outputDir = this.updatedPom.getParentFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            try {
                Files.write(this.updatedPom.toPath(), this.pomLines, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to persist changes to " + this.project.getFile(), (Exception)e);
            }
            try {
                IoUtils.copy((Path)this.updatedPom.toPath(), (Path)this.project.getFile().toPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to replace " + this.project.getFile() + " with " + this.updatedPom, (Exception)e);
            }
            this.project.setPomFile(this.updatedPom);
        }
    }

    private void updatePreviousMemberRelease(PlatformMemberImpl member, int membersIndex) throws MojoExecutionException {
        int releaseEnd;
        if (member.bomChanged == null || !member.bomChanged.booleanValue() || member.config().isHidden()) {
            return;
        }
        int memberIndex = this.pomLineContaining("<name>" + member.config().getName() + "</name>", membersIndex);
        if (memberIndex < 0) {
            throw new MojoExecutionException("Failed to locate member configuration with <name>" + member.config().getName() + "</name>");
        }
        int releaseIndex = this.pomLineContaining("<release", memberIndex);
        if (releaseIndex < 0) {
            char ch;
            releaseIndex = memberIndex + 1;
            StringBuilder sb = new StringBuilder();
            String nameLine = this.pomLines().get(memberIndex);
            for (int i = 0; i < nameLine.length() && Character.isWhitespace(ch = nameLine.charAt(i)); ++i) {
                sb.append(ch);
            }
            this.pomLines().add(releaseIndex, sb + "<release combine.self=\"override\">");
            this.pomLines().add(releaseIndex + 1, sb + "</release>");
        }
        if ((releaseEnd = this.pomLineContaining("</release>", releaseIndex)) < 0) {
            throw new MojoExecutionException("Failed to locate the closing </release> for member with <name>" + member.config().getName() + "</name>");
        }
        String l = this.pomLines().get(releaseIndex);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < l.length() && Character.isWhitespace(l.charAt(i)); ++i) {
            buf.append(l.charAt(i));
        }
        Artifact generatedBom = member.getAlignedDecomposedBom().bomArtifact();
        buf.append("    <lastDetectedBomUpdate>").append(generatedBom.getGroupId()).append(":").append(generatedBom.getArtifactId()).append(":").append(generatedBom.getVersion()).append("</lastDetectedBomUpdate>");
        int prevIndex = this.pomLineContaining("<lastDetectedBomUpdate>", releaseIndex, releaseEnd);
        if (prevIndex < 0) {
            this.pomLines().add(releaseIndex + 1, buf.toString());
        } else {
            this.pomLines().set(prevIndex, buf.toString());
        }
    }

    private void generateMavenPluginModule(Model parentPom) throws MojoExecutionException {
        ArtifactCoords targetCoords = ArtifactCoords.fromString((String)this.platformConfig.getAttachedMavenPlugin().getTargetPluginCoords());
        String moduleName = targetCoords.getArtifactId();
        parentPom.addModule(moduleName);
        if (this.platformConfig.getAttachedMavenPlugin().isImportSources()) {
            this.importOriginalPluginSources(parentPom, moduleName, this.platformConfig.getAttachedMavenPlugin(), targetCoords);
        } else {
            this.republishOriginalPluginBinary(parentPom, moduleName, targetCoords, ArtifactCoords.fromString((String)this.platformConfig.getAttachedMavenPlugin().getOriginalPluginCoords()));
        }
    }

    private void importOriginalPluginSources(Model parentPom, String moduleName, AttachedMavenPluginConfig pluginConfig, ArtifactCoords targetCoords) throws MojoExecutionException {
        Model pom;
        Path sourcesJar;
        ArtifactCoords originalCoords = ArtifactCoords.fromString((String)pluginConfig.getOriginalPluginCoords());
        try {
            sourcesJar = this.getNonWorkspaceResolver().resolve((Artifact)new DefaultArtifact(originalCoords.getGroupId(), originalCoords.getArtifactId(), "sources", "jar", originalCoords.getVersion())).getArtifact().getFile().toPath();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve the sources JAR of " + originalCoords, e);
        }
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        Path baseDir = pomXml.getParentFile().toPath();
        Path javaSources = baseDir.resolve("src").resolve("main").resolve("java");
        Path resourcesDir = javaSources.getParent().resolve("resources");
        try {
            ZipUtils.unzip((Path)sourcesJar, (Path)javaSources);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to unzip " + sourcesJar + " to " + javaSources, (Exception)e);
        }
        try (Stream<Path> stream = Files.list(javaSources);){
            stream.forEach(p -> {
                if (p.getFileName().toString().equals("io")) {
                    return;
                }
                try {
                    IoUtils.copy((Path)p, (Path)resourcesDir.resolve(p.getFileName()));
                    IoUtils.recursiveDelete((Path)p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Path metainfDir = resourcesDir.resolve("META-INF");
            Path mavenDir = metainfDir.resolve("maven");
            IoUtils.copy((Path)mavenDir.resolve(originalCoords.getGroupId()).resolve(originalCoords.getArtifactId()).resolve(POM_XML), (Path)baseDir.resolve(POM_XML));
            IoUtils.recursiveDelete((Path)mavenDir);
            IoUtils.recursiveDelete((Path)metainfDir.resolve("INDEX.LIST"));
            IoUtils.recursiveDelete((Path)metainfDir.resolve("MANIFEST.MF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to import original plugin sources", (Exception)e);
        }
        try {
            Files.walkFileTree(javaSources, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().equals("HelpMojo.java")) {
                        try {
                            Files.delete(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process " + javaSources, (Exception)e);
        }
        try {
            pom = ModelUtils.readModel((Path)pomXml.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + pomXml, (Exception)e);
        }
        pom.setPomFile(pomXml);
        pom.setGroupId(targetCoords.getGroupId());
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(targetCoords.getArtifactId()));
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        DependencyManagement dm = pom.getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            pom.setDependencyManagement(dm);
        }
        Artifact quarkusBom = this.quarkusCore.getGeneratedPlatformBom();
        Dependency quarkusBomImport = new Dependency();
        quarkusBomImport.setGroupId(quarkusBom.getGroupId());
        quarkusBomImport.setArtifactId(quarkusBom.getArtifactId());
        quarkusBomImport.setType("pom");
        quarkusBomImport.setVersion(quarkusBom.getVersion());
        quarkusBomImport.setScope("import");
        dm.addDependency(quarkusBomImport);
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Model originalEffectiveModel = new EffectiveModelResolver(this.getNonWorkspaceResolver()).resolveEffectiveModel(originalCoords);
        Map<String, Plugin> effectivePlugins = originalEffectiveModel.getBuild().getPlugins().stream().collect(Collectors.toMap(Plugin::getArtifactId, p -> p));
        int i = 0;
        while (i < build.getPlugins().size()) {
            Plugin plugin = (Plugin)build.getPlugins().get(i++);
            Plugin effectivePlugin = effectivePlugins.get(plugin.getArtifactId());
            if (plugin.getArtifactId().equals("maven-plugin-plugin")) {
                build.getPlugins().set(i - 1, effectivePlugin);
                continue;
            }
            plugin.setVersion(effectivePlugin.getVersion());
        }
        GeneratePlatformProjectMojo.copyMavenCompilerProperties(originalEffectiveModel, pom);
        List originalDeps = originalEffectiveModel.getDependencies();
        HashMap<ArtifactKey, String> originalDepVersions = new HashMap<ArtifactKey, String>(originalDeps.size());
        for (Dependency d : originalDeps) {
            originalDepVersions.put(ArtifactKey.of((String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getClassifier(), (String)d.getType()), d.getVersion());
        }
        List managedDeps = this.quarkusCore.generatedBomModel.getDependencyManagement().getDependencies();
        HashMap<ArtifactKey, String> managedDepVersions = new HashMap<ArtifactKey, String>(managedDeps.size());
        for (Object d : managedDeps) {
            managedDepVersions.put(this.getKey((Dependency)d), d.getVersion());
        }
        List pluginDeps = pom.getDependencies();
        pom.setDependencies(new ArrayList(pluginDeps.size()));
        for (Dependency d : pluginDeps) {
            String originalVersion;
            ArtifactKey key;
            if ("test".equals(d.getScope())) continue;
            if (d.getVersion() == null) {
                key = this.getKey(d);
                if (!managedDepVersions.containsKey(key)) {
                    originalVersion = (String)originalDepVersions.get(key);
                    if (originalVersion == null) {
                        throw new IllegalStateException("Failed to determine version for dependency " + d + " of the Maven plugin " + originalCoords);
                    }
                    d.setVersion(this.getTestArtifactVersion(originalCoords.getGroupId(), originalVersion));
                }
            } else if (d.getVersion().startsWith("${")) {
                key = this.getKey(d);
                originalVersion = (String)originalDepVersions.get(key);
                if (originalVersion == null) {
                    throw new IllegalStateException("Failed to determine version for dependency " + d + " of the Maven plugin " + originalCoords);
                }
                if (originalVersion.equals(managedDepVersions.get(key))) {
                    d.setVersion(null);
                } else {
                    d.setVersion(this.getTestArtifactVersion(originalCoords.getGroupId(), originalVersion));
                }
            }
            pom.addDependency(d);
        }
        Properties originalProps = pom.getProperties();
        if (!originalProps.isEmpty()) {
            pom.setProperties(new Properties());
            for (Map.Entry<Object, Object> originalProp : originalProps.entrySet()) {
                String propName = originalProp.getKey().toString();
                if (this.getTestArtifactGroupIdForProperty(propName) != null) continue;
                pom.getProperties().setProperty(propName, originalProp.getValue().toString());
            }
        }
        if (pluginConfig.isFlattenPom()) {
            this.configureFlattenPlugin(pom, false, Map.of("dependencyManagement", "keep"));
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private static void copyMavenCompilerProperties(Model srcModel, Model targetModel) {
        Properties srcProps = srcModel.getProperties();
        for (String propName : srcProps.stringPropertyNames()) {
            if (!propName.startsWith("maven.compiler.")) continue;
            targetModel.getProperties().setProperty(propName, srcProps.getProperty(propName));
        }
    }

    private void configureFlattenPlugin(Model pom, boolean updatePomFile, Map<String, String> elementConfig) {
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("org.codehaus.mojo");
        plugin.setArtifactId("flatten-maven-plugin");
        PluginExecution e = new PluginExecution();
        plugin.addExecution(e);
        e.setId("flatten");
        e.setPhase("process-resources");
        e.addGoal("flatten");
        Xpp3Dom config = new Xpp3Dom("configuration");
        e.setConfiguration((Object)config);
        config.addChild(GeneratePlatformProjectMojo.textDomElement("flattenMode", "oss"));
        if (updatePomFile) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("updatePomFile", "true"));
        }
        Xpp3Dom pomElements = new Xpp3Dom("pomElements");
        config.addChild(pomElements);
        pomElements.addChild(GeneratePlatformProjectMojo.textDomElement("build", "remove"));
        pomElements.addChild(GeneratePlatformProjectMojo.textDomElement("repositories", "remove"));
        ArrayList<String> elementNames = new ArrayList<String>(elementConfig.keySet());
        Collections.sort(elementNames);
        for (String elementName : elementNames) {
            pomElements.addChild(GeneratePlatformProjectMojo.textDomElement(elementName, elementConfig.get(elementName)));
        }
        e = new PluginExecution();
        plugin.addExecution(e);
        e.setId("flatten.clean");
        e.setPhase("clean");
        e.addGoal("clean");
    }

    private static Xpp3Dom textDomElement(String name, String value) {
        Xpp3Dom e = new Xpp3Dom(name);
        e.setValue(value);
        return e;
    }

    private static Xpp3Dom newDomChildrenAppend(String name) {
        Xpp3Dom dom = GeneratePlatformProjectMojo.newDom(name);
        dom.setAttribute("combine.children", "append");
        return dom;
    }

    private static Xpp3Dom newDomSelfAppend(String name) {
        Xpp3Dom dom = GeneratePlatformProjectMojo.newDom(name);
        dom.setAttribute("combine.self", "append");
        return dom;
    }

    private static Xpp3Dom newDomSelfOverride(String name) {
        Xpp3Dom dom = GeneratePlatformProjectMojo.newDom(name);
        dom.setAttribute("combine.self", "override");
        return dom;
    }

    private static Xpp3Dom newDom(String name) {
        return new Xpp3Dom(name);
    }

    private ArtifactKey getKey(Dependency d) {
        return ArtifactKey.of((String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getClassifier(), (String)d.getType());
    }

    private static File getPomFile(Model parentPom, String moduleName) {
        return new File(new File(parentPom.getProjectDirectory(), moduleName), POM_XML);
    }

    private void republishOriginalPluginBinary(Model parentPom, String moduleName, ArtifactCoords targetCoords, ArtifactCoords originalCoords) throws MojoExecutionException {
        Model pom = Utils.newModel();
        if (!targetCoords.getGroupId().equals(this.project.getGroupId())) {
            pom.setGroupId(targetCoords.getGroupId());
        }
        pom.setArtifactId(moduleName);
        if (!targetCoords.getVersion().equals(this.project.getVersion())) {
            pom.setVersion(targetCoords.getVersion());
        }
        pom.setPackaging("maven-plugin");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(targetCoords.getArtifactId()));
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        DependencyManagement dm = pom.getDependencyManagement();
        if (dm == null) {
            dm = new DependencyManagement();
            pom.setDependencyManagement(dm);
        }
        Artifact quarkusBom = this.quarkusCore.getGeneratedPlatformBom();
        Dependency quarkusBomImport = new Dependency();
        quarkusBomImport.setGroupId(quarkusBom.getGroupId());
        quarkusBomImport.setArtifactId(quarkusBom.getArtifactId());
        quarkusBomImport.setType("pom");
        quarkusBomImport.setVersion(quarkusBom.getVersion());
        quarkusBomImport.setScope("import");
        dm.addDependency(quarkusBomImport);
        Build build = new Build();
        pom.setBuild(build);
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("generate-resources");
        exec.addGoal("attach-maven-plugin");
        Xpp3Dom config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        config.addChild(GeneratePlatformProjectMojo.textDomElement("originalPluginCoords", this.platformConfig.getAttachedMavenPlugin().getOriginalPluginCoords()));
        config.addChild(GeneratePlatformProjectMojo.textDomElement("targetPluginCoords", this.platformConfig.getAttachedMavenPlugin().getTargetPluginCoords()));
        plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("com.coderplus.maven.plugins");
        plugin.setArtifactId("copy-rename-maven-plugin");
        plugin.setVersion("1.0");
        exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setId("copy-plugin-help");
        exec.setPhase("process-classes");
        exec.addGoal("copy");
        config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        config.addChild(GeneratePlatformProjectMojo.textDomElement("sourceFile", "${project.build.outputDirectory}/META-INF/maven/" + targetCoords.getGroupId() + "/" + targetCoords.getArtifactId() + "/plugin-help.xml"));
        config.addChild(GeneratePlatformProjectMojo.textDomElement("destinationFile", "${project.build.outputDirectory}/META-INF/maven/" + originalCoords.getGroupId() + "/" + originalCoords.getArtifactId() + "/plugin-help.xml"));
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateMavenRepoZipModule(Model parentPom) throws MojoExecutionException {
        Model pom = Utils.newModel();
        String artifactId = "maven-repo-zip-generator";
        pom.setArtifactId("maven-repo-zip-generator");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("maven-repo-zip-generator"));
        parentPom.addModule("maven-repo-zip-generator");
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, "maven-repo-zip-generator");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        Utils.skipInstallAndDeploy(pom);
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        Profile profile = new Profile();
        profile.setId("mavenRepoZip");
        ActivationProperty activationProperty = new ActivationProperty();
        activationProperty.setName("mavenRepoZip");
        Activation activation = new Activation();
        activation.setProperty(activationProperty);
        profile.setActivation(activation);
        pom.addProfile(profile);
        build = new Build();
        profile.setBuild((BuildBase)build);
        StringBuilder sb = new StringBuilder();
        for (PlatformMemberImpl m : this.members.values()) {
            if (m.config.isHidden() || !m.config.isEnabled()) continue;
            sb.append("quarkus-platform-bom:generate-maven-repo-zip@").append(m.getConfiguredPlatformBom().getArtifactId()).append(' ');
        }
        build.setDefaultGoal(sb.toString());
        PluginManagement pluginMgmt = new PluginManagement();
        build.setPluginManagement(pluginMgmt);
        plugin = new Plugin();
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        pluginMgmt.addPlugin(plugin);
        GenerateMavenRepoZip generateMavenRepoZip = this.platformConfig.getGenerateMavenRepoZip();
        Path repoOutputDir = this.buildDir.toPath().resolve("maven-repo");
        repoOutputDir = pomXml.toPath().getParent().getParent().relativize(repoOutputDir);
        for (PlatformMember platformMember : this.members.values()) {
            Xpp3Dom d;
            if (!platformMember.config().isEnabled() || platformMember.config().isHidden()) continue;
            PluginExecution exec = new PluginExecution();
            plugin.addExecution(exec);
            exec.setId(platformMember.getConfiguredPlatformBom().getArtifactId());
            exec.setPhase("process-resources");
            exec.addGoal("generate-maven-repo-zip");
            Xpp3Dom e = new Xpp3Dom("generateMavenRepoZip");
            Xpp3Dom bom = new Xpp3Dom("bom");
            bom.setValue(platformMember.getGeneratedPlatformBom().toString());
            e.addChild(bom);
            if (generateMavenRepoZip.getRepositoryDir() != null) {
                e.addChild(GeneratePlatformProjectMojo.textDomElement("repositoryDir", generateMavenRepoZip.getRepositoryDir()));
            }
            Path repoDir = repoOutputDir.resolve(platformMember.getConfiguredPlatformBom().getArtifactId());
            e.addChild(GeneratePlatformProjectMojo.textDomElement("repositoryDir", repoDir.toString()));
            e.addChild(GeneratePlatformProjectMojo.textDomElement("zipLocation", repoDir + "/" + platformMember.getConfiguredPlatformBom().getArtifactId() + "-maven-repo.zip"));
            if (generateMavenRepoZip.getIncludedVersionsPattern() != null) {
                e.addChild(GeneratePlatformProjectMojo.textDomElement("includedVersionsPattern", generateMavenRepoZip.getIncludedVersionsPattern()));
            } else if (this.platformConfig.getBomGenerator() != null && !this.platformConfig.getBomGenerator().versionConstraintPreferences.isEmpty()) {
                if (this.platformConfig.getBomGenerator().versionConstraintPreferences.size() != 1) {
                    throw new MojoExecutionException("Found more than one includedVersionsPattern for the Maven repo generator: " + this.platformConfig.getBomGenerator().versionConstraintPreferences);
                }
                e.addChild(GeneratePlatformProjectMojo.textDomElement("includedVersionsPattern", this.platformConfig.getBomGenerator().versionConstraintPreferences.get(0)));
            }
            if (!generateMavenRepoZip.getExcludedGroupIds().isEmpty()) {
                d = new Xpp3Dom("excludedGroupIds");
                for (String groupId : generateMavenRepoZip.getExcludedGroupIds()) {
                    d.addChild(GeneratePlatformProjectMojo.textDomElement("groupId", groupId));
                }
                e.addChild(d);
            }
            if (!generateMavenRepoZip.getExcludedArtifacts().isEmpty()) {
                d = new Xpp3Dom("excludedArtifacts");
                for (String key : generateMavenRepoZip.getExcludedArtifacts()) {
                    d.addChild(GeneratePlatformProjectMojo.textDomElement("key", key));
                }
                e.addChild(d);
            }
            if (!generateMavenRepoZip.getExtraArtifacts().isEmpty()) {
                Xpp3Dom extras = new Xpp3Dom("extraArtifacts");
                for (String coords : generateMavenRepoZip.getExtraArtifacts()) {
                    extras.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", coords));
                }
                extras.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", platformMember.descriptorCoords().toString()));
                extras.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", platformMember.propertiesCoords().toString()));
                e.addChild(extras);
            }
            if (generateMavenRepoZip.getIncludedVersionsPattern() != null) {
                e.addChild(GeneratePlatformProjectMojo.textDomElement("includedVersionsPattern", generateMavenRepoZip.getIncludedVersionsPattern()));
            }
            Xpp3Dom configuration = new Xpp3Dom("configuration");
            configuration.addChild(e);
            exec.setConfiguration((Object)configuration);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateMemberModule(PlatformMemberImpl member, Model parentPom) throws MojoExecutionException {
        String moduleName = GeneratePlatformProjectMojo.getArtifactIdBase(member.getGeneratedPlatformBom().getArtifactId());
        Model pom = Utils.newModel();
        if (!member.getGeneratedPlatformBom().getGroupId().equals(this.project.getGroupId())) {
            pom.setGroupId(member.getGeneratedPlatformBom().getGroupId());
        }
        pom.setArtifactId(moduleName + "-parent");
        if (!member.getGeneratedPlatformBom().getVersion().equals(this.project.getVersion())) {
            pom.setVersion(member.getGeneratedPlatformBom().getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + member.config().getName() + " - Parent");
        parentPom.addModule(moduleName);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        member.baseModel = pom;
        this.generateMemberBom(member);
        if (member.config().hasTests()) {
            this.generateMemberIntegrationTestsModule(member);
        }
        if (member.config().isHidden() || this.platformConfig.getRelease() != null && this.platformConfig.getRelease().isOnlyChangedMembers() && member.getGeneratedPlatformBom().equals(member.previousLastUpdatedBom())) {
            this.getLog().info((CharSequence)("Excluding " + member.getGeneratedPlatformBom() + " from the upcoming release"));
            Utils.skipInstallAndDeploy(pom);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void generateMemberBom(PlatformMemberImpl member) throws MojoExecutionException {
        Model baseModel = this.project.getModel().clone();
        baseModel.setName(GeneratePlatformProjectMojo.getNameBase(member.baseModel) + " Quarkus Platform BOM");
        String moduleName = "bom";
        member.baseModel.addModule("bom");
        Path platformBomXml = member.baseModel.getProjectDirectory().toPath().resolve("bom").resolve(POM_XML);
        member.generatedBomModel = PlatformBomUtils.toPlatformModel((DecomposedBom)member.generatedBom, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        this.addReleaseProfile(member.generatedBomModel);
        if (member.config().isHidden()) {
            Utils.skipInstallAndDeploy(member.generatedBomModel);
        }
        try {
            Files.createDirectories(platformBomXml.getParent(), new FileAttribute[0]);
            ModelUtils.persistModel((Path)platformBomXml, (Model)member.generatedBomModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist generated BOM to " + platformBomXml, (Exception)e);
        }
        member.generatedPomFile = platformBomXml;
        if (this.recordUpdatedBoms) {
            this.isChangedSinceLastRelease(member);
        }
    }

    private boolean isChangedSinceLastRelease(PlatformMemberImpl member) throws MojoExecutionException {
        if (member.bomChanged == null) {
            Artifact prevBomCoords = member.previousLastUpdatedBom();
            if (prevBomCoords == null) {
                member.bomChanged = true;
            } else {
                ArtifactCoords generatedCoords;
                ArtifactCoords prevCoords = ArtifactCoords.pom((String)prevBomCoords.getGroupId(), (String)prevBomCoords.getArtifactId(), (String)prevBomCoords.getVersion());
                if (!prevCoords.equals(generatedCoords = ArtifactCoords.pom((String)member.getAlignedDecomposedBom().bomArtifact().getGroupId(), (String)member.getAlignedDecomposedBom().bomArtifact().getArtifactId(), (String)member.getAlignedDecomposedBom().bomArtifact().getVersion()))) {
                    List prevDeps;
                    try {
                        prevDeps = this.getNonWorkspaceResolver().resolveDescriptor(prevBomCoords).getManagedDependencies();
                    }
                    catch (BootstrapMavenException e) {
                        throw new MojoExecutionException("Failed to resolve " + prevBomCoords, (Exception)((Object)e));
                    }
                    if (prevDeps.isEmpty()) {
                        member.bomChanged = true;
                    } else {
                        HashSet<ArtifactCoords> prevArtifacts = new HashSet<ArtifactCoords>(prevDeps.size());
                        for (org.eclipse.aether.graph.Dependency d : prevDeps) {
                            if (!GeneratePlatformProjectMojo.isMeaningfulClasspathConstraint(d.getArtifact())) continue;
                            prevArtifacts.add(GeneratePlatformProjectMojo.toCoords(d.getArtifact()));
                        }
                        HashSet<ArtifactCoords> currentArtifacts = new HashSet<ArtifactCoords>(prevArtifacts.size());
                        for (ProjectRelease r : member.generatedBom.releases()) {
                            for (ProjectDependency d : r.dependencies()) {
                                if (!GeneratePlatformProjectMojo.isMeaningfulClasspathConstraint(d.artifact())) continue;
                                currentArtifacts.add(GeneratePlatformProjectMojo.toCoords(d.artifact()));
                            }
                        }
                        member.bomChanged = !prevArtifacts.equals(currentArtifacts);
                    }
                } else {
                    member.bomChanged = false;
                }
            }
        }
        return member.bomChanged;
    }

    private List<Profile> getGeneratedBomReleaseProfile() {
        if (this.generatedBomReleaseProfile == null) {
            this.generatedBomReleaseProfile = new ArrayList<Profile>(2);
            for (Profile p : this.project.getModel().getProfiles()) {
                if (!p.getId().startsWith("release")) continue;
                this.generatedBomReleaseProfile.add(this.copyReleasePlugins(p));
            }
        }
        return this.generatedBomReleaseProfile;
    }

    private Profile copyReleasePlugins(Profile parentReleaseProfile) {
        Profile memberReleaseProfile = new Profile();
        memberReleaseProfile.setId(parentReleaseProfile.getId());
        memberReleaseProfile.setActivation(parentReleaseProfile.getActivation());
        if (parentReleaseProfile.getBuild() != null) {
            Build build = new Build();
            memberReleaseProfile.setBuild((BuildBase)build);
            build.setPluginManagement(parentReleaseProfile.getBuild().getPluginManagement());
            for (Plugin plugin : parentReleaseProfile.getBuild().getPlugins()) {
                if (plugin.getArtifactId().equals("maven-gpg-plugin")) {
                    build.addPlugin(this.clonePluginConfig(plugin));
                    continue;
                }
                if (!plugin.getArtifactId().equals("nexus-staging-maven-plugin")) continue;
                build.addPlugin(this.clonePluginConfig(plugin));
            }
        }
        return memberReleaseProfile;
    }

    private Plugin clonePluginConfig(Plugin plugin) {
        if (plugin.getVersion() == null) {
            Plugin managedPlugin = (Plugin)this.project.getPluginManagement().getPluginsAsMap().get(plugin.getKey());
            if (managedPlugin == null) {
                this.getLog().warn((CharSequence)("Failed to determine the version for " + plugin.getKey()));
            }
            plugin = plugin.clone();
            plugin.setVersion(managedPlugin.getVersion());
        }
        return plugin;
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private static boolean isMeaningfulClasspathConstraint(Artifact a) {
        return a.getExtension().equals("jar") && !PlatformArtifacts.isCatalogArtifactId((String)a.getArtifactId()) && !a.getArtifactId().endsWith("-quarkus-platform-properties") && !"sources".equals(a.getClassifier()) && !"javadoc".equals(a.getClassifier());
    }

    private List<String> pomLines() {
        if (this.pomLines != null) {
            return this.pomLines;
        }
        try {
            this.pomLines = Files.readAllLines(this.project.getFile().toPath());
            return this.pomLines;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + this.project.getFile(), e);
        }
    }

    private int pomLineContaining(String text, int fromLine) {
        return this.pomLineContaining(text, fromLine, Integer.MAX_VALUE);
    }

    private int pomLineContaining(String text, int fromLine, int toLine) {
        List<String> lines = this.pomLines();
        int upperLimit = Math.min(lines.size(), toLine);
        while (fromLine < upperLimit && !lines.get(fromLine).contains(text)) {
            ++fromLine;
        }
        return fromLine == upperLimit ? -1 : fromLine;
    }

    private void generateMemberIntegrationTestsModule(PlatformMemberImpl member) throws MojoExecutionException {
        Model parentPom = member.baseModel;
        String moduleName = "integration-tests";
        Model pom = Utils.newModel();
        pom.setArtifactId(GeneratePlatformProjectMojo.getArtifactIdBase(parentPom) + "-integration-tests-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName("integration-tests") + " - Parent");
        parentPom.addModule("integration-tests");
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, "integration-tests");
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        DependencyManagement dm = new DependencyManagement();
        pom.setDependencyManagement(dm);
        Dependency managedDep = this.getUniversalBomImport();
        dm.addDependency(managedDep);
        managedDep = new Dependency();
        managedDep.setGroupId("io.quarkus");
        managedDep.setArtifactId("quarkus-integration-test-class-transformer");
        managedDep.setVersion(this.quarkusCore.getVersionProperty());
        dm.addDependency(managedDep);
        managedDep = new Dependency();
        managedDep.setGroupId("io.quarkus");
        managedDep.setArtifactId("quarkus-integration-test-class-transformer-deployment");
        managedDep.setVersion(this.quarkusCore.getVersionProperty());
        dm.addDependency(managedDep);
        LinkedHashMap<ArtifactKey, PlatformMemberTestConfig> testConfigs = new LinkedHashMap<ArtifactKey, PlatformMemberTestConfig>();
        for (PlatformMemberTestConfig test : member.config().getTests()) {
            testConfigs.put(ArtifactCoords.fromString((String)test.getArtifact()).getKey(), test);
        }
        if (member.config().getTestCatalogArtifact() != null) {
            Document testCatalogDoc;
            File testCatalogFile;
            Artifact testCatalogArtifact = GeneratePlatformProjectMojo.toAetherArtifact(member.config().getTestCatalogArtifact());
            try {
                testCatalogFile = this.getNonWorkspaceResolver().resolve(testCatalogArtifact).getArtifact().getFile();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolve test catalog artifact " + testCatalogArtifact, e);
            }
            try (BufferedReader reader = Files.newBufferedReader(testCatalogFile.toPath());){
                Builder parser = new Builder();
                testCatalogDoc = parser.build((Reader)reader);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Failed to parse " + testCatalogFile, ex);
            }
            for (Element testElement : testCatalogDoc.getRootElement().getChildElements("testArtifact")) {
                ArtifactCoords testCoords;
                PlatformMemberTestConfig testConfig;
                String testVersion;
                String testGroupId = testElement.getFirstChildElement("groupId").getValue();
                if (testGroupId == null) {
                    throw new MojoExecutionException("Test catalog " + testCatalogFile + " contains an artifact with a missing groupId " + testElement);
                }
                String testArtifactId = testElement.getFirstChildElement("artifactId").getValue();
                if (testArtifactId == null) {
                    throw new MojoExecutionException("Test catalog " + testCatalogFile + " contains an artifact with a missing artifactId " + testElement);
                }
                Element versionElement = testElement.getFirstChildElement("version");
                String string = testVersion = versionElement == null ? null : versionElement.getValue();
                if (testVersion == null || testVersion.isBlank()) {
                    testVersion = testCatalogArtifact.getVersion();
                }
                if ((testConfig = (PlatformMemberTestConfig)testConfigs.get((testCoords = ArtifactCoords.jar((String)testGroupId, (String)testArtifactId, (String)testVersion)).getKey())) != null) continue;
                testConfig = new PlatformMemberTestConfig();
                testConfig.setArtifact(testCoords.getGroupId() + ":" + testCoords.getArtifactId() + ":" + testCoords.getVersion());
                testConfigs.put(testCoords.getKey(), testConfig);
            }
        }
        for (PlatformMemberTestConfig testConfig : testConfigs.values()) {
            if (member.config().getDefaultTestConfig() != null) {
                testConfig.applyDefaults(member.config().getDefaultTestConfig());
            }
            if (testConfig.isExcluded()) continue;
            this.generateIntegrationTestModule(ArtifactCoords.fromString((String)testConfig.getArtifact()), testConfig, pom);
        }
        Utils.skipInstallAndDeploy(pom);
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private Dependency getUniversalBomImport() {
        Dependency bomDep = new Dependency();
        Artifact bom = this.getUniversalBomArtifact();
        bomDep.setGroupId(bom.getGroupId());
        bomDep.setArtifactId(bom.getArtifactId());
        bomDep.setVersion(this.getUniversalBomArtifact().getVersion());
        bomDep.setType("pom");
        bomDep.setScope("import");
        return bomDep;
    }

    private void generateIntegrationTestModule(ArtifactCoords testArtifact, PlatformMemberTestConfig testConfig, Model parentPom) throws MojoExecutionException {
        Object moduleName;
        if (parentPom.getModules().contains(testArtifact.getArtifactId())) {
            String tmp = testArtifact.getArtifactId() + "-" + testArtifact.getVersion();
            if (parentPom.getModules().contains(tmp)) {
                throw new MojoExecutionException("The same test " + testArtifact + " appears to be added twice");
            }
            moduleName = tmp;
            this.getLog().warn((CharSequence)("Using " + (String)moduleName + " as the module name for " + testArtifact + " since " + testArtifact.getArtifactId() + " module name already exists"));
        } else {
            moduleName = testArtifact.getArtifactId();
        }
        parentPom.addModule((String)moduleName);
        Model pom = Utils.newModel();
        pom.setArtifactId((String)moduleName);
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + (String)moduleName);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, (String)moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        if (!testConfig.getPomProperties().isEmpty()) {
            pom.setProperties(testConfig.getPomProperties());
        }
        if (testConfig.isSkip()) {
            pom.getProperties().setProperty("maven.test.skip", "true");
        }
        String testArtifactVersion = this.getTestArtifactVersion(testArtifact.getGroupId(), testArtifact.getVersion());
        Dependency appArtifactDep = new Dependency();
        appArtifactDep.setGroupId(testArtifact.getGroupId());
        appArtifactDep.setArtifactId(testArtifact.getArtifactId());
        if (!testArtifact.getClassifier().isEmpty()) {
            appArtifactDep.setClassifier(testArtifact.getClassifier());
        }
        appArtifactDep.setType(testArtifact.getType());
        appArtifactDep.setVersion(testArtifactVersion);
        pom.addDependency(appArtifactDep);
        Dependency testArtifactDep = new Dependency();
        testArtifactDep.setGroupId(testArtifact.getGroupId());
        testArtifactDep.setArtifactId(testArtifact.getArtifactId());
        testArtifactDep.setClassifier("tests");
        testArtifactDep.setType("test-jar");
        testArtifactDep.setVersion(testArtifactVersion);
        testArtifactDep.setScope("test");
        pom.addDependency(testArtifactDep);
        this.addDependencies(pom, testConfig.getDependencies(), false);
        this.addDependencies(pom, testConfig.getTestDependencies(), true);
        Xpp3Dom depsToScan = new Xpp3Dom("dependenciesToScan");
        depsToScan.addChild(GeneratePlatformProjectMojo.textDomElement("dependency", testArtifact.getGroupId() + ":" + testArtifact.getArtifactId()));
        if (!testConfig.isSkipJvm()) {
            Build build = new Build();
            pom.setBuild(build);
            if (testConfig.isMavenFailsafePlugin()) {
                build.addPlugin(this.createFailsafeConfig(testConfig, depsToScan, false));
            } else {
                Plugin plugin = new Plugin();
                build.addPlugin(plugin);
                plugin.setGroupId("org.apache.maven.plugins");
                plugin.setArtifactId("maven-surefire-plugin");
                Xpp3Dom config = new Xpp3Dom("configuration");
                plugin.setConfiguration((Object)config);
                config.addChild(depsToScan);
                if (!testConfig.getSystemProperties().isEmpty()) {
                    this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemPropertyVariables"), testConfig.getSystemProperties());
                }
                if (!testConfig.getJvmSystemProperties().isEmpty()) {
                    this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemPropertyVariables"), testConfig.getJvmSystemProperties());
                }
                if (!testConfig.getEnvironmentVariables().isEmpty()) {
                    this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "environmentVariables"), testConfig.getEnvironmentVariables());
                }
                if (!testConfig.getJvmEnvironmentVariables().isEmpty()) {
                    this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "environmentVariables"), testConfig.getJvmEnvironmentVariables());
                }
                this.addGroupsConfig(testConfig, config, false);
                GeneratePlatformProjectMojo.addIncludesExcludesConfig(testConfig, config, false);
                if (testConfig.getJvmArgLine() != null) {
                    config.addChild(GeneratePlatformProjectMojo.textDomElement("argLine", testConfig.getJvmArgLine()));
                } else if (testConfig.getArgLine() != null) {
                    config.addChild(GeneratePlatformProjectMojo.textDomElement("argLine", testConfig.getArgLine()));
                }
                if (testConfig.getJvmTestPattern() != null) {
                    config.addChild(GeneratePlatformProjectMojo.textDomElement("test", testConfig.getJvmTestPattern()));
                } else if (testConfig.getTestPattern() != null) {
                    config.addChild(GeneratePlatformProjectMojo.textDomElement("test", testConfig.getTestPattern()));
                }
            }
            try {
                for (org.eclipse.aether.graph.Dependency d : this.getNonWorkspaceResolver().resolveDescriptor((Artifact)GeneratePlatformProjectMojo.toPomArtifact(testArtifact)).getDependencies()) {
                    if (!d.getScope().equals("test")) continue;
                    Artifact a = d.getArtifact();
                    if ("pom".equals(a.getExtension()) && !d.getExclusions().isEmpty()) {
                        boolean skip = false;
                        for (Exclusion e : d.getExclusions()) {
                            if (!"*".equals(e.getGroupId()) || !"*".equals(e.getArtifactId())) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                    }
                    Dependency modelDep = new Dependency();
                    modelDep.setGroupId(a.getGroupId());
                    modelDep.setArtifactId(a.getArtifactId());
                    if (!a.getClassifier().isEmpty()) {
                        modelDep.setClassifier(a.getClassifier());
                    }
                    modelDep.setType(a.getExtension());
                    if (!this.universalBomDepKeys.containsKey(ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension()))) {
                        modelDep.setVersion(this.getTestArtifactVersion(a.getGroupId(), a.getVersion()));
                    }
                    modelDep.setScope(d.getScope());
                    if (d.getOptional() != null) {
                        modelDep.setOptional(d.getOptional().booleanValue());
                    }
                    if (!d.getExclusions().isEmpty()) {
                        for (Exclusion e : d.getExclusions()) {
                            org.apache.maven.model.Exclusion modelEx = new org.apache.maven.model.Exclusion();
                            modelEx.setGroupId(e.getGroupId());
                            modelEx.setArtifactId(e.getArtifactId());
                            modelDep.addExclusion(modelEx);
                        }
                    }
                    pom.addDependency(modelDep);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to describe " + testArtifact, e);
            }
        }
        if (!testConfig.isSkipNative()) {
            Profile profile = new Profile();
            pom.addProfile(profile);
            profile.setId("native-image");
            Activation activation = new Activation();
            profile.setActivation(activation);
            ActivationProperty prop = new ActivationProperty();
            activation.setProperty(prop);
            prop.setName("native");
            profile.addProperty("quarkus.package.type", "native");
            BuildBase buildBase = new BuildBase();
            profile.setBuild(buildBase);
            buildBase.addPlugin(this.createFailsafeConfig(testConfig, depsToScan, true));
            Plugin plugin = new Plugin();
            buildBase.addPlugin(plugin);
            plugin.setGroupId("io.quarkus");
            plugin.setArtifactId("quarkus-maven-plugin");
            plugin.setVersion(this.quarkusCore.getVersionProperty());
            PluginExecution exec = new PluginExecution();
            plugin.addExecution(exec);
            exec.setId("native-image");
            exec.addGoal("build");
            Xpp3Dom config = new Xpp3Dom("configuration");
            exec.setConfiguration((Object)config);
            if (testConfig.isSkip()) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("skip", "true"));
            }
            config.addChild(GeneratePlatformProjectMojo.textDomElement("appArtifact", testArtifact.getGroupId() + ":" + testArtifact.getArtifactId() + ":" + testArtifactVersion));
        }
        Utils.disablePlugin(pom, "maven-jar-plugin", "default-jar");
        Utils.disablePlugin(pom, "maven-source-plugin", "attach-sources");
        if (testConfig.isPackageApplication()) {
            this.addQuarkusBuildConfig(pom, appArtifactDep);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
        if (testConfig.getTransformWith() != null) {
            Path xsl = Paths.get(testConfig.getTransformWith(), new String[0]).toAbsolutePath();
            if (!Files.exists(xsl, new LinkOption[0])) {
                throw new MojoExecutionException("Failed to locate " + xsl);
            }
            File transformedPom = new File(pomXml.getParent(), "transformed-pom.xml");
            StreamSource xslt = new StreamSource(xsl.toFile());
            StreamSource xml = new StreamSource(pomXml);
            StreamResult out = new StreamResult(transformedPom);
            TransformerFactory factory = this.getTransformerFactory();
            try {
                Transformer transformer = factory.newTransformer(xslt);
                transformer.transform(xml, out);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to transform " + pomXml + " with " + xsl, e);
            }
            try {
                Files.move(transformedPom.toPath(), pomXml.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to move " + transformedPom + " to " + pomXml, (Exception)e);
            }
        }
        Path seed = pom.getProjectDirectory().toPath().resolve("src").resolve("main").resolve("resources").resolve("seed");
        try {
            Files.createDirectories(seed.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(seed, new OpenOption[0]);){
                writer.write("seed");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create file " + seed, (Exception)e);
        }
        if (!testConfig.getCopyTasks().isEmpty()) {
            for (PlatformMemberTestConfig.Copy copy : testConfig.getCopyTasks()) {
                Path src = Path.of(copy.getSrc(), new String[0]);
                if (!Files.exists(src, new LinkOption[0])) {
                    throw new MojoExecutionException("Failed to generate test module for " + testConfig.getArtifact() + ": couldn't copy " + copy.getSrc() + " to " + copy.getDestination() + " because " + src + " does not exist");
                }
                try {
                    IoUtils.copy((Path)src, (Path)Path.of(copy.getDestination(), new String[0]));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy " + src + " to " + Path.of(copy.getDestination(), new String[0]), (Exception)e);
                }
            }
        }
    }

    private void addQuarkusBuildConfig(Model pom, Dependency appArtifactDep) {
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.quarkusCore.getInputBom().getGroupId());
        plugin.setArtifactId("quarkus-maven-plugin");
        plugin.setVersion(this.quarkusCore.getVersionProperty());
        PluginExecution e = new PluginExecution();
        plugin.addExecution(e);
        e.addGoal("build");
        Xpp3Dom config = new Xpp3Dom("configuration");
        e.setConfiguration((Object)config);
        StringBuilder sb = new StringBuilder();
        sb.append(appArtifactDep.getGroupId()).append(':').append(appArtifactDep.getArtifactId()).append(':');
        if (appArtifactDep.getClassifier() != null && !appArtifactDep.getClassifier().isEmpty()) {
            sb.append(appArtifactDep.getClassifier()).append(':').append(appArtifactDep.getType()).append(':');
        }
        sb.append(appArtifactDep.getVersion());
        config.addChild(GeneratePlatformProjectMojo.textDomElement("appArtifact", sb.toString()));
    }

    private String getTestArtifactVersion(String artifactGroupId, String version) {
        String versionProp;
        if (this.pomPropsByValues.isEmpty()) {
            this.mapProjectProperties(this.project.getOriginalModel().getProperties());
            for (Profile p : this.project.getActiveProfiles()) {
                this.mapProjectProperties(p.getProperties());
            }
        }
        if ((versionProp = this.pomPropsByValues.get(version)) == null) {
            return version;
        }
        if (versionProp.isEmpty() && (versionProp = this.pomPropsByValues.get(artifactGroupId + ":" + version)) == null) {
            return version;
        }
        return "${" + versionProp + "}";
    }

    private void mapProjectProperties(Properties props) {
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String groupId;
            String name = prop.getKey().toString();
            String value = prop.getValue().toString();
            String previous = this.pomPropsByValues.putIfAbsent(value, name);
            if (previous == null || (groupId = this.getTestArtifactGroupIdForProperty(name)) == null) continue;
            if (previous.isEmpty()) {
                this.pomPropsByValues.putIfAbsent(groupId + ":" + value, name);
                continue;
            }
            String previousGroupId = this.getTestArtifactGroupIdForProperty(previous);
            if (previousGroupId == null) {
                this.pomPropsByValues.putIfAbsent(value, name);
            }
            this.pomPropsByValues.put(value, "");
            this.pomPropsByValues.put(previousGroupId + ":" + value, previous);
            this.pomPropsByValues.putIfAbsent(groupId + ":" + value, name);
        }
    }

    private String getTestArtifactGroupIdForProperty(String versionProperty) {
        for (String s : this.pomLines()) {
            int coordsStart;
            int coordsEnd = s.indexOf(versionProperty);
            if (coordsEnd < 0 || (coordsEnd = s.indexOf("</artifact>", coordsEnd)) < 0 || (coordsStart = s.indexOf("<artifact>")) < 0) continue;
            return ArtifactCoords.fromString((String)s.substring(coordsStart += "<artifact>".length(), coordsEnd)).getGroupId();
        }
        return null;
    }

    private void addDependencies(Model pom, List<String> dependencies, boolean test) {
        if (!dependencies.isEmpty()) {
            for (String depStr : dependencies) {
                ArtifactCoords coords = ArtifactCoords.fromString((String)depStr);
                Dependency dep = new Dependency();
                dep.setGroupId(coords.getGroupId());
                dep.setArtifactId(coords.getArtifactId());
                if (!coords.getClassifier().isEmpty()) {
                    dep.setClassifier(coords.getClassifier());
                }
                if (!"jar".equals(coords.getType())) {
                    dep.setType(coords.getType());
                }
                if (!this.universalBomDepKeys.containsKey(ArtifactKey.of((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getClassifier(), (String)coords.getType()))) {
                    dep.setVersion(coords.getVersion());
                }
                if (test) {
                    dep.setScope("test");
                }
                pom.addDependency(dep);
            }
        }
    }

    private void addGroupsConfig(PlatformMemberTestConfig testConfig, Xpp3Dom config, boolean nativeTest) {
        String groupsStr = testConfig.getGroups();
        if (nativeTest && testConfig.getNativeGroups() != null) {
            groupsStr = testConfig.getNativeGroups();
        }
        if (groupsStr == null) {
            return;
        }
        config.addChild(GeneratePlatformProjectMojo.textDomElement("groups", groupsStr));
    }

    private static void addIncludesExcludesConfig(PlatformMemberTestConfig testConfig, Xpp3Dom config, boolean nativeTest) {
        if (nativeTest) {
            if (!testConfig.getNativeIncludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "includes", "include", testConfig.getNativeIncludes());
            }
            if (!testConfig.getNativeExcludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "excludes", "exclude", testConfig.getNativeExcludes());
            }
        } else {
            if (!testConfig.getJvmIncludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "includes", "include", testConfig.getJvmIncludes());
            }
            if (!testConfig.getJvmExcludes().isEmpty()) {
                GeneratePlatformProjectMojo.addElements(config, "excludes", "exclude", testConfig.getJvmExcludes());
            }
        }
    }

    private static void addElements(Xpp3Dom config, String wrapperName, String elementName, List<String> values) {
        Xpp3Dom includes = new Xpp3Dom(wrapperName);
        config.addChild(includes);
        for (String s : values) {
            includes.addChild(GeneratePlatformProjectMojo.textDomElement(elementName, s));
        }
    }

    private TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        return this.transformerFactory == null ? (this.transformerFactory = TransformerFactory.newInstance()) : this.transformerFactory;
    }

    private Plugin createFailsafeConfig(PlatformMemberTestConfig testConfig, Xpp3Dom depsToScan, boolean nativeTest) {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-failsafe-plugin");
        Xpp3Dom config = new Xpp3Dom("configuration");
        plugin.setConfiguration((Object)config);
        config.addChild(depsToScan);
        plugin.setConfiguration((Object)config);
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.addGoal("integration-test");
        exec.addGoal("verify");
        config = new Xpp3Dom("configuration");
        exec.setConfiguration((Object)config);
        if (nativeTest) {
            Xpp3Dom nativeImagePath = new Xpp3Dom("native.image.path");
            GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties").addChild(nativeImagePath);
            nativeImagePath.setValue("${project.build.directory}/${project.build.finalName}-runner");
        }
        if (!testConfig.getSystemProperties().isEmpty()) {
            this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties"), testConfig.getSystemProperties());
        }
        if (!testConfig.getEnvironmentVariables().isEmpty()) {
            this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "environmentVariables"), testConfig.getEnvironmentVariables());
        }
        if (nativeTest) {
            if (!testConfig.getNativeSystemProperties().isEmpty()) {
                this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties"), testConfig.getNativeSystemProperties());
            }
        } else if (!testConfig.getJvmSystemProperties().isEmpty()) {
            this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "systemProperties"), testConfig.getJvmSystemProperties());
        }
        if (nativeTest) {
            if (!testConfig.getNativeEnvironmentVariables().isEmpty()) {
                this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "environmentVariables"), testConfig.getNativeEnvironmentVariables());
            }
        } else if (!testConfig.getJvmEnvironmentVariables().isEmpty()) {
            this.addMapConfig(GeneratePlatformProjectMojo.getOrCreateChild(config, "environmentVariables"), testConfig.getJvmEnvironmentVariables());
        }
        if (nativeTest) {
            if (testConfig.getNativeArgLine() != null) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("argLine", testConfig.getNativeArgLine()));
            } else if (testConfig.getArgLine() != null) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("argLine", testConfig.getArgLine()));
            }
        } else if (testConfig.getJvmArgLine() != null) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("argLine", testConfig.getJvmArgLine()));
        } else if (testConfig.getArgLine() != null) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("argLine", testConfig.getArgLine()));
        }
        if (nativeTest) {
            if (testConfig.getNativeTestPattern() != null) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("test", testConfig.getNativeTestPattern()));
            } else if (testConfig.getTestPattern() != null) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("test", testConfig.getTestPattern()));
            }
        } else if (testConfig.getJvmTestPattern() != null) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("test", testConfig.getJvmTestPattern()));
        } else if (testConfig.getTestPattern() != null) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("test", testConfig.getTestPattern()));
        }
        this.addGroupsConfig(testConfig, config, nativeTest);
        GeneratePlatformProjectMojo.addIncludesExcludesConfig(testConfig, config, nativeTest);
        return plugin;
    }

    private static Xpp3Dom getOrCreateChild(Xpp3Dom parent, String child) {
        Xpp3Dom e = parent.getChild(child);
        if (e == null) {
            e = new Xpp3Dom(child);
            parent.addChild(e);
        }
        return e;
    }

    private void addMapConfig(Xpp3Dom sysProps, Map<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sysProps.addChild(GeneratePlatformProjectMojo.textDomElement(entry.getKey(), entry.getValue()));
        }
    }

    private void generateUniversalPlatformModule(Model parentPom) throws MojoExecutionException {
        Artifact bomArtifact = this.getUniversalBomArtifact();
        String moduleName = GeneratePlatformProjectMojo.getArtifactIdBase(bomArtifact.getArtifactId());
        Model pom = Utils.newModel();
        pom.setArtifactId(moduleName + "-parent");
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " " + GeneratePlatformProjectMojo.artifactIdToName(moduleName) + " - Parent");
        parentPom.addModule(moduleName);
        File pomXml = GeneratePlatformProjectMojo.getPomFile(parentPom, moduleName);
        pom.setPomFile(pomXml);
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(pomXml.toPath().getParent().relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        this.generatePlatformDescriptorModule(ArtifactCoords.of((String)bomArtifact.getGroupId(), (String)PlatformArtifacts.ensureCatalogArtifactId((String)bomArtifact.getArtifactId()), (String)bomArtifact.getVersion(), (String)"json", (String)bomArtifact.getVersion()), pom, true, null, null);
        GeneratePlatformProjectMojo.persistPom(pom);
        GeneratePlatformProjectMojo.persistPom(parentPom);
        DecomposedBom generatedBom = this.generateUniversalPlatformBomModule(pom);
        if (this.platformConfig.getUniversal().isGeneratePlatformProperties()) {
            PlatformMemberConfig tmpConfig = new PlatformMemberConfig();
            tmpConfig.setBom(this.platformConfig.getUniversal().getBom());
            PlatformMemberImpl tmp = new PlatformMemberImpl(tmpConfig);
            tmp.setAlignedDecomposedBom(generatedBom);
            tmp.baseModel = pom;
            this.generatePlatformPropertiesModule(tmp, false);
        }
        if (this.platformConfig.getUniversal().isSkipInstall()) {
            Utils.skipInstallAndDeploy(pom);
        }
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    /*
     * WARNING - void declaration
     */
    private void generatePlatformDescriptorModule(ArtifactCoords descriptorCoords, Model parentPom, boolean copyQuarkusCoreMetadata, AttachedMavenPluginConfig attachedPlugin, PlatformMember member) throws MojoExecutionException {
        Object overridesFile;
        String moduleName = "descriptor";
        parentPom.addModule("descriptor");
        Path moduleDir = parentPom.getProjectDirectory().toPath().resolve("descriptor");
        Model pom = Utils.newModel();
        if (!descriptorCoords.getGroupId().equals(ModelUtils.getGroupId((Model)parentPom))) {
            pom.setGroupId(descriptorCoords.getGroupId());
        }
        pom.setArtifactId(descriptorCoords.getArtifactId());
        if (!descriptorCoords.getVersion().equals(ModelUtils.getVersion((Model)parentPom))) {
            pom.setVersion(descriptorCoords.getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform Descriptor");
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(moduleDir.relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        this.addResourcesPlugin(pom, true);
        Build build = pom.getBuild();
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("generate-platform-descriptor");
        Xpp3Dom config = new Xpp3Dom("configuration");
        String bomArtifact = PlatformArtifacts.ensureBomArtifactId((String)descriptorCoords.getArtifactId());
        config.addChild(GeneratePlatformProjectMojo.textDomElement("bomArtifactId", bomArtifact));
        config.addChild(GeneratePlatformProjectMojo.textDomElement("quarkusCoreVersion", this.quarkusCore.getVersionProperty()));
        if (this.platformConfig.hasUpstreamQuarkusCoreVersion()) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("upstreamQuarkusCoreVersion", this.platformConfig.getUpstreamQuarkusCoreVersion()));
        }
        Xpp3Dom stackConfig = new Xpp3Dom("platformRelease");
        config.addChild(stackConfig);
        Xpp3Dom platformKey = new Xpp3Dom("platformKey");
        stackConfig.addChild(platformKey);
        stackConfig.addChild(GeneratePlatformProjectMojo.textDomElement("stream", "${platform.stream}"));
        stackConfig.addChild(GeneratePlatformProjectMojo.textDomElement("version", "${platform.release}"));
        Xpp3Dom membersConfig = new Xpp3Dom("members");
        stackConfig.addChild(membersConfig);
        if (descriptorCoords.getGroupId().equals(this.getUniversalBomArtifact().getGroupId()) && descriptorCoords.getArtifactId().equals(PlatformArtifacts.ensureCatalogArtifactId((String)this.getUniversalBomArtifact().getArtifactId()))) {
            platformKey.setValue("${project.groupId}");
            this.addMemberDescriptorConfig(pom, membersConfig, descriptorCoords);
        } else {
            platformKey.setValue("${platform.key}");
            for (PlatformMember platformMember : this.members.values()) {
                if (platformMember.config().isHidden()) continue;
                this.addMemberDescriptorConfig(pom, membersConfig, platformMember.descriptorCoords());
            }
        }
        ObjectNode overrides = null;
        if (copyQuarkusCoreMetadata) {
            JsonNode categories;
            JsonNode descriptorNode;
            Path jsonPath;
            overrides = CatalogMapperHelper.mapper().createObjectNode();
            Artifact artifact = this.quarkusCore.getInputBom();
            DefaultArtifact jsonArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId() + "-quarkus-platform-descriptor", artifact.getVersion(), "json", artifact.getVersion());
            try {
                jsonPath = this.getNonWorkspaceResolver().resolve((Artifact)jsonArtifact).getArtifact().getFile().toPath();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to resolve " + jsonArtifact, (Exception)((Object)e));
            }
            try (BufferedReader bufferedReader = Files.newBufferedReader(jsonPath);){
                descriptorNode = CatalogMapperHelper.mapper().readTree((Reader)bufferedReader);
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Failed to deserialize " + jsonPath, (Exception)iOException);
            }
            JsonNode jsonNode = descriptorNode.get("metadata");
            if (jsonNode != null) {
                JsonNode props;
                if (attachedPlugin != null && (props = jsonNode.get("project")) != null && (props = props.get("properties")) != null) {
                    ObjectNode jo = (ObjectNode)props;
                    ArtifactCoords pluginCoords = ArtifactCoords.fromString((String)attachedPlugin.getTargetPluginCoords());
                    String pluginGroupId = pluginCoords.getGroupId().equals(ModelUtils.getGroupId((Model)pom)) ? "${project.groupId}" : pluginCoords.getGroupId();
                    jo.replace("maven-plugin-groupId", (JsonNode)jo.textNode(pluginGroupId));
                    jo.replace("maven-plugin-version", (JsonNode)jo.textNode(GeneratePlatformProjectMojo.getDependencyVersion(pom, pluginCoords)));
                }
                overrides.set("metadata", jsonNode);
            }
            if ((categories = descriptorNode.get("categories")) != null) {
                overrides.set("categories", categories);
            }
        }
        PlatformDescriptorGeneratorConfig platformDescriptorGeneratorConfig = this.platformConfig.getDescriptorGenerator();
        if (member != null) {
            Object metadata;
            Artifact lastUpdatedBom = member.latestBomRelease();
            pom.getProperties().setProperty(MEMBER_LAST_BOM_UPDATE_PROP, lastUpdatedBom.getGroupId() + ":" + lastUpdatedBom.getArtifactId() + ":" + lastUpdatedBom.getVersion());
            if (overrides == null) {
                overrides = CatalogMapperHelper.mapper().createObjectNode();
            }
            if ((metadata = overrides.get("metadata")) == null) {
                metadata = overrides.putObject("metadata");
            }
            ObjectNode on = (ObjectNode)metadata;
            on.set(LAST_BOM_UPDATE, (JsonNode)on.textNode("${member.last-bom-update}"));
            List list = member.getExtensionGroupIds();
            if (!list.isEmpty()) {
                Xpp3Dom processGroupIds = new Xpp3Dom("processGroupIds");
                config.addChild(processGroupIds);
                for (String groupId : list) {
                    processGroupIds.addChild(GeneratePlatformProjectMojo.textDomElement("groupId", groupId));
                }
            }
            this.addExtensionDependencyCheck(member.config().getRedHatExtensionDependencyCheck(), config);
        } else {
            this.addExtensionDependencyCheck(this.platformConfig.getUniversal().getRedHatExtensionDependencyCheck(), config);
        }
        if (platformDescriptorGeneratorConfig != null && !platformDescriptorGeneratorConfig.ignoredArtifacts.isEmpty()) {
            Xpp3Dom ignoredArtifacts = new Xpp3Dom("ignoredArtifacts");
            config.addChild(ignoredArtifacts);
            for (String coords : platformDescriptorGeneratorConfig.ignoredArtifacts) {
                ignoredArtifacts.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", coords));
            }
        }
        StringJoiner metadataOverrideFiles = new StringJoiner(",");
        if (overrides != null && !overrides.isEmpty()) {
            overridesFile = moduleDir.resolve("src").resolve("main").resolve("resources").resolve("overrides.json");
            try {
                CatalogMapperHelper.serialize((Object)overrides, (Path)overridesFile);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Failed to serialize metadata to " + (Path)overridesFile, ex);
            }
            overridesFile = moduleDir.resolve("target").resolve("classes").resolve(overridesFile.getFileName());
            metadataOverrideFiles.add("${project.basedir}/" + moduleDir.relativize((Path)overridesFile));
        }
        if (platformDescriptorGeneratorConfig != null && platformDescriptorGeneratorConfig.overridesFile != null) {
            void var23_38;
            overridesFile = platformDescriptorGeneratorConfig.overridesFile.split(",");
            int ex = ((String[])overridesFile).length;
            boolean bl = false;
            while (var23_38 < ex) {
                String path = overridesFile[var23_38];
                metadataOverrideFiles.add("${project.basedir}/" + moduleDir.relativize(Paths.get(path.trim(), new String[0])));
                ++var23_38;
            }
        }
        if (member == null) {
            ArrayList overrideArtifacts = new ArrayList(0);
            for (PlatformMember platformMember : this.members.values()) {
                for (String s : platformMember.config().getMetadataOverrideFiles()) {
                    this.addMetadataOverrideFile(metadataOverrideFiles, moduleDir, Path.of(s, new String[0]));
                }
                overrideArtifacts.addAll(platformMember.config().getMetadataOverrideArtifacts());
            }
            this.addMetadataOverrideArtifacts(config, overrideArtifacts);
        } else {
            for (String s : member.config().getMetadataOverrideFiles()) {
                this.addMetadataOverrideFile(metadataOverrideFiles, moduleDir, Path.of(s, new String[0]));
            }
            this.addMetadataOverrideArtifacts(config, member.config().getMetadataOverrideArtifacts());
        }
        if (metadataOverrideFiles.length() > 0) {
            config.addChild(GeneratePlatformProjectMojo.textDomElement("overridesFile", metadataOverrideFiles.toString()));
        }
        if (platformDescriptorGeneratorConfig != null) {
            if (platformDescriptorGeneratorConfig.skipCategoryCheck) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("skipCategoryCheck", "true"));
            }
            if (platformDescriptorGeneratorConfig.resolveDependencyManagement) {
                config.addChild(GeneratePlatformProjectMojo.textDomElement("resolveDependencyManagement", "true"));
            }
        }
        plugin.setConfiguration((Object)config);
        Dependency dep = new Dependency();
        dep.setGroupId(descriptorCoords.getGroupId());
        dep.setArtifactId(bomArtifact);
        dep.setType("pom");
        dep.setVersion(GeneratePlatformProjectMojo.getDependencyVersion(pom, descriptorCoords));
        pom.addDependency(dep);
        if (member != null && member.config().isHidden()) {
            Utils.skipInstallAndDeploy(pom);
        }
        this.configureFlattenPluginForMetadataArtifacts(pom);
        Path pomXml = moduleDir.resolve(POM_XML);
        pom.setPomFile(pomXml.toFile());
        GeneratePlatformProjectMojo.persistPom(pom);
    }

    private void configureFlattenPluginForMetadataArtifacts(Model pom) {
        this.configureFlattenPlugin(pom, true, Map.of("dependencyManagement", "remove", "dependencies", "remove", "mailingLists", "remove"));
    }

    private void addExtensionDependencyCheck(RedHatExtensionDependencyCheck depCheckConfig, Xpp3Dom config) {
        if (depCheckConfig != null && depCheckConfig.isEnabled() && depCheckConfig.getVersionPattern() != null) {
            Xpp3Dom depCheck = new Xpp3Dom("extensionDependencyCheck");
            config.addChild(depCheck);
            depCheck.addChild(GeneratePlatformProjectMojo.textDomElement("versionPattern", depCheckConfig.getVersionPattern()));
            if (depCheckConfig.getCheckDepth() != Integer.MAX_VALUE) {
                depCheck.addChild(GeneratePlatformProjectMojo.textDomElement("checkDepth", String.valueOf(depCheckConfig.getCheckDepth())));
            }
        }
    }

    private void addMetadataOverrideArtifacts(Xpp3Dom config, List<String> overrideArtifacts) {
        if (overrideArtifacts.isEmpty()) {
            return;
        }
        Xpp3Dom artifacts = new Xpp3Dom("metadataOverrideArtifacts");
        config.addChild(artifacts);
        for (String s : overrideArtifacts) {
            artifacts.addChild(GeneratePlatformProjectMojo.textDomElement("artifact", s));
        }
    }

    private void addMetadataOverrideFile(StringJoiner metadataOverrideFiles, Path moduleDir, Path file) throws MojoExecutionException {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new MojoExecutionException("Configured metadata overrides file " + file + " does not exist");
        }
        metadataOverrideFiles.add("${project.basedir}/" + moduleDir.relativize(file));
    }

    private void addMemberDescriptorConfig(Model pom, Xpp3Dom membersConfig, ArtifactCoords memberCoords) {
        Object value = memberCoords.getGroupId().equals(ModelUtils.getGroupId((Model)pom)) && memberCoords.getVersion().equals(ModelUtils.getVersion((Model)pom)) ? "${project.groupId}:" + memberCoords.getArtifactId() + ":${project.version}:json:${project.version}" : memberCoords.toString();
        membersConfig.addChild(GeneratePlatformProjectMojo.textDomElement("member", (String)value));
    }

    private void generatePlatformPropertiesModule(PlatformMemberImpl member, boolean addPlatformReleaseConfig) throws MojoExecutionException {
        ArtifactCoords propertiesCoords = member.propertiesCoords();
        Model parentPom = member.baseModel;
        String moduleName = "properties";
        parentPom.addModule("properties");
        Path moduleDir = parentPom.getProjectDirectory().toPath().resolve("properties");
        Model pom = Utils.newModel();
        if (!propertiesCoords.getGroupId().equals(ModelUtils.getGroupId((Model)parentPom))) {
            pom.setGroupId(propertiesCoords.getGroupId());
        }
        pom.setArtifactId(propertiesCoords.getArtifactId());
        if (!propertiesCoords.getVersion().equals(ModelUtils.getVersion((Model)parentPom))) {
            pom.setVersion(propertiesCoords.getVersion());
        }
        pom.setPackaging("pom");
        pom.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform Properties");
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)parentPom));
        parent.setArtifactId(parentPom.getArtifactId());
        parent.setRelativePath(moduleDir.relativize(parentPom.getProjectDirectory().toPath()).toString());
        pom.setParent(parent);
        GeneratePlatformProjectMojo.setParentVersion(pom, parentPom);
        DependencyManagement dm = new DependencyManagement();
        pom.setDependencyManagement(dm);
        Dependency bom = new Dependency();
        dm.addDependency(bom);
        bom.setGroupId(propertiesCoords.getGroupId());
        bom.setArtifactId(propertiesCoords.getArtifactId().substring(0, propertiesCoords.getArtifactId().length() - "-quarkus-platform-properties".length()));
        bom.setVersion(GeneratePlatformProjectMojo.getDependencyVersion(pom, propertiesCoords));
        bom.setType("pom");
        bom.setScope("import");
        this.addResourcesPlugin(pom, true);
        Build build = pom.getBuild();
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId(this.pluginDescriptor().getGroupId());
        plugin.setArtifactId(this.pluginDescriptor().getArtifactId());
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("platform-properties");
        OrderedProperties props = new OrderedProperties.OrderedPropertiesBuilder().withOrdering(String.CASE_INSENSITIVE_ORDER).withSuppressDateInComment(true).build();
        if (member.config().getBom() != null) {
            List originalDm;
            PlatformMemberImpl srcMember = this.platformConfig.getUniversal().getBom().equals(member.config().getBom()) ? this.quarkusCore : member;
            try {
                originalDm = this.getNonWorkspaceResolver().resolveDescriptor(srcMember.getInputBom()).getManagedDependencies();
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to resolve " + member.getInputBom(), (Exception)((Object)e));
            }
            Properties tmp = new Properties();
            for (org.eclipse.aether.graph.Dependency dependency : originalDm) {
                Artifact a = dependency.getArtifact();
                if (!a.getExtension().equals("properties") || !a.getArtifactId().endsWith("-quarkus-platform-properties") || !a.getArtifactId().startsWith(srcMember.getInputBom().getArtifactId()) || !a.getGroupId().equals(srcMember.getInputBom().getGroupId()) || !a.getVersion().equals(srcMember.getInputBom().getVersion())) continue;
                try (BufferedReader reader = Files.newBufferedReader(this.nonWsResolver.resolve(a).getArtifact().getFile().toPath());){
                    tmp.load(reader);
                    break;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to resolve " + a, e);
                }
            }
            for (Map.Entry entry : tmp.entrySet()) {
                String name = entry.getKey().toString();
                pom.getProperties().setProperty(name, entry.getValue().toString());
                props.setProperty(name, "${" + name + "}");
            }
        }
        if (addPlatformReleaseConfig) {
            Xpp3Dom config = new Xpp3Dom("configuration");
            Xpp3Dom stackConfig = new Xpp3Dom("platformRelease");
            config.addChild(stackConfig);
            stackConfig.addChild(GeneratePlatformProjectMojo.textDomElement("platformKey", "${platform.key}"));
            stackConfig.addChild(GeneratePlatformProjectMojo.textDomElement("stream", "${platform.stream}"));
            stackConfig.addChild(GeneratePlatformProjectMojo.textDomElement("version", "${platform.release}"));
            Xpp3Dom membersConfig = new Xpp3Dom("members");
            stackConfig.addChild(membersConfig);
            Iterator<PlatformMemberImpl> i = this.members.values().iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (i.hasNext()) {
                PlatformMember m = i.next();
                if (m.config().isHidden()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                membersConfig.addChild(GeneratePlatformProjectMojo.textDomElement("member", m.descriptorCoords().toString()));
                ArtifactCoords bomCoords = PlatformArtifacts.ensureBomArtifact((ArtifactCoords)m.descriptorCoords());
                if (bomCoords.getGroupId().equals(this.project.getGroupId()) && bomCoords.getVersion().equals(this.project.getVersion())) {
                    stringBuilder.append("${project.groupId}:").append(bomCoords.getArtifactId()).append("::pom:${project.version}");
                    continue;
                }
                stringBuilder.append(bomCoords);
            }
            props.setProperty("platform.release-info@${platform.key}$${platform.stream}#${platform.release}", stringBuilder.toString());
        }
        if (member.config().isHidden()) {
            Utils.skipInstallAndDeploy(pom);
        }
        this.configureFlattenPluginForMetadataArtifacts(pom);
        Path pomXml = moduleDir.resolve(POM_XML);
        pom.setPomFile(pomXml.toFile());
        GeneratePlatformProjectMojo.persistPom(pom);
        Path dir = pom.getPomFile().toPath().getParent().resolve("src").resolve("main").resolve("resources");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directory " + dir, (Exception)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(dir.resolve("platform-properties.properties"), new OpenOption[0]);){
            props.store((Writer)writer, pom.getName());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + dir.resolve("platform-properties.properties"), (Exception)e);
        }
    }

    private void addResourcesPlugin(Model pom, boolean filtering) {
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        Plugin plugin = new Plugin();
        build.addPlugin(plugin);
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-resources-plugin");
        PluginExecution exec = new PluginExecution();
        plugin.addExecution(exec);
        exec.setPhase("process-resources");
        exec.addGoal("resources");
        if (filtering) {
            Resource r = new Resource();
            r.setDirectory("src/main/resources");
            r.setFiltering(true);
            build.setResources(Collections.singletonList(r));
        }
    }

    private PluginDescriptor pluginDescriptor() {
        return this.pluginDescr == null ? (this.pluginDescr = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor")) : this.pluginDescr;
    }

    private DecomposedBom generateUniversalPlatformBomModule(Model parentPom) throws MojoExecutionException {
        Artifact bomArtifact = this.getUniversalBomArtifact();
        PlatformBomGeneratorConfig bomGen = this.platformConfig.getBomGenerator();
        PlatformBomConfig.Builder configBuilder = PlatformBomConfig.builder().artifactResolver(ArtifactResolverProvider.get((MavenArtifactResolver)this.getNonWorkspaceResolver())).pomResolver(PomSource.of((Artifact)bomArtifact)).includePlatformProperties(this.platformConfig.getUniversal().isGeneratePlatformProperties()).platformBom(bomArtifact).versionIncrementor(this.platformConfig.getRelease() == null ? null : this.platformConfig.getRelease().getVersionIncrementor());
        if (this.platformConfig.getBomGenerator() != null) {
            configBuilder.disableGroupAlignmentToPreferredVersions(this.platformConfig.getBomGenerator().disableGroupAlignmentToPreferredVersions);
        }
        for (PlatformMember platformMember : this.members.values()) {
            configBuilder.addMember(platformMember);
        }
        if (bomGen != null) {
            configBuilder.enableNonMemberQuarkiverseExtensions(bomGen.enableNonMemberQuarkiverseExtensions);
            if (bomGen.enforcedDependencies != null) {
                for (String string : bomGen.enforcedDependencies) {
                    ArtifactCoords coords = ArtifactCoords.fromString((String)string);
                    configBuilder.enforce((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
                }
            }
            if (bomGen.excludedDependencies != null) {
                for (String string : bomGen.excludedDependencies) {
                    configBuilder.exclude(ArtifactKey.fromString((String)string));
                }
            }
            if (bomGen.excludedGroups != null) {
                for (String string : bomGen.excludedGroups) {
                    configBuilder.excludeGroupId(string);
                }
            }
            configBuilder.versionConstraintPreference(bomGen.versionConstraintPreferences);
            int foreignPreferredConstraint = 0;
            if (bomGen.notPreferredQuarkusBomConstraint != null) {
                if (bomGen.foreignPreferredConstraint != null) {
                    throw new IllegalStateException("Deprecated notPreferredQuarkusBomConstraint is configured in addition to foreignPreferredConstrait");
                }
                foreignPreferredConstraint = ForeignPreferredConstraint.valueOf((String)bomGen.notPreferredQuarkusBomConstraint).flag();
            } else if (bomGen.foreignPreferredConstraint != null) {
                for (String s : bomGen.foreignPreferredConstraint.split("\\s*,\\s*")) {
                    if (s.isEmpty()) continue;
                    foreignPreferredConstraint |= ForeignPreferredConstraint.valueOf((String)s).flag();
                }
            }
            if (foreignPreferredConstraint > 0) {
                configBuilder.foreignPreferredConstraint(foreignPreferredConstraint);
            }
        }
        try {
            this.universalGeneratedBom = new PlatformBomComposer(configBuilder.build(), (MessageWriter)new MojoMessageWriter(this.getLog())).platformBom();
        }
        catch (BomDecomposerException e) {
            throw new MojoExecutionException("Failed to generate the platform BOM", (Exception)((Object)e));
        }
        Model baseModel = this.project.getModel().clone();
        baseModel.setName(GeneratePlatformProjectMojo.getNameBase(parentPom) + " Quarkus Platform BOM");
        String string = "bom";
        parentPom.addModule("bom");
        this.universalPlatformBomXml = parentPom.getProjectDirectory().toPath().resolve("bom").resolve(POM_XML);
        Model pom = PlatformBomUtils.toPlatformModel((DecomposedBom)this.universalGeneratedBom, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        this.addReleaseProfile(pom);
        try {
            Files.createDirectories(this.universalPlatformBomXml.getParent(), new FileAttribute[0]);
            ModelUtils.persistModel((Path)this.universalPlatformBomXml, (Model)pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist generated BOM to " + this.universalPlatformBomXml, (Exception)e);
        }
        for (ProjectRelease r : this.universalGeneratedBom.releases()) {
            for (ProjectDependency d : r.dependencies()) {
                this.universalBomDepKeys.put(d.key(), d.artifact().getVersion());
            }
        }
        return this.universalGeneratedBom;
    }

    private Artifact getUniversalBomArtifact() {
        return this.universalBom == null ? (this.universalBom = GeneratePlatformProjectMojo.toPomArtifact(this.platformConfig.getUniversal().getBom())) : this.universalBom;
    }

    private PlatformCatalogResolver catalogResolver() {
        return this.catalogs == null ? (this.catalogs = new PlatformCatalogResolver(this.getWorkspaceAwareMavenResolver())) : this.catalogs;
    }

    private MavenArtifactResolver getNonWorkspaceResolver() {
        if (this.nonWsResolver == null) {
            try {
                this.nonWsResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositoryManager(this.mvnProvider.getRemoteRepositoryManager())).setRemoteRepositories(this.repos)).setWorkspaceDiscovery(false)).build();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
            }
        }
        return this.nonWsResolver;
    }

    private MavenArtifactResolver getWorkspaceAwareMavenResolver() {
        if (this.wsAwareResolver == null) {
            this.wsAwareResolver = this.mvnProvider.createArtifactResolver(BootstrapMavenContext.config().setRemoteRepositories(this.repos).setCurrentProject(new File(this.outputDir, POM_XML).toString()));
        }
        return this.wsAwareResolver;
    }

    private PlatformReleaseConfig releaseConfig() {
        if (this.platformReleaseConfig == null) {
            PlatformReleaseConfig tmp;
            PlatformReleaseConfig platformReleaseConfig = tmp = this.platformConfig.getRelease() == null ? new PlatformReleaseConfig() : this.platformConfig.getRelease();
            if (tmp.getPlatformKey() == null) {
                tmp.setPlatformKey(this.project.getGroupId());
            }
            if (tmp.getStream() == null) {
                String projectVersion = this.project.getVersion();
                int microDot = projectVersion.lastIndexOf(46);
                while (microDot > 0 && !Character.isDigit(projectVersion.charAt(microDot + 1))) {
                    microDot = projectVersion.lastIndexOf(46, microDot - 1);
                }
                tmp.setStream(microDot < 0 ? projectVersion : projectVersion.substring(0, microDot));
            }
            if (tmp.getVersion() == null) {
                tmp.setVersion(this.quarkusCore.getGeneratedPlatformBom().getVersion());
            }
            this.platformReleaseConfig = tmp;
        }
        return this.platformReleaseConfig;
    }

    private static String getDependencyVersion(Model pom, ArtifactCoords coords) {
        return ModelUtils.getRawVersion((Model)pom).equals(coords.getVersion()) ? "${project.version}" : coords.getVersion();
    }

    private static ArtifactKey toKey(Artifact a) {
        return ArtifactKey.ga((String)a.getGroupId(), (String)a.getArtifactId());
    }

    private static DefaultArtifact toPomArtifact(String coords) {
        return GeneratePlatformProjectMojo.toPomArtifact(ArtifactCoords.fromString((String)coords));
    }

    private static DefaultArtifact toPomArtifact(ArtifactCoords coords) {
        return new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), "", "pom", coords.getVersion());
    }

    private static Artifact toAetherArtifact(String coords) {
        ArtifactCoords a = ArtifactCoords.fromString((String)coords);
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private static void persistPom(Model pom) throws MojoExecutionException {
        try {
            pom.getPomFile().getParentFile().mkdirs();
            ModelUtils.persistModel((Path)pom.getPomFile().toPath(), (Model)pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate the platform BOM " + pom.getPomFile(), (Exception)e);
        }
    }

    private static String getArtifactIdBase(Model pom) {
        return GeneratePlatformProjectMojo.getArtifactIdBase(pom.getArtifactId());
    }

    private static String getArtifactIdBase(String s) {
        int i = s.lastIndexOf(45);
        return i > 0 ? s.substring(0, i) : s;
    }

    private static String getNameBase(Model pom) {
        String s = pom.getName();
        int i = s.lastIndexOf(45);
        return i > 0 ? s.substring(0, i + 1) : s;
    }

    private static String artifactIdToName(String artifactId) {
        String[] parts = artifactId.split("-");
        StringBuilder buf = new StringBuilder(artifactId.length() + parts.length);
        String part = parts[0];
        buf.append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        for (int i = 1; i < parts.length; ++i) {
            part = parts[i];
            buf.append(' ').append(Character.toUpperCase(part.charAt(0))).append(part, 1, part.length());
        }
        return buf.toString();
    }

    private static boolean isBlank(String s) {
        return s == null || s.isBlank();
    }

    private class PlatformMemberImpl
    implements PlatformMember {
        final PlatformMemberConfig config;
        private final Artifact originalBomCoords;
        private Artifact configuredPlatformBom;
        private ArtifactCoords descriptorCoords;
        private ArtifactCoords propertiesCoords;
        private ArtifactCoords stackDescriptorCoords;
        private ArtifactKey key;
        private Model baseModel;
        private DecomposedBom originalBom;
        private DecomposedBom generatedBom;
        private Model generatedBomModel;
        private Path generatedPomFile;
        private String versionProperty;
        private Artifact prevBomRelease;
        private Boolean bomChanged;
        private List<org.eclipse.aether.graph.Dependency> inputConstraints;

        PlatformMemberImpl(PlatformMemberConfig config) {
            this.config = config;
            this.originalBomCoords = config.getBom() == null ? null : GeneratePlatformProjectMojo.toPomArtifact(config.getBom());
        }

        public PlatformMemberConfig config() {
            return this.config;
        }

        public List<String> getExtensionGroupIds() {
            if (!this.config.getExtensionGroupIds().isEmpty()) {
                return this.config.getExtensionGroupIds();
            }
            if (this.getInputBom() != null) {
                return List.of(this.getInputBom().getGroupId());
            }
            return List.of();
        }

        public List<String> getOwnGroupIds() {
            if (!this.config.getOwnGroupIds().isEmpty()) {
                return this.config.getOwnGroupIds();
            }
            return this.getExtensionGroupIds();
        }

        public Artifact previousLastUpdatedBom() {
            if (this.prevBomRelease == null) {
                String prev;
                String string = prev = this.config.getRelease() == null ? null : this.config.getRelease().getLastDetectedBomUpdate();
                if (prev != null) {
                    this.prevBomRelease = GeneratePlatformProjectMojo.toPomArtifact(prev);
                }
            }
            return this.prevBomRelease;
        }

        public Artifact latestBomRelease() {
            return this.bomChanged != null && this.bomChanged != false || this.previousLastUpdatedBom() == null ? this.getGeneratedPlatformBom() : this.previousLastUpdatedBom();
        }

        public Artifact getInputBom() {
            return this.originalBomCoords;
        }

        public Artifact getConfiguredPlatformBom() {
            return this.configuredPlatformBom == null ? (this.configuredPlatformBom = GeneratePlatformProjectMojo.toPomArtifact(this.config.getPlatformBom(GeneratePlatformProjectMojo.this.getUniversalBomArtifact().getGroupId()))) : this.configuredPlatformBom;
        }

        public Artifact getGeneratedPlatformBom() {
            return this.getAlignedDecomposedBom().bomArtifact();
        }

        public boolean isIncrementBomVersionOnChange() {
            return GeneratePlatformProjectMojo.this.platformConfig.getRelease() != null && GeneratePlatformProjectMojo.this.platformConfig.getRelease().isOnlyChangedMembers();
        }

        public ArtifactKey key() {
            if (this.key == null) {
                this.key = this.getInputBom() == null ? GeneratePlatformProjectMojo.toKey(this.getConfiguredPlatformBom()) : GeneratePlatformProjectMojo.toKey(this.getInputBom());
            }
            return this.key;
        }

        public List<org.eclipse.aether.graph.Dependency> inputConstraints() {
            if (this.inputConstraints == null) {
                List dm = this.config.getDependencyManagement().toAetherDependencies();
                if (this.getInputBom() == null) {
                    this.inputConstraints = dm;
                } else if (dm.isEmpty()) {
                    this.inputConstraints = Collections.singletonList(new org.eclipse.aether.graph.Dependency(this.getInputBom(), "import"));
                } else {
                    if (this.getInputBom() != null) {
                        dm.add(new org.eclipse.aether.graph.Dependency(this.getInputBom(), "import"));
                    }
                    this.inputConstraints = dm;
                }
            }
            return this.inputConstraints;
        }

        public ArtifactCoords descriptorCoords() {
            return this.descriptorCoords == null ? (this.descriptorCoords = ArtifactCoords.of((String)this.getGeneratedPlatformBom().getGroupId(), (String)(this.getGeneratedPlatformBom().getArtifactId() + "-quarkus-platform-descriptor"), (String)this.getGeneratedPlatformBom().getVersion(), (String)"json", (String)this.getGeneratedPlatformBom().getVersion())) : this.descriptorCoords;
        }

        public ArtifactCoords propertiesCoords() {
            return this.propertiesCoords == null ? (this.propertiesCoords = ArtifactCoords.of((String)this.getGeneratedPlatformBom().getGroupId(), (String)(this.getGeneratedPlatformBom().getArtifactId() + "-quarkus-platform-properties"), null, (String)"properties", (String)this.getGeneratedPlatformBom().getVersion())) : this.propertiesCoords;
        }

        public String getVersionProperty() {
            if (this.versionProperty == null) {
                Artifact quarkusBom = GeneratePlatformProjectMojo.this.quarkusCore.getInputBom();
                this.versionProperty = GeneratePlatformProjectMojo.this.getTestArtifactVersion(quarkusBom.getGroupId(), quarkusBom.getVersion());
                if (this.versionProperty.equals(quarkusBom.getVersion())) {
                    String ga = quarkusBom.getGroupId() + ":" + quarkusBom.getArtifactId() + ":";
                    for (String l : GeneratePlatformProjectMojo.this.pomLines()) {
                        if (!l.startsWith(ga)) continue;
                        this.versionProperty = ArtifactCoords.fromString((String)l).getVersion();
                        break;
                    }
                }
            }
            return this.versionProperty;
        }

        public DecomposedBom originalDecomposedBom() {
            return this.originalBom;
        }

        public void setOriginalDecomposedBom(DecomposedBom originalBom) {
            this.originalBom = originalBom;
        }

        public void setAlignedDecomposedBom(DecomposedBom alignedBom) {
            this.generatedBom = alignedBom;
        }

        public DecomposedBom getAlignedDecomposedBom() {
            return this.generatedBom;
        }

        public Collection<ArtifactKey> extensionCatalog() {
            return List.of();
        }

        public void setExtensionCatalog(Collection<ArtifactKey> extensionCatalog) {
        }
    }
}

