/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

@Mojo(name="extension-changes", threadSafe=true, requiresProject=false)
public class ExtensionChangesMojo
extends AbstractMojo {
    @Component
    RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(property="bom", required=true)
    String bom;
    @Parameter(property="previousBom", required=false)
    String previousBom;
    @Parameter(property="registryConfig", required=false)
    File registryConfig;
    @Parameter(property="registry", required=false, defaultValue="registry.quarkus.io")
    String registry;
    @Parameter(property="outputFile", required=false)
    File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<Object, Object> previousExtensions;
        MavenArtifactResolver resolver;
        ArtifactCoords catalogCoords = PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)ArtifactCoords.fromString((String)this.bom));
        try {
            resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRemoteRepositoryManager(this.remoteRepoManager)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
        ExtensionCatalog catalog = ExtensionChangesMojo.resolveExtensionCatalog(catalogCoords, resolver);
        ArtifactCoords previousCatalogCoords = this.previousBom == null ? this.getPreviousBom(resolver, catalog) : PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)ArtifactCoords.fromString((String)this.previousBom));
        ExtensionCatalog previousCatalog = previousCatalogCoords != null ? ExtensionChangesMojo.resolveExtensionCatalog(previousCatalogCoords, resolver) : null;
        Map<ArtifactKey, String> extensions = ExtensionChangesMojo.getExtensions(catalog);
        if (previousCatalog == null) {
            this.getLog().warn((CharSequence)"Could not determine the previous version of the extension catalog");
            previousExtensions = Map.of();
        } else {
            this.getLog().info((CharSequence)("Comparing " + catalog.getBom().toCompactCoords() + " to " + previousCatalog.getBom().toCompactCoords()));
            previousExtensions = ExtensionChangesMojo.getExtensions(previousCatalog);
        }
        List<Dependency> platformConstraints = null;
        List<Dependency> prevPlatformConstraints = null;
        ArrayList<ExtensionStatus> statusList = new ArrayList<ExtensionStatus>();
        for (Map.Entry<Object, Object> entry : previousExtensions.entrySet()) {
            String newVersion = extensions.remove(entry.getKey());
            if (newVersion == null) {
                statusList.add(ExtensionStatus.removed((ArtifactKey)entry.getKey(), (String)entry.getValue()));
                continue;
            }
            if (newVersion.equals(entry.getValue())) {
                DefaultArtifact artifact;
                if (platformConstraints == null) {
                    platformConstraints = this.getPlatformConstraints(catalog, resolver);
                    prevPlatformConstraints = this.getPlatformConstraints(previousCatalog, resolver);
                }
                if (ExtensionChangesMojo.getClasspath((Artifact)(artifact = new DefaultArtifact(((ArtifactKey)entry.getKey()).getGroupId(), ((ArtifactKey)entry.getKey()).getArtifactId(), ((ArtifactKey)entry.getKey()).getClassifier(), ((ArtifactKey)entry.getKey()).getType(), (String)entry.getValue())), platformConstraints, resolver).equals(ExtensionChangesMojo.getClasspath((Artifact)artifact, prevPlatformConstraints, resolver))) continue;
                statusList.add(ExtensionStatus.classpathUpdate((ArtifactKey)entry.getKey(), (String)entry.getValue()));
                continue;
            }
            statusList.add(ExtensionStatus.versionUpdate((ArtifactKey)entry.getKey(), newVersion));
        }
        for (Map.Entry<Object, Object> entry : extensions.entrySet()) {
            statusList.add(ExtensionStatus.newStatus((ArtifactKey)entry.getKey(), (String)entry.getValue()));
        }
        if (this.outputFile != null) {
            this.outputFile.getParentFile().mkdirs();
        }
        StringWriter json = null;
        try {
            BufferedWriter bufferedWriter;
            if (this.outputFile == null) {
                json = new StringWriter();
                BufferedWriter bufferedWriter2 = new BufferedWriter(json);
                bufferedWriter = bufferedWriter2;
            } else {
                bufferedWriter = Files.newBufferedWriter(this.outputFile.toPath(), new OpenOption[0]);
            }
            try (BufferedWriter bufferedWriter3 = bufferedWriter;){
                CatalogMapperHelper.serialize(statusList, (Writer)bufferedWriter3);
            }
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Failed to serialize extension changes report to JSON", (Exception)iOException);
        }
        if (json != null) {
            this.getLog().info((CharSequence)json.getBuffer().toString());
        }
    }

    private static Set<ArtifactCoords> getClasspath(Artifact a, List<Dependency> managedDeps, MavenArtifactResolver resolver) {
        DependencyNode root;
        try {
            root = resolver.collectManagedDependencies(a, List.of(), managedDeps, List.of(), List.of(), new String[0]).getRoot();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException(e);
        }
        return ExtensionChangesMojo.getClasspath(root);
    }

    private static Set<ArtifactCoords> getClasspath(DependencyNode node) {
        HashSet<ArtifactCoords> result = new HashSet<ArtifactCoords>();
        for (DependencyNode c : node.getChildren()) {
            ExtensionChangesMojo.collectClasspath(c, result);
        }
        return result;
    }

    private static void collectClasspath(DependencyNode node, Set<ArtifactCoords> collected) {
        Artifact a = node.getArtifact();
        if (a != null) {
            collected.add(ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion()));
        }
        for (DependencyNode c : node.getChildren()) {
            ExtensionChangesMojo.collectClasspath(c, collected);
        }
    }

    private List<Dependency> getPlatformConstraints(ExtensionCatalog catalog, MavenArtifactResolver resolver) {
        Map map = (Map)catalog.getMetadata().get("platform-release");
        if (map == null) {
            throw new IllegalArgumentException("Failed to locate platform-release metadata in " + catalog.getId());
        }
        List members = (List)map.get("members");
        if (members == null) {
            throw new IllegalArgumentException("Failed to locate members under platform-release metadata in " + catalog.getId());
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (String s : members) {
            ArtifactDescriptorResult descriptor;
            ArtifactCoords bomCoords = PlatformArtifacts.ensureBomArtifact((ArtifactCoords)ArtifactCoords.fromString((String)s));
            try {
                descriptor = resolver.resolveDescriptor((Artifact)new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), bomCoords.getClassifier(), bomCoords.getType(), bomCoords.getVersion()));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve artifact descriptor for " + bomCoords.toCompactCoords(), e);
            }
            if (descriptor.getManagedDependencies().isEmpty()) {
                this.getLog().warn((CharSequence)("Failed to collect managed dependencies from " + bomCoords.toCompactCoords()));
                continue;
            }
            result.addAll(descriptor.getManagedDependencies());
        }
        return result;
    }

    private static Map<ArtifactKey, String> getExtensions(ExtensionCatalog catalog) {
        if (catalog == null) {
            return Map.of();
        }
        Collection extensionList = catalog.getExtensions();
        HashMap<ArtifactKey, String> result = new HashMap<ArtifactKey, String>(extensionList.size());
        for (Extension e : extensionList) {
            Object unlisted = e.getMetadata().get("unlisted");
            if (unlisted != null && (unlisted instanceof Boolean && ((Boolean)unlisted).booleanValue() || unlisted instanceof String && Boolean.parseBoolean((String)unlisted))) continue;
            result.put(e.getArtifact().getKey(), e.getArtifact().getVersion());
        }
        return result;
    }

    private static ExtensionCatalog resolveExtensionCatalog(ArtifactCoords catalogCoords, MavenArtifactResolver resolver) throws MojoExecutionException {
        ExtensionCatalog catalog;
        Path catalogJson;
        try {
            catalogJson = resolver.resolve((Artifact)new DefaultArtifact(catalogCoords.getGroupId(), catalogCoords.getArtifactId(), catalogCoords.getClassifier(), catalogCoords.getType(), catalogCoords.getVersion())).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve extension catalog " + catalogCoords, (Exception)((Object)e));
        }
        try {
            catalog = ExtensionCatalog.fromFile((Path)catalogJson);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to deserialize extension catalog " + catalogJson, (Exception)e);
        }
        return catalog;
    }

    private ArtifactCoords getPreviousBom(MavenArtifactResolver resolver, ExtensionCatalog catalog) throws MojoExecutionException {
        GenericVersion current;
        PlatformStream prevStream;
        ExtensionCatalogResolver catalogResolver;
        ExtensionCatalogResolver.Builder extResolverBuilder = ExtensionCatalogResolver.builder().artifactResolver(resolver).messageWriter((MessageWriter)new MojoMessageWriter(this.getLog()));
        if (this.registryConfig != null) {
            if (!this.registryConfig.exists()) {
                throw new MojoExecutionException(this.registryConfig + " does not exist");
            }
            if (this.registryConfig.isDirectory()) {
                throw new MojoExecutionException(this.registryConfig + " is a directory");
            }
            try {
                extResolverBuilder.config(RegistriesConfig.fromFile((Path)this.registryConfig.toPath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse registry configuration file " + this.registryConfig, (Exception)e);
            }
        } else {
            if (this.registry == null || this.registry.isEmpty()) {
                throw new MojoExecutionException("Registry ID has not been provided");
            }
            extResolverBuilder.config(RegistriesConfig.builder().setRegistries(List.of(RegistryConfig.builder().setId(this.registry).build())).build());
        }
        try {
            catalogResolver = extResolverBuilder.build();
        }
        catch (RegistryResolutionException e) {
            throw new MojoExecutionException("Failed to initialize extension catalog resolver for registry " + this.registry, (Exception)((Object)e));
        }
        Map platformRelease = (Map)catalog.getMetadata().get("platform-release");
        if (platformRelease == null) {
            throw new MojoExecutionException("Failed to locate platform-release information in " + catalog.getId());
        }
        String currentPlatform = (String)platformRelease.get("platform-key");
        if (currentPlatform == null) {
            throw new MojoExecutionException("Failed to locate the platform key in " + catalog.getBom().toCompactCoords());
        }
        String currentStream = (String)platformRelease.get("stream");
        if (currentStream == null) {
            throw new MojoExecutionException("Failed to determine the platform release stream of " + catalog.getBom().toCompactCoords());
        }
        String currentVersion = (String)platformRelease.get("version");
        if (currentVersion == null) {
            throw new MojoExecutionException("Failed to platform release version in " + catalog.getBom().toCompactCoords());
        }
        try {
            prevStream = ExtensionChangesMojo.findPlatformStream(currentPlatform, currentStream, catalogResolver.resolvePlatformCatalog("all"));
            if (prevStream == null) {
                this.getLog().debug((CharSequence)"No previous platform release stream");
                return null;
            }
        }
        catch (RegistryResolutionException e) {
            throw new MojoExecutionException("Failed to resolve stream " + currentPlatform + ":" + currentStream, (Exception)((Object)e));
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            current = versionScheme.parseVersion(currentVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        GenericVersion previous = null;
        PlatformRelease previousRelease = null;
        for (PlatformRelease pr : prevStream.getReleases()) {
            GenericVersion v;
            try {
                v = versionScheme.parseVersion(pr.getVersion().toString());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException((Throwable)e);
            }
            if (current.compareTo((Object)v) <= 0 || previous != null && previous.compareTo((Object)v) >= 0) continue;
            previous = v;
            previousRelease = pr;
        }
        if (previousRelease == null) {
            return null;
        }
        ArtifactKey bomKey = catalog.getBom().getKey();
        for (ArtifactCoords bomCoords : previousRelease.getMemberBoms()) {
            if (!bomCoords.getKey().equals(bomKey)) continue;
            return PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)bomCoords);
        }
        return null;
    }

    private static PlatformStream findPlatformStream(String platformKey, String streamId, PlatformCatalog platformCatalog) {
        for (Platform platform : platformCatalog.getPlatforms()) {
            PlatformStream prevStream;
            if (!platformKey.equals(platform.getPlatformKey()) || (prevStream = platform.getStream(streamId)) == null) continue;
            return prevStream;
        }
        return null;
    }

    public static class ExtensionStatus {
        public static final String STATUS_REMOVED = "removed";
        public static final String STATUS_NEW = "new";
        public static final String STATUS_VERSION_UPDATE = "version-update";
        public static final String STATUS_CLASSPATH_UPDATE = "classpath-update";
        public String artifact;
        public String status;

        public static ExtensionStatus removed(ArtifactKey key, String version) {
            return new ExtensionStatus(key + ":" + version, STATUS_REMOVED);
        }

        public static ExtensionStatus newStatus(ArtifactKey key, String version) {
            return new ExtensionStatus(key + ":" + version, STATUS_NEW);
        }

        public static ExtensionStatus versionUpdate(ArtifactKey key, String version) {
            return new ExtensionStatus(key + ":" + version, STATUS_VERSION_UPDATE);
        }

        public static ExtensionStatus classpathUpdate(ArtifactKey key, String version) {
            return new ExtensionStatus(key + ":" + version, STATUS_CLASSPATH_UPDATE);
        }

        public ExtensionStatus() {
        }

        public ExtensionStatus(String artifact, String status) {
            this.artifact = artifact;
            this.status = status;
        }
    }
}

