/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.PomUtils;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.dependency.ArtifactCoordsPattern;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;

@Mojo(name="flatten-platform-bom", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE, threadSafe=true)
public class FlattenPlatformBomMojo
extends AbstractMojo {
    @Component
    RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${skipPlatformBom}")
    protected boolean skip;
    @Parameter(property="alphabetically", defaultValue="true")
    boolean alphabetically;
    @Parameter
    List<String> excludeArtifactKeys = List.of();
    List<ArtifactCoordsPattern> excludePatterns;
    @Parameter(required=true, defaultValue="${project.build.directory}/flattened-${project.artifactId}-${project.version}.pom")
    File outputFile;
    @Parameter(required=false, property="filterInvalidConstraints")
    boolean filterInvalidConstraints;
    @Parameter(required=false, property="excludeScopes")
    List<String> excludeScopes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactDescriptorResult bomDescriptor = this.resolveBomDescriptor();
        this.initExcludePatterns();
        DependencyManagement dm = new DependencyManagement();
        List managedDeps = bomDescriptor.getManagedDependencies();
        HashMap<String, Dependency> modelDeps = this.alphabetically ? new HashMap<String, Dependency>(managedDeps.size()) : null;
        for (Object d : managedDeps) {
            if (!this.excludeScopes.isEmpty() && this.excludeScopes.contains(d.getScope())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Excluded " + (org.eclipse.aether.graph.Dependency)d + " by scope"));
                continue;
            }
            if (this.isExcluded(d.getArtifact())) continue;
            Artifact a = d.getArtifact();
            String type = a.getProperties().getOrDefault("type", a.getExtension());
            Dependency modelDep = FlattenPlatformBomMojo.toModelDep((org.eclipse.aether.graph.Dependency)d);
            if (a.getArtifactId().endsWith("-quarkus-platform-descriptor") || a.getArtifactId().endsWith("-quarkus-platform-properties")) {
                dm.addDependency(modelDep);
                continue;
            }
            if (this.filterInvalidConstraints && !this.exists(a)) {
                this.getLog().warn((CharSequence)(a + " could not be resolved and was removed from the BOM"));
                continue;
            }
            if (modelDeps != null) {
                ArtifactKey key = ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)type);
                modelDeps.put(key.toString(), modelDep);
            } else {
                dm.addDependency(modelDep);
            }
            if (!"tests".equals(modelDep.getClassifier()) || !"test-jar".equals(modelDep.getType())) continue;
            Dependency noClassifier = modelDep.clone();
            noClassifier.setClassifier(null);
            if (modelDeps != null) {
                modelDeps.put(ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), null, (String)type).toString(), noClassifier);
                continue;
            }
            dm.addDependency(noClassifier);
        }
        if (modelDeps != null) {
            ArrayList keys = new ArrayList(modelDeps.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                dm.addDependency((Dependency)modelDeps.get(key));
            }
        }
        Model newModel = PomUtils.initModel((Model)this.project.getModel());
        newModel.setDependencyManagement(dm);
        try {
            this.outputFile.getParentFile().mkdirs();
            ModelUtils.persistModel((Path)this.outputFile.toPath(), (Model)newModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist flattened platform bom to " + this.outputFile, (Exception)e);
        }
        this.project.setPomFile(this.outputFile);
    }

    private boolean isExcluded(Artifact a) {
        if (this.excludePatterns.isEmpty()) {
            return false;
        }
        String type = a.getProperties().getOrDefault("type", a.getExtension());
        for (ArtifactCoordsPattern pattern : this.excludePatterns) {
            if (!pattern.matches(a.getGroupId(), a.getArtifactId(), a.getClassifier(), type, a.getVersion())) continue;
            return true;
        }
        return false;
    }

    private void initExcludePatterns() {
        ArrayList<ArtifactCoordsPattern> patterns = new ArrayList<ArtifactCoordsPattern>(this.excludeArtifactKeys.size());
        if (!this.excludeArtifactKeys.isEmpty()) {
            for (String keyStr : this.excludeArtifactKeys) {
                patterns.add(ArtifactCoordsPattern.of((String)keyStr));
            }
        }
        this.excludePatterns = patterns;
    }

    private ArtifactDescriptorResult resolveBomDescriptor() throws MojoExecutionException {
        ArtifactDescriptorResult bomDescriptor;
        org.apache.maven.artifact.Artifact artifact = this.project.getArtifact();
        DefaultArtifact bomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "", "pom", artifact.getVersion());
        try {
            bomDescriptor = this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact((Artifact)bomArtifact).setRepositories(this.repos));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read artifact descriptor for " + bomArtifact, e);
        }
        return bomDescriptor;
    }

    private boolean exists(Artifact a) {
        return a.getClassifier().isEmpty() && this.resolve((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), "pom", a.getVersion())) || this.resolve(a);
    }

    private boolean resolve(Artifact a) {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(a).setRepositories(this.repos)).isResolved();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Dependency toModelDep(org.eclipse.aether.graph.Dependency d) {
        Artifact a = d.getArtifact();
        Dependency modelDep = new Dependency();
        modelDep.setGroupId(a.getGroupId());
        modelDep.setArtifactId(a.getArtifactId());
        if (!a.getClassifier().isEmpty()) {
            modelDep.setClassifier(a.getClassifier());
        }
        modelDep.setType(a.getProperties().getOrDefault("type", a.getExtension()));
        modelDep.setVersion(a.getVersion());
        if (d.getScope() != null && !d.getScope().isEmpty() && !"compile".equals(d.getScope())) {
            modelDep.setScope(d.getScope());
        }
        if (d.isOptional()) {
            modelDep.setOptional(true);
        }
        if (!d.getExclusions().isEmpty()) {
            for (Exclusion e : d.getExclusions()) {
                org.apache.maven.model.Exclusion modelExcl = new org.apache.maven.model.Exclusion();
                modelExcl.setGroupId(e.getGroupId());
                modelExcl.setArtifactId(e.getArtifactId());
                modelDep.addExclusion(modelExcl);
            }
        }
        return modelDep;
    }
}

