/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactRequest;

@Mojo(name="non-productized", threadSafe=true)
public class NonProductizedDepsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(required=true)
    String bom;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    private final Set<ArtifactCoords> productized = new HashSet<ArtifactCoords>();
    private final Map<Integer, Set<ArtifactCoords>> nonProductized = new HashMap<Integer, Set<ArtifactCoords>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        List managedDeps;
        ExtensionCatalog catalog;
        Path jsonPath;
        ArtifactCoords bomCoords = ArtifactCoords.fromString((String)this.bom);
        ArtifactCoords catalogCoords = PlatformArtifacts.getCatalogArtifactForBom((ArtifactCoords)bomCoords);
        try {
            jsonPath = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setRepositories(this.repos).setArtifact((Artifact)new DefaultArtifact(catalogCoords.getGroupId(), catalogCoords.getArtifactId(), catalogCoords.getClassifier(), catalogCoords.getType(), catalogCoords.getVersion()))).getArtifact().getFile().toPath();
        }
        catch (Exception e2) {
            throw new MojoExecutionException("Failed to resolve " + String.valueOf(catalogCoords), e2);
        }
        try {
            catalog = ExtensionCatalog.fromFile((Path)jsonPath);
        }
        catch (IOException e3) {
            throw new MojoExecutionException("Failed to parse " + String.valueOf(jsonPath), (Exception)e3);
        }
        try {
            managedDeps = this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setRepositories(this.repos).setArtifact((Artifact)new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion()))).getManagedDependencies();
        }
        catch (Exception e4) {
            throw new MojoExecutionException("Failed to resolve the descriptor of " + String.valueOf(bomCoords), e4);
        }
        HashSet managedCoords = new HashSet(managedDeps.size());
        managedDeps.forEach(d -> managedCoords.add(NonProductizedDepsMojo.toCoords(d.getArtifact())));
        ArrayList supported = new ArrayList();
        catalog.getExtensions().forEach(e -> {
            DependencyNode root;
            Object o = e.getMetadata().get("redhat-support");
            if (o == null) {
                return;
            }
            supported.add(e);
            try {
                DefaultArtifact a = new DefaultArtifact(e.getArtifact().getGroupId(), e.getArtifact().getArtifactId(), e.getArtifact().getClassifier(), e.getArtifact().getType(), e.getArtifact().getVersion());
                root = this.repoSystem.collectDependencies(this.repoSession, new CollectRequest().setManagedDependencies(managedDeps).setRepositories(this.repos).setRoot(new Dependency((Artifact)a, "runtime"))).getRoot();
            }
            catch (Exception e1) {
                throw new RuntimeException("Failed to collect dependencies of " + e.getArtifact().toCompactCoords(), e1);
            }
            if (!NonProductizedDepsMojo.isProductized(e.getArtifact().getVersion())) {
                this.nonProductized.computeIfAbsent(0, k -> new HashSet()).add(e.getArtifact());
            } else {
                this.productized.add(e.getArtifact());
            }
            root.getChildren().forEach(n -> this.processNodes((DependencyNode)n, 1));
        });
        if (this.nonProductized.isEmpty()) {
            return;
        }
        HashSet<ArtifactCoords> allNonProductized = new HashSet<ArtifactCoords>();
        System.out.println("Non-productized artifacts of supported extensions:");
        ArrayList<Integer> levels = new ArrayList<Integer>(this.nonProductized.keySet());
        Collections.sort(levels);
        for (Integer i : levels) {
            Set<ArtifactCoords> set = this.nonProductized.get(i);
            System.out.println("Level " + i + " (" + set.size() + " artifacts):");
            int managed = 0;
            int notManaged = 0;
            for (ArtifactCoords c : set) {
                System.out.println(" - " + String.valueOf(c));
                allNonProductized.add(c);
                if (managedCoords.contains(c)) {
                    ++managed;
                    continue;
                }
                ++notManaged;
            }
            System.out.println("  managed: " + managed);
            System.out.println("  non-managed: " + notManaged);
        }
        System.out.println("Extensions: " + supported.size());
        System.out.println("Non-productized (" + allNonProductized.size() + " artifacts):");
        int managed = 0;
        int notManaged = 0;
        for (ArtifactCoords c : allNonProductized) {
            if (managedCoords.contains(c)) {
                ++managed;
                continue;
            }
            ++notManaged;
        }
        System.out.println("  managed: " + managed);
        System.out.println("  non-managed: " + notManaged);
        System.out.println("Productized (" + this.productized.size() + " artifacts):");
        managed = 0;
        notManaged = 0;
        for (ArtifactCoords c : this.productized) {
            if (managedCoords.contains(c)) {
                ++managed;
                continue;
            }
            ++notManaged;
        }
        System.out.println("  managed: " + managed);
        System.out.println("  non-managed: " + notManaged);
    }

    private static boolean isProductized(String v) {
        return v.contains("redhat");
    }

    private void processNodes(DependencyNode node, int level) {
        ArtifactCoords coords = NonProductizedDepsMojo.toCoords(node.getArtifact());
        if (!NonProductizedDepsMojo.isProductized(coords.getVersion())) {
            this.nonProductized.computeIfAbsent(level, k -> new HashSet()).add(coords);
        } else {
            this.productized.add(coords);
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNodes(child, level + 1);
        }
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }
}

