/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bootstrap.util.IoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="platform-properties", threadSafe=true)
public class PlatformPropertiesMojo
extends AbstractMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="true", property="platformPropertiesInBom")
    private boolean platformPropertiesInBom = true;
    @Parameter(defaultValue="platform-properties.properties", property="platformPropertiesFileName")
    private String propertiesFileName = "platform-properties.properties";
    @Parameter(property="skipPlatformPrefixCheck")
    boolean skipPlatformPrefixCheck;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.getArtifactId().endsWith("-quarkus-platform-properties")) {
            throw new MojoExecutionException("Project's artifactId " + this.project.getArtifactId() + " does not end with -quarkus-platform-properties");
        }
        File propsFile = new File(this.project.getBuild().getOutputDirectory(), this.propertiesFileName);
        if (!propsFile.exists()) {
            throw new MojoExecutionException("Failed to locate " + String.valueOf(propsFile));
        }
        if (!this.skipPlatformPrefixCheck) {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(propsFile);){
                props.load(is);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read properties " + String.valueOf(propsFile), (Exception)e);
            }
            StringBuilder buf = null;
            for (Object name : props.keySet()) {
                if (String.valueOf(name).startsWith("platform.")) continue;
                if (buf == null) {
                    buf = new StringBuilder().append("The following platform properties are missing the '").append("platform.").append("' prefix: ");
                } else {
                    buf.append(", ");
                }
                buf.append(name);
            }
            if (buf != null) {
                throw new MojoExecutionException(buf.toString());
            }
        }
        if (this.platformPropertiesInBom) {
            this.assertPlatformPropertiesInBom();
        }
        File published = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + ".properties");
        try {
            IoUtils.copy((Path)propsFile.toPath(), (Path)published.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy " + String.valueOf(propsFile) + " to " + String.valueOf(published), (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "properties", published);
    }

    private void assertPlatformPropertiesInBom() throws MojoExecutionException {
        boolean platformPropsManaged = false;
        for (Dependency dep : this.dependencyManagement()) {
            if (!dep.getArtifactId().equals(this.project.getArtifactId()) || !dep.getGroupId().equals(this.project.getGroupId()) || !dep.getVersion().equals(this.project.getVersion())) continue;
            platformPropsManaged = true;
            break;
        }
        if (!platformPropsManaged) {
            throw new MojoExecutionException("The project's dependencyManagement does not appear to include " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
        }
    }

    private List<Dependency> dependencyManagement() {
        return this.project.getDependencyManagement() == null ? null : this.project.getDependencyManagement().getDependencies();
    }
}

