/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.RhVersionPattern;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.util.PlatformArtifacts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="trace", threadSafe=true, requiresProject=false)
public class TraceDependencyMojo
extends AbstractMojo {
    private static final String COM_REDHAT_QUARKUS_PLATFORM = "com.redhat.quarkus.platform";
    private static final String ARROW = "\u21b3";
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(property="dependency")
    String dependency;
    @Parameter(property="key")
    String key;
    @Parameter(property="release", required=true)
    String release;
    @Parameter(property="redhatSupported")
    boolean redhatSupported;
    @Parameter(property="detailed")
    boolean detailed;
    @Parameter(property="runtimeOnly")
    boolean runtimeOnly;
    private MavenArtifactResolver resolver;
    private Map<ArtifactCoords, List<Dependency>> platformManagedDeps = new HashMap<ArtifactCoords, List<Dependency>>();
    private Map<ArtifactCoords, Map<ArtifactCoords, TargetInfo>> traces = new HashMap<ArtifactCoords, Map<ArtifactCoords, TargetInfo>>();
    private Map<ArtifactCoords, ArtifactCoords> bomTraces = new HashMap<ArtifactCoords, ArtifactCoords>();
    private ArtifactCoords dependencyCoords;
    private ArtifactKey dependencyKey;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.dependency != null) {
            this.dependencyCoords = ArtifactCoords.fromString((String)this.dependency);
            if (this.key != null) {
                throw new MojoExecutionException("Only one of 'dependency' or 'key' can be set at the same time");
            }
        } else {
            if (this.key == null) {
                throw new MojoExecutionException("Neither 'dependency' nor 'key' parameter was set");
            }
            this.dependencyKey = ArtifactKey.fromString((String)this.key);
        }
        ExtensionCatalog extensionCatalog = this.resolveExtensionCatalog();
        ArtifactCoords quarkusBom = this.getQuarkusBom(extensionCatalog);
        for (Extension extension : extensionCatalog.getExtensions()) {
            this.processExtension(extension, quarkusBom);
        }
        if (this.bomTraces.isEmpty()) {
            this.getLog().info((CharSequence)("None of the BOMs include " + String.valueOf(this.traceTarget())));
        } else {
            this.getLog().info((CharSequence)("The following BOMs include " + String.valueOf(this.traceTarget()) + ":"));
            for (Map.Entry entry : this.bomTraces.entrySet()) {
                this.getLog().info((CharSequence)("  " + ((ArtifactCoords)entry.getKey()).toCompactCoords()));
                if (!this.isLogTraceTarget()) continue;
                this.getLog().info((CharSequence)("  \u21b3 " + ((ArtifactCoords)entry.getValue()).toCompactCoords()));
            }
            this.getLog().info((CharSequence)"");
        }
        if (this.traces.isEmpty()) {
            this.getLog().info((CharSequence)("None of the extensions depend on " + String.valueOf(this.traceTarget())));
        } else {
            this.getLog().info((CharSequence)("The following extensions depend on " + String.valueOf(this.traceTarget()) + ":"));
            for (Map.Entry entry : this.traces.entrySet()) {
                this.getLog().info((CharSequence)("  Extensions included in " + ((ArtifactCoords)entry.getKey()).toCompactCoords() + ":"));
                for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                    if (this.detailed) {
                        for (int i = 0; i < ((TargetInfo)e.getValue()).chain.length; ++i) {
                            StringBuilder sb = new StringBuilder("    ");
                            for (int j = 0; j < i - 1; ++j) {
                                sb.append("  ");
                            }
                            if (i > 0) {
                                sb.append(ARROW).append(" ");
                            }
                            this.getLog().info((CharSequence)sb.append(((TargetInfo)e.getValue()).chain[i].toCompactCoords()));
                        }
                        continue;
                    }
                    this.getLog().info((CharSequence)("    " + ((ArtifactCoords)e.getKey()).toCompactCoords()));
                    if (!this.isLogTraceTarget()) continue;
                    this.getLog().info((CharSequence)("    \u21b3 " + ((TargetInfo)e.getValue()).target.toCompactCoords()));
                }
            }
        }
    }

    private boolean isLogTraceTarget() {
        return this.dependency == null;
    }

    private Object traceTarget() {
        if (this.dependency == null) {
            return this.key;
        }
        return this.dependency;
    }

    private void processExtension(Extension e, ArtifactCoords quarkusBom) throws MojoExecutionException {
        if (this.redhatSupported && !RhVersionPattern.isRhVersion((String)e.getArtifact().getVersion())) {
            return;
        }
        ArtifactCoords platformBom = this.getPlatformOrigin(e);
        if (platformBom == null) {
            return;
        }
        List<Dependency> managedDeps = this.getPlatformManagedDeps(platformBom, quarkusBom);
        ArtifactCoords root = e.getArtifact();
        TargetInfo found = this.walkLooking(this.collectDeps((Artifact)this.toAetherArtifact(root), managedDeps), 0);
        if (found == null && !this.runtimeOnly) {
            root = ArtifactCoords.of((String)root.getGroupId(), (String)(root.getArtifactId() + "-deployment"), (String)root.getClassifier(), (String)root.getType(), (String)root.getVersion());
            found = this.walkLooking(this.collectDeps((Artifact)this.toAetherArtifact(root), managedDeps), 0);
        }
        if (found != null) {
            this.traces.computeIfAbsent(platformBom, k -> new HashMap()).put(root, found);
        }
    }

    private TargetInfo walkLooking(DependencyNode node, int depth) throws MojoExecutionException {
        Artifact a = node.getArtifact();
        if (a != null && this.matchesTraceTarget(a)) {
            return new TargetInfo(this.toCoords(a), depth);
        }
        for (DependencyNode c : node.getChildren()) {
            TargetInfo target = this.walkLooking(c, depth + 1);
            if (target == null) continue;
            target.chain[depth] = this.toCoords(a);
            return target;
        }
        return null;
    }

    private ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private boolean matchesTraceTarget(Artifact a) {
        if (this.dependencyCoords != null) {
            return a.getArtifactId().equals(this.dependencyCoords.getArtifactId()) && a.getGroupId().equals(this.dependencyCoords.getGroupId()) && a.getExtension().equals(this.dependencyCoords.getType()) && a.getVersion().equals(this.dependencyCoords.getVersion()) && a.getClassifier().equals(this.dependencyCoords.getClassifier());
        }
        if (this.dependencyKey != null) {
            return a.getArtifactId().equals(this.dependencyKey.getArtifactId()) && a.getGroupId().equals(this.dependencyKey.getGroupId()) && a.getExtension().equals(this.dependencyKey.getType()) && a.getClassifier().equals(this.dependencyKey.getClassifier());
        }
        throw new IllegalStateException("Neither dependencyCoords nor dependencyKey is initialized");
    }

    private DependencyNode collectDeps(Artifact a, List<Dependency> managedDeps) throws MojoExecutionException {
        try {
            return this.resolver().collectManagedDependencies(a, List.of(), managedDeps, List.of(), List.of(), new String[]{"test", "provided"}).getRoot();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to collect dependencies of " + String.valueOf(a), (Exception)((Object)e));
        }
    }

    private List<Dependency> getPlatformManagedDeps(ArtifactCoords bom, ArtifactCoords quarkusBom) throws MojoExecutionException {
        List<Dependency> managedDeps = this.platformManagedDeps.get(bom);
        if (managedDeps != null) {
            return managedDeps;
        }
        List<Dependency> quarkusManagedDeps = this.platformManagedDeps.get(quarkusBom);
        if (quarkusManagedDeps == null) {
            quarkusManagedDeps = this.getManagedDeps(quarkusBom);
            this.platformManagedDeps.put(quarkusBom, quarkusManagedDeps);
            if (bom.equals(quarkusBom)) {
                return quarkusManagedDeps;
            }
        }
        List<Dependency> tmp = this.getManagedDeps(bom);
        managedDeps = new ArrayList<Dependency>(quarkusManagedDeps.size() + tmp.size());
        managedDeps.addAll(quarkusManagedDeps);
        managedDeps.addAll(tmp);
        this.platformManagedDeps.put(bom, managedDeps);
        return managedDeps;
    }

    private List<Dependency> getManagedDeps(ArtifactCoords bom) throws MojoExecutionException {
        try {
            List managedDeps = this.resolver().resolveDescriptor((Artifact)this.toAetherArtifact(bom)).getManagedDependencies();
            for (Dependency d : managedDeps) {
                Artifact a = d.getArtifact();
                if (!this.matchesTraceTarget(a) || this.redhatSupported && !bom.getGroupId().equals(COM_REDHAT_QUARKUS_PLATFORM)) continue;
                this.bomTraces.put(bom, this.toCoords(a));
                break;
            }
            return managedDeps;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to read artifact descriptor for " + String.valueOf(bom), (Exception)((Object)e));
        }
    }

    private DefaultArtifact toAetherArtifact(ArtifactCoords coords) {
        return new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
    }

    private ArtifactCoords getPlatformOrigin(Extension e) {
        for (ExtensionOrigin o : e.getOrigins()) {
            if (!o.isPlatform()) continue;
            return o.getBom();
        }
        return null;
    }

    private ArtifactCoords getQuarkusBom(ExtensionCatalog extensionCatalog) {
        for (ExtensionOrigin o2 : extensionCatalog.getDerivedFrom()) {
            if (!o2.getBom().getArtifactId().equals("quarkus-bom")) continue;
            return o2.getBom();
        }
        StringJoiner sj = new StringJoiner(", ");
        extensionCatalog.getDerivedFrom().forEach(o -> sj.add(o.getBom().toCompactCoords()));
        throw new IllegalStateException("Failed to locate quarkus-bom among " + sj.toString());
    }

    private ExtensionCatalog resolveExtensionCatalog() throws MojoExecutionException {
        ArtifactCoords platformCoords = this.release.contains(":") ? PlatformArtifacts.ensureBomArtifact((ArtifactCoords)ArtifactCoords.fromString((String)this.release)) : (RhVersionPattern.isRhVersion((String)this.release) ? ArtifactCoords.pom((String)COM_REDHAT_QUARKUS_PLATFORM, (String)"quarkus-bom", (String)this.release) : ArtifactCoords.pom((String)"io.quarkus.platform", (String)"quarkus-bom", (String)this.release));
        return ToolsUtils.resolvePlatformDescriptorDirectly((String)platformCoords.getGroupId(), (String)platformCoords.getArtifactId(), (String)platformCoords.getVersion(), (MavenArtifactResolver)this.resolver(), (MessageWriter)new MojoMessageWriter(this.getLog()));
    }

    private MavenArtifactResolver resolver() throws MojoExecutionException {
        if (this.resolver != null) {
            return this.resolver;
        }
        try {
            this.resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositoryManager(this.remoteRepoManager)).setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).build();
            return this.resolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize the Maven resolver");
        }
    }

    private static class TargetInfo {
        final ArtifactCoords target;
        final ArtifactCoords[] chain;

        private TargetInfo(ArtifactCoords target, int depth) {
            this.target = target;
            this.chain = new ArtifactCoords[depth + 1];
            this.chain[depth] = target;
        }
    }
}

