/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="init-overlay-project", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE, requiresProject=false)
public class InitOverlayProjectMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="com.redhat.quarkus.platform", property="groupId")
    String groupId;
    @Parameter(required=false, property="artifactId")
    String artifactId;
    @Parameter(required=false, property="version")
    String version;
    @Parameter(required=true, defaultValue="quarkusio")
    String githubOrg;
    @Parameter(required=true, defaultValue="quarkus-platform")
    String githubRepo;
    @Parameter(required=false, property="forTag")
    String forTag;
    @Parameter(required=false, property="forBranch")
    String forBranch;
    @Parameter(required=false)
    Set<String> excludeResources = Set.of(".git", "generated-platform-project");
    @Parameter(required=true, defaultValue="${basedir}", property="dir")
    File dir;
    private Path projectDir;
    @Parameter(required=false, property="forceOverlay")
    boolean forceOverlay;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model originalModel;
        Stream<Path> stream;
        this.projectDir = this.dir.toPath().normalize().toAbsolutePath();
        if (Files.exists(this.projectDir, new LinkOption[0])) {
            boolean emptyDir;
            if (!Files.isDirectory(this.projectDir, new LinkOption[0])) {
                throw new MojoExecutionException("Can't create a new project at " + String.valueOf(this.projectDir) + " because it appears to be an existing file");
            }
            try {
                stream = Files.list(this.projectDir);
                try {
                    emptyDir = stream.count() == 0L;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read the content of directory " + String.valueOf(this.projectDir), (Exception)e);
            }
            if (!emptyDir) {
                if (!this.forceOverlay) {
                    throw new MojoExecutionException("The project directory " + String.valueOf(this.projectDir) + " isn't empty. If you still want to re-initialize the overly please add -DforceOverlay to the command line");
                }
                this.getLog().warn((CharSequence)("Overriding the existing overlay in " + String.valueOf(this.projectDir)));
            }
        }
        this.run(this.projectDir.getParent(), "git", "clone", "https://github.com/" + this.githubOrg + "/" + this.githubRepo + ".git", this.projectDir.getFileName().toString());
        String contentRef = this.getContentRef();
        if (!"main".equals(contentRef)) {
            this.run(this.projectDir, "git", "checkout", contentRef);
        }
        try {
            stream = Files.list(this.projectDir);
            try {
                Iterator i = stream.iterator();
                while (i.hasNext()) {
                    Path p = (Path)i.next();
                    if (!this.excludeResources.contains(this.projectDir.relativize(p).toString())) continue;
                    IoUtils.recursiveDelete((Path)p);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to process " + String.valueOf(this.projectDir), e);
        }
        Path pomXml = this.projectDir.resolve("pom.xml");
        if (!Files.exists(pomXml, new LinkOption[0])) {
            throw new MojoExecutionException("Failed to locate " + String.valueOf(pomXml));
        }
        try {
            originalModel = ModelUtils.readModel((Path)pomXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + String.valueOf(pomXml), (Exception)e);
        }
        Model model = new Model();
        model.setModelVersion(originalModel.getModelVersion());
        Parent parent = new Parent();
        parent.setGroupId(ModelUtils.getGroupId((Model)originalModel));
        parent.setArtifactId(originalModel.getArtifactId());
        parent.setVersion(ModelUtils.getVersion((Model)originalModel));
        parent.setRelativePath("");
        model.setParent(parent);
        model.setPackaging("pom");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId == null ? originalModel.getArtifactId() : this.artifactId);
        if (this.version != null && !this.version.isBlank()) {
            model.setVersion(this.version);
        }
        model.getProperties().setProperty("quarkus.upstream.version", originalModel.getVersion());
        Build build = new Build();
        model.setBuild(build);
        build.setPlugins(originalModel.getBuild().getPlugins());
        for (Plugin plugin : build.getPlugins()) {
            if (!plugin.getArtifactId().equals("quarkus-platform-bom-maven-plugin")) continue;
            InitOverlayProjectMojo.configurePlatform(plugin);
            break;
        }
        try {
            ModelUtils.persistModel((Path)pomXml, (Model)model);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist POM to " + String.valueOf(pomXml), (Exception)e);
        }
    }

    private static void configurePlatform(Plugin plugin) throws MojoExecutionException {
        Xpp3Dom config;
        Object o = plugin.getConfiguration();
        if (o != null) {
            if (!(o instanceof Xpp3Dom)) {
                throw new MojoExecutionException("Plugin configuration is not of type " + Xpp3Dom.class.getName() + " but " + o.getClass().getName());
            }
            config = (Xpp3Dom)o;
        } else {
            config = new Xpp3Dom("configuration");
            plugin.setConfiguration((Object)config);
        }
        Xpp3Dom platform = new Xpp3Dom("platformConfig");
        config.addChild(platform);
        Xpp3Dom upstreamQuarkusCoreVersion = new Xpp3Dom("upstreamQuarkusCoreVersion");
        upstreamQuarkusCoreVersion.setValue("${quarkus.upstream.version}");
        platform.addChild(upstreamQuarkusCoreVersion);
    }

    private void run(Path workDir, String ... commands) throws MojoExecutionException {
        Process process = null;
        try {
            process = new ProcessBuilder(new String[0]).command(commands).redirectErrorStream(true).inheritIO().directory(workDir.toFile()).start();
            process.waitFor();
            process = null;
            if (process != null) {
                Process p = process;
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
                    final /* synthetic */ Process val$p;
                    {
                        this.val$p = process;
                    }

                    @Override
                    public void run() {
                        this.val$p.destroy();
                        try {
                            this.val$p.waitFor();
                        }
                        catch (InterruptedException e) {
                            InitOverlayProjectMojo.this.getLog().warn((CharSequence)"Unable to properly wait for dev-mode end", (Throwable)e);
                        }
                    }
                }, "Git " + commands[1] + " shutdown hook"));
            }
        }
        catch (IOException | InterruptedException e) {
            try {
                throw new MojoExecutionException("Failed to clone", e);
            }
            catch (Throwable throwable) {
                if (process != null) {
                    Process p = process;
                    Runtime.getRuntime().addShutdownHook(new Thread(new /* invalid duplicate definition of identical inner class */, "Git " + commands[1] + " shutdown hook"));
                }
                throw throwable;
            }
        }
    }

    private String getContentRef() {
        if (this.forTag != null && !this.forTag.isBlank()) {
            return this.forTag;
        }
        if (this.forBranch != null && !this.forBranch.isBlank()) {
            return this.forBranch;
        }
        return "main";
    }
}

