/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.platform.PlatformMemberConfig;
import io.quarkus.bom.platform.ProjectDependencyFilterConfig;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-pnc-build-config", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE, requiresProject=false)
public class PncBuildConfigMojo
extends AbstractMojo {
    private static final String BOM_GAVS = "bomGavs";
    private static final String PARAMETERS = "parameters";
    private static final String STEPS = "steps";
    @Parameter(required=true, defaultValue="${basedir}/src/main/resources/build-config-template.yaml")
    File configTemplate;
    @Parameter(required=true, defaultValue="${project.build.directory}/build-config.yaml")
    File generatedConfig;
    @Parameter
    PlatformConfig platformConfig;
    private ObjectMapper mapper = CatalogMapperHelper.initMapper((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));

    public void execute() throws MojoExecutionException, MojoFailureException {
        JsonNode buildConfig = this.readBuildConfigTemplate();
        this.setIfNotConfigured(buildConfig, "version", this.platformConfig.getRelease().getVersion());
        JsonNode repositoryGeneration = this.getOrCreateNode(buildConfig, "flow", "repositoryGeneration");
        this.configureDefaultRepoParams(repositoryGeneration);
        this.addMemberRepoGeneratingSteps(repositoryGeneration);
        this.persistBuildConfig(buildConfig);
    }

    private void configureDefaultRepoParams(JsonNode repositoryGeneration) throws MojoExecutionException {
        JsonNode defaultParameters = this.getOrCreateNode(repositoryGeneration, PARAMETERS);
        this.setIfNotConfigured(defaultParameters, BOM_GAVS, () -> {
            ArtifactCoords c = this.platformConfig.getCore().getPlatformBom(this.platformConfig.getRelease().getPlatformKey());
            return c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion();
        });
        this.setIfNotConfigured(defaultParameters, "resolveIncludes", "*:*:*redhat-*");
        ProjectDependencyFilterConfig coreDepsToBuild = this.platformConfig.getCore().getDependenciesToBuild();
        if (coreDepsToBuild != null && !coreDepsToBuild.getIncludeArtifacts().isEmpty()) {
            ArrayNode steps = this.getOrCreateArray(repositoryGeneration, STEPS);
            ObjectNode coreStep = null;
            for (int i = 0; i < steps.size(); ++i) {
                JsonNode node = steps.get(i);
                if (!node.has(PARAMETERS)) {
                    coreStep = node;
                    break;
                }
                JsonNode params = node.get(PARAMETERS);
                if (params.has(BOM_GAVS)) continue;
                coreStep = node;
                break;
            }
            if (coreStep == null) {
                coreStep = this.mapper.createObjectNode();
                steps.add((JsonNode)coreStep);
            }
            this.addResolveArtifacts(this.getOrCreateNode((JsonNode)coreStep, PARAMETERS), coreDepsToBuild);
        }
    }

    private void addResolveArtifacts(JsonNode parameters, ProjectDependencyFilterConfig depsToBuild) {
        this.setIfNotConfigured(parameters, "resolveArtifacts", () -> {
            Iterator i = depsToBuild.getIncludeArtifacts().iterator();
            StringBuilder sb = new StringBuilder().append(PncBuildConfigMojo.toGATCV((ArtifactCoords)i.next()));
            while (i.hasNext()) {
                sb.append(", ").append(PncBuildConfigMojo.toGATCV((ArtifactCoords)i.next()));
            }
            return sb.toString();
        });
    }

    private void addMemberRepoGeneratingSteps(JsonNode repositoryGeneration) throws MojoExecutionException {
        if (this.platformConfig.getMembers().isEmpty()) {
            return;
        }
        ArrayNode steps = this.getOrCreateArray(repositoryGeneration, STEPS);
        String defaultGroupId = this.platformConfig.getRelease().getPlatformKey();
        for (PlatformMemberConfig member : this.platformConfig.getMembers()) {
            if (!member.isEnabled() || member.isHidden()) continue;
            ArtifactCoords memberBom = member.getPlatformBom(defaultGroupId);
            JsonNode step = this.getOrCreateItemWithElement(steps, memberBom.getGroupId() + ":" + memberBom.getArtifactId() + ":" + memberBom.getVersion(), PARAMETERS, BOM_GAVS);
            if (member.getDependenciesToBuild() == null || member.getDependenciesToBuild().getIncludeArtifacts().isEmpty()) continue;
            this.addResolveArtifacts(this.getOrCreateNode(step, PARAMETERS), member.getDependenciesToBuild());
        }
    }

    private static String toGATCV(ArtifactCoords c) {
        return c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getType() + ":" + c.getClassifier() + ":" + c.getVersion();
    }

    private JsonNode getOrCreateItemWithElement(ArrayNode array, String value, String ... fieldName) {
        JsonNode node;
        for (int i = 0; i < array.size(); ++i) {
            String name;
            JsonNode idNode = node = array.get(i);
            String[] stringArray = fieldName;
            int n = stringArray.length;
            for (int j = 0; j < n && (idNode = ((ObjectNode)idNode).get(name = stringArray[j])) != null; ++j) {
            }
            if (idNode == null || !value.equals(idNode.textValue())) continue;
            return node;
        }
        ObjectNode root = this.mapper.createObjectNode();
        node = root;
        for (int i = 0; i < fieldName.length - 1; ++i) {
            ObjectNode child = this.mapper.createObjectNode();
            node.set(fieldName[i], (JsonNode)child);
            node = child;
        }
        node.set(fieldName[fieldName.length - 1], (JsonNode)this.mapper.getNodeFactory().textNode(value));
        array.add((JsonNode)root);
        return root;
    }

    private ArrayNode getOrCreateArray(JsonNode parent, String ... name) throws MojoExecutionException {
        ArrayNode array;
        JsonNode node;
        if (name.length > 1) {
            parent = this.getOrCreateNode(parent, Arrays.copyOfRange(name, 0, name.length - 1));
        }
        if ((node = parent.get(name[name.length - 1])) != null && !(node instanceof NullNode)) {
            if (!(node instanceof ArrayNode)) {
                throw new MojoExecutionException(name[name.length] + " is not an instance of " + ArrayNode.class.getName() + " but " + node.getClass().getName());
            }
            array = (ArrayNode)node;
        } else {
            array = this.mapper.createArrayNode();
            ((ObjectNode)parent).set(name[name.length - 1], (JsonNode)array);
        }
        return array;
    }

    private JsonNode getOrCreateNode(JsonNode parent, String ... name) throws MojoExecutionException {
        if (name.length == 0) {
            return parent;
        }
        JsonNode node = parent;
        for (String n : name) {
            JsonNode tmp = node.get(n);
            if (tmp == null) {
                tmp = this.mapper.createObjectNode();
                ((ObjectNode)node).set(n, tmp);
            }
            node = tmp;
        }
        return node;
    }

    private void setIfNotConfigured(JsonNode node, String fieldName, String value) {
        if (!node.has(fieldName)) {
            ((ObjectNode)node).set(fieldName, (JsonNode)this.mapper.getNodeFactory().textNode(value));
        }
    }

    private void setIfNotConfigured(JsonNode node, String fieldName, Supplier<String> supplier) {
        if (!node.has(fieldName)) {
            ((ObjectNode)node).set(fieldName, (JsonNode)this.mapper.getNodeFactory().textNode(supplier.get()));
        }
    }

    private void persistBuildConfig(JsonNode mareteConfig) throws MojoExecutionException {
        if (!this.generatedConfig.exists()) {
            this.generatedConfig.getParentFile().mkdirs();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.generatedConfig.toPath(), new OpenOption[0]);){
            try (BufferedReader reader = Files.newBufferedReader(this.configTemplate.toPath());){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("#!")) continue;
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read " + String.valueOf(this.configTemplate), (Exception)e);
            }
            writer.newLine();
            this.mapper.writer().writeValue((Writer)writer, (Object)mareteConfig);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + String.valueOf(this.generatedConfig), (Exception)e);
        }
    }

    private JsonNode readBuildConfigTemplate() throws MojoExecutionException {
        JsonNode jsonNode;
        block8: {
            BufferedReader reader = Files.newBufferedReader(this.configTemplate.toPath());
            try {
                jsonNode = this.mapper.readTree((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to parse " + String.valueOf(this.configTemplate), (Exception)e);
                }
            }
            reader.close();
        }
        return jsonNode;
    }
}

