/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.decomposer.maven.GenerateMavenRepoZip;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.util.GlobUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.DefaultSettingsReader;
import org.apache.maven.settings.io.DefaultSettingsWriter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;

public class MavenRepoZip {
    private static final String JAVADOC = "javadoc";
    private static final String SOURCES = "sources";
    private Path repoDir;
    private MavenArtifactResolver resolver;
    private List<Dependency> managedDeps = List.of();
    private MessageWriter log;
    private Set<String> excludedGroupIds = Set.of();
    private Set<ArtifactKey> excludedArtifacts = Set.of();
    private List<ArtifactCoords> extraArtifacts = List.of();
    private Pattern includedVersionsPattern;

    public static Generator newGenerator() {
        return new MavenRepoZip().new Generator();
    }

    private void doGenerate() {
        this.log.info("Generating Maven repository at " + String.valueOf(this.repoDir));
        for (Dependency d : this.managedDeps) {
            this.collectDependencies(d.getArtifact());
        }
        for (ArtifactCoords coords : this.extraArtifacts) {
            this.collectDependencies((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
        }
    }

    private void collectDependencies(Artifact artifact) {
        if (this.isFilteredOut(artifact)) {
            return;
        }
        try {
            this.resolver.resolveDependencies(artifact, this.managedDeps);
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to collect dependencies of " + String.valueOf(artifact), e);
        }
        if (artifact.getExtension().equals("pom")) {
            return;
        }
        if ("jar".equals(artifact.getExtension())) {
            this.resolveOrNull((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), SOURCES, "jar", artifact.getVersion()));
            this.resolveOrNull((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), JAVADOC, "jar", artifact.getVersion()));
        }
    }

    private boolean isFilteredOut(Artifact artifact) {
        return artifact == null || JAVADOC.equals(artifact.getClassifier()) || SOURCES.equals(artifact.getClassifier()) || this.includedVersionsPattern != null && !this.includedVersionsPattern.matcher(artifact.getVersion()).matches() || this.excludedGroupIds.contains(artifact.getGroupId()) || this.excludedArtifacts.contains(MavenRepoZip.getKey(artifact));
    }

    private Artifact resolveOrNull(Artifact rtArtifact) {
        try {
            return this.resolver.resolve(rtArtifact).getArtifact();
        }
        catch (BootstrapMavenException e) {
            return null;
        }
    }

    private static ArtifactKey getKey(Artifact a) {
        return ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension());
    }

    public static void main(String[] args) throws Exception {
        Set<String> prodSet = MavenRepoZip.collectPaths(Paths.get(System.getProperty("user.home"), new String[0]).resolve("Downloads/rh-quarkus-2.2.3.GA-maven-repository/maven-repository"));
        Set<String> platformSet = MavenRepoZip.collectPaths(Paths.get(System.getProperty("user.home"), new String[0]).resolve("git/quarkus-platform-product/target/repository"));
        HashSet<String> missing = new HashSet<String>();
        HashSet<String> extra = new HashSet<String>();
        for (String s : prodSet) {
            if (platformSet.contains(s)) continue;
            missing.add(s);
        }
        for (String s : platformSet) {
            if (prodSet.contains(s)) continue;
            extra.add(s);
        }
        if (!missing.isEmpty()) {
            System.out.println("MISSING ARTIFACTS " + missing.size());
            MavenRepoZip.logPaths(missing);
        }
        if (!extra.isEmpty()) {
            System.out.println("EXTRA ARTIFACTS " + extra.size());
            MavenRepoZip.logPaths(extra);
        }
    }

    private static void logPaths(Set<String> prodSet) {
        ArrayList<String> list = new ArrayList<String>(prodSet);
        Collections.sort(list);
        list.forEach(s -> System.out.println((String)s));
    }

    private static Set<String> collectPaths(final Path root) throws IOException {
        final HashSet<String> paths = new HashSet<String>();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String name = file.getFileName().toString();
                if (!name.endsWith(".md5") && !name.endsWith(".sha1")) {
                    paths.add(root.relativize(file).toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }

    public class Generator {
        private static final String ORIGINAL_LOCAL_REPO = "original-local";
        private static final String MAVEN_REPO_ZIP = "maven-repo-zip";
        private static final String REPOSITORY = "repository";

        private Generator() {
        }

        public Generator setConfig(GenerateMavenRepoZip config) {
            MavenRepoZip.this.repoDir = Path.of(config == null ? REPOSITORY : (config.getRepositoryDir() == null ? REPOSITORY : config.getRepositoryDir()), new String[0]).normalize().toAbsolutePath();
            MavenRepoZip.this.excludedGroupIds = config.getExcludedGroupIds();
            if (!config.getExcludedArtifacts().isEmpty()) {
                MavenRepoZip.this.excludedArtifacts = config.getExcludedArtifacts().stream().map(ArtifactKey::fromString).collect(Collectors.toSet());
            }
            if (!config.getExtraArtifacts().isEmpty()) {
                MavenRepoZip.this.extraArtifacts = config.getExtraArtifacts().stream().map(ArtifactCoords::fromString).collect(Collectors.toList());
            }
            if (config.getIncludedVersionsPattern() != null) {
                MavenRepoZip.this.includedVersionsPattern = Pattern.compile(GlobUtil.toRegexPattern((String)config.getIncludedVersionsPattern()));
            }
            return this;
        }

        public Generator setLog(MessageWriter logger) {
            MavenRepoZip.this.log = logger;
            return this;
        }

        public Generator setMavenArtifactResolver(MavenArtifactResolver mavenResolver) {
            MavenRepoZip.this.resolver = mavenResolver;
            return this;
        }

        public Generator setManagedDependencies(List<Dependency> managedDependencies) {
            MavenRepoZip.this.managedDeps = managedDependencies;
            return this;
        }

        public void generate() {
            Repository repo;
            BootstrapMavenContext mavenContext;
            if (MavenRepoZip.this.repoDir == null) {
                MavenRepoZip.this.repoDir = Path.of(REPOSITORY, new String[0]);
            }
            MavenRepoZip.this.repoDir = MavenRepoZip.this.repoDir.toAbsolutePath().normalize();
            if (MavenRepoZip.this.log == null) {
                MavenRepoZip.this.log = MessageWriter.info();
            }
            try {
                mavenContext = new BootstrapMavenContext(BootstrapMavenContext.config().setWorkspaceDiscovery(false));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven context", e);
            }
            Settings settings = this.getBaseMavenSettings(mavenContext.getUserSettings());
            settings.setLocalRepository(MavenRepoZip.this.repoDir.toString());
            Profile profile = new Profile();
            profile.setId(MAVEN_REPO_ZIP);
            settings.addActiveProfile(MAVEN_REPO_ZIP);
            settings.addProfile(profile);
            try {
                repo = this.configureRepo(ORIGINAL_LOCAL_REPO, Path.of(mavenContext.getLocalRepo(), new String[0]).toUri().toURL().toExternalForm());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to configure repository", e);
            }
            profile.addRepository(repo);
            profile.addPluginRepository(repo);
            Path settingsXml = MavenRepoZip.this.repoDir.resolve("settings.xml");
            try {
                Files.createDirectories(MavenRepoZip.this.repoDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directory " + String.valueOf(MavenRepoZip.this.repoDir), e);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(settingsXml, new OpenOption[0]);){
                new DefaultSettingsWriter().write((Writer)writer, Map.of(), settings);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to persist Maven settings to " + String.valueOf(settingsXml), e);
            }
            BootstrapMavenContextConfig resolverConfig = BootstrapMavenContext.config();
            if (MavenRepoZip.this.resolver != null) {
                resolverConfig.setRepositorySystem(MavenRepoZip.this.resolver.getSystem());
                resolverConfig.setRemoteRepositoryManager(MavenRepoZip.this.resolver.getRemoteRepositoryManager());
                resolverConfig.setCurrentProject(MavenRepoZip.this.resolver.getMavenContext().getCurrentProject());
            }
            try {
                MavenRepoZip.this.resolver = new MavenArtifactResolver(new BootstrapMavenContext(resolverConfig.setUserSettings(settingsXml.toFile())));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
            }
            ArrayList finalRepos = new ArrayList(MavenRepoZip.this.resolver.getRepositories());
            Iterator ir = finalRepos.iterator();
            RemoteRepository originalLocalRepo = null;
            while (ir.hasNext()) {
                RemoteRepository r = (RemoteRepository)ir.next();
                if (!r.getId().equals(ORIGINAL_LOCAL_REPO)) continue;
                originalLocalRepo = r;
                ir.remove();
                break;
            }
            if (originalLocalRepo != null) {
                ArrayList<Object> tmp = new ArrayList<Object>(finalRepos.size() + 1);
                tmp.add(originalLocalRepo);
                tmp.addAll(finalRepos);
                finalRepos = tmp;
                try {
                    MavenRepoZip.this.resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositoryManager(MavenRepoZip.this.resolver.getRemoteRepositoryManager())).setRepositorySystem(MavenRepoZip.this.resolver.getSystem())).setRepositorySystemSession(MavenRepoZip.this.resolver.getSession())).setRemoteRepositories(finalRepos)).setCurrentProject(MavenRepoZip.this.resolver.getMavenContext().getCurrentProject())).build();
                }
                catch (BootstrapMavenException e) {
                    throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
                }
            }
            MavenRepoZip.this.doGenerate();
        }

        private Repository configureRepo(String id, String url) {
            Repository repo = new Repository();
            repo.setId(id);
            repo.setLayout("default");
            repo.setUrl(url);
            RepositoryPolicy policy = new RepositoryPolicy();
            policy.setEnabled(true);
            repo.setReleases(policy);
            repo.setSnapshots(policy);
            return repo;
        }

        private Settings getBaseMavenSettings(File mavenSettings) {
            if (mavenSettings != null && mavenSettings.exists()) {
                try {
                    return new DefaultSettingsReader().read(mavenSettings, Map.of());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read Maven settings from " + String.valueOf(mavenSettings), e);
                }
            }
            return new Settings();
        }
    }
}

