/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.decomposer.maven.GenerateMavenRepoZip;
import io.quarkus.bom.decomposer.maven.platformgen.AttachedMavenPluginConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformBomGeneratorConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformDescriptorGeneratorConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformReleaseConfig;
import io.quarkus.bom.decomposer.maven.platformgen.SbomerGlobalConfig;
import io.quarkus.bom.decomposer.maven.platformgen.UniversalPlatformConfig;
import io.quarkus.bom.platform.PlatformMemberConfig;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class PlatformConfig {
    private PlatformReleaseConfig release;
    private UniversalPlatformConfig universal;
    private PlatformMemberConfig core;
    private Collection<PlatformMemberConfig> members = List.of();
    private PlatformBomGeneratorConfig bomGenerator;
    private PlatformDescriptorGeneratorConfig descriptorGenerator;
    private AttachedMavenPluginConfig attachedMavenPlugin;
    private String upstreamQuarkusCoreVersion;
    private boolean generateBomReports = true;
    private String generateBomReportsZip;
    private GenerateMavenRepoZip generateMavenRepoZip;
    private SbomerGlobalConfig sbomerConfig;

    public PlatformReleaseConfig getRelease() {
        return this.release;
    }

    public void setRelease(PlatformReleaseConfig platformRelease) {
        this.release = platformRelease;
    }

    public UniversalPlatformConfig getUniversal() {
        return this.universal == null ? (this.universal = new UniversalPlatformConfig()) : this.universal;
    }

    public void setUniversal(UniversalPlatformConfig universal) {
        this.universal = universal;
    }

    public PlatformMemberConfig getCore() {
        return this.core;
    }

    public void setCore(PlatformMemberConfig core) {
        this.core = core;
    }

    public Collection<PlatformMemberConfig> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<PlatformMemberConfig> members) {
        LinkedHashMap<String, PlatformMemberConfig> map = new LinkedHashMap<String, PlatformMemberConfig>(members.size());
        for (PlatformMemberConfig member : members) {
            PlatformMemberConfig original = map.putIfAbsent(member.getName(), member);
            if (original == null) continue;
            original.applyOverrides(member);
        }
        this.members = map.values();
    }

    public PlatformBomGeneratorConfig getBomGenerator() {
        return this.bomGenerator;
    }

    public void setBomGenerator(PlatformBomGeneratorConfig bomGenerator) {
        this.bomGenerator = bomGenerator;
    }

    public PlatformDescriptorGeneratorConfig getDescriptorGenerator() {
        return this.descriptorGenerator;
    }

    public void setDescriptorGenerator(PlatformDescriptorGeneratorConfig descriptorGenerator) {
        this.descriptorGenerator = descriptorGenerator;
    }

    public AttachedMavenPluginConfig getAttachedMavenPlugin() {
        return this.attachedMavenPlugin;
    }

    public void setAttachedMavenPlugin(AttachedMavenPluginConfig attachedMavenPlugin) {
        this.attachedMavenPlugin = attachedMavenPlugin;
    }

    public String getUpstreamQuarkusCoreVersion() {
        return this.upstreamQuarkusCoreVersion;
    }

    public void setUpstreamQuarkusCoreVersion(String upstreamQuarkusCoreVersion) {
        this.upstreamQuarkusCoreVersion = upstreamQuarkusCoreVersion;
    }

    public boolean hasUpstreamQuarkusCoreVersion() {
        return this.upstreamQuarkusCoreVersion != null && !this.upstreamQuarkusCoreVersion.isBlank();
    }

    public boolean isGenerateBomReports() {
        return this.generateBomReports;
    }

    public void setGenerateBomReports(boolean generateBomReports) {
        this.generateBomReports = generateBomReports;
    }

    public String getGenerateBomReportsZip() {
        return this.generateBomReportsZip;
    }

    public void setGenerateBomReportsZip(String generateBomReportsZip) {
        this.generateBomReportsZip = generateBomReportsZip;
    }

    public GenerateMavenRepoZip getGenerateMavenRepoZip() {
        return this.generateMavenRepoZip;
    }

    public void setGenerateMavenRepoZip(GenerateMavenRepoZip generateMavenRepoZip) {
        this.generateMavenRepoZip = generateMavenRepoZip;
    }

    public SbomerGlobalConfig getSbomer() {
        return this.sbomerConfig;
    }

    public void setSbomer(SbomerGlobalConfig sbomerConfig) {
        this.sbomerConfig = sbomerConfig;
    }
}

