/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

@Mojo(name="attach-maven-plugin", threadSafe=true)
public class AttachPluginMojo
extends AbstractMojo {
    @Parameter(required=true)
    String originalPluginCoords;
    @Parameter(required=true)
    String targetPluginCoords;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private RepositorySystem repoSystem;
    @Component
    private RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactCoords originalCoords = ArtifactCoords.fromString((String)this.originalPluginCoords);
        ArtifactCoords targetCoords = ArtifactCoords.fromString((String)this.targetPluginCoords);
        Path targetDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        if (!Files.exists(targetDir, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create directory " + targetDir, (Exception)e);
            }
        }
        DefaultArtifact mainArtifact = new DefaultArtifact(originalCoords.getGroupId(), originalCoords.getArtifactId(), null, "jar", originalCoords.getVersion());
        Path mainJar = this.resolve((Artifact)mainArtifact);
        Path classesDir = targetDir.resolve("classes");
        try {
            ZipUtils.unzip((Path)mainJar, (Path)classesDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to unpack " + mainJar + " to " + targetDir.resolve("classes"), (Exception)e);
        }
        IoUtils.recursiveDelete((Path)classesDir.resolve("META-INF").resolve("maven"));
        Path originalPom = this.resolve((Artifact)new DefaultArtifact(originalCoords.getGroupId(), originalCoords.getArtifactId(), null, "pom", originalCoords.getVersion()));
        Model generatedModel = this.project.getOriginalModel().clone();
        generatedModel.setGroupId(targetCoords.getGroupId());
        generatedModel.setArtifactId(targetCoords.getArtifactId());
        generatedModel.setVersion(targetCoords.getVersion());
        try {
            generatedModel.setBuild(ModelUtils.readModel((Path)originalPom).getBuild());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read " + originalPom, (Exception)e);
        }
        Set<ArtifactKey> managedKeys = this.getManagedKeys();
        ArtifactDescriptorResult descr = this.describe((Artifact)mainArtifact);
        for (Dependency d : descr.getDependencies()) {
            if ("test".equals(d.getScope())) continue;
            org.apache.maven.model.Dependency modelDep = new org.apache.maven.model.Dependency();
            Artifact a = d.getArtifact();
            modelDep.setGroupId(a.getGroupId());
            modelDep.setArtifactId(a.getArtifactId());
            if (!a.getClassifier().isEmpty()) {
                modelDep.setClassifier(a.getClassifier());
            }
            if (!a.getExtension().isEmpty() && !"jar".equals(a.getExtension())) {
                modelDep.setType(a.getExtension());
            }
            if (!managedKeys.contains(new ArtifactKey(modelDep.getGroupId(), modelDep.getArtifactId(), modelDep.getClassifier(), modelDep.getType()))) {
                modelDep.setVersion(a.getVersion());
            }
            if (!d.getScope().isEmpty() && !"compile".equals(d.getScope())) {
                modelDep.setScope(d.getScope());
            }
            if (d.isOptional()) {
                modelDep.setOptional(true);
            }
            for (Exclusion e : d.getExclusions()) {
                org.apache.maven.model.Exclusion modelE = new org.apache.maven.model.Exclusion();
                modelE.setGroupId(e.getGroupId());
                modelE.setArtifactId(e.getArtifactId());
                modelDep.addExclusion(modelE);
            }
            generatedModel.addDependency(modelDep);
        }
        Path generatedPom = targetDir.resolve(targetCoords.getArtifactId() + "-" + targetCoords.getVersion() + ".pom");
        try {
            ModelUtils.persistModel((Path)generatedPom, (Model)generatedModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persiste POM at " + generatedPom, (Exception)e);
        }
        this.project.setPomFile(generatedPom.toFile());
    }

    private ArtifactDescriptorResult describe(Artifact a) throws MojoExecutionException {
        try {
            return this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact(a).setRepositories(this.pluginRepos));
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException("Failed to describe " + a, (Exception)((Object)e));
        }
    }

    private Path resolve(Artifact pluginArtifact) throws MojoExecutionException {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(pluginArtifact).setRepositories(this.pluginRepos)).getArtifact().getFile().toPath();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve artifact " + pluginArtifact, (Exception)((Object)e));
        }
    }

    private Set<ArtifactKey> getManagedKeys() {
        DependencyManagement dm = this.project.getDependencyManagement();
        if (dm == null) {
            return Collections.emptySet();
        }
        List deps = dm.getDependencies();
        if (deps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ArtifactKey> keys = new HashSet<ArtifactKey>(deps.size());
        for (org.apache.maven.model.Dependency d : deps) {
            keys.add(new ArtifactKey(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType()));
        }
        return keys;
    }
}

