/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.decomposer.maven.platformgen.PlatformMemberDefaultTestConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformMemberReleaseConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformMemberTestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class PlatformMemberConfig {
    private String name;
    private String bom;
    private List<String> dependencyManagement = Collections.emptyList();
    private Boolean enabled;
    private Boolean hidden;
    private Boolean alignOwnConstraints;
    private PlatformMemberReleaseConfig release;
    private PlatformMemberDefaultTestConfig defaultTestConfig;
    private Collection<PlatformMemberTestConfig> tests = new ArrayList<PlatformMemberTestConfig>();
    private String testCatalogArtifact;
    private List<String> metadataOverrideFiles = new ArrayList<String>(0);
    private List<String> metadataOverrideArtifacts = new ArrayList<String>(0);
    private List<String> extensionGroupIds = new ArrayList<String>(0);

    void applyOverrides(PlatformMemberConfig overrides) {
        if (overrides.bom != null) {
            this.bom = overrides.bom;
        }
        if (!overrides.dependencyManagement.isEmpty()) {
            if (this.dependencyManagement.isEmpty()) {
                this.dependencyManagement = overrides.dependencyManagement;
            } else {
                overrides.dependencyManagement.stream().filter(s -> this.dependencyManagement.contains(s)).forEach(this.dependencyManagement::add);
            }
        }
        if (overrides.enabled != null) {
            this.enabled = overrides.enabled;
        }
        if (overrides.hidden != null) {
            this.hidden = overrides.hidden;
        }
        if (overrides.alignOwnConstraints != null) {
            this.alignOwnConstraints = overrides.alignOwnConstraints;
        }
        if (overrides.release != null) {
            this.release.applyOverrides(overrides.release);
        }
        if (overrides.defaultTestConfig != null) {
            if (this.defaultTestConfig == null) {
                this.defaultTestConfig = overrides.defaultTestConfig;
            } else {
                this.defaultTestConfig.applyOverrides(overrides.defaultTestConfig);
            }
        }
        if (!overrides.tests.isEmpty()) {
            if (this.tests.isEmpty()) {
                this.tests = overrides.tests;
            } else {
                LinkedHashMap<String, PlatformMemberTestConfig> map = new LinkedHashMap<String, PlatformMemberTestConfig>(this.tests.size() + overrides.tests.size());
                for (PlatformMemberTestConfig t : this.tests) {
                    map.put(t.getArtifact(), t);
                }
                for (PlatformMemberTestConfig t : overrides.tests) {
                    PlatformMemberTestConfig original = map.put(t.getArtifact(), t);
                    if (original == null) continue;
                    original.applyOverrides(t);
                }
                this.tests = map.values();
            }
        }
        if (overrides.testCatalogArtifact != null) {
            this.testCatalogArtifact = overrides.testCatalogArtifact;
        }
        if (!overrides.metadataOverrideFiles.isEmpty()) {
            this.metadataOverrideFiles.addAll(overrides.metadataOverrideFiles);
        }
        if (!overrides.metadataOverrideArtifacts.isEmpty()) {
            this.metadataOverrideArtifacts.addAll(overrides.metadataOverrideArtifacts);
        }
        if (!overrides.extensionGroupIds.isEmpty()) {
            this.extensionGroupIds.addAll(overrides.extensionGroupIds);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBom(String bom) {
        this.bom = bom;
    }

    public String getBom() {
        return this.bom;
    }

    public void setDependencyManagement(List<String> dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
    }

    public List<String> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public void setRelease(PlatformMemberReleaseConfig release) {
        this.release = release;
    }

    public PlatformMemberReleaseConfig getRelease() {
        return this.release;
    }

    public void setTestCatalogArtifact(String testCatalogArtifact) {
        this.testCatalogArtifact = testCatalogArtifact;
    }

    public String getTestCatalogArtifact() {
        return this.testCatalogArtifact;
    }

    public void setDefaultTestConfig(PlatformMemberDefaultTestConfig defaultTestConfig) {
        this.defaultTestConfig = defaultTestConfig;
    }

    public PlatformMemberDefaultTestConfig getDefaultTestConfig() {
        return this.defaultTestConfig;
    }

    public void addTest(PlatformMemberTestConfig test) {
        this.tests.add(test);
    }

    public Collection<PlatformMemberTestConfig> getTests() {
        return this.tests;
    }

    public boolean hasTests() {
        return !this.tests.isEmpty() || this.testCatalogArtifact != null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    public boolean isHidden() {
        return this.hidden == null ? false : this.hidden;
    }

    public boolean isAlignOwnConstraints() {
        return this.alignOwnConstraints == null ? false : this.alignOwnConstraints;
    }

    public void setMetadataOverrideFiles(List<String> metadataOverrideFiles) {
        this.metadataOverrideFiles = metadataOverrideFiles;
    }

    public List<String> getMetadataOverrideFiles() {
        return this.metadataOverrideFiles;
    }

    public void setMetadataOverrideArtifacts(List<String> metadataOverrideArtifacts) {
        this.metadataOverrideArtifacts = metadataOverrideArtifacts;
    }

    public List<String> getMetadataOverrideArtifacts() {
        return this.metadataOverrideArtifacts;
    }

    public List<String> getExtensionGroupIds() {
        return this.extensionGroupIds;
    }

    public void setExtensionGroupIds(List<String> extensionGroupIds) {
        this.extensionGroupIds = extensionGroupIds;
    }
}

