/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.BomDecomposer;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.ProjectDependency;
import io.quarkus.bom.decomposer.ProjectRelease;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bom.decomposer.maven.platformgen.DependenciesToBuildConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.paths.PathTree;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependencies-to-build", threadSafe=true)
public class DependenciesToBuildMojo
extends AbstractMojo {
    private static final String NOT_MANAGED = " [not managed]";
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(required=true, property="bom", defaultValue="${project.groupId}:${project.artifactId}::pom:${project.version}")
    String bom;
    @Parameter(required=true, property="level", defaultValue="-1")
    int level = -1;
    @Parameter(required=false, property="includeNonManaged")
    boolean includeNonManaged;
    @Parameter(required=false, property="logArtifactsToBuild")
    boolean logArtifactsToBuild = true;
    @Parameter(required=false, property="logModulesToBuild")
    boolean logModulesToBuild;
    @Parameter(required=false, property="logTrees")
    boolean logTrees;
    @Parameter(required=false, property="logRemaining")
    boolean logRemaining;
    @Parameter(required=false, property="logSummary")
    boolean logSummary = true;
    @Parameter(required=false, property="logNonManagedVisited")
    boolean logNonManagedVisited;
    @Parameter(property="outputFile", required=false)
    File outputFile;
    private PrintStream fileOutput;
    @Parameter(property="appendOutput", required=false, defaultValue="false")
    boolean appendOutput;
    @Parameter(property="logCodeRepos", required=false)
    boolean logCodeRepos;
    @Parameter(property="logCodeRepoGraph", required=false)
    boolean logCodeRepoGraph;
    @Parameter(required=false)
    PlatformConfig platformConfig;
    @Parameter(required=false)
    DependenciesToBuildConfig dependenciesToBuild;
    private Set<io.quarkus.maven.dependency.ArtifactCoords> managedCoords;
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> allDepsToBuild = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> nonManagedVisited = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> skippedDeps = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> remainingDeps = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Map<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency> artifactDeps = new HashMap<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency>();
    private final Map<ReleaseId, ReleaseRepo> releaseRepos = new HashMap<ReleaseId, ReleaseRepo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        List managedDeps;
        ExtensionCatalog catalog;
        Path jsonPath;
        MavenArtifactResolver resolver;
        io.quarkus.maven.dependency.ArtifactCoords bomCoords;
        if (this.logCodeRepoGraph) {
            this.logCodeRepos = true;
        }
        if (PlatformArtifacts.isCatalogArtifactId((String)(bomCoords = io.quarkus.maven.dependency.ArtifactCoords.fromString((String)this.bom)).getArtifactId())) {
            bomCoords = new GACTV(bomCoords.getGroupId(), PlatformArtifacts.ensureBomArtifactId((String)bomCoords.getArtifactId()), "", "pom", bomCoords.getVersion());
        }
        this.debug("Quarkus platform BOM %s", bomCoords);
        GACTV catalogCoords = new GACTV(bomCoords.getGroupId(), PlatformArtifacts.ensureCatalogArtifactId((String)bomCoords.getArtifactId()), bomCoords.getVersion(), "json", bomCoords.getVersion());
        this.debug("Quarkus extension catalog %s", catalogCoords);
        try {
            resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(true)).setPreferPomsFromWorkspace(true)).setCurrentProject(this.project.getFile().toString())).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
        try {
            jsonPath = resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact((io.quarkus.maven.dependency.ArtifactCoords)catalogCoords)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the extension catalog", (Exception)((Object)e));
        }
        try {
            this.debug("Parsing extension catalog %s", jsonPath);
            catalog = ExtensionCatalog.fromFile((Path)jsonPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + jsonPath, (Exception)e);
        }
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the descriptor of " + bomCoords, (Exception)((Object)e));
        }
        if (managedDeps.isEmpty()) {
            throw new MojoExecutionException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        this.managedCoords = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>(managedDeps.size());
        for (Object d : managedDeps) {
            this.managedCoords.add(DependenciesToBuildMojo.toCoords(d.getArtifact()));
        }
        ArrayList<Extension> supported = new ArrayList<Extension>();
        for (Extension ext : catalog.getExtensions()) {
            Object o;
            ArtifactCoords rtArtifact = ext.getArtifact();
            if (this.isExcluded((io.quarkus.maven.dependency.ArtifactCoords)rtArtifact) || (o = ext.getMetadata().get("redhat-support")) == null) continue;
            supported.add(ext);
            this.processExtensionArtifact(resolver, managedDeps, (io.quarkus.maven.dependency.ArtifactCoords)new GACTV(rtArtifact.getGroupId(), rtArtifact.getArtifactId(), rtArtifact.getClassifier(), rtArtifact.getType(), rtArtifact.getVersion()));
            GACTV deploymentCoords = new GACTV(rtArtifact.getGroupId(), rtArtifact.getArtifactId() + "-deployment", "", "jar", rtArtifact.getVersion());
            if (!this.managedCoords.contains(deploymentCoords)) {
                Path rtJar;
                try {
                    rtJar = resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact((io.quarkus.maven.dependency.ArtifactCoords)rtArtifact)).getArtifact().getFile().toPath();
                }
                catch (BootstrapMavenException e1) {
                    throw new MojoExecutionException("Failed to resolve " + (io.quarkus.maven.dependency.ArtifactCoords)rtArtifact, (Exception)((Object)e1));
                }
                deploymentCoords = (io.quarkus.maven.dependency.ArtifactCoords)PathTree.ofDirectoryOrArchive((Path)rtJar).apply("META-INF/quarkus-extension.properties", visit -> {
                    if (visit == null) {
                        return null;
                    }
                    Properties props = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                        props.load(reader);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    String str = props.getProperty("deployment-artifact");
                    return str == null ? null : io.quarkus.maven.dependency.ArtifactCoords.fromString((String)str);
                });
                if (deploymentCoords == null) {
                    throw new MojoExecutionException("Failed to determine the corresponding deployment artifact for " + rtArtifact.toCompactCoords());
                }
            }
            this.processExtensionArtifact(resolver, managedDeps, (io.quarkus.maven.dependency.ArtifactCoords)deploymentCoords);
        }
        if (this.dependenciesToBuild != null && !this.dependenciesToBuild.getIncludeArtifacts().isEmpty()) {
            for (io.quarkus.maven.dependency.ArtifactCoords coords : this.dependenciesToBuild.getIncludeArtifacts()) {
                this.processExtensionArtifact(resolver, managedDeps, coords);
            }
        }
        try {
            List<String> sorted;
            int codeReposTotal = 0;
            if (this.logArtifactsToBuild && !this.allDepsToBuild.isEmpty()) {
                this.logComment("Artifacts to be built from source from " + bomCoords.toCompactCoords() + ":");
                if (this.logCodeRepos) {
                    this.initReleaseRepos(this.decompose(resolver, (Artifact)bomArtifact, managedDeps, this.nonManagedVisited));
                    codeReposTotal = this.releaseRepos.size();
                    LinkedHashMap orderedMap = new LinkedHashMap(codeReposTotal);
                    for (ReleaseRepo r : this.releaseRepos.values()) {
                        if (!r.isRoot()) continue;
                        this.order(r, orderedMap);
                    }
                    for (ReleaseRepo e : orderedMap.values()) {
                        this.logComment(e.id().toString());
                        for (String s : DependenciesToBuildMojo.toSortedStrings(e.artifacts, this.logModulesToBuild)) {
                            this.log(s);
                        }
                    }
                    if (this.logCodeRepoGraph) {
                        this.logComment("");
                        this.logComment("Code repository dependency graph");
                        for (ReleaseRepo r : this.releaseRepos.values()) {
                            if (!r.isRoot()) continue;
                            this.logReleaseRepoDep(r, 0);
                        }
                        this.logComment("");
                    }
                } else {
                    for (String s : DependenciesToBuildMojo.toSortedStrings(this.allDepsToBuild, this.logModulesToBuild)) {
                        this.log(s);
                    }
                }
            }
            if (this.logNonManagedVisited && !this.nonManagedVisited.isEmpty()) {
                this.logComment("Non-managed dependencies visited walking dependency trees:");
                sorted = DependenciesToBuildMojo.toSortedStrings(this.nonManagedVisited, this.logModulesToBuild);
                for (int i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + sorted.get(i));
                }
            }
            if (this.logRemaining) {
                this.logComment("Remaining artifacts include:");
                sorted = DependenciesToBuildMojo.toSortedStrings(this.remainingDeps, this.logModulesToBuild);
                for (int i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + sorted.get(i));
                }
            }
            if (this.logSummary) {
                StringBuilder sb = new StringBuilder().append("Selecting ");
                if (this.level < 0) {
                    sb.append("all the");
                } else {
                    sb.append(this.level).append(" level(s) of");
                }
                if (this.includeNonManaged) {
                    sb.append(" managed and non-managed");
                } else {
                    sb.append(" managed (stopping at the first non-managed one)");
                }
                sb.append(" dependencies of supported extensions from ").append(bomCoords.toCompactCoords()).append(" will result in:");
                this.logComment(sb.toString());
                sb.setLength(0);
                sb.append(this.allDepsToBuild.size()).append(" artifacts");
                if (codeReposTotal > 0) {
                    sb.append(" from ").append(codeReposTotal).append(" code repositories");
                }
                sb.append(" to build from source");
                this.logComment(sb.toString());
                if (this.includeNonManaged && !this.nonManagedVisited.isEmpty()) {
                    this.logComment("  * " + this.nonManagedVisited.size() + " of which is/are not managed by the BOM");
                }
                if (!this.skippedDeps.isEmpty()) {
                    this.logComment(this.skippedDeps.size() + " dependency nodes skipped");
                }
                this.logComment(this.allDepsToBuild.size() + this.skippedDeps.size() + " dependencies visited in total");
            }
        }
        finally {
            if (this.fileOutput != null) {
                this.fileOutput.close();
            }
        }
    }

    private void processExtensionArtifact(MavenArtifactResolver resolver, List<Dependency> managedDeps, io.quarkus.maven.dependency.ArtifactCoords extArtifact) {
        DependencyNode root;
        try {
            DefaultArtifact a = DependenciesToBuildMojo.toAetherArtifact(extArtifact);
            root = resolver.getSystem().collectDependencies(resolver.getSession(), new CollectRequest().setManagedDependencies(managedDeps).setRepositories(resolver.getRepositories()).setRoot(new Dependency((Artifact)a, "runtime"))).getRoot();
        }
        catch (DependencyCollectionException e1) {
            throw new RuntimeException("Failed to collect dependencies of " + extArtifact.toCompactCoords(), e1);
        }
        if (this.logTrees) {
            if (this.managedCoords.contains(extArtifact)) {
                this.logComment(extArtifact.toCompactCoords());
            } else {
                this.logComment(extArtifact.toCompactCoords() + NOT_MANAGED);
            }
        }
        if (this.addToBeBuilt(extArtifact)) {
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(this.logCodeRepos ? this.getOrCreateArtifactDep(extArtifact) : null, d, 1, false);
            }
        } else if (this.logRemaining) {
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(null, d, 1, true);
            }
        }
        if (this.logTrees) {
            this.logComment("");
        }
    }

    private static DefaultArtifact toAetherArtifact(io.quarkus.maven.dependency.ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private DecomposedBom decompose(MavenArtifactResolver resolver, Artifact bomArtifact, Collection<Dependency> managed, Collection<io.quarkus.maven.dependency.ArtifactCoords> nonManaged) throws MojoExecutionException {
        BomDecomposer.BomDecomposerConfig config = BomDecomposer.config().bomArtifact(bomArtifact).logger((MessageWriter)new MojoMessageWriter(this.getLog())).loadReleaseDetectors(false).mavenArtifactResolver(ArtifactResolverProvider.get((MavenArtifactResolver)resolver));
        if (nonManaged != null && !nonManaged.isEmpty()) {
            ArrayList<Dependency> allDeps = new ArrayList<Dependency>(managed.size() + nonManaged.size());
            allDeps.addAll(managed);
            for (io.quarkus.maven.dependency.ArtifactCoords c : nonManaged) {
                allDeps.add(new Dependency((Artifact)DependenciesToBuildMojo.toAetherArtifact(c), "compile"));
            }
            config.dependencies(allDeps);
        }
        DecomposedBom decomposedBom = null;
        try {
            decomposedBom = config.decompose();
        }
        catch (BomDecomposerException e) {
            throw new MojoExecutionException("Failed to decompose BOM " + bomArtifact, (Exception)((Object)e));
        }
        return decomposedBom;
    }

    private void initReleaseRepos(DecomposedBom decomposedBom) {
        HashMap deps = new HashMap();
        decomposedBom.releases().forEach(r -> {
            r.dependencies().forEach(d -> deps.put(d.key(), d));
            this.getOrCreateRepo((ProjectRelease)r);
        });
        HashMap<io.quarkus.maven.dependency.ArtifactCoords, ReleaseId> artifactReleases = new HashMap<io.quarkus.maven.dependency.ArtifactCoords, ReleaseId>();
        for (io.quarkus.maven.dependency.ArtifactCoords c : this.allDepsToBuild) {
            ProjectDependency dep = (ProjectDependency)deps.get(c.getKey());
            if (dep == null) {
                throw new IllegalStateException("Failed to find dependency for " + c.getKey());
            }
            this.getRepo((ReleaseId)dep.releaseId()).artifacts.add(c);
            artifactReleases.put(c, dep.releaseId());
        }
        Iterator<Map.Entry<ReleaseId, ReleaseRepo>> i = this.releaseRepos.entrySet().iterator();
        while (i.hasNext()) {
            if (!i.next().getValue().artifacts.isEmpty()) continue;
            i.remove();
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            ReleaseRepo repo = this.getRepo((ReleaseId)artifactReleases.get(d.coords));
            for (ArtifactDependency c : d.children.values()) {
                repo.addRepoDependency(this.getRepo((ReleaseId)artifactReleases.get(c.coords)));
            }
        }
    }

    private void order(ReleaseRepo repo, Map<ReleaseId, ReleaseRepo> repos) {
        for (ReleaseRepo d : repo.dependencies.values()) {
            if (repos.containsKey(d.id())) continue;
            this.order(d, repos);
        }
        repos.putIfAbsent(repo.id(), repo);
    }

    private void logReleaseRepoDep(ReleaseRepo repo, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(repo.id().origin()).append(' ').append(repo.id().version());
        this.logComment(sb.toString());
        for (ReleaseRepo child : repo.dependencies.values()) {
            this.logReleaseRepoDep(child, depth + 1);
        }
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            if (args.length == 0) {
                this.getLog().debug((CharSequence)msg);
            } else {
                this.getLog().debug((CharSequence)String.format(msg, args));
            }
        }
    }

    private static List<String> toSortedStrings(Collection<io.quarkus.maven.dependency.ArtifactCoords> coords, boolean asModules) {
        ArrayList<String> list;
        if (asModules) {
            HashSet<CallSite> set = new HashSet<CallSite>();
            for (io.quarkus.maven.dependency.ArtifactCoords c : coords) {
                set.add((CallSite)((Object)(c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion())));
            }
            list = new ArrayList(set);
        } else {
            list = new ArrayList<String>(coords.size());
            for (io.quarkus.maven.dependency.ArtifactCoords c : coords) {
                list.add(c.toGACTVString());
            }
        }
        Collections.sort(list);
        return list;
    }

    private PrintStream getOutput() {
        if (this.outputFile == null) {
            return System.out;
        }
        if (this.fileOutput == null) {
            this.outputFile.getParentFile().mkdirs();
            try {
                this.fileOutput = new PrintStream(new FileOutputStream(this.outputFile, this.appendOutput), false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open " + this.outputFile + " for writing", e);
            }
        }
        return this.fileOutput;
    }

    private void logComment(String msg) {
        this.log("# " + msg);
    }

    private void log(String msg) {
        this.getOutput().println(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNodes(ArtifactDependency parent, DependencyNode node, int level, boolean remaining) {
        io.quarkus.maven.dependency.ArtifactCoords coords = DependenciesToBuildMojo.toCoords(node.getArtifact());
        if (this.isExcluded(coords)) {
            return;
        }
        ArtifactDependency artDep = null;
        if (remaining) {
            this.addToRemaining(coords);
        } else if (this.level < 0 || level <= this.level) {
            if (this.addToBeBuilt(coords)) {
                if (this.logTrees) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < level; ++i) {
                        buf.append("  ");
                    }
                    buf.append(coords.toCompactCoords());
                    if (!this.managedCoords.contains(coords)) {
                        buf.append(' ').append(NOT_MANAGED);
                    }
                    this.logComment(buf.toString());
                }
                if (parent != null) {
                    artDep = this.getOrCreateArtifactDep(coords);
                    parent.addDependency(artDep);
                }
            } else {
                if (!this.logRemaining) return;
                remaining = true;
            }
        } else {
            this.addToSkipped(coords);
            if (!this.logRemaining) return;
            remaining = true;
            this.addToRemaining(coords);
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNodes(artDep, child, level + 1, remaining);
        }
    }

    private boolean addToBeBuilt(io.quarkus.maven.dependency.ArtifactCoords coords) {
        boolean managed = this.managedCoords.contains(coords);
        if (!managed) {
            this.nonManagedVisited.add(coords);
        }
        if (managed || this.includeNonManaged || this.isIncluded(coords)) {
            this.allDepsToBuild.add(coords);
            this.skippedDeps.remove(coords);
            this.remainingDeps.remove(coords);
            return true;
        }
        this.addToSkipped(coords);
        if (this.logRemaining) {
            this.addToRemaining(coords);
        }
        return false;
    }

    private void addToSkipped(io.quarkus.maven.dependency.ArtifactCoords coords) {
        if (!this.allDepsToBuild.contains(coords)) {
            this.skippedDeps.add(coords);
        }
    }

    private void addToRemaining(io.quarkus.maven.dependency.ArtifactCoords coords) {
        if (!this.allDepsToBuild.contains(coords)) {
            this.remainingDeps.add(coords);
        }
    }

    private boolean isExcluded(io.quarkus.maven.dependency.ArtifactCoords coords) {
        return this.dependenciesToBuild != null && (this.dependenciesToBuild.getExcludeGroupIds().contains(coords.getGroupId()) || this.dependenciesToBuild.getExcludeKeys().contains(coords.getKey()) || this.dependenciesToBuild.getExcludeArtifacts().contains(coords));
    }

    private boolean isIncluded(io.quarkus.maven.dependency.ArtifactCoords coords) {
        return this.dependenciesToBuild != null && (this.dependenciesToBuild.getIncludeGroupIds().contains(coords.getGroupId()) || this.dependenciesToBuild.getIncludeKeys().contains(coords.getKey()) || this.dependenciesToBuild.getIncludeArtifacts().contains(coords));
    }

    private static io.quarkus.maven.dependency.ArtifactCoords toCoords(Artifact a) {
        return new GACTV(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion());
    }

    private ArtifactDependency getOrCreateArtifactDep(io.quarkus.maven.dependency.ArtifactCoords c) {
        return this.artifactDeps.computeIfAbsent(c, k -> new ArtifactDependency(c));
    }

    private ReleaseRepo getOrCreateRepo(ProjectRelease release) {
        return this.releaseRepos.computeIfAbsent(release.id(), k -> new ReleaseRepo(release));
    }

    private ReleaseRepo getRepo(ReleaseId id) {
        return Objects.requireNonNull(this.releaseRepos.get(id));
    }

    private static class ReleaseRepo {
        final ProjectRelease release;
        final List<io.quarkus.maven.dependency.ArtifactCoords> artifacts = new ArrayList<io.quarkus.maven.dependency.ArtifactCoords>();
        final Map<ReleaseId, ReleaseRepo> parents = new HashMap<ReleaseId, ReleaseRepo>();
        final Map<ReleaseId, ReleaseRepo> dependencies = new LinkedHashMap<ReleaseId, ReleaseRepo>();

        ReleaseRepo(ProjectRelease release) {
            this.release = release;
        }

        ReleaseId id() {
            return this.release.id();
        }

        void addRepoDependency(ReleaseRepo repo) {
            if (repo != this) {
                this.dependencies.putIfAbsent(repo.id(), repo);
                repo.parents.putIfAbsent(this.id(), this);
            }
        }

        boolean isRoot() {
            return this.parents.isEmpty();
        }
    }

    private static class ArtifactDependency {
        final io.quarkus.maven.dependency.ArtifactCoords coords;
        final Map<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency> children = new LinkedHashMap<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency>();

        ArtifactDependency(io.quarkus.maven.dependency.ArtifactCoords coords) {
            this.coords = coords;
        }

        void addDependency(ArtifactDependency d) {
            this.children.putIfAbsent(d.coords, d);
        }
    }
}

