/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import io.quarkus.bom.decomposer.maven.platformgen.DependenciesToBuildConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.paths.PathTree;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependencies-to-build", threadSafe=true, requiresProject=false)
public class DependenciesToBuildMojo
extends AbstractMojo {
    private static final String NOT_MANAGED = " [not managed]";
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(required=false, defaultValue="${project.file}")
    File projectFile;
    @Parameter(required=true, property="bom", defaultValue="${project.groupId}:${project.artifactId}::pom:${project.version}")
    String bom;
    @Parameter(required=true, property="level", defaultValue="-1")
    int level = -1;
    @Parameter(required=false, property="includeNonManaged")
    boolean includeNonManaged;
    @Parameter(required=false, property="logArtifactsToBuild")
    boolean logArtifactsToBuild = true;
    @Parameter(required=false, property="logModulesToBuild")
    boolean logModulesToBuild;
    @Parameter(required=false, property="logTrees")
    boolean logTrees;
    @Parameter(required=false, property="logRemaining")
    boolean logRemaining;
    @Parameter(required=false, property="logSummary")
    boolean logSummary = true;
    @Parameter(required=false, property="logNonManagedVisited")
    boolean logNonManagedVisited;
    @Parameter(property="outputFile", required=false)
    File outputFile;
    private PrintStream fileOutput;
    @Parameter(property="appendOutput", required=false, defaultValue="false")
    boolean appendOutput;
    @Parameter(property="logCodeRepos", required=false)
    boolean logCodeRepos;
    @Parameter(property="logCodeRepoGraph", required=false)
    boolean logCodeRepoGraph;
    @Parameter(property="excludeParentPoms", required=false)
    boolean excludeParentPoms;
    @Parameter(property="excludeBomImports", required=false)
    boolean excludeBomImports;
    @Parameter(required=false)
    PlatformConfig platformConfig;
    @Parameter(required=false)
    DependenciesToBuildConfig dependenciesToBuild;
    private Set<io.quarkus.maven.dependency.ArtifactCoords> targetBomConstraints;
    private Map<io.quarkus.maven.dependency.ArtifactCoords, List<Dependency>> enforcedConstraintsForBom = new HashMap<io.quarkus.maven.dependency.ArtifactCoords, List<Dependency>>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> allDepsToBuild = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> nonManagedVisited = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> skippedDeps = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Set<io.quarkus.maven.dependency.ArtifactCoords> remainingDeps = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>();
    private final Map<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency> artifactDeps = new HashMap<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency>();
    private final Map<ReleaseId, ReleaseRepo> releaseRepos = new HashMap<ReleaseId, ReleaseRepo>();
    private final Map<io.quarkus.maven.dependency.ArtifactCoords, Map<String, String>> effectivePomProps = new HashMap<io.quarkus.maven.dependency.ArtifactCoords, Map<String, String>>();
    private MavenArtifactResolver resolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        io.quarkus.maven.dependency.ArtifactCoords targetBomCoords;
        if (this.logCodeRepoGraph) {
            this.logCodeRepos = true;
        }
        if (PlatformArtifacts.isCatalogArtifactId((String)(targetBomCoords = io.quarkus.maven.dependency.ArtifactCoords.fromString((String)this.bom)).getArtifactId())) {
            targetBomCoords = io.quarkus.maven.dependency.ArtifactCoords.pom((String)targetBomCoords.getGroupId(), (String)PlatformArtifacts.ensureBomArtifactId((String)targetBomCoords.getArtifactId()), (String)targetBomCoords.getVersion());
        } else if (!targetBomCoords.getType().equals("pom")) {
            targetBomCoords = io.quarkus.maven.dependency.ArtifactCoords.pom((String)targetBomCoords.getGroupId(), (String)targetBomCoords.getArtifactId(), (String)targetBomCoords.getVersion());
        }
        this.debug("Quarkus platform BOM %s", targetBomCoords);
        io.quarkus.maven.dependency.ArtifactCoords catalogCoords = io.quarkus.maven.dependency.ArtifactCoords.of((String)targetBomCoords.getGroupId(), (String)PlatformArtifacts.ensureCatalogArtifactId((String)targetBomCoords.getArtifactId()), (String)targetBomCoords.getVersion(), (String)"json", (String)targetBomCoords.getVersion());
        this.debug("Quarkus extension catalog %s", catalogCoords);
        try {
            this.resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(this.projectFile != null)).setPreferPomsFromWorkspace(this.projectFile != null)).setCurrentProject(this.projectFile == null ? null : this.projectFile.toString())).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
        ExtensionCatalog catalog = this.resolveCatalog(catalogCoords);
        List<Dependency> targetBomManagedDeps = this.getBomConstraints(targetBomCoords);
        this.targetBomConstraints = new HashSet<io.quarkus.maven.dependency.ArtifactCoords>(targetBomManagedDeps.size());
        for (Dependency d : targetBomManagedDeps) {
            this.targetBomConstraints.add(DependenciesToBuildMojo.toCoords(d.getArtifact()));
        }
        Collection<io.quarkus.maven.dependency.ArtifactCoords> otherDescriptorCoords = DependenciesToBuildMojo.getOtherMemberDescriptorCoords(catalog);
        if (!otherDescriptorCoords.isEmpty()) {
            io.quarkus.maven.dependency.ArtifactCoords generatedCoreBomCoords = null;
            if (targetBomCoords.getArtifactId().equals("quarkus-bom")) {
                generatedCoreBomCoords = targetBomCoords;
            } else {
                String coreDescriptorArtifactId = "quarkus-bom-quarkus-platform-descriptor";
                for (io.quarkus.maven.dependency.ArtifactCoords artifactCoords : otherDescriptorCoords) {
                    if (!artifactCoords.getArtifactId().equals("quarkus-bom-quarkus-platform-descriptor")) continue;
                    generatedCoreBomCoords = PlatformArtifacts.ensureBomArtifact((io.quarkus.maven.dependency.ArtifactCoords)artifactCoords);
                    break;
                }
                if (generatedCoreBomCoords == null) {
                    throw new MojoExecutionException("Failed to locate quarkus-bom among " + otherDescriptorCoords);
                }
            }
            if (targetBomCoords.equals(generatedCoreBomCoords)) {
                this.enforcedConstraintsForBom.put(targetBomCoords, targetBomManagedDeps);
                ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(otherDescriptorCoords.size() + 1);
                catalogs.add(catalog);
                for (io.quarkus.maven.dependency.ArtifactCoords artifactCoords : otherDescriptorCoords) {
                    ExtensionCatalog otherCatalog = this.resolveCatalog(artifactCoords);
                    catalogs.add(otherCatalog);
                    ArtifactCoords otherBomCoords = otherCatalog.getBom();
                    List<Dependency> otherBomDeps = this.getBomConstraints((io.quarkus.maven.dependency.ArtifactCoords)otherBomCoords);
                    ArrayList<Dependency> enforcedConstraints = new ArrayList<Dependency>(targetBomManagedDeps.size() + otherBomDeps.size());
                    enforcedConstraints.addAll(otherBomDeps);
                    enforcedConstraints.addAll(otherBomDeps);
                    this.enforcedConstraintsForBom.put((io.quarkus.maven.dependency.ArtifactCoords)otherBomCoords, enforcedConstraints);
                }
                catalog = CatalogMergeUtility.merge(catalogs);
            } else {
                List<Dependency> bomConstraints = this.getBomConstraints(generatedCoreBomCoords);
                bomConstraints.addAll(targetBomManagedDeps);
                this.enforcedConstraintsForBom.put(targetBomCoords, bomConstraints);
            }
        } else {
            this.enforcedConstraintsForBom.put(targetBomCoords, targetBomManagedDeps);
        }
        ArrayList<Extension> supported = new ArrayList<Extension>();
        for (Object ext : catalog.getExtensions()) {
            Object o;
            ArtifactCoords artifactCoords = ext.getArtifact();
            if (this.isExcluded((io.quarkus.maven.dependency.ArtifactCoords)artifactCoords) || (o = ext.getMetadata().get("redhat-support")) == null) continue;
            supported.add((Extension)ext);
            List<Dependency> extConstraints = this.getConstraintsForExtension((Extension)ext);
            this.processExtensionArtifact(extConstraints, io.quarkus.maven.dependency.ArtifactCoords.of((String)artifactCoords.getGroupId(), (String)artifactCoords.getArtifactId(), (String)artifactCoords.getClassifier(), (String)artifactCoords.getType(), (String)artifactCoords.getVersion()));
            io.quarkus.maven.dependency.ArtifactCoords deploymentCoords = io.quarkus.maven.dependency.ArtifactCoords.jar((String)artifactCoords.getGroupId(), (String)(artifactCoords.getArtifactId() + "-deployment"), (String)artifactCoords.getVersion());
            if (!this.targetBomConstraints.contains(deploymentCoords)) {
                Path rtJar;
                try {
                    rtJar = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact((io.quarkus.maven.dependency.ArtifactCoords)artifactCoords)).getArtifact().getFile().toPath();
                }
                catch (BootstrapMavenException e1) {
                    throw new MojoExecutionException("Failed to resolve " + (io.quarkus.maven.dependency.ArtifactCoords)artifactCoords, (Exception)((Object)e1));
                }
                deploymentCoords = (io.quarkus.maven.dependency.ArtifactCoords)PathTree.ofDirectoryOrArchive((Path)rtJar).apply("META-INF/quarkus-extension.properties", visit -> {
                    if (visit == null) {
                        return null;
                    }
                    Properties props = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                        props.load(reader);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    String str = props.getProperty("deployment-artifact");
                    return str == null ? null : io.quarkus.maven.dependency.ArtifactCoords.fromString((String)str);
                });
                if (deploymentCoords == null) {
                    throw new MojoExecutionException("Failed to determine the corresponding deployment artifact for " + artifactCoords.toCompactCoords());
                }
            }
            this.processExtensionArtifact(extConstraints, deploymentCoords);
        }
        if (this.dependenciesToBuild != null && !this.dependenciesToBuild.getIncludeArtifacts().isEmpty()) {
            List<Dependency> enforcedConstraints = this.enforcedConstraintsForBom.get(targetBomCoords);
            if (enforcedConstraints == null) {
                throw new MojoExecutionException("Failed to locate enforced constraints for " + targetBomCoords);
            }
            for (io.quarkus.maven.dependency.ArtifactCoords artifactCoords : this.dependenciesToBuild.getIncludeArtifacts()) {
                this.processExtensionArtifact(enforcedConstraints, artifactCoords);
            }
        }
        try {
            List<String> sorted;
            int codeReposTotal = 0;
            if (this.logArtifactsToBuild && !this.allDepsToBuild.isEmpty()) {
                this.logComment("Artifacts to be built from source from " + targetBomCoords.toCompactCoords() + ":");
                if (this.logCodeRepos) {
                    this.initReleaseRepos();
                    codeReposTotal = this.releaseRepos.size();
                    LinkedHashMap orderedMap = new LinkedHashMap(codeReposTotal);
                    for (ReleaseRepo r : this.releaseRepos.values()) {
                        if (!r.isRoot()) continue;
                        this.order(r, orderedMap);
                    }
                    for (ReleaseRepo e : orderedMap.values()) {
                        this.logComment(e.id().toString());
                        for (String s : DependenciesToBuildMojo.toSortedStrings(e.artifacts, this.logModulesToBuild)) {
                            this.log(s);
                        }
                    }
                    if (this.logCodeRepoGraph) {
                        this.logComment("");
                        this.logComment("Code repository dependency graph");
                        for (ReleaseRepo r : this.releaseRepos.values()) {
                            if (!r.isRoot()) continue;
                            this.logReleaseRepoDep(r, 0);
                        }
                        this.logComment("");
                    }
                } else {
                    for (String string : DependenciesToBuildMojo.toSortedStrings(this.allDepsToBuild, this.logModulesToBuild)) {
                        this.log(string);
                    }
                }
            }
            if (this.logNonManagedVisited && !this.nonManagedVisited.isEmpty()) {
                void var9_26;
                this.logComment("Non-managed dependencies visited walking dependency trees:");
                sorted = DependenciesToBuildMojo.toSortedStrings(this.nonManagedVisited, this.logModulesToBuild);
                boolean bl = false;
                while (var9_26 < sorted.size()) {
                    this.logComment((int)(var9_26 + true) + ") " + sorted.get((int)var9_26));
                    ++var9_26;
                }
            }
            if (this.logRemaining) {
                void var9_28;
                this.logComment("Remaining artifacts include:");
                sorted = DependenciesToBuildMojo.toSortedStrings(this.remainingDeps, this.logModulesToBuild);
                boolean bl = false;
                while (var9_28 < sorted.size()) {
                    this.logComment((int)(var9_28 + true) + ") " + sorted.get((int)var9_28));
                    ++var9_28;
                }
            }
            if (this.logSummary) {
                StringBuilder sb = new StringBuilder().append("Selecting ");
                if (this.level < 0) {
                    sb.append("all the");
                } else {
                    sb.append(this.level).append(" level(s) of");
                }
                if (this.includeNonManaged) {
                    sb.append(" managed and non-managed");
                } else {
                    sb.append(" managed (stopping at the first non-managed one)");
                }
                sb.append(" dependencies of supported extensions from ").append(targetBomCoords.toCompactCoords()).append(" will result in:");
                this.logComment(sb.toString());
                sb.setLength(0);
                sb.append(this.allDepsToBuild.size()).append(" artifacts");
                if (codeReposTotal > 0) {
                    sb.append(" from ").append(codeReposTotal).append(" code repositories");
                }
                sb.append(" to build from source");
                this.logComment(sb.toString());
                if (this.includeNonManaged && !this.nonManagedVisited.isEmpty()) {
                    this.logComment("  * " + this.nonManagedVisited.size() + " of which is/are not managed by the BOM");
                }
                if (!this.skippedDeps.isEmpty()) {
                    this.logComment(this.skippedDeps.size() + " dependency nodes skipped");
                }
                this.logComment(this.allDepsToBuild.size() + this.skippedDeps.size() + " dependencies visited in total");
                this.logComment(supported.size() + " out of " + catalog.getExtensions().size() + " extensions are supported");
            }
        }
        finally {
            if (this.fileOutput != null) {
                this.fileOutput.close();
            }
        }
    }

    private List<Dependency> getConstraintsForExtension(Extension ext) throws MojoExecutionException {
        for (ExtensionOrigin origin : ext.getOrigins()) {
            List<Dependency> enforcedConstraints;
            if (origin.getBom() == null || (enforcedConstraints = this.enforcedConstraintsForBom.get(origin.getBom())) == null) continue;
            return enforcedConstraints;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to locate enforced constraints for ").append(ext.getArtifact().toCompactCoords()).append(" with origins ");
        for (int i = 0; i < ext.getOrigins().size(); ++i) {
            ExtensionOrigin origin = (ExtensionOrigin)ext.getOrigins().get(i);
            if (origin.getBom() == null) continue;
            sb.append(origin.getBom().toCompactCoords());
            if (i <= 0) continue;
            sb.append(", ");
        }
        sb.append(" among ");
        Iterator<io.quarkus.maven.dependency.ArtifactCoords> i = this.enforcedConstraintsForBom.keySet().iterator();
        if (i.hasNext()) {
            sb.append(i.next().toCompactCoords());
            while (i.hasNext()) {
                sb.append(", ").append(i.next().toCompactCoords());
            }
        }
        throw new MojoExecutionException(sb.toString());
    }

    private List<Dependency> getBomConstraints(io.quarkus.maven.dependency.ArtifactCoords bomCoords) throws MojoExecutionException {
        List managedDeps;
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = this.resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the descriptor of " + bomCoords, (Exception)((Object)e));
        }
        if (managedDeps.isEmpty()) {
            throw new MojoExecutionException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        return managedDeps;
    }

    private ExtensionCatalog resolveCatalog(io.quarkus.maven.dependency.ArtifactCoords catalogCoords) throws MojoExecutionException {
        ExtensionCatalog catalog;
        Path jsonPath;
        try {
            jsonPath = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact(catalogCoords)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the extension catalog", (Exception)((Object)e));
        }
        try {
            this.debug("Parsing extension catalog %s", jsonPath);
            catalog = ExtensionCatalog.fromFile((Path)jsonPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + jsonPath, (Exception)e);
        }
        return catalog;
    }

    private void processExtensionArtifact(List<Dependency> managedDeps, io.quarkus.maven.dependency.ArtifactCoords extArtifact) {
        DependencyNode root;
        try {
            DefaultArtifact a = DependenciesToBuildMojo.toAetherArtifact(extArtifact);
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), new CollectRequest().setManagedDependencies(managedDeps).setRepositories(this.resolver.getRepositories()).setRoot(new Dependency((Artifact)a, "runtime"))).getRoot();
        }
        catch (DependencyCollectionException e1) {
            throw new RuntimeException("Failed to collect dependencies of " + extArtifact.toCompactCoords(), e1);
        }
        if (this.logTrees) {
            if (this.targetBomConstraints.contains(extArtifact)) {
                this.logComment(extArtifact.toCompactCoords());
            } else {
                this.logComment(extArtifact.toCompactCoords() + NOT_MANAGED);
            }
        }
        if (this.addExtensionDependencyToBuild(extArtifact)) {
            ArtifactDependency extDep = this.getOrCreateArtifactDep(extArtifact);
            if (!this.excludeParentPoms && this.logTrees) {
                extDep.logBomImportsAndParents();
            }
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(extDep, d, 1, false);
            }
        } else if (this.logRemaining) {
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(null, d, 1, true);
            }
        }
        if (this.logTrees) {
            this.logComment("");
        }
    }

    private static DefaultArtifact toAetherArtifact(io.quarkus.maven.dependency.ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private void initReleaseRepos() throws MojoExecutionException {
        ReleaseIdResolver idResolver = new ReleaseIdResolver(this.resolver);
        HashMap<io.quarkus.maven.dependency.ArtifactCoords, ReleaseId> artifactReleases = new HashMap<io.quarkus.maven.dependency.ArtifactCoords, ReleaseId>();
        for (io.quarkus.maven.dependency.ArtifactCoords c : this.allDepsToBuild) {
            ReleaseId releaseId;
            try {
                releaseId = idResolver.releaseId((Artifact)DependenciesToBuildMojo.toAetherArtifact(c));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolve release id for " + c, e);
            }
            this.getOrCreateRepo((ReleaseId)releaseId).artifacts.add(c);
            artifactReleases.put(c, releaseId);
        }
        Iterator<Map.Entry<ReleaseId, ReleaseRepo>> i = this.releaseRepos.entrySet().iterator();
        while (i.hasNext()) {
            if (!i.next().getValue().artifacts.isEmpty()) continue;
            i.remove();
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            ReleaseRepo repo = this.getRepo((ReleaseId)artifactReleases.get(d.coords));
            for (ArtifactDependency c : d.getAllDependencies()) {
                repo.addRepoDependency(this.getRepo((ReleaseId)artifactReleases.get(c.coords)));
            }
        }
    }

    private void order(ReleaseRepo repo, Map<ReleaseId, ReleaseRepo> repos) {
        for (ReleaseRepo d : repo.dependencies.values()) {
            if (repos.containsKey(d.id())) continue;
            this.order(d, repos);
        }
        repos.putIfAbsent(repo.id(), repo);
    }

    private void logReleaseRepoDep(ReleaseRepo repo, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(repo.id().origin()).append(' ').append(repo.id().version());
        this.logComment(sb.toString());
        for (ReleaseRepo child : repo.dependencies.values()) {
            this.logReleaseRepoDep(child, depth + 1);
        }
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            if (args.length == 0) {
                this.getLog().debug((CharSequence)msg);
            } else {
                this.getLog().debug((CharSequence)String.format(msg, args));
            }
        }
    }

    private static List<String> toSortedStrings(Collection<io.quarkus.maven.dependency.ArtifactCoords> coords, boolean asModules) {
        ArrayList<String> list;
        if (asModules) {
            HashSet<CallSite> set = new HashSet<CallSite>();
            for (io.quarkus.maven.dependency.ArtifactCoords c : coords) {
                set.add((CallSite)((Object)(c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion())));
            }
            list = new ArrayList(set);
        } else {
            list = new ArrayList<String>(coords.size());
            for (io.quarkus.maven.dependency.ArtifactCoords c : coords) {
                list.add(c.toGACTVString());
            }
        }
        Collections.sort(list);
        return list;
    }

    private PrintStream getOutput() {
        if (this.outputFile == null) {
            return System.out;
        }
        if (this.fileOutput == null) {
            this.outputFile.getParentFile().mkdirs();
            try {
                this.fileOutput = new PrintStream(new FileOutputStream(this.outputFile, this.appendOutput), false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open " + this.outputFile + " for writing", e);
            }
        }
        return this.fileOutput;
    }

    private void logComment(String msg) {
        this.log("# " + msg);
    }

    private void log(String msg) {
        this.getOutput().println(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNodes(ArtifactDependency parent, DependencyNode node, int level, boolean remaining) {
        io.quarkus.maven.dependency.ArtifactCoords coords = DependenciesToBuildMojo.toCoords(node.getArtifact());
        if (this.isExcluded(coords)) {
            return;
        }
        ArtifactDependency artDep = null;
        if (remaining) {
            this.addToRemaining(coords);
        } else if (this.level < 0 || level <= this.level) {
            if (this.addExtensionDependencyToBuild(coords)) {
                if (this.logTrees) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < level; ++i) {
                        buf.append("  ");
                    }
                    buf.append(coords.toCompactCoords());
                    if (!this.targetBomConstraints.contains(coords)) {
                        buf.append(' ').append(NOT_MANAGED);
                    }
                    this.logComment(buf.toString());
                }
                if (parent != null) {
                    artDep = this.getOrCreateArtifactDep(coords);
                    parent.addDependency(artDep);
                    if (this.logTrees) {
                        artDep.logBomImportsAndParents(level + 1);
                    }
                }
            } else {
                if (!this.logRemaining) return;
                remaining = true;
            }
        } else {
            this.addToSkipped(coords);
            if (!this.logRemaining) return;
            remaining = true;
            this.addToRemaining(coords);
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNodes(artDep, child, level + 1, remaining);
        }
    }

    private boolean addExtensionDependencyToBuild(io.quarkus.maven.dependency.ArtifactCoords coords) {
        if (!this.addArtifactToBuild(coords)) {
            return false;
        }
        if (!this.excludeParentPoms) {
            this.addImportedBomsAndParentPomToBuild(coords);
        }
        return true;
    }

    private boolean addArtifactToBuild(io.quarkus.maven.dependency.ArtifactCoords coords) {
        boolean managed = this.targetBomConstraints.contains(coords);
        if (!managed) {
            this.nonManagedVisited.add(coords);
        }
        if (managed || this.includeNonManaged || this.isIncluded(coords) || !this.excludeParentPoms && coords.getType().equals("pom")) {
            this.allDepsToBuild.add(coords);
            this.skippedDeps.remove(coords);
            this.remainingDeps.remove(coords);
            return true;
        }
        this.addToSkipped(coords);
        if (this.logRemaining) {
            this.addToRemaining(coords);
        }
        return false;
    }

    private Map<String, String> addImportedBomsAndParentPomToBuild(io.quarkus.maven.dependency.ArtifactCoords coords) {
        Model model;
        Path pomXml;
        io.quarkus.maven.dependency.ArtifactCoords pomCoords;
        io.quarkus.maven.dependency.ArtifactCoords artifactCoords = pomCoords = coords.getType().equals("pom") ? coords : io.quarkus.maven.dependency.ArtifactCoords.pom((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion());
        if (this.allDepsToBuild.contains(pomCoords)) {
            return this.effectivePomProps.getOrDefault(pomCoords, Map.of());
        }
        try {
            pomXml = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact(pomCoords)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to resolve " + pomCoords, e);
        }
        try {
            model = ModelUtils.readModel((Path)pomXml);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + pomXml, e);
        }
        ArtifactDependency artDep = this.getOrCreateArtifactDep(coords);
        Map<String, String> parentPomProps = null;
        Parent parent = model.getParent();
        if (parent != null) {
            io.quarkus.maven.dependency.ArtifactCoords parentPomCoords;
            String parentVersion = parent.getVersion();
            if (ModelUtils.isUnresolvedVersion((String)parentVersion)) {
                if (model.getVersion() == null || model.getVersion().equals(parentVersion)) {
                    parentVersion = pomCoords.getVersion();
                } else {
                    this.getLog().warn((CharSequence)("Failed to resolve the version of" + parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion() + " as a parent of " + pomCoords));
                    parentVersion = null;
                }
            }
            if (parentVersion != null && !this.isExcluded(parentPomCoords = io.quarkus.maven.dependency.ArtifactCoords.pom((String)parent.getGroupId(), (String)parent.getArtifactId(), (String)parentVersion))) {
                artDep.setParentPom(this.getOrCreateArtifactDep(parentPomCoords));
                parentPomProps = this.addImportedBomsAndParentPomToBuild(parentPomCoords);
                this.addArtifactToBuild(parentPomCoords);
            }
        }
        if (this.excludeBomImports) {
            return Map.of();
        }
        Map<String, String> pomProps = DependenciesToBuildMojo.toMap(model.getProperties());
        pomProps.put("project.version", pomCoords.getVersion());
        pomProps.put("project.groupId", pomCoords.getGroupId());
        if (parentPomProps != null) {
            HashMap<String, String> tmp = new HashMap<String, String>(parentPomProps.size() + pomProps.size());
            tmp.putAll(parentPomProps);
            tmp.putAll(pomProps);
            pomProps = tmp;
        }
        this.effectivePomProps.put(pomCoords, pomProps);
        this.addImportedBomsToBuild(artDep, model, pomProps);
        return pomProps;
    }

    private void addImportedBomsToBuild(ArtifactDependency pomArtDep, Model model, Map<String, String> effectiveProps) {
        DependencyManagement dm = model.getDependencyManagement();
        if (dm == null) {
            return;
        }
        for (org.apache.maven.model.Dependency d : dm.getDependencies()) {
            io.quarkus.maven.dependency.ArtifactCoords bomCoords;
            if (!"import".equals(d.getScope()) || !"pom".equals(d.getType())) continue;
            String groupId = this.resolveProperty(d.getGroupId(), d, effectiveProps);
            String version = this.resolveProperty(d.getVersion(), d, effectiveProps);
            if (groupId == null || version == null || this.isExcluded(bomCoords = io.quarkus.maven.dependency.ArtifactCoords.pom((String)groupId, (String)d.getArtifactId(), (String)version))) continue;
            if (pomArtDep != null) {
                ArtifactDependency bomDep = this.getOrCreateArtifactDep(bomCoords);
                pomArtDep.addBomImport(bomDep);
            }
            this.addImportedBomsAndParentPomToBuild(bomCoords);
            this.addArtifactToBuild(bomCoords);
        }
    }

    private String resolveProperty(String expr, org.apache.maven.model.Dependency dep, Map<String, String> props) {
        if (expr.startsWith("${") && expr.endsWith("}")) {
            String name = expr.substring(2, expr.length() - 1);
            String value = props.get(name);
            if (value == null) {
                this.getLog().warn((CharSequence)("Failed to resolve " + value + " from " + dep));
                return null;
            }
            return value;
        }
        return expr;
    }

    private void addToSkipped(io.quarkus.maven.dependency.ArtifactCoords coords) {
        if (!this.allDepsToBuild.contains(coords)) {
            this.skippedDeps.add(coords);
        }
    }

    private void addToRemaining(io.quarkus.maven.dependency.ArtifactCoords coords) {
        if (!this.allDepsToBuild.contains(coords)) {
            this.remainingDeps.add(coords);
        }
    }

    private boolean isExcluded(io.quarkus.maven.dependency.ArtifactCoords coords) {
        return this.dependenciesToBuild != null && (this.dependenciesToBuild.getExcludeGroupIds().contains(coords.getGroupId()) || this.dependenciesToBuild.getExcludeKeys().contains(coords.getKey()) || this.dependenciesToBuild.getExcludeArtifacts().contains(coords));
    }

    private boolean isIncluded(io.quarkus.maven.dependency.ArtifactCoords coords) {
        return this.dependenciesToBuild != null && (this.dependenciesToBuild.getIncludeGroupIds().contains(coords.getGroupId()) || this.dependenciesToBuild.getIncludeKeys().contains(coords.getKey()) || this.dependenciesToBuild.getIncludeArtifacts().contains(coords));
    }

    private static io.quarkus.maven.dependency.ArtifactCoords toCoords(Artifact a) {
        return io.quarkus.maven.dependency.ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private ArtifactDependency getOrCreateArtifactDep(io.quarkus.maven.dependency.ArtifactCoords c) {
        return this.artifactDeps.computeIfAbsent(c, k -> new ArtifactDependency(c));
    }

    private ReleaseRepo getOrCreateRepo(ReleaseId id) {
        return this.releaseRepos.computeIfAbsent(id, k -> new ReleaseRepo(id));
    }

    private ReleaseRepo getRepo(ReleaseId id) {
        return Objects.requireNonNull(this.releaseRepos.get(id));
    }

    private static Collection<io.quarkus.maven.dependency.ArtifactCoords> getOtherMemberDescriptorCoords(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata();
        if (map == null) {
            return List.of();
        }
        Object o = map.get("platform-release");
        if (o == null || !(o instanceof Map)) {
            return List.of();
        }
        if ((o = ((Map)o).get("members")) == null || !(o instanceof List)) {
            return List.of();
        }
        List list = (List)o;
        ArrayList<io.quarkus.maven.dependency.ArtifactCoords> result = new ArrayList<io.quarkus.maven.dependency.ArtifactCoords>(list.size());
        list.forEach(i -> {
            if (!i.equals(catalog.getId())) {
                result.add(io.quarkus.maven.dependency.ArtifactCoords.fromString((String)i.toString()));
            }
        });
        return result;
    }

    private static Map<String, String> toMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(DependenciesToBuildMojo.toString(e.getKey()), DependenciesToBuildMojo.toString(e.getValue()));
        }
        return map;
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static class ReleaseRepo {
        final ReleaseId id;
        final List<io.quarkus.maven.dependency.ArtifactCoords> artifacts = new ArrayList<io.quarkus.maven.dependency.ArtifactCoords>();
        final Map<ReleaseId, ReleaseRepo> parents = new HashMap<ReleaseId, ReleaseRepo>();
        final Map<ReleaseId, ReleaseRepo> dependencies = new LinkedHashMap<ReleaseId, ReleaseRepo>();

        ReleaseRepo(ReleaseId release) {
            this.id = release;
        }

        ReleaseId id() {
            return this.id;
        }

        void addRepoDependency(ReleaseRepo repo) {
            if (repo != this) {
                this.dependencies.putIfAbsent(repo.id(), repo);
                repo.parents.putIfAbsent(this.id(), this);
            }
        }

        boolean isRoot() {
            return this.parents.isEmpty();
        }
    }

    private class ArtifactDependency {
        final io.quarkus.maven.dependency.ArtifactCoords coords;
        final Map<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency> children = new LinkedHashMap<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency>();
        final Map<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency> bomImports = new LinkedHashMap<io.quarkus.maven.dependency.ArtifactCoords, ArtifactDependency>();
        ArtifactDependency parentPom;

        ArtifactDependency(io.quarkus.maven.dependency.ArtifactCoords coords) {
            this.coords = coords;
        }

        public void addBomImport(ArtifactDependency bomDep) {
            this.bomImports.put(bomDep.coords, bomDep);
        }

        public void setParentPom(ArtifactDependency parentPom) {
            this.parentPom = parentPom;
        }

        void addDependency(ArtifactDependency d) {
            this.children.putIfAbsent(d.coords, d);
        }

        Iterable<ArtifactDependency> getAllDependencies() {
            ArrayList<ArtifactDependency> list = new ArrayList<ArtifactDependency>(this.children.size() + this.bomImports.size() + 1);
            if (this.parentPom != null) {
                list.add(this.parentPom);
            }
            list.addAll(this.bomImports.values());
            list.addAll(this.children.values());
            return list;
        }

        private void logBomImportsAndParents() {
            this.logBomImportsAndParents(1);
        }

        private void logBomImportsAndParents(int depth) {
            if (this.parentPom == null && this.bomImports.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            String offset = sb.toString();
            if (this.parentPom != null) {
                sb.setLength(0);
                sb.append(offset).append(this.parentPom.coords.toCompactCoords()).append(" [parent pom]");
                DependenciesToBuildMojo.this.logComment(sb.toString());
                this.parentPom.logBomImportsAndParents(depth + 1);
            }
            for (ArtifactDependency d : this.bomImports.values()) {
                sb.setLength(0);
                sb.append(offset).append(d.coords.toCompactCoords()).append(" [bom import]");
                DependenciesToBuildMojo.this.logComment(sb.toString());
                d.logBomImportsAndParents(depth + 1);
            }
        }
    }
}

