/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.bom.decomposer.ReleaseIdResolver;
import io.quarkus.bom.decomposer.detector.PrefixedTagReleaseIdDetector;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.util.GlobUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public class DependenciesToBuildReportGenerator {
    private static final String NOT_MANAGED = " [not managed]";
    private MavenArtifactResolver resolver;
    private ArtifactCoords targetBomCoords;
    private MessageWriter log;
    private Collection<ArtifactCoords> topLevelArtifactsToBuild = List.of();
    private int level = -1;
    private boolean includeNonManaged;
    private boolean logArtifactsToBuild = true;
    private boolean logModulesToBuild;
    private boolean logTrees;
    private boolean logRemaining;
    private boolean logSummary = true;
    private boolean logNonManagedVisited;
    private File outputFile;
    private PrintStream fileOutput;
    private boolean appendOutput;
    private boolean logCodeRepos;
    private boolean logCodeRepoGraph;
    private boolean excludeParentPoms;
    private boolean excludeBomImports;
    private boolean validateCodeRepoTags;
    private Set<String> excludeGroupIds = Set.of();
    private Set<ArtifactKey> excludeKeys = Set.of();
    private Set<ArtifactCoords> excludeArtifacts = Set.of();
    private Set<String> includeGroupIds = Set.of();
    private Set<ArtifactKey> includeKeys = Set.of();
    private Set<ArtifactCoords> includeArtifacts = Set.of();
    private Function<ArtifactCoords, List<Dependency>> artifactConstraintsProvider;
    private Set<ArtifactCoords> targetBomConstraints;
    private List<Dependency> targetBomManagedDeps;
    private final Set<ArtifactCoords> allDepsToBuild = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> nonManagedVisited = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> skippedDeps = new HashSet<ArtifactCoords>();
    private final Set<ArtifactCoords> remainingDeps = new HashSet<ArtifactCoords>();
    private final Map<ArtifactCoords, ArtifactDependency> artifactDeps = new HashMap<ArtifactCoords, ArtifactDependency>();
    private final Map<ReleaseId, ReleaseRepo> releaseRepos = new HashMap<ReleaseId, ReleaseRepo>();
    private final Map<ArtifactCoords, Map<String, String>> effectivePomProps = new HashMap<ArtifactCoords, Map<String, String>>();
    private final Map<Set<ReleaseId>, List<ReleaseId>> circularRepoDeps = new HashMap<Set<ReleaseId>, List<ReleaseId>>();
    private static final String RH_VERSION_SUFFIX = "?redhat-*";
    private static final Pattern RH_VERSION_SUFFIX_PATTERN = Pattern.compile(GlobUtil.toRegexPattern((String)"?redhat-*"));
    private static final String RH_VERSION_EXPR = "*redhat-*";
    private static final Pattern RH_VERSION_PATTERN = Pattern.compile(GlobUtil.toRegexPattern((String)"*redhat-*"));

    public static Builder builder() {
        return new DependenciesToBuildReportGenerator().new Builder();
    }

    private DependenciesToBuildReportGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        if (this.logCodeRepoGraph) {
            this.logCodeRepos = true;
        }
        this.targetBomManagedDeps = this.getBomConstraints(this.targetBomCoords);
        this.targetBomConstraints = new HashSet<ArtifactCoords>(this.targetBomManagedDeps.size());
        for (Dependency d : this.targetBomManagedDeps) {
            this.targetBomConstraints.add(DependenciesToBuildReportGenerator.toCoords(d.getArtifact()));
        }
        if (this.artifactConstraintsProvider == null) {
            this.artifactConstraintsProvider = t -> this.targetBomManagedDeps;
        }
        for (ArtifactCoords coords : this.getTopLevelArtifactsToBuild()) {
            if (this.isExcluded(coords)) continue;
            this.processTopLevelArtifact(this.artifactConstraintsProvider.apply(coords), coords);
        }
        if (!this.includeArtifacts.isEmpty()) {
            for (ArtifactCoords coords : this.includeArtifacts) {
                this.processTopLevelArtifact(this.artifactConstraintsProvider.apply(coords), coords);
            }
        }
        try {
            ArrayList<ReleaseRepo> sorted;
            int codeReposTotal = 0;
            if (this.logArtifactsToBuild && !this.allDepsToBuild.isEmpty()) {
                this.logComment("Artifacts to be built from source from " + this.targetBomCoords.toCompactCoords() + ":");
                if (this.logCodeRepos) {
                    this.initReleaseRepos();
                    this.detectCircularRepoDeps();
                    codeReposTotal = this.releaseRepos.size();
                    sorted = new ArrayList<ReleaseRepo>(codeReposTotal);
                    for (ReleaseRepo r : this.releaseRepos.values()) {
                        if (!r.isRoot()) continue;
                        this.sort(r, new HashSet<ReleaseId>(codeReposTotal), sorted);
                    }
                    for (ReleaseRepo e : sorted) {
                        this.logComment("repo-url " + e.id().origin());
                        this.logComment("tag " + e.id().version().asString());
                        for (String s : DependenciesToBuildReportGenerator.toSortedStrings(e.artifacts, this.logModulesToBuild)) {
                            this.log(s);
                        }
                    }
                    if (!this.circularRepoDeps.isEmpty()) {
                        this.logComment("ERROR: The following circular dependency chains were detected among releases:");
                        Iterator<Object> chains = this.circularRepoDeps.values().iterator();
                        int i = 0;
                        while (chains.hasNext()) {
                            this.logComment("  Chain #" + ++i + ":");
                            ((List)chains.next()).forEach(id -> this.logComment("    " + id));
                            this.logComment("");
                        }
                    }
                    if (this.logCodeRepoGraph) {
                        this.logComment("");
                        this.logComment("Code repository dependency graph");
                        for (ReleaseRepo r : this.releaseRepos.values()) {
                            if (!r.isRoot()) continue;
                            this.logReleaseRepoDep(r, 0);
                        }
                        this.logComment("");
                    }
                } else {
                    for (String s : DependenciesToBuildReportGenerator.toSortedStrings(this.allDepsToBuild, this.logModulesToBuild)) {
                        this.log(s);
                    }
                }
            }
            if (this.logNonManagedVisited && !this.nonManagedVisited.isEmpty()) {
                this.logComment("Non-managed dependencies visited walking dependency trees:");
                sorted = DependenciesToBuildReportGenerator.toSortedStrings(this.nonManagedVisited, this.logModulesToBuild);
                for (int i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + (String)sorted.get(i));
                }
            }
            if (this.logRemaining) {
                this.logComment("Remaining artifacts include:");
                sorted = DependenciesToBuildReportGenerator.toSortedStrings(this.remainingDeps, this.logModulesToBuild);
                for (int i = 0; i < sorted.size(); ++i) {
                    this.logComment(i + 1 + ") " + (String)sorted.get(i));
                }
            }
            if (this.logSummary) {
                StringBuilder sb = new StringBuilder().append("Selecting ");
                if (this.level < 0) {
                    sb.append("all the");
                } else {
                    sb.append(this.level).append(" level(s) of");
                }
                if (this.includeNonManaged) {
                    sb.append(" managed and non-managed");
                } else {
                    sb.append(" managed (stopping at the first non-managed one)");
                }
                sb.append(" dependencies of supported extensions from ").append(this.targetBomCoords.toCompactCoords()).append(" will result in:");
                this.logComment(sb.toString());
                sb.setLength(0);
                sb.append(this.allDepsToBuild.size()).append(" artifacts");
                if (codeReposTotal > 0) {
                    sb.append(" from ").append(codeReposTotal).append(" code repositories");
                }
                sb.append(" to build from source");
                this.logComment(sb.toString());
                if (this.includeNonManaged && !this.nonManagedVisited.isEmpty()) {
                    this.logComment("  * " + this.nonManagedVisited.size() + " of which is/are not managed by the BOM");
                }
                if (!this.skippedDeps.isEmpty()) {
                    this.logComment(this.skippedDeps.size() + " dependency nodes skipped");
                }
                this.logComment(this.allDepsToBuild.size() + this.skippedDeps.size() + " dependencies visited in total");
            }
        }
        finally {
            if (this.fileOutput != null) {
                this.fileOutput.close();
            }
        }
    }

    protected Iterable<ArtifactCoords> getTopLevelArtifactsToBuild() {
        if (this.topLevelArtifactsToBuild == null || this.topLevelArtifactsToBuild.isEmpty()) {
            ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>();
            for (ArtifactCoords d : this.targetBomConstraints) {
                if (!this.targetBomCoords.getGroupId().equals(d.getGroupId()) || !d.isJar() || this.isExcluded(d)) continue;
                result.add(d);
                this.log.debug(d.toCompactCoords() + " selected as a top level artifact to build");
            }
            return result;
        }
        return this.topLevelArtifactsToBuild;
    }

    private void processTopLevelArtifact(List<Dependency> managedDeps, ArtifactCoords topLevelArtifact) {
        boolean addDependency;
        DependencyNode root;
        try {
            DefaultArtifact a = DependenciesToBuildReportGenerator.toAetherArtifact(topLevelArtifact);
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), new CollectRequest().setManagedDependencies(managedDeps).setRepositories(this.resolver.getRepositories()).setRoot(new Dependency((Artifact)a, "runtime"))).getRoot();
            if (root.getChildren().isEmpty()) {
                this.resolver.resolve((Artifact)a);
            }
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed to collect dependencies of " + topLevelArtifact.toCompactCoords(), e1);
        }
        if (this.logTrees) {
            if (this.targetBomConstraints.contains(topLevelArtifact)) {
                this.logComment(topLevelArtifact.toCompactCoords());
            } else {
                this.logComment(topLevelArtifact.toCompactCoords() + NOT_MANAGED);
            }
        }
        try {
            addDependency = this.addDependencyToBuild(topLevelArtifact);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process " + topLevelArtifact, e);
        }
        if (addDependency) {
            ArtifactDependency extDep = this.getOrCreateArtifactDep(topLevelArtifact);
            if (!this.excludeParentPoms && this.logTrees) {
                extDep.logBomImportsAndParents();
            }
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(extDep, d, 1, false);
            }
        } else if (this.logRemaining) {
            for (DependencyNode d : root.getChildren()) {
                this.processNodes(null, d, 1, true);
            }
        }
        if (this.logTrees) {
            this.logComment("");
        }
    }

    private static DefaultArtifact toAetherArtifact(ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private static String ensureNoRhSuffix(String version) {
        return RH_VERSION_SUFFIX_PATTERN.matcher(version).replaceFirst("");
    }

    private void initReleaseRepos() {
        ReleaseIdResolver idResolver = DependenciesToBuildReportGenerator.newReleaseIdResolver(this.resolver, this.log, this.validateCodeRepoTags, this.getRhCoordsUpstreamVersions());
        HashMap<ArtifactCoords, ReleaseId> artifactReleases = new HashMap<ArtifactCoords, ReleaseId>();
        for (ArtifactCoords c : this.allDepsToBuild) {
            ReleaseId releaseId;
            try {
                releaseId = idResolver.releaseId((Artifact)DependenciesToBuildReportGenerator.toAetherArtifact(c));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve release id for " + c, e);
            }
            this.getOrCreateRepo((ReleaseId)releaseId).artifacts.add(c);
            artifactReleases.put(c, releaseId);
        }
        Iterator<Map.Entry<ReleaseId, ReleaseRepo>> i = this.releaseRepos.entrySet().iterator();
        while (i.hasNext()) {
            if (!i.next().getValue().artifacts.isEmpty()) continue;
            i.remove();
        }
        for (ArtifactDependency d : this.artifactDeps.values()) {
            ReleaseRepo repo = this.getRepo((ReleaseId)artifactReleases.get(d.coords));
            for (ArtifactDependency c : d.getAllDependencies()) {
                repo.addRepoDependency(this.getRepo((ReleaseId)artifactReleases.get(c.coords)));
            }
        }
    }

    private Map<ArtifactCoords, String> getRhCoordsUpstreamVersions() {
        HashMap<String, List> upstreamVersions = new HashMap<String, List>();
        ArrayList<ArtifactCoords> rhCoords = new ArrayList<ArtifactCoords>();
        for (ArtifactCoords c : this.allDepsToBuild) {
            if (RH_VERSION_PATTERN.matcher(c.getVersion()).matches()) {
                rhCoords.add(c);
                continue;
            }
            upstreamVersions.computeIfAbsent(c.getGroupId(), k -> new ArrayList()).add(new DefaultArtifactVersion(c.getVersion()));
        }
        if (rhCoords.isEmpty()) {
            return Map.of();
        }
        HashMap<ArtifactCoords, String> rhCoordsUpstreamVersions = new HashMap<ArtifactCoords, String>(rhCoords.size());
        block1: for (ArtifactCoords c : rhCoords) {
            List originalVersions = (List)upstreamVersions.get(c.getGroupId());
            if (originalVersions == null) continue;
            DefaultArtifactVersion noRhSuffixVersion = new DefaultArtifactVersion(DependenciesToBuildReportGenerator.ensureNoRhSuffix(c.getVersion()));
            for (ArtifactVersion v : originalVersions) {
                if (!v.equals(noRhSuffixVersion)) continue;
                rhCoordsUpstreamVersions.put(c, v.toString());
                continue block1;
            }
        }
        return rhCoordsUpstreamVersions;
    }

    private static ReleaseIdResolver newReleaseIdResolver(MavenArtifactResolver artifactResolver, MessageWriter log, boolean validateCodeRepoTags, Map<ArtifactCoords, String> versionMapping) {
        ArrayList<Object> releaseDetectors = new ArrayList<Object>();
        releaseDetectors.add(new PrefixedTagReleaseIdDetector("jetty-", List.of("org.eclipse.jetty")));
        releaseDetectors.add(new ReleaseIdDetector(){

            public ReleaseId detectReleaseId(ReleaseIdResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
                int i;
                if (!"io.vertx".equals(artifact.getGroupId())) {
                    return null;
                }
                String s = artifact.getArtifactId();
                if (!s.startsWith("vertx-")) {
                    return releaseResolver.defaultReleaseId(artifact);
                }
                if (s.equals("vertx-uri-template") || s.equals("vertx-codegen")) {
                    return ReleaseIdFactory.forScmAndTag((String)("https://github.com/eclipse-vertx/" + s), (String)artifact.getVersion());
                }
                if (s.equals("vertx-core")) {
                    return ReleaseIdFactory.forScmAndTag((String)"https://github.com/eclipse-vertx/vert.x", (String)artifact.getVersion());
                }
                if (s.startsWith("vertx-") && s.endsWith("-client") || s.startsWith("vertx-sql-")) {
                    return ReleaseIdFactory.forScmAndTag((String)"https://github.com/eclipse-vertx/vertx-sql-client", (String)artifact.getVersion());
                }
                if (s.startsWith("vertx-ext")) {
                    s = "vertx-ext-parent";
                } else if (!s.equals("vertx-bridge-common") && (i = s.indexOf(45, "vertx-".length())) > 0) {
                    s = s.substring(0, i);
                }
                return ReleaseIdFactory.forScmAndTag((String)("https://github.com/vert-x3/" + s), (String)artifact.getVersion());
            }
        });
        releaseDetectors.addAll(ServiceLoader.load(ReleaseIdDetector.class).stream().map(p -> (ReleaseIdDetector)p.get()).collect(Collectors.toList()));
        return new ReleaseIdResolver(artifactResolver, releaseDetectors, log, validateCodeRepoTags, versionMapping);
    }

    public static void main(String[] args) throws Exception {
        String versionExpr = RH_VERSION_SUFFIX;
        Pattern pattern = Pattern.compile(GlobUtil.toRegexPattern((String)versionExpr));
        String version = "2.13.0.CR1-redhat-00001";
        Matcher matcher = pattern.matcher(version);
        System.out.println("matches: " + matcher.matches());
        System.out.println(matcher.replaceAll(""));
    }

    private void sort(ReleaseRepo repo, Set<ReleaseId> processed, List<ReleaseRepo> sorted) {
        if (!processed.add(repo.id)) {
            return;
        }
        for (ReleaseRepo d : repo.dependencies.values()) {
            this.sort(d, processed, sorted);
        }
        sorted.add(repo);
    }

    private void logReleaseRepoDep(ReleaseRepo repo, int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(repo.id().origin()).append(' ').append(repo.id().version());
        this.logComment(sb.toString());
        for (ReleaseRepo child : repo.dependencies.values()) {
            this.logReleaseRepoDep(child, depth + 1);
        }
    }

    private static List<String> toSortedStrings(Collection<ArtifactCoords> coords, boolean asModules) {
        ArrayList<String> list;
        if (asModules) {
            HashSet<CallSite> set = new HashSet<CallSite>();
            for (ArtifactCoords c : coords) {
                set.add((CallSite)((Object)(c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion())));
            }
            list = new ArrayList(set);
        } else {
            list = new ArrayList<String>(coords.size());
            for (ArtifactCoords c : coords) {
                list.add(c.toGACTVString());
            }
        }
        Collections.sort(list);
        return list;
    }

    private PrintStream getOutput() {
        if (this.outputFile == null) {
            return System.out;
        }
        if (this.fileOutput == null) {
            this.outputFile.getParentFile().mkdirs();
            try {
                this.fileOutput = new PrintStream(new FileOutputStream(this.outputFile, this.appendOutput), false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Failed to open " + this.outputFile + " for writing", e);
            }
        }
        return this.fileOutput;
    }

    private void logComment(String msg) {
        this.log("# " + msg);
    }

    private void log(String msg) {
        this.getOutput().println(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNodes(ArtifactDependency parent, DependencyNode node, int level, boolean remaining) {
        ArtifactCoords coords = DependenciesToBuildReportGenerator.toCoords(node.getArtifact());
        if (this.isExcluded(coords)) {
            return;
        }
        ArtifactDependency artDep = null;
        if (remaining) {
            this.addToRemaining(coords);
        } else if (this.level < 0 || level <= this.level) {
            if (this.addDependencyToBuild(coords)) {
                if (this.logTrees) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < level; ++i) {
                        buf.append("  ");
                    }
                    buf.append(coords.toCompactCoords());
                    if (!this.targetBomConstraints.contains(coords)) {
                        buf.append(' ').append(NOT_MANAGED);
                    }
                    this.logComment(buf.toString());
                }
                if (parent != null) {
                    artDep = this.getOrCreateArtifactDep(coords);
                    parent.addDependency(artDep);
                    if (this.logTrees) {
                        artDep.logBomImportsAndParents(level + 1);
                    }
                }
            } else {
                if (!this.logRemaining) return;
                remaining = true;
            }
        } else {
            this.addToSkipped(coords);
            if (!this.logRemaining) return;
            remaining = true;
            this.addToRemaining(coords);
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNodes(artDep, child, level + 1, remaining);
        }
    }

    private boolean addDependencyToBuild(ArtifactCoords coords) {
        if (!this.addArtifactToBuild(coords)) {
            return false;
        }
        if (!this.excludeParentPoms) {
            this.addImportedBomsAndParentPomToBuild(coords);
        }
        return true;
    }

    private boolean addArtifactToBuild(ArtifactCoords coords) {
        boolean managed = this.targetBomConstraints.contains(coords);
        if (!managed) {
            this.nonManagedVisited.add(coords);
        }
        if (managed || this.includeNonManaged || this.isIncluded(coords) || !this.excludeParentPoms && coords.getType().equals("pom")) {
            this.allDepsToBuild.add(coords);
            this.skippedDeps.remove(coords);
            this.remainingDeps.remove(coords);
            return true;
        }
        this.addToSkipped(coords);
        if (this.logRemaining) {
            this.addToRemaining(coords);
        }
        return false;
    }

    private Map<String, String> addImportedBomsAndParentPomToBuild(ArtifactCoords coords) {
        Model model;
        Path pomXml;
        ArtifactCoords pomCoords;
        ArtifactCoords artifactCoords = pomCoords = coords.getType().equals("pom") ? coords : ArtifactCoords.pom((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getVersion());
        if (this.allDepsToBuild.contains(pomCoords)) {
            return this.effectivePomProps.getOrDefault(pomCoords, Map.of());
        }
        try {
            pomXml = this.resolver.resolve((Artifact)DependenciesToBuildReportGenerator.toAetherArtifact(pomCoords)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to resolve " + pomCoords, e);
        }
        try {
            model = ModelUtils.readModel((Path)pomXml);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + pomXml, e);
        }
        ArtifactDependency artDep = this.getOrCreateArtifactDep(coords);
        Map<String, String> parentPomProps = null;
        Parent parent = model.getParent();
        if (parent != null) {
            ArtifactCoords parentPomCoords;
            String parentVersion = parent.getVersion();
            if (ModelUtils.isUnresolvedVersion((String)parentVersion)) {
                if (model.getVersion() == null || model.getVersion().equals(parentVersion)) {
                    parentVersion = pomCoords.getVersion();
                } else {
                    this.log.warn("Failed to resolve the version of" + parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion() + " as a parent of " + pomCoords);
                    parentVersion = null;
                }
            }
            if (parentVersion != null && !this.isExcluded(parentPomCoords = ArtifactCoords.pom((String)parent.getGroupId(), (String)parent.getArtifactId(), (String)parentVersion))) {
                artDep.setParentPom(this.getOrCreateArtifactDep(parentPomCoords));
                parentPomProps = this.addImportedBomsAndParentPomToBuild(parentPomCoords);
                this.addArtifactToBuild(parentPomCoords);
            }
        }
        if (this.excludeBomImports) {
            return Map.of();
        }
        Map<String, String> pomProps = DependenciesToBuildReportGenerator.toMap(model.getProperties());
        pomProps.put("project.version", pomCoords.getVersion());
        pomProps.put("project.groupId", pomCoords.getGroupId());
        if (parentPomProps != null) {
            HashMap<String, String> tmp = new HashMap<String, String>(parentPomProps.size() + pomProps.size());
            tmp.putAll(parentPomProps);
            tmp.putAll(pomProps);
            pomProps = tmp;
        }
        this.effectivePomProps.put(pomCoords, pomProps);
        this.addImportedBomsToBuild(artDep, model, pomProps);
        return pomProps;
    }

    private void addImportedBomsToBuild(ArtifactDependency pomArtDep, Model model, Map<String, String> effectiveProps) {
        DependencyManagement dm = model.getDependencyManagement();
        if (dm == null) {
            return;
        }
        for (org.apache.maven.model.Dependency d : dm.getDependencies()) {
            ArtifactCoords bomCoords;
            if (!"import".equals(d.getScope()) || !"pom".equals(d.getType())) continue;
            String groupId = this.resolveProperty(d.getGroupId(), d, effectiveProps);
            String version = this.resolveProperty(d.getVersion(), d, effectiveProps);
            if (groupId == null || version == null || this.isExcluded(bomCoords = ArtifactCoords.pom((String)groupId, (String)d.getArtifactId(), (String)version))) continue;
            if (pomArtDep != null) {
                ArtifactDependency bomDep = this.getOrCreateArtifactDep(bomCoords);
                pomArtDep.addBomImport(bomDep);
            }
            this.addImportedBomsAndParentPomToBuild(bomCoords);
            this.addArtifactToBuild(bomCoords);
        }
    }

    private String resolveProperty(String expr, org.apache.maven.model.Dependency dep, Map<String, String> props) {
        if (expr.startsWith("${") && expr.endsWith("}")) {
            String name = expr.substring(2, expr.length() - 1);
            String value = props.get(name);
            if (value == null) {
                this.log.warn("Failed to resolve " + value + " from " + dep);
                return null;
            }
            return this.resolveProperty(value, dep, props);
        }
        return expr;
    }

    private void addToSkipped(ArtifactCoords coords) {
        if (!this.allDepsToBuild.contains(coords)) {
            this.skippedDeps.add(coords);
        }
    }

    private void addToRemaining(ArtifactCoords coords) {
        if (!this.allDepsToBuild.contains(coords)) {
            this.remainingDeps.add(coords);
        }
    }

    private boolean isExcluded(ArtifactCoords coords) {
        return this.excludeGroupIds.contains(coords.getGroupId()) || this.excludeKeys.contains(coords.getKey()) || this.excludeArtifacts.contains(coords);
    }

    private boolean isIncluded(ArtifactCoords coords) {
        return this.includeGroupIds.contains(coords.getGroupId()) || this.includeKeys.contains(coords.getKey()) || this.includeArtifacts.contains(coords);
    }

    private List<Dependency> getBomConstraints(ArtifactCoords bomCoords) {
        List managedDeps;
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = this.resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to resolve the descriptor of " + bomCoords, e);
        }
        if (managedDeps.isEmpty()) {
            throw new RuntimeException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        return managedDeps;
    }

    private ArtifactDependency getOrCreateArtifactDep(ArtifactCoords c) {
        return this.artifactDeps.computeIfAbsent(c, k -> new ArtifactDependency(c));
    }

    private ReleaseRepo getOrCreateRepo(ReleaseId id) {
        return this.releaseRepos.computeIfAbsent(id, k -> new ReleaseRepo(id));
    }

    private ReleaseRepo getRepo(ReleaseId id) {
        return Objects.requireNonNull(this.releaseRepos.get(id));
    }

    private void detectCircularRepoDeps() {
        for (ReleaseRepo r : this.releaseRepos.values()) {
            ArrayList<ReleaseId> chain = new ArrayList<ReleaseId>();
            this.detectCircularRepoDeps(r, chain);
        }
    }

    private void detectCircularRepoDeps(ReleaseRepo r, List<ReleaseId> chain) {
        if (chain.contains(r.id)) {
            this.circularRepoDeps.computeIfAbsent(new HashSet<ReleaseId>(chain), k -> new ArrayList(chain));
            return;
        }
        chain.add(r.id);
        for (ReleaseRepo d : r.dependencies.values()) {
            this.detectCircularRepoDeps(d, chain);
        }
        chain.remove(chain.size() - 1);
    }

    private static Map<String, String> toMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(DependenciesToBuildReportGenerator.toString(e.getKey()), DependenciesToBuildReportGenerator.toString(e.getValue()));
        }
        return map;
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private static class ReleaseRepo {
        final ReleaseId id;
        final List<ArtifactCoords> artifacts = new ArrayList<ArtifactCoords>();
        final Map<ReleaseId, ReleaseRepo> dependants = new HashMap<ReleaseId, ReleaseRepo>();
        final Map<ReleaseId, ReleaseRepo> dependencies = new LinkedHashMap<ReleaseId, ReleaseRepo>();

        ReleaseRepo(ReleaseId release) {
            this.id = release;
        }

        ReleaseId id() {
            return this.id;
        }

        void addRepoDependency(ReleaseRepo repo) {
            if (repo != this) {
                this.dependencies.putIfAbsent(repo.id(), repo);
                repo.dependants.putIfAbsent(this.id(), this);
            }
        }

        boolean isRoot() {
            return this.dependants.isEmpty();
        }
    }

    private class ArtifactDependency {
        final ArtifactCoords coords;
        final Map<ArtifactCoords, ArtifactDependency> children = new LinkedHashMap<ArtifactCoords, ArtifactDependency>();
        final Map<ArtifactCoords, ArtifactDependency> bomImports = new LinkedHashMap<ArtifactCoords, ArtifactDependency>();
        ArtifactDependency parentPom;

        ArtifactDependency(ArtifactCoords coords) {
            this.coords = coords;
        }

        public void addBomImport(ArtifactDependency bomDep) {
            this.bomImports.put(bomDep.coords, bomDep);
        }

        public void setParentPom(ArtifactDependency parentPom) {
            this.parentPom = parentPom;
        }

        void addDependency(ArtifactDependency d) {
            this.children.putIfAbsent(d.coords, d);
        }

        Iterable<ArtifactDependency> getAllDependencies() {
            ArrayList<ArtifactDependency> list = new ArrayList<ArtifactDependency>(this.children.size() + this.bomImports.size() + 1);
            if (this.parentPom != null) {
                list.add(this.parentPom);
            }
            list.addAll(this.bomImports.values());
            list.addAll(this.children.values());
            return list;
        }

        private void logBomImportsAndParents() {
            this.logBomImportsAndParents(1);
        }

        private void logBomImportsAndParents(int depth) {
            if (this.parentPom == null && this.bomImports.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            String offset = sb.toString();
            if (this.parentPom != null) {
                sb.setLength(0);
                sb.append(offset).append(this.parentPom.coords.toCompactCoords()).append(" [parent pom]");
                DependenciesToBuildReportGenerator.this.logComment(sb.toString());
                this.parentPom.logBomImportsAndParents(depth + 1);
            }
            for (ArtifactDependency d : this.bomImports.values()) {
                sb.setLength(0);
                sb.append(offset).append(d.coords.toCompactCoords()).append(" [bom import]");
                DependenciesToBuildReportGenerator.this.logComment(sb.toString());
                d.logBomImportsAndParents(depth + 1);
            }
        }
    }

    public class Builder {
        private Builder() {
        }

        public Builder setResolver(MavenArtifactResolver artifactResolver) {
            DependenciesToBuildReportGenerator.this.resolver = artifactResolver;
            return this;
        }

        public Builder setBom(ArtifactCoords bom) {
            DependenciesToBuildReportGenerator.this.targetBomCoords = bom;
            return this;
        }

        public Builder setTopLevelArtifactsToBuild(Collection<ArtifactCoords> topArtifactsToBuild) {
            DependenciesToBuildReportGenerator.this.topLevelArtifactsToBuild = topArtifactsToBuild;
            return this;
        }

        public Builder setLevel(int level) {
            DependenciesToBuildReportGenerator.this.level = level;
            return this;
        }

        public Builder setIncludeNonManaged(boolean includeNonManaged) {
            DependenciesToBuildReportGenerator.this.includeNonManaged = includeNonManaged;
            return this;
        }

        public Builder setLogArtifactsToBuild(boolean logArtifactsToBuild) {
            DependenciesToBuildReportGenerator.this.logArtifactsToBuild = logArtifactsToBuild;
            return this;
        }

        public Builder setLogModulesToBuild(boolean logModulesToBuild) {
            DependenciesToBuildReportGenerator.this.logModulesToBuild = logModulesToBuild;
            return this;
        }

        public Builder setLogTrees(boolean logTrees) {
            DependenciesToBuildReportGenerator.this.logTrees = logTrees;
            return this;
        }

        public Builder setLogRemaining(boolean logRemaining) {
            DependenciesToBuildReportGenerator.this.logRemaining = logRemaining;
            return this;
        }

        public Builder setLogSummary(boolean logSummary) {
            DependenciesToBuildReportGenerator.this.logSummary = logSummary;
            return this;
        }

        public Builder setLogNonManagedVisited(boolean logNonManagedVisited) {
            DependenciesToBuildReportGenerator.this.logNonManagedVisited = logNonManagedVisited;
            return this;
        }

        public Builder setOutputFile(File outputFile) {
            DependenciesToBuildReportGenerator.this.outputFile = outputFile;
            return this;
        }

        public Builder setAppendOutput(boolean appendOutput) {
            DependenciesToBuildReportGenerator.this.appendOutput = appendOutput;
            return this;
        }

        public Builder setLogCodeRepos(boolean logCodeRepos) {
            DependenciesToBuildReportGenerator.this.logCodeRepos = logCodeRepos;
            return this;
        }

        public Builder setLogCodeRepoGraph(boolean logCodeRepoGraph) {
            DependenciesToBuildReportGenerator.this.logCodeRepoGraph = logCodeRepoGraph;
            return this;
        }

        public Builder setExcludeParentPoms(boolean excludeParentPoms) {
            DependenciesToBuildReportGenerator.this.excludeParentPoms = excludeParentPoms;
            return this;
        }

        public Builder setExcludeBomImports(boolean excludeBomImports) {
            DependenciesToBuildReportGenerator.this.excludeBomImports = excludeBomImports;
            return this;
        }

        public Builder setArtifactConstraintsProvider(Function<ArtifactCoords, List<Dependency>> constraintsProvider) {
            DependenciesToBuildReportGenerator.this.artifactConstraintsProvider = constraintsProvider;
            return this;
        }

        public Builder setMessageWriter(MessageWriter msgWriter) {
            DependenciesToBuildReportGenerator.this.log = msgWriter;
            return this;
        }

        public Builder setExcludeGroupIds(Set<String> groupIds) {
            DependenciesToBuildReportGenerator.this.excludeGroupIds = groupIds;
            return this;
        }

        public Builder setExcludeKeys(Set<ArtifactKey> artifactKeys) {
            DependenciesToBuildReportGenerator.this.excludeKeys = artifactKeys;
            return this;
        }

        public Builder setExcludeArtifacts(Set<ArtifactCoords> artifacts) {
            DependenciesToBuildReportGenerator.this.excludeArtifacts = artifacts;
            return this;
        }

        public Builder setIncludeGroupIds(Set<String> groupIds) {
            DependenciesToBuildReportGenerator.this.includeGroupIds = groupIds;
            return this;
        }

        public Builder setIncludeKeys(Set<ArtifactKey> artifactKeys) {
            DependenciesToBuildReportGenerator.this.includeKeys = artifactKeys;
            return this;
        }

        public Builder setIncludeArtifacts(Set<ArtifactCoords> artifacts) {
            DependenciesToBuildReportGenerator.this.includeArtifacts = artifacts;
            return this;
        }

        public Builder setValidateCodeRepoTags(boolean validateTags) {
            DependenciesToBuildReportGenerator.this.validateCodeRepoTags = validateTags;
            return this;
        }

        public DependenciesToBuildReportGenerator build() {
            if (DependenciesToBuildReportGenerator.this.resolver == null) {
                try {
                    DependenciesToBuildReportGenerator.this.resolver = ((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).build();
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
                }
            }
            if (DependenciesToBuildReportGenerator.this.log == null) {
                DependenciesToBuildReportGenerator.this.log = MessageWriter.info();
            }
            return DependenciesToBuildReportGenerator.this;
        }

        protected DependenciesToBuildReportGenerator doBuild() {
            return DependenciesToBuildReportGenerator.this;
        }
    }
}

