/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomHtmlReportGenerator;
import io.quarkus.bom.decomposer.DecomposedBomVisitor;
import io.quarkus.bom.diff.BomDiff;
import io.quarkus.bom.diff.HtmlBomDiffReportGenerator;
import io.quarkus.bom.platform.PlatformBomComposer;
import io.quarkus.bom.platform.PlatformBomConfig;
import io.quarkus.bom.platform.PlatformBomUtils;
import io.quarkus.bom.platform.PlatformCatalogResolver;
import io.quarkus.bom.platform.ReportIndexPageGenerator;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="generate-platform-bom", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyCollection=ResolutionScope.NONE)
public class GeneratePlatformBomMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${skipPlatformBom}")
    protected boolean skip;
    @Parameter
    protected Set<String> enforcedDependencies = new HashSet<String>(0);
    @Parameter
    protected Set<String> excludedDependencies = new HashSet<String>(0);
    @Parameter
    protected Set<String> excludedGroups = new HashSet<String>(0);
    MavenArtifactResolver artifactResolver;
    PlatformCatalogResolver catalogs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to analyze managed dependencies of " + this.project.getArtifact(), e);
        }
    }

    private void doExecute() throws Exception {
        Path outputDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("boms");
        PlatformBomConfig.Builder configBuilder = PlatformBomConfig.builder().pomResolver(PomSource.of((Path)this.project.getFile().toPath()));
        if (this.enforcedDependencies != null) {
            for (String enforced : this.enforcedDependencies) {
                AppArtifactCoords coords = AppArtifact.fromString((String)enforced);
                configBuilder.enforce((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion()));
            }
        }
        if (this.excludedDependencies != null) {
            for (String excluded : this.excludedDependencies) {
                configBuilder.exclude(AppArtifactKey.fromString((String)excluded));
            }
        }
        if (this.excludedGroups != null) {
            for (String excluded : this.excludedGroups) {
                configBuilder.excludeGroupId(excluded);
            }
        }
        PlatformBomConfig config = configBuilder.artifactResolver(this.artifactResolver()).build();
        try (ReportIndexPageGenerator index = new ReportIndexPageGenerator(outputDir.resolve("index.html"));){
            PlatformBomComposer bomComposer = new PlatformBomComposer(config);
            DecomposedBom generatedBom = bomComposer.platformBom();
            File generatedPom = this.generateBomReports(bomComposer.originalPlatformBom(), generatedBom, this.project.getModel(), outputDir, index).toFile();
            if (!generatedPom.exists()) {
                throw new MojoExecutionException("Failed to locate the generated platform pom.xml at " + generatedPom);
            }
            this.project.setPomFile(generatedPom);
            for (DecomposedBom importedBom : bomComposer.upgradedImportedBoms()) {
                this.generateBomReports(bomComposer.originalImportedBom(importedBom.bomArtifact()), importedBom, null, outputDir, index);
            }
        }
    }

    private Path generateBomReports(DecomposedBom originalBom, DecomposedBom generatedBom, Model baseModel, Path outputDir, ReportIndexPageGenerator index) throws IOException, BomDecomposerException, MojoExecutionException {
        outputDir = outputDir.resolve(GeneratePlatformBomMojo.bomDirName(generatedBom.bomArtifact()));
        Path platformBomXml = outputDir.resolve("pom.xml");
        PlatformBomUtils.toPom((DecomposedBom)generatedBom, (Path)platformBomXml, (Model)baseModel, (PlatformCatalogResolver)this.catalogResolver());
        BomDiff.Config config = BomDiff.config();
        if (generatedBom.bomResolver().isResolved()) {
            config.compare(generatedBom.bomResolver().pomPath());
        } else {
            config.compare(generatedBom.bomArtifact());
        }
        BomDiff bomDiff = config.to(platformBomXml);
        Path diffFile = outputDir.resolve("diff.html");
        HtmlBomDiffReportGenerator.config((Path)diffFile).report(bomDiff);
        Path generatedReleasesFile = outputDir.resolve("generated-releases.html");
        generatedBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)generatedReleasesFile).skipOriginsWithSingleRelease().build());
        Path originalReleasesFile = outputDir.resolve("original-releases.html");
        originalBom.visit((DecomposedBomVisitor)DecomposedBomHtmlReportGenerator.builder((Path)originalReleasesFile).skipOriginsWithSingleRelease().build());
        index.bomReport(bomDiff.mainUrl(), bomDiff.toUrl(), generatedBom, originalReleasesFile, generatedReleasesFile, diffFile);
        return platformBomXml;
    }

    private static String bomDirName(Artifact a) {
        return a.getGroupId() + "." + a.getArtifactId() + "-" + a.getVersion();
    }

    private PlatformCatalogResolver catalogResolver() throws MojoExecutionException {
        return this.catalogs == null ? (this.catalogs = new PlatformCatalogResolver(this.artifactResolver())) : this.catalogs;
    }

    private MavenArtifactResolver artifactResolver() throws MojoExecutionException {
        try {
            return this.artifactResolver == null ? (this.artifactResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem)).setRepositorySystemSession(this.repoSession)).setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).build()) : this.artifactResolver;
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
    }
}

