/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.platform.ProjectDependencyFilterConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.ProjectDependencyResolver;
import io.quarkus.domino.manifest.ManifestGenerator;
import io.quarkus.domino.manifest.ProductInfo;
import io.quarkus.domino.manifest.ProductInfoImpl;
import io.quarkus.domino.manifest.SbomGeneratingDependencyVisitor;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.paths.PathTree;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependencies-to-build", threadSafe=true, requiresProject=false)
public class DependenciesToBuildMojo
extends AbstractMojo {
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(required=false, defaultValue="${project.file}")
    File projectFile;
    @Parameter(required=true, property="bom", defaultValue="${project.groupId}:${project.artifactId}::pom:${project.version}")
    String bom;
    @Parameter(required=true, property="level", defaultValue="-1")
    int level = -1;
    @Parameter(required=false, property="includeNonManaged")
    Boolean includeNonManaged;
    @Parameter(required=false, property="logArtifactsToBuild")
    boolean logArtifactsToBuild = true;
    @Parameter(required=false, property="logModulesToBuild")
    boolean logModulesToBuild;
    @Parameter(required=false, property="logTrees")
    boolean logTrees;
    @Parameter(required=false, property="logTreesFor")
    String logTreesFor;
    @Parameter(required=false, property="logRemaining")
    boolean logRemaining;
    @Parameter(required=false, property="logSummary")
    boolean logSummary = true;
    @Parameter(required=false, property="logNonManagedVisited")
    boolean logNonManagedVisited;
    @Parameter(property="outputFile", required=false)
    File outputFile;
    @Parameter(property="appendOutput", required=false, defaultValue="false")
    boolean appendOutput;
    @Parameter(property="logCodeRepos", required=false)
    boolean logCodeRepos;
    @Parameter(property="logCodeRepoGraph", required=false)
    boolean logCodeRepoGraph;
    @Parameter(property="excludeParentPoms", required=false)
    boolean excludeParentPoms;
    @Parameter(property="excludeBomImports", required=false)
    boolean excludeBomImports;
    @Parameter(required=false)
    PlatformConfig platformConfig;
    @Parameter(required=false)
    ProjectDependencyFilterConfig dependenciesToBuild;
    @Deprecated(since="0.0.78")
    @Parameter(required=false, property="validateCodeRepoTags")
    boolean validateCodeRepoTags;
    @Parameter(required=false, property="legacyScmLocator")
    boolean legacyScmLocator;
    @Parameter(required=false, property="recipeRepos")
    List<String> recipeRepos;
    @Parameter(required=false, property="warnOnMissingScm")
    boolean warnOnMissingScm;
    @Parameter(property="includeAlreadyBuilt", required=false)
    boolean includeAlreadyBuilt;
    @Parameter(required=false, property="manifest")
    boolean manifest;
    @Parameter(required=false, property="flatManifest")
    boolean flatManifest;
    @Parameter(required=false, property="redhatSupported")
    boolean redhatSupported;
    @Parameter(required=false)
    ProductInfoImpl.Builder productInfo;
    private Set<ArtifactCoords> targetBomConstraints;
    private Map<ArtifactCoords, List<Dependency>> enforcedConstraintsForBom = new HashMap<ArtifactCoords, List<Dependency>>();
    private MavenArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactCoords targetBomCoords = ArtifactCoords.fromString((String)this.bom);
        if (PlatformArtifacts.isCatalogArtifactId((String)targetBomCoords.getArtifactId())) {
            targetBomCoords = ArtifactCoords.pom((String)targetBomCoords.getGroupId(), (String)PlatformArtifacts.ensureBomArtifactId((String)targetBomCoords.getArtifactId()), (String)targetBomCoords.getVersion());
        } else if (!targetBomCoords.getType().equals("pom")) {
            targetBomCoords = ArtifactCoords.pom((String)targetBomCoords.getGroupId(), (String)targetBomCoords.getArtifactId(), (String)targetBomCoords.getVersion());
        }
        this.debug("Quarkus platform BOM %s", targetBomCoords);
        ArtifactCoords catalogCoords = ArtifactCoords.of((String)targetBomCoords.getGroupId(), (String)PlatformArtifacts.ensureCatalogArtifactId((String)targetBomCoords.getArtifactId()), (String)targetBomCoords.getVersion(), (String)"json", (String)targetBomCoords.getVersion());
        this.debug("Quarkus extension catalog %s", catalogCoords);
        try {
            this.resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(this.projectFile != null)).setPreferPomsFromWorkspace(this.projectFile != null)).setCurrentProject(this.projectFile == null ? null : this.projectFile.toString())).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
        List<Dependency> targetBomManagedDeps = this.getBomConstraints(targetBomCoords);
        this.targetBomConstraints = new HashSet<ArtifactCoords>(targetBomManagedDeps.size());
        for (Dependency d : targetBomManagedDeps) {
            this.targetBomConstraints.add(DependenciesToBuildMojo.toCoords(d.getArtifact()));
        }
        ExtensionCatalog catalog = this.resolveCatalog(catalogCoords);
        Collection<ArtifactCoords> otherDescriptorCoords = DependenciesToBuildMojo.getOtherMemberDescriptorCoords(catalog);
        if (!otherDescriptorCoords.isEmpty()) {
            ArtifactCoords generatedCoreBomCoords = null;
            if (targetBomCoords.getArtifactId().equals("quarkus-bom")) {
                generatedCoreBomCoords = targetBomCoords;
            } else {
                String coreDescriptorArtifactId = "quarkus-bom-quarkus-platform-descriptor";
                for (ArtifactCoords c : otherDescriptorCoords) {
                    if (!c.getArtifactId().equals("quarkus-bom-quarkus-platform-descriptor")) continue;
                    generatedCoreBomCoords = PlatformArtifacts.ensureBomArtifact((ArtifactCoords)c);
                    break;
                }
                if (generatedCoreBomCoords == null) {
                    throw new MojoExecutionException("Failed to locate quarkus-bom among " + otherDescriptorCoords);
                }
            }
            if (targetBomCoords.equals(generatedCoreBomCoords)) {
                this.enforcedConstraintsForBom.put(targetBomCoords, targetBomManagedDeps);
                ArrayList<ExtensionCatalog> catalogs = new ArrayList<ExtensionCatalog>(otherDescriptorCoords.size() + 1);
                catalogs.add(catalog);
                for (ArtifactCoords descrCoords : otherDescriptorCoords) {
                    ExtensionCatalog otherCatalog = this.resolveCatalog(descrCoords);
                    if (!this.isManifestMode()) {
                        catalogs.add(otherCatalog);
                    }
                    ArtifactCoords otherBomCoords = otherCatalog.getBom();
                    List<Dependency> otherBomDeps = this.getBomConstraints(otherBomCoords);
                    ArrayList<Dependency> enforcedConstraints = new ArrayList<Dependency>(targetBomManagedDeps.size() + otherBomDeps.size());
                    enforcedConstraints.addAll(targetBomManagedDeps);
                    enforcedConstraints.addAll(otherBomDeps);
                    this.enforcedConstraintsForBom.put(otherBomCoords, enforcedConstraints);
                }
                catalog = CatalogMergeUtility.merge(catalogs);
            } else {
                List<Dependency> bomConstraints = this.getBomConstraints(generatedCoreBomCoords);
                bomConstraints.addAll(targetBomManagedDeps);
                this.enforcedConstraintsForBom.put(targetBomCoords, bomConstraints);
            }
        } else {
            this.enforcedConstraintsForBom.put(targetBomCoords, targetBomManagedDeps);
        }
        HashMap<ArtifactCoords, Extension> supported = new HashMap<ArtifactCoords, Extension>();
        for (Extension ext : catalog.getExtensions()) {
            ArtifactCoords rtArtifact = ext.getArtifact();
            if (this.isExcluded(rtArtifact) || this.redhatSupported && !ext.getMetadata().containsKey("redhat-support")) continue;
            supported.put(ext.getArtifact(), ext);
            ArtifactCoords deploymentCoords = ArtifactCoords.jar((String)rtArtifact.getGroupId(), (String)(rtArtifact.getArtifactId() + "-deployment"), (String)rtArtifact.getVersion());
            if (!this.targetBomConstraints.contains(deploymentCoords)) {
                Path rtJar;
                try {
                    rtJar = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact(rtArtifact)).getArtifact().getFile().toPath();
                }
                catch (BootstrapMavenException e1) {
                    throw new MojoExecutionException("Failed to resolve " + rtArtifact, (Exception)((Object)e1));
                }
                deploymentCoords = (ArtifactCoords)PathTree.ofDirectoryOrArchive((Path)rtJar).apply("META-INF/quarkus-extension.properties", visit -> {
                    if (visit == null) {
                        return null;
                    }
                    Properties props = new Properties();
                    try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                        props.load(reader);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    String str = props.getProperty("deployment-artifact");
                    return str == null ? null : ArtifactCoords.fromString((String)str);
                });
                if (deploymentCoords == null) {
                    throw new MojoExecutionException("Failed to determine the corresponding deployment artifact for " + rtArtifact.toCompactCoords());
                }
            }
            supported.put(deploymentCoords, ext);
        }
        ProjectDependencyResolver.Builder depsResolver = ProjectDependencyResolver.builder().setArtifactConstraintsProvider(coords -> {
            Extension ext = (Extension)supported.get(coords);
            return ext == null ? targetBomManagedDeps : this.getConstraintsForExtension(ext);
        }).setArtifactResolver(this.resolver).setMessageWriter((MessageWriter)new MojoMessageWriter(this.getLog())).setLogOutputFile(this.isManifestMode() ? null : (this.outputFile == null ? null : this.outputFile.toPath())).setAppendOutput(this.appendOutput).setDependencyConfig((ProjectDependencyConfig)ProjectDependencyConfig.builder().setProjectBom(targetBomCoords).setProjectArtifacts(supported.keySet()).setIncludeGroupIds(this.dependenciesToBuild.getIncludeGroupIds()).setIncludeKeys(this.dependenciesToBuild.getIncludeKeys()).setIncludeArtifacts(this.dependenciesToBuild.getIncludeArtifacts()).setExcludePatterns(this.dependenciesToBuild.getExcludeArtifacts()).setExcludeGroupIds(this.dependenciesToBuild.getExcludeGroupIds()).setExcludeKeys(this.dependenciesToBuild.getExcludeKeys()).setExcludeBomImports(this.excludeBomImports).setExcludeParentPoms(this.excludeParentPoms).setIncludeNonManaged(this.includeNonManaged == null ? this.isManifestMode() : this.includeNonManaged.booleanValue()).setLevel(this.level).setLogArtifactsToBuild(this.logArtifactsToBuild).setLogCodeRepoTree(this.logCodeRepoGraph).setLogCodeRepos(this.logCodeRepos).setLogModulesToBuild(this.logModulesToBuild).setLogNonManagedVisited(this.logNonManagedVisited).setLogRemaining(this.logRemaining).setLogSummary(this.logSummary).setLogTrees(this.logTrees).setLogTreesFor(this.logTreesFor).setIncludeAlreadyBuilt(this.includeAlreadyBuilt).setValidateCodeRepoTags(this.validateCodeRepoTags).setLegacyScmLocator(this.legacyScmLocator).setRecipeRepos(this.recipeRepos).setWarnOnMissingScm(this.warnOnMissingScm));
        if (this.manifest) {
            depsResolver.addDependencyTreeVisitor((DependencyTreeVisitor)new SbomGeneratingDependencyVisitor(this.resolver, this.outputFile == null ? null : this.outputFile.toPath(), (ProductInfo)this.productInfo)).build().resolveDependencies();
        } else if (this.flatManifest) {
            depsResolver.build().consumeSorted(ManifestGenerator.builder().setArtifactResolver(this.resolver).setOutputFile(this.outputFile == null ? null : this.outputFile.toPath()).build().toConsumer());
        } else {
            depsResolver.build().log();
        }
    }

    private boolean isManifestMode() {
        return this.manifest || this.flatManifest;
    }

    private List<Dependency> getConstraintsForExtension(Extension ext) {
        for (ExtensionOrigin origin : ext.getOrigins()) {
            List<Dependency> enforcedConstraints;
            if (origin.getBom() == null || (enforcedConstraints = this.enforcedConstraintsForBom.get(origin.getBom())) == null) continue;
            return enforcedConstraints;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to locate enforced constraints for ").append(ext.getArtifact().toCompactCoords()).append(" with origins ");
        for (int i = 0; i < ext.getOrigins().size(); ++i) {
            ExtensionOrigin origin = (ExtensionOrigin)ext.getOrigins().get(i);
            if (origin.getBom() == null) continue;
            sb.append(origin.getBom().toCompactCoords());
            if (i <= 0) continue;
            sb.append(", ");
        }
        sb.append(" among ");
        Iterator<ArtifactCoords> i = this.enforcedConstraintsForBom.keySet().iterator();
        if (i.hasNext()) {
            sb.append(i.next().toCompactCoords());
            while (i.hasNext()) {
                sb.append(", ").append(i.next().toCompactCoords());
            }
        }
        throw new RuntimeException(sb.toString());
    }

    private List<Dependency> getBomConstraints(ArtifactCoords bomCoords) throws MojoExecutionException {
        List managedDeps;
        DefaultArtifact bomArtifact = new DefaultArtifact(bomCoords.getGroupId(), bomCoords.getArtifactId(), "", "pom", bomCoords.getVersion());
        try {
            managedDeps = this.resolver.resolveDescriptor((Artifact)bomArtifact).getManagedDependencies();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the descriptor of " + bomCoords, (Exception)((Object)e));
        }
        if (managedDeps.isEmpty()) {
            throw new MojoExecutionException(bomCoords.toCompactCoords() + " does not include any managed dependency or its descriptor could not be read");
        }
        return managedDeps;
    }

    private ExtensionCatalog resolveCatalog(ArtifactCoords catalogCoords) throws MojoExecutionException {
        ExtensionCatalog catalog;
        Path jsonPath;
        try {
            jsonPath = this.resolver.resolve((Artifact)DependenciesToBuildMojo.toAetherArtifact(catalogCoords)).getArtifact().getFile().toPath();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to resolve the extension catalog", (Exception)((Object)e));
        }
        try {
            this.debug("Parsing extension catalog %s", jsonPath);
            catalog = ExtensionCatalog.fromFile((Path)jsonPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse " + jsonPath, (Exception)e);
        }
        return catalog;
    }

    private static DefaultArtifact toAetherArtifact(ArtifactCoords a) {
        return new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getType(), a.getVersion());
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            if (args.length == 0) {
                this.getLog().debug((CharSequence)msg);
            } else {
                this.getLog().debug((CharSequence)String.format(msg, args));
            }
        }
    }

    private boolean isExcluded(ArtifactCoords coords) {
        return this.dependenciesToBuild != null && (this.dependenciesToBuild.getExcludeGroupIds().contains(coords.getGroupId()) || this.dependenciesToBuild.getExcludeKeys().contains(coords.getKey()) || this.dependenciesToBuild.getExcludeArtifacts().contains(coords));
    }

    private static ArtifactCoords toCoords(Artifact a) {
        return ArtifactCoords.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension(), (String)a.getVersion());
    }

    private static Collection<ArtifactCoords> getOtherMemberDescriptorCoords(ExtensionCatalog catalog) {
        Map map = catalog.getMetadata();
        if (map == null) {
            return List.of();
        }
        Object o = map.get("platform-release");
        if (o == null || !(o instanceof Map)) {
            return List.of();
        }
        if ((o = ((Map)o).get("members")) == null || !(o instanceof List)) {
            return List.of();
        }
        List list = (List)o;
        ArrayList<ArtifactCoords> result = new ArrayList<ArtifactCoords>(list.size());
        list.forEach(i -> {
            if (!i.equals(catalog.getId())) {
                result.add(ArtifactCoords.fromString((String)i.toString()));
            }
        });
        return result;
    }
}

