/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven;

import io.quarkus.bom.decomposer.maven.MojoMessageWriter;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.DependencyTreeVisitor;
import io.quarkus.domino.ProjectDependencyConfig;
import io.quarkus.domino.ProjectDependencyResolver;
import io.quarkus.domino.manifest.ProductInfo;
import io.quarkus.domino.manifest.ProductInfoImpl;
import io.quarkus.domino.manifest.SbomGeneratingDependencyVisitor;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="deps-to-rebuild", threadSafe=true, requiresProject=false)
public class NonQuarkusDepsToBuildMojo
extends AbstractMojo {
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Parameter(required=false, defaultValue="${project.file}")
    File projectFile;
    @Parameter(required=true, property="bom", defaultValue="${project.groupId}:${project.artifactId}::pom:${project.version}")
    String bom;
    @Parameter(required=true, property="level", defaultValue="-1")
    int level = -1;
    @Parameter(required=false, property="includeNonManaged")
    boolean includeNonManaged;
    @Parameter(required=false, property="logArtifactsToBuild")
    boolean logArtifactsToBuild = true;
    @Parameter(required=false, property="logModulesToBuild")
    boolean logModulesToBuild;
    @Parameter(required=false, property="logTrees")
    boolean logTrees;
    @Parameter(required=false, property="logRemaining")
    boolean logRemaining;
    @Parameter(required=false, property="logSummary")
    boolean logSummary = true;
    @Parameter(required=false, property="logNonManagedVisited")
    boolean logNonManagedVisited;
    @Parameter(property="outputFile", required=false)
    File outputFile;
    @Parameter(property="appendOutput", required=false, defaultValue="false")
    boolean appendOutput;
    @Parameter(property="logCodeRepos", required=false)
    boolean logCodeRepos;
    @Parameter(property="logCodeRepoGraph", required=false)
    boolean logCodeRepoGraph;
    @Parameter(property="excludeParentPoms", required=false)
    boolean excludeParentPoms;
    @Parameter(property="excludeBomImports", required=false)
    boolean excludeBomImports;
    @Parameter(required=false)
    List<String> topLevelArtifactsToBuild = List.of();
    @Parameter(required=false)
    Set<String> excludeArtifacts = Set.of();
    @Parameter(required=false)
    Set<String> excludeGroupIds = Set.of();
    @Parameter(required=false)
    Set<String> excludeKeys = Set.of();
    @Parameter(required=false)
    Set<String> includeGroupIds = Set.of();
    @Parameter(required=false)
    Set<String> includeKeys = Set.of();
    @Deprecated(since="0.0.78")
    @Parameter(required=false, property="validateCodeRepoTags")
    boolean validateCodeRepoTags;
    @Parameter(required=false, property="warnOnResolutionErrors")
    boolean warnOnResolutionErrors;
    @Parameter(required=false, property="warnOnMissingScm")
    boolean warnOnMissingScm;
    @Parameter(required=false, property="includeOptionalDeps")
    boolean includeOptionalDeps;
    @Parameter(required=false, property="recipeRepos")
    List<String> recipeRepos;
    @Parameter(required=false, property="legacyScmLocator")
    boolean legacyScmLocator;
    @Parameter(required=false, property="manifest")
    boolean manifest;
    @Parameter(required=false)
    ProductInfoImpl.Builder productInfo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenArtifactResolver resolver;
        try {
            resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepoManager)).setWorkspaceDiscovery(this.projectFile != null)).setPreferPomsFromWorkspace(this.projectFile != null)).setCurrentProject(this.projectFile == null ? null : this.projectFile.toString())).build();
        }
        catch (BootstrapMavenException e) {
            throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
        }
        ProjectDependencyResolver.Builder builder = ProjectDependencyResolver.builder().setArtifactResolver(resolver).setMessageWriter((MessageWriter)new MojoMessageWriter(this.getLog())).setLogOutputFile(this.outputFile == null ? null : this.outputFile.toPath()).setAppendOutput(this.appendOutput).setDependencyConfig((ProjectDependencyConfig)ProjectDependencyConfig.builder().setProjectBom(this.bom == null ? null : ArtifactCoords.fromString((String)this.bom)).setProjectArtifacts((Collection)this.topLevelArtifactsToBuild.stream().map(ArtifactCoords::fromString).collect(Collectors.toList())).setIncludeGroupIds(this.includeGroupIds).setIncludeKeys(NonQuarkusDepsToBuildMojo.toKeySet(this.includeKeys)).setExcludePatterns(NonQuarkusDepsToBuildMojo.toCoordsSet(this.excludeArtifacts)).setExcludeGroupIds(this.excludeGroupIds).setExcludeKeys(NonQuarkusDepsToBuildMojo.toKeySet(this.excludeKeys)).setExcludeBomImports(this.excludeBomImports).setExcludeParentPoms(this.excludeParentPoms).setIncludeNonManaged(this.includeNonManaged).setLevel(this.level).setLogArtifactsToBuild(this.logArtifactsToBuild).setLogCodeRepoTree(this.logCodeRepoGraph).setLogCodeRepos(this.logCodeRepos).setLogModulesToBuild(this.logModulesToBuild).setLogNonManagedVisited(this.logNonManagedVisited).setLogRemaining(this.logRemaining).setLogSummary(this.logSummary).setLogTrees(this.logTrees).setValidateCodeRepoTags(this.validateCodeRepoTags).setLegacyScmLocator(this.legacyScmLocator).setWarnOnResolutionErrors(this.warnOnResolutionErrors).setWarnOnMissingScm(this.warnOnMissingScm).setIncludeOptionalDeps(this.includeOptionalDeps).setRecipeRepos(this.recipeRepos == null ? List.of() : this.recipeRepos));
        if (this.manifest) {
            builder.addDependencyTreeVisitor((DependencyTreeVisitor)new SbomGeneratingDependencyVisitor(resolver, this.outputFile == null ? null : this.outputFile.toPath(), (ProductInfo)this.productInfo)).build().resolveDependencies();
        } else {
            builder.build().log();
        }
    }

    private static Set<ArtifactCoords> toCoordsSet(Collection<String> set) {
        HashSet<ArtifactCoords> result = new HashSet<ArtifactCoords>(set.size());
        for (String s : set) {
            result.add(ArtifactCoords.fromString((String)s));
        }
        return result;
    }

    private static Set<ArtifactKey> toKeySet(Collection<String> set) {
        HashSet<ArtifactKey> result = new HashSet<ArtifactKey>(set.size());
        for (String s : set) {
            result.add(ArtifactKey.fromString((String)s));
        }
        return result;
    }
}

