/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.decomposer.maven.platformgen.DelegatingExecutionListener;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="quarkus-platform-bom-lifecycle")
public class PlatformBomLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    static final String QUARKUS_REGISTRY_URL = "quarkus.registry.url";
    static final String UPDATE_POM_ON_INSTALL = "updatePomOnInstall";

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        final String registryUrl = System.getProperty(QUARKUS_REGISTRY_URL);
        DelegatingExecutionListener listener = new DelegatingExecutionListener();
        listener.add(session.getRequest().getExecutionListener());
        listener.add((ExecutionListener)new AbstractExecutionListener(){
            private MavenProject configProject;

            public void mojoSucceeded(ExecutionEvent event) {
                MavenProject project = event.getProject();
                MojoExecution mojo = event.getMojoExecution();
                if (mojo.getGoal().equals("generate-platform-project") && mojo.getArtifactId().equals("quarkus-platform-bom-maven-plugin") && mojo.getGroupId().equals("io.quarkus")) {
                    this.configProject = project;
                }
                if (mojo.getArtifactId().equals("maven-install-plugin") && mojo.getGoal().equals("install")) {
                    String updatePomOnInstall;
                    if (project.getArtifactId().endsWith("-quarkus-platform-descriptor")) {
                        if (registryUrl != null) {
                            this.platformDescriptorReleased(registryUrl, event);
                        }
                        return;
                    }
                    if (project == this.configProject && (updatePomOnInstall = (String)this.configProject.getProperties().get(PlatformBomLifecycleParticipant.UPDATE_POM_ON_INSTALL)) != null && Boolean.parseBoolean(updatePomOnInstall)) {
                        Path originalPom = project.getBasedir().toPath().resolve("pom.xml");
                        try {
                            IoUtils.copy((Path)project.getFile().toPath(), (Path)originalPom);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to replace the " + originalPom + " with " + project.getFile());
                        }
                    }
                }
            }

            private void platformDescriptorReleased(String registryUrl2, ExecutionEvent event) {
                MojoExecution mojo = event.getMojoExecution();
                if (!mojo.getArtifactId().equals("maven-install-plugin") || !mojo.getGoal().equals("install")) {
                    return;
                }
                MavenProject project = event.getProject();
                StringBuilder buf = new StringBuilder(registryUrl2);
                buf.append("/").append(project.getGroupId());
                buf.append("/").append(project.getArtifactId());
                buf.append("/").append(project.getVersion());
                try {
                    URL u = new URL(buf.toString());
                    URLConnection con = u.openConnection();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            System.out.println("REGISTRY: " + line);
                            line = reader.readLine();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        session.getRequest().setExecutionListener((ExecutionListener)listener);
    }
}

