/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.playground;

import io.quarkus.bom.decomposer.maven.playground.Element;
import io.quarkus.bom.decomposer.maven.playground.ElementCatalog;
import io.quarkus.bom.decomposer.maven.playground.Member;
import io.quarkus.bom.decomposer.maven.playground.Union;
import io.quarkus.bom.decomposer.maven.playground.UnionVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ElementCatalogBuilder {
    private final Map<Object, ElementBuilder> elements = new HashMap<Object, ElementBuilder>();
    private final Map<Object, MemberBuilder> members = new HashMap<Object, MemberBuilder>();
    private final Map<Comparable<?>, UnionBuilder> unions = new HashMap();

    public static ElementCatalogBuilder newInstance() {
        return new ElementCatalogBuilder();
    }

    private ElementBuilder getOrCreateElement(Object elementKey, Object elementVersion) {
        return this.elements.computeIfAbsent(elementKey, k -> new ElementBuilder(k, elementVersion));
    }

    private MemberBuilder getOrCreateMember(Object key, Object version) {
        return this.members.computeIfAbsent(key + ":" + version, k -> new MemberBuilder(key, version));
    }

    public UnionBuilder newUnion(int version) {
        return this.newUnion(IntVersion.get(version));
    }

    public UnionBuilder newUnion(UnionVersion version) {
        return this.unions.computeIfAbsent(version, v -> new UnionBuilder(version));
    }

    public ElementCatalog build() {
        final HashMap<Object, Element> map = new HashMap<Object, Element>(this.elements.size());
        for (ElementBuilder e : this.elements.values()) {
            Element build = e.build();
            map.put(build.key(), build);
        }
        for (MemberBuilder m : this.members.values()) {
            m.build();
        }
        for (UnionBuilder u : this.unions.values()) {
            u.build();
        }
        ElementCatalog catalog = new ElementCatalog(){

            @Override
            public Collection<Element> elements() {
                return map.values();
            }

            @Override
            public Collection<Object> elementKeys() {
                return ElementCatalogBuilder.this.elements.keySet();
            }

            @Override
            public Element get(Object elementKey) {
                return (Element)map.get(elementKey);
            }

            public String toString() {
                return ElementCatalogBuilder.this.elements.toString();
            }
        };
        return catalog;
    }

    static class IntVersion
    implements UnionVersion {
        private final Integer version;

        static UnionVersion get(Integer i) {
            return new IntVersion(i);
        }

        public IntVersion(int version) {
            this.version = version;
        }

        @Override
        public int compareTo(UnionVersion o) {
            if (o instanceof IntVersion) {
                return this.version.compareTo(((IntVersion)o).version);
            }
            throw new IllegalArgumentException(o + " is not an instance of " + IntVersion.class.getName());
        }

        public String toString() {
            return this.version.toString();
        }
    }

    private abstract class BuildCallback<T> {
        private BuildCallback() {
        }

        protected abstract void created(T var1);
    }

    public class UnionBuilder
    extends BuildCallback<Member> {
        private final UnionVersion version;
        private final List<Member> members = new ArrayList<Member>();

        private UnionBuilder(UnionVersion version) {
            this.version = Objects.requireNonNull(version);
        }

        public MemberBuilder addMember(Object memberKey, Object memberVersion) {
            return ElementCatalogBuilder.this.getOrCreateMember(memberKey, memberVersion).addUnion(this);
        }

        @Override
        protected void created(Member t) {
            this.members.add(t);
        }

        public Union build() {
            Union u = new Union(){

                @Override
                public UnionVersion verion() {
                    return UnionBuilder.this.version;
                }

                @Override
                public Collection<Member> members() {
                    return UnionBuilder.this.members;
                }

                public String toString() {
                    return UnionBuilder.this.version.toString() + UnionBuilder.this.members;
                }
            };
            return u;
        }
    }

    public class MemberBuilder
    extends BuildCallback<Element> {
        private final Object key;
        private final Object version;
        private UnionVersion unionVersion;
        private final List<BuildCallback<Member>> callbacks = new ArrayList<BuildCallback<Member>>();
        private final Map<Object, Element> elements = new HashMap<Object, Element>();

        private MemberBuilder(Object key, Object version) {
            this.key = Objects.requireNonNull(key);
            this.version = Objects.requireNonNull(version);
        }

        public ElementBuilder addElement(Object elementKey) {
            return ElementCatalogBuilder.this.getOrCreateElement(elementKey, this.version).addCallback(this);
        }

        MemberBuilder addUnion(UnionBuilder union) {
            if (this.unionVersion == null) {
                this.unionVersion = union.version;
            }
            this.callbacks.add(union);
            return this;
        }

        @Override
        protected void created(Element t) {
            this.elements.put(t.key(), t);
        }

        public Member build() {
            Member m = new Member(){

                @Override
                public Object key() {
                    return MemberBuilder.this.key;
                }

                @Override
                public Object version() {
                    return MemberBuilder.this.version;
                }

                @Override
                public UnionVersion unionVersion() {
                    return MemberBuilder.this.unionVersion;
                }

                @Override
                public Collection<Element> elements() {
                    return MemberBuilder.this.elements.values();
                }

                @Override
                public Collection<Object> elementKeys() {
                    return MemberBuilder.this.elements.keySet();
                }

                @Override
                public Element get(Object elementKey) {
                    return (Element)MemberBuilder.this.elements.get(elementKey);
                }

                public String toString() {
                    return MemberBuilder.this.key.toString() + "#" + MemberBuilder.this.version + MemberBuilder.this.elements.values();
                }

                @Override
                public boolean containsAll(Collection<Object> elementKeys) {
                    return MemberBuilder.this.elements.keySet().containsAll(elementKeys);
                }
            };
            this.callbacks.forEach(c -> c.created(m));
            return m;
        }
    }

    public class ElementBuilder
    extends BuildCallback<Member> {
        private final Object key;
        private final Object version;
        private final List<BuildCallback<Element>> callbacks = new ArrayList<BuildCallback<Element>>(4);
        private final List<Member> members = new ArrayList<Member>();

        private ElementBuilder(Object key, Object version) {
            this.key = Objects.requireNonNull(key);
            this.version = Objects.requireNonNull(version);
        }

        private ElementBuilder addCallback(MemberBuilder callback) {
            this.callbacks.add(callback);
            callback.callbacks.add(this);
            return this;
        }

        private Element build() {
            Element e = new Element(){

                @Override
                public Object key() {
                    return ElementBuilder.this.key;
                }

                @Override
                public Collection<Member> members() {
                    return ElementBuilder.this.members;
                }

                public String toString() {
                    return ElementBuilder.this.key.toString() + "#" + ElementBuilder.this.version;
                }

                @Override
                public Object version() {
                    return ElementBuilder.this.version;
                }
            };
            this.callbacks.forEach(c -> c.created(e));
            return e;
        }

        @Override
        protected void created(Member t) {
            this.members.add(t);
        }
    }
}

