/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.playground;

import io.quarkus.bom.decomposer.maven.playground.Element;
import io.quarkus.bom.decomposer.maven.playground.ElementCatalog;
import io.quarkus.bom.decomposer.maven.playground.ElementCatalogBuilder;
import io.quarkus.bom.decomposer.maven.playground.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class Playground {
    public static void main(String[] args) throws Exception {
        ElementCatalogBuilder catalogBuilder = ElementCatalogBuilder.newInstance();
        ElementCatalogBuilder.UnionBuilder unionBuilder = catalogBuilder.newUnion(1);
        ElementCatalogBuilder.MemberBuilder kogito = unionBuilder.addMember("kogito", "1.1.1");
        kogito.addElement("kogito-e1");
        kogito.addElement("kogito-e2");
        ElementCatalogBuilder.MemberBuilder camel = unionBuilder.addMember("camel", "1.2.2");
        camel.addElement("camel-e1");
        camel.addElement("camel-e2");
        unionBuilder = catalogBuilder.newUnion(2);
        kogito = unionBuilder.addMember("kogito", "2.1.1");
        kogito.addElement("kogito-e1");
        kogito.addElement("kogito-e2");
        camel = unionBuilder.addMember("camel", "2.2.2");
        camel.addElement("camel-e1");
        camel.addElement("camel-e2");
        unionBuilder = catalogBuilder.newUnion(3);
        kogito = unionBuilder.addMember("kogito", "3.1.1");
        kogito.addElement("kogito-e1");
        kogito.addElement("kogito-e2");
        unionBuilder = catalogBuilder.newUnion(4);
        kogito = unionBuilder.addMember("kogito", "4.1.1");
        kogito.addElement("kogito-e1");
        kogito.addElement("kogito-e2");
        ElementCatalog catalog = catalogBuilder.build();
        Playground.log(catalog);
        List<Member> members = Playground.membersFor(catalog, "kogito-e2");
        StringBuilder buf = new StringBuilder();
        buf.append("Selected members: ");
        if (members.isEmpty()) {
            buf.append("NONE");
        } else {
            buf.append(members.get(0).key());
            for (int i = 1; i < members.size(); ++i) {
                buf.append(", ").append(members.get(i).key());
            }
        }
        System.out.println(buf);
    }

    private static List<Member> membersFor(ElementCatalog catalog, Object ... elementKeys) {
        List<Object> eKeyList = Arrays.asList(elementKeys);
        Comparator comparator = Comparable::compareTo;
        TreeMap unionVersions = new TreeMap(comparator.reversed());
        for (Object elementKey : elementKeys) {
            Element e = catalog.get(elementKey);
            if (e == null) {
                throw new RuntimeException("Element " + elementKey + " not found in the catalog");
            }
            for (Member m2 : e.members()) {
                unionVersions.computeIfAbsent(m2.unionVersion(), v -> new ArrayList()).add(m2);
            }
        }
        for (List members : unionVersions.values()) {
            HashSet memberElementKeys = new HashSet();
            members.forEach(m -> memberElementKeys.addAll(m.elementKeys()));
            if (!memberElementKeys.containsAll(eKeyList)) continue;
            return members;
        }
        return Collections.emptyList();
    }

    private static void log(ElementCatalog catalog) {
        catalog.elements().stream().map(Element::key).sorted().map(catalog::get).forEach(e -> {
            System.out.println("element: " + e.key());
            for (Member m : e.members()) {
                System.out.println("  member: " + m.key() + " @ union: " + m.unionVersion());
            }
        });
    }
}

