/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;

public class Utils {
    public static Model newModel() {
        Model model = new Model(){

            public void setProperties(Properties props) {
                if (!(props instanceof SortedProperties)) {
                    SortedProperties sorted = new SortedProperties();
                    for (Map.Entry<Object, Object> prop : props.entrySet()) {
                        sorted.setProperty(prop.getKey().toString(), prop.getValue() == null ? null : prop.getValue().toString());
                    }
                    props = sorted;
                }
                super.setProperties(props);
            }
        };
        model.setProperties((Properties)new SortedProperties());
        model.setModelVersion("4.0.0");
        return model;
    }

    public static void skipInstallAndDeploy(Model pom) {
        Utils.disablePlugin(pom, "maven-install-plugin", "default-install");
        Utils.disablePlugin(pom, "maven-deploy-plugin", "default-deploy");
        pom.getProperties().setProperty("gpg.skip", "true");
    }

    public static void disablePlugin(Model pom, String pluginArtifactId, String execId) {
        PluginManagement pm;
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        if ((pm = build.getPluginManagement()) == null) {
            pm = new PluginManagement();
            build.setPluginManagement(pm);
        }
        Plugin plugin = new Plugin();
        pm.addPlugin(plugin);
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId(pluginArtifactId);
        PluginExecution e = new PluginExecution();
        plugin.addExecution(e);
        e.setId(execId);
        e.setPhase("none");
    }

    public static void main(String[] args) throws Exception {
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        public Enumeration<Object> keys() {
            List<String> sorted = this.sortedKeys();
            Vector<String> keyList = new Vector<String>(sorted.size());
            for (String s : sorted) {
                keyList.add(s);
            }
            return keyList.elements();
        }

        @Override
        public Set<Object> keySet() {
            List<String> sorted = this.sortedKeys();
            LinkedHashSet<Object> result = new LinkedHashSet<Object>(sorted.size());
            result.addAll(sorted);
            return result;
        }

        private List<String> sortedKeys() {
            Set<Object> originalKeys = super.keySet();
            ArrayList<String> sorted = new ArrayList<String>(this.size());
            for (Object o : originalKeys) {
                sorted.add(o == null ? null : o.toString());
            }
            Collections.sort(sorted);
            return sorted;
        }
    }
}

