/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.maven.platformgen;

import io.quarkus.bom.decomposer.maven.platformgen.PlatformConfig;
import io.quarkus.bom.decomposer.maven.platformgen.PlatformReleaseConfig;
import io.quarkus.bom.platform.version.PncVersionProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="next-platform-version", threadSafe=true)
public class NextPlatformVersionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter
    PlatformConfig platformConfig;
    @Parameter(property="apply")
    boolean apply;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String nextVersion;
        PlatformReleaseConfig releaseConfig;
        PlatformReleaseConfig platformReleaseConfig = releaseConfig = this.platformConfig == null ? null : this.platformConfig.getRelease();
        if (releaseConfig == null) {
            this.getLog().info((CharSequence)"Platform release configuration is missing");
            return;
        }
        if ("PNC".equalsIgnoreCase(releaseConfig.getVersionIncrementor())) {
            nextVersion = PncVersionProvider.getNextRedHatBuildVersion((String)this.project.getGroupId(), (String)this.project.getArtifactId(), (String)this.project.getVersion());
        } else if (this.project.getVersion().endsWith("-SNAPSHOT")) {
            nextVersion = this.project.getVersion().substring(0, this.project.getVersion().length() - "-SNAPSHOT".length());
        } else {
            DefaultArtifactVersion v = new DefaultArtifactVersion(this.project.getVersion());
            StringBuilder sb = new StringBuilder();
            sb.append(v.getMajorVersion()).append(".").append(v.getMinorVersion()).append(".").append(v.getIncrementalVersion() + 1);
            if (v.getQualifier() != null) {
                sb.append(".").append(v.getQualifier());
            }
            nextVersion = sb.toString();
        }
        if (this.project.getVersion().equals(nextVersion)) {
            this.getLog().info((CharSequence)"The current project version is already set the next release version");
        } else {
            this.getLog().info((CharSequence)("The next project version will be " + nextVersion));
            if (this.apply) {
                String pomContent;
                Model model = this.project.getOriginalModel();
                String modelVersion = model.getVersion();
                if (modelVersion == null) {
                    this.getLog().error((CharSequence)"Cannot set the next version since the version is managed by a parent POM");
                    return;
                }
                Path pomPath = this.project.getFile().toPath();
                try {
                    pomContent = Files.readString(pomPath);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to read " + this.project.getFile(), (Exception)e);
                }
                pomContent = pomContent.replaceFirst(this.project.getVersion(), nextVersion);
                try (BufferedWriter writer = Files.newBufferedWriter(pomPath, new OpenOption[0]);){
                    writer.write(pomContent);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to write the POM to " + this.project.getFile(), (Exception)e);
                }
            }
        }
    }
}

