/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools;

import io.quarkus.platform.tools.MessageWriter;
import java.io.PrintStream;

public class DefaultMessageWriter
implements MessageWriter {
    protected final PrintStream out;
    protected boolean debug;

    public DefaultMessageWriter() {
        this(System.out);
    }

    public DefaultMessageWriter(PrintStream out) {
        this.out = out;
    }

    public DefaultMessageWriter setDebugEnabled(boolean debugEnabled) {
        this.debug = debugEnabled;
        return this;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public void info(String msg) {
        this.out.println(msg);
    }

    @Override
    public void error(String msg) {
        this.out.println(msg);
    }

    @Override
    public void debug(String msg) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.out.println("DEBUG: " + msg);
    }

    @Override
    public void warn(String msg) {
        this.out.println("WARN: " + msg);
    }
}

