/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json.impl;

import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoader;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoaderContext;
import io.quarkus.platform.descriptor.loader.json.ArtifactResolver;
import io.quarkus.platform.descriptor.loader.json.QuarkusJsonPlatformDescriptorLoaderContext;
import io.quarkus.platform.descriptor.loader.json.impl.QuarkusJsonPlatformDescriptorLoaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.maven.model.Dependency;

public class QuarkusJsonPlatformDescriptorLoaderBootstrap
implements QuarkusPlatformDescriptorLoader<QuarkusPlatformDescriptor, QuarkusPlatformDescriptorLoaderContext> {
    private static InputStream getResourceStream(String relativePath) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(relativePath);
        if (is == null) {
            throw new IllegalStateException("Failed to locate " + relativePath + " on the classpath");
        }
        return is;
    }

    public QuarkusPlatformDescriptor load(QuarkusPlatformDescriptorLoaderContext context) {
        Path resourceRoot;
        context.getMessageWriter().debug("Loading the default Quarkus Platform descriptor from the classpath");
        Properties props = new Properties();
        InputStream quarkusProps = QuarkusJsonPlatformDescriptorLoaderBootstrap.getResourceStream("quarkus.properties");
        try {
            props.load(quarkusProps);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load properties quarkus.properties", e);
        }
        try {
            resourceRoot = MojoUtils.getClassOrigin(QuarkusJsonPlatformDescriptorLoaderBootstrap.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to determine the resource root for " + this.getClass().getName(), e);
        }
        ArtifactResolver resolver = new ArtifactResolver(){

            public <T> T process(String groupId, String artifactId, String classifier, String type, String version, Function<Path, T> processor) {
                throw new UnsupportedOperationException();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public List<Dependency> getManagedDependencies(String groupId, String artifactId, String classifier, String type, String version) {
                if (Files.isDirectory(resourceRoot, new LinkOption[0])) {
                    return QuarkusJsonPlatformDescriptorLoaderBootstrap.readManagedDeps(resourceRoot.resolve("quarkus-bom/pom.xml"));
                }
                try (FileSystem fs = FileSystems.newFileSystem(resourceRoot, null);){
                    List list = QuarkusJsonPlatformDescriptorLoaderBootstrap.readManagedDeps(fs.getPath("/quarkus-bom/pom.xml", new String[0]));
                    return list;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to open " + resourceRoot, e);
                }
            }
        };
        return new QuarkusJsonPlatformDescriptorLoaderImpl().load(new QuarkusJsonPlatformDescriptorLoaderContext(resolver, context.getMessageWriter()){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public <T> T parseJson(Function<InputStream, T> parser) {
                if (Files.isDirectory(resourceRoot, new LinkOption[0])) {
                    return (T)QuarkusJsonPlatformDescriptorLoaderBootstrap.doParse(resourceRoot.resolve("quarkus-bom-descriptor/extensions.json"), parser);
                }
                try (FileSystem fs = FileSystems.newFileSystem(resourceRoot, null);){
                    Object object = QuarkusJsonPlatformDescriptorLoaderBootstrap.doParse(fs.getPath("/quarkus-bom-descriptor/extensions.json", new String[0]), parser);
                    return (T)object;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to open " + resourceRoot, e);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Dependency> readManagedDeps(Path pom) {
        if (!Files.exists(pom, new LinkOption[0])) {
            throw new IllegalStateException("Failed to locate " + pom);
        }
        try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
            List list = MojoUtils.readPom((InputStream)is).getDependencyManagement().getDependencies();
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read model of " + pom, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T doParse(Path p, Function<InputStream, T> parser) {
        if (!Files.exists(p, new LinkOption[0])) {
            throw new IllegalStateException("Path does not exist: " + p);
        }
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            InputStream inputStream = parser.apply(is);
            return (T)inputStream;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + p, e);
        }
    }
}

