/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.resolver.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoaderContext;
import io.quarkus.platform.descriptor.loader.json.ArtifactResolver;
import io.quarkus.platform.descriptor.loader.json.ClassPathResourceLoader;
import io.quarkus.platform.descriptor.loader.json.DirectoryResourceLoader;
import io.quarkus.platform.descriptor.loader.json.QuarkusJsonPlatformDescriptorLoader;
import io.quarkus.platform.descriptor.loader.json.QuarkusJsonPlatformDescriptorLoaderContext;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ZipResourceLoader;
import io.quarkus.platform.tools.DefaultMessageWriter;
import io.quarkus.platform.tools.MessageWriter;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class QuarkusJsonPlatformDescriptorResolver {
    public static final String PROP_PLATFORM_JSON_GROUP_ID = "quarkus.platform.json.groupId";
    public static final String PROP_PLATFORM_JSON_ARTIFACT_ID = "quarkus.platform.json.artifactId";
    public static final String PROP_PLATFORM_JSON_VERSION = "quarkus.platform.json.version";
    public static final String PROP_PLATFORM_JSON_VERSION_RANGE = "quarkus.platform.json.version-range";
    private String jsonGroupId;
    private String jsonArtifactId;
    private String jsonVersion;
    private String jsonVersionRange;
    private Path jsonDescriptor;
    private String bomGroupId;
    private String bomArtifactId;
    private String bomVersion;
    private String bomVersionRange;
    private AppModelResolver artifactResolver;
    private MessageWriter log;

    public static QuarkusJsonPlatformDescriptorResolver newInstance() {
        return new QuarkusJsonPlatformDescriptorResolver();
    }

    public QuarkusPlatformDescriptor resolveFromJson(String groupId, String artifactId, String version) {
        this.jsonGroupId = groupId;
        this.jsonArtifactId = artifactId;
        this.jsonVersion = version;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveLatestFromJson(String groupId, String artifactId, String versionRange) {
        this.jsonGroupId = groupId;
        this.jsonArtifactId = artifactId;
        this.jsonVersionRange = versionRange;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveFromJsonArtifactId(String artifactId) {
        this.jsonArtifactId = artifactId;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveFromJson(Path jsonDescriptor) {
        this.jsonDescriptor = jsonDescriptor;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveFromBom(String groupId, String artifactId, String version) {
        this.bomGroupId = groupId;
        this.bomArtifactId = artifactId;
        this.bomVersion = version;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveLatestFromBom(String groupId, String artifactId, String versionRange) {
        this.bomGroupId = groupId;
        this.bomArtifactId = artifactId;
        this.bomVersionRange = versionRange;
        return this.resolve();
    }

    public QuarkusJsonPlatformDescriptorResolver setArtifactResolver(AppModelResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
        return this;
    }

    public QuarkusJsonPlatformDescriptorResolver setMessageWriter(MessageWriter msgWriter) {
        this.log = msgWriter;
        return this;
    }

    public QuarkusPlatformDescriptor resolve() {
        if (this.log == null) {
            this.log = new DefaultMessageWriter();
        }
        if (this.artifactResolver == null) {
            try {
                this.artifactResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().build());
            }
            catch (AppModelResolverException e) {
                throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
            }
        }
        if (this.jsonDescriptor != null) {
            return this.loadFromFile(this.jsonDescriptor);
        }
        return this.resolveJsonDescriptor(this.artifactResolver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QuarkusPlatformDescriptor loadFromFile(Path jsonFile) {
        String quarkusCoreVersion;
        Throwable throwable;
        this.log.debug("Loading Quarkus platform descriptor from %s", new Object[]{jsonFile});
        if (!Files.exists(jsonFile, new LinkOption[0])) {
            throw new IllegalStateException("Failed to locate extensions JSON file at " + jsonFile);
        }
        try {
            throwable = null;
            try (BufferedReader reader = Files.newBufferedReader(jsonFile);){
                JsonObject jsonObject = Json.parse((Reader)reader).asObject();
                quarkusCoreVersion = jsonObject.getString("quarkus-core-version", null);
                if (quarkusCoreVersion == null) {
                    throw new IllegalStateException("Failed to determine the Quarkus Core version for " + jsonFile);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse extensions JSON file " + jsonFile);
        }
        this.log.debug("Loaded Quarkus platform is based on Quarkus %s", new Object[]{quarkusCoreVersion});
        try {
            throwable = null;
            try (InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);){
                QuarkusPlatformDescriptor quarkusPlatformDescriptor = this.loadPlatformDescriptor(this.artifactResolver, is, quarkusCoreVersion);
                return quarkusPlatformDescriptor;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + jsonFile, e);
        }
    }

    private QuarkusPlatformDescriptor resolveJsonDescriptor(AppModelResolver artifactResolver) {
        if (this.bomArtifactId != null) {
            return this.resolveJsonArtifactFromBom(artifactResolver);
        }
        return this.resolveJsonArtifactFromArgs(artifactResolver);
    }

    private QuarkusPlatformDescriptor resolveJsonArtifactFromArgs(AppModelResolver artifactResolver) {
        String jsonGroupId = this.jsonGroupId;
        String jsonArtifactId = this.jsonArtifactId;
        String jsonVersion = this.jsonVersion;
        if (jsonGroupId == null) {
            jsonGroupId = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_GROUP_ID, (String)"io.quarkus");
        }
        if (jsonArtifactId == null) {
            jsonArtifactId = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_ARTIFACT_ID, (String)"quarkus-universe-bom");
        }
        if (jsonVersion == null) {
            if (this.jsonVersionRange != null) {
                jsonVersion = this.resolveLatestJsonVersion(artifactResolver, jsonGroupId, jsonArtifactId, this.jsonVersionRange);
            } else {
                jsonVersion = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_VERSION);
                if (jsonVersion == null) {
                    jsonVersion = this.resolveLatestJsonVersion(artifactResolver, jsonGroupId, jsonArtifactId, this.jsonVersionRange);
                }
            }
        }
        return this.loadFromJsonArtifact(artifactResolver, new AppArtifact(jsonGroupId, jsonArtifactId, null, "json", jsonVersion));
    }

    private QuarkusPlatformDescriptor resolveJsonArtifactFromBom(AppModelResolver artifactResolver) {
        String bomGroupId = this.bomGroupId;
        if (bomGroupId == null) {
            bomGroupId = "io.quarkus";
        }
        if (this.bomArtifactId == null) {
            throw new IllegalStateException("Quarkus Platform BOM artifactId is missing");
        }
        if (this.bomVersion == null) {
            String bomVersionRange = this.bomVersionRange;
            if (bomVersionRange == null) {
                bomVersionRange = "[0,)";
            }
            AppArtifact bomArtifact = new AppArtifact(bomGroupId, this.bomArtifactId, null, "pom", bomVersionRange);
            this.log.debug("Resolving the latest version of %s", new Object[]{bomArtifact});
            try {
                this.bomVersion = artifactResolver.getLatestVersionFromRange(bomArtifact, bomVersionRange);
            }
            catch (AppModelResolverException e) {
                throw new IllegalStateException("Failed to resolve the latest version of " + bomArtifact, e);
            }
            throw new IllegalStateException("Quarkus Platform BOM version is missing");
        }
        this.log.debug("Resolving Quarkus platform descriptor from %s:%s::pom:%s", new Object[]{bomGroupId, this.bomArtifactId, this.bomVersion});
        InputStream bomIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("quarkus-bom/pom.xml");
        if (bomIs != null) {
            Model model;
            try {
                model = MojoUtils.readPom((InputStream)bomIs);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load POM model from the classpath for quarkus-bom/pom.xml", e);
            }
            finally {
                try {
                    bomIs.close();
                }
                catch (IOException iOException) {}
            }
            if (this.bomArtifactId.equals(model.getArtifactId())) {
                Parent bomParent = model.getParent();
                if (this.bomVersion.equals(model.getVersion() == null ? bomParent.getVersion() : model.getVersion()) && bomGroupId.equals(model.getGroupId() == null ? bomParent.getGroupId() : model.getGroupId())) {
                    this.log.debug("The requested Quarkus platform BOM version is available on the classpath");
                    InputStream jsonStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("quarkus-bom-descriptor/extensions.json");
                    if (jsonStream != null) {
                        InputStream quarkusPropsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("quarkus.properties");
                        if (quarkusPropsStream != null) {
                            Properties props = new Properties();
                            try {
                                props.load(quarkusPropsStream);
                            }
                            catch (IOException e) {
                                throw new IllegalStateException("Failed to load quarkus.properties from the classpath", e);
                            }
                            String quarkusVersion = props.getProperty("plugin-version");
                            if (quarkusVersion == null) {
                                throw new IllegalStateException("quarkus.properties loaded from the classpath is missing plugin-version property");
                            }
                            return this.loadPlatformDescriptor(artifactResolver, jsonStream, quarkusVersion);
                        }
                        this.log.debug("Failed to locate quarkus.properties on the classpath");
                    } else {
                        this.log.debug("Failed to locate Quarkus JSON platform descriptor on the classpath");
                    }
                }
            }
        }
        return this.loadFromJsonArtifact(artifactResolver, new AppArtifact(bomGroupId, this.bomArtifactId, null, "json", this.bomVersion));
    }

    private QuarkusPlatformDescriptor loadFromJsonArtifact(AppModelResolver artifactResolver, AppArtifact jsonArtifact) {
        try {
            this.log.debug("Attempting to resolve Quarkus JSON platform descriptor as %s", new Object[]{jsonArtifact});
            return this.loadFromFile(artifactResolver.resolve(jsonArtifact));
        }
        catch (Exception e) {
            this.log.debug("Failed to resolve %s due to %s", new Object[]{jsonArtifact, e});
            AppArtifact fallbackArtifact = new AppArtifact(jsonArtifact.getGroupId(), jsonArtifact.getArtifactId() + "-descriptor-json", null, "json", jsonArtifact.getVersion());
            this.log.debug("Attempting to resolve Quarkus JSON platform descriptor as %s", new Object[]{fallbackArtifact});
            try {
                return this.loadFromFile(artifactResolver.resolve(fallbackArtifact));
            }
            catch (Exception e1) {
                throw new IllegalStateException("Failed to resolve the JSON descriptor artifact as " + jsonArtifact, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuarkusPlatformDescriptor loadPlatformDescriptor(AppModelResolver mvn, final InputStream jsonStream, String quarkusCoreVersion) {
        ClassLoader jsonDescrLoaderCl = null;
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-platform-descriptor-json/pom.properties";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/maven/io.quarkus/quarkus-platform-descriptor-json/pom.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load META-INF/maven/io.quarkus/quarkus-platform-descriptor-json/pom.properties from the classpath", e);
            }
            String version = props.getProperty("version");
            if (quarkusCoreVersion.equals(version)) {
                jsonDescrLoaderCl = Thread.currentThread().getContextClassLoader();
            } else {
                this.log.debug("Version of the Quarkus JSON platform descriptor loader on the classpath is %s", new Object[]{version});
            }
        }
        ClassPathResourceLoader resourceLoader = null;
        boolean externalLoader = false;
        if (jsonDescrLoaderCl == null) {
            URL jsonDescrUrl;
            AppArtifact jsonDescrArtifact = new AppArtifact("io.quarkus", "quarkus-platform-descriptor-json", null, "jar", quarkusCoreVersion);
            this.log.debug("Resolving Quarkus JSON platform descriptor loader from %s", new Object[]{jsonDescrArtifact});
            try {
                Path path = mvn.resolve(jsonDescrArtifact);
                resourceLoader = Files.isDirectory(path, new LinkOption[0]) ? new DirectoryResourceLoader(path) : new ZipResourceLoader(path);
                this.log.debug("Quarkus platform resources will be loaded from %s", new Object[]{path});
                jsonDescrUrl = path.toUri().toURL();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to resolve " + jsonDescrArtifact, e);
            }
            jsonDescrLoaderCl = new URLClassLoader(new URL[]{jsonDescrUrl}, Thread.currentThread().getContextClassLoader());
            externalLoader = true;
        }
        try {
            Iterator<QuarkusJsonPlatformDescriptorLoader> i = ServiceLoader.load(QuarkusJsonPlatformDescriptorLoader.class, jsonDescrLoaderCl).iterator();
            if (!i.hasNext()) {
                throw new IllegalStateException("Failed to locate an implementation of " + QuarkusJsonPlatformDescriptorLoader.class.getName());
            }
            QuarkusJsonPlatformDescriptorLoader jsonDescrLoader = i.next();
            if (i.hasNext()) {
                throw new IllegalStateException("Located more than one implementation of " + QuarkusJsonPlatformDescriptorLoader.class.getName());
            }
            ArtifactResolver loaderResolver = new ArtifactResolver(){

                public <T> T process(String groupId, String artifactId, String classifier, String type, String version, Function<Path, T> processor) {
                    AppArtifact artifact = new AppArtifact(groupId, artifactId, classifier, type, version);
                    try {
                        return processor.apply(QuarkusJsonPlatformDescriptorResolver.this.artifactResolver.resolve(artifact));
                    }
                    catch (AppModelResolverException e) {
                        throw new IllegalStateException("Failed to resolve " + artifact, e);
                    }
                }

                public List<Dependency> getManagedDependencies(String groupId, String artifactId, String classifier, String type, String version) {
                    Path pom;
                    if (!"pom".equals(type)) {
                        throw new IllegalStateException("This implementation expects artifacts of type pom");
                    }
                    AppArtifact pomArtifact = new AppArtifact(groupId, artifactId, classifier, type, version);
                    try {
                        pom = QuarkusJsonPlatformDescriptorResolver.this.artifactResolver.resolve(pomArtifact);
                    }
                    catch (AppModelResolverException e) {
                        throw new IllegalStateException("Failed to resolve " + pomArtifact, e);
                    }
                    try {
                        return ModelUtils.readModel((Path)pom).getDependencyManagement().getDependencies();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to read model of " + pom, e);
                    }
                }
            };
            QuarkusPlatformDescriptor quarkusPlatformDescriptor = jsonDescrLoader.load((QuarkusPlatformDescriptorLoaderContext)new QuarkusJsonPlatformDescriptorLoaderContext(loaderResolver, (ResourceLoader)(resourceLoader == null ? new ClassPathResourceLoader() : resourceLoader), this.log){

                public <T> T parseJson(Function<InputStream, T> parser) {
                    return parser.apply(jsonStream);
                }
            });
            return quarkusPlatformDescriptor;
        }
        finally {
            if (externalLoader) {
                try {
                    ((URLClassLoader)jsonDescrLoaderCl).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String resolveLatestJsonVersion(AppModelResolver artifactResolver, String groupId, String artifactId, String versionRange) {
        if (versionRange == null && (versionRange = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_VERSION_RANGE)) == null) {
            versionRange = "[0,)";
        }
        try {
            return this.resolveLatestFromVersionRange(artifactResolver, groupId, artifactId, null, "json", versionRange);
        }
        catch (AppModelResolverException e) {
            throw new IllegalStateException("Failed to resolve the latest JSON platform version of " + groupId + ":" + artifactId + "::json:" + versionRange);
        }
    }

    private String resolveLatestFromVersionRange(AppModelResolver mvn, String groupId, String artifactId, String classifier, String type, String versionRange) throws AppModelResolverException {
        AppArtifact appArtifact = new AppArtifact(groupId, artifactId, classifier, type, versionRange);
        this.log.debug("Resolving the latest version of " + appArtifact);
        String latestVersion = mvn.getLatestVersionFromRange(appArtifact, versionRange);
        if (latestVersion == null) {
            throw new IllegalStateException("Failed to resolve the latest version of " + appArtifact);
        }
        return latestVersion;
    }
}

