/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.resolver.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.loader.QuarkusPlatformDescriptorLoaderContext;
import io.quarkus.platform.descriptor.loader.json.ArtifactResolver;
import io.quarkus.platform.descriptor.loader.json.ClassPathResourceLoader;
import io.quarkus.platform.descriptor.loader.json.DirectoryResourceLoader;
import io.quarkus.platform.descriptor.loader.json.QuarkusJsonPlatformDescriptorLoader;
import io.quarkus.platform.descriptor.loader.json.QuarkusJsonPlatformDescriptorLoaderContext;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ZipResourceLoader;
import io.quarkus.platform.descriptor.resolver.json.PlatformDescriptorLoadingException;
import io.quarkus.platform.descriptor.resolver.json.VersionNotAvailableException;
import io.quarkus.platform.tools.DefaultMessageWriter;
import io.quarkus.platform.tools.MessageWriter;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class QuarkusJsonPlatformDescriptorResolver {
    private static final String BUNDLED_QUARKUS_BOM_PATH = "quarkus-bom/pom.xml";
    private static final String BUNDLED_QUARKUS_PROPERTIES_PATH = "quarkus.properties";
    private static final String BUNDLED_EXTENSIONS_JSON_PATH = "quarkus-bom-descriptor/extensions.json";
    private static final String QUARKUS_PLATFORM_DESCRIPTOR_JSON = "quarkus-platform-descriptor-json";
    private static final String DEFAULT_QUARKUS_PLATFORM_VERSION_RANGE = "[1.0.0.CR2,2)";
    private static final String DEFAULT_NON_QUARKUS_VERSION_RANGE = "[0,)";
    public static final String PROP_PLATFORM_JSON_GROUP_ID = "quarkus.platform.json.groupId";
    public static final String PROP_PLATFORM_JSON_ARTIFACT_ID = "quarkus.platform.json.artifactId";
    public static final String PROP_PLATFORM_JSON_VERSION = "quarkus.platform.json.version";
    public static final String PROP_PLATFORM_JSON_VERSION_RANGE = "quarkus.platform.json.version-range";
    private String jsonGroupId;
    private String jsonArtifactId;
    private String jsonVersion;
    private String jsonVersionRange;
    private Path jsonDescriptor;
    private String bomGroupId;
    private String bomArtifactId;
    private String bomVersion;
    private String bomVersionRange;
    private AppModelResolver artifactResolver;
    private MessageWriter log;

    public static QuarkusJsonPlatformDescriptorResolver newInstance() {
        return new QuarkusJsonPlatformDescriptorResolver();
    }

    private static String getDefaultVersionRange(String groupId, String artifactId) {
        return "io.quarkus".equals(groupId) && ("quarkus-bom".equals(artifactId) || "quarkus-bom-descriptor".equals(artifactId) || "quarkus-universe-bom".equals(artifactId)) ? DEFAULT_QUARKUS_PLATFORM_VERSION_RANGE : DEFAULT_NON_QUARKUS_VERSION_RANGE;
    }

    public QuarkusPlatformDescriptor resolveFromJson(String groupId, String artifactId, String version) {
        this.jsonGroupId = groupId;
        this.jsonArtifactId = artifactId;
        this.jsonVersion = version;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveLatestFromJson(String groupId, String artifactId, String versionRange) {
        this.jsonGroupId = groupId;
        this.jsonArtifactId = artifactId;
        this.jsonVersionRange = versionRange;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveFromJsonArtifactId(String artifactId) {
        this.jsonArtifactId = artifactId;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveFromJson(Path jsonDescriptor) {
        this.jsonDescriptor = jsonDescriptor;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveFromBom(String groupId, String artifactId, String version) {
        this.bomGroupId = groupId;
        this.bomArtifactId = artifactId;
        this.bomVersion = version;
        return this.resolve();
    }

    public QuarkusPlatformDescriptor resolveLatestFromBom(String groupId, String artifactId, String versionRange) {
        this.bomGroupId = groupId;
        this.bomArtifactId = artifactId;
        this.bomVersionRange = versionRange;
        return this.resolve();
    }

    public QuarkusJsonPlatformDescriptorResolver setArtifactResolver(AppModelResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
        return this;
    }

    public QuarkusJsonPlatformDescriptorResolver setMessageWriter(MessageWriter msgWriter) {
        this.log = msgWriter;
        return this;
    }

    public QuarkusPlatformDescriptor resolve() {
        this.ensureLoggerInitialized();
        AppModelResolver artifactResolver = this.artifactResolver;
        if (artifactResolver == null) {
            try {
                artifactResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().build());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
            }
        }
        try {
            if (this.jsonDescriptor != null) {
                return this.loadFromFile(artifactResolver, this.jsonDescriptor);
            }
            return this.resolveJsonDescriptor(artifactResolver);
        }
        catch (PlatformDescriptorLoadingException | VersionNotAvailableException e) {
            throw new IllegalStateException("Failed to load Quarkus platform descriptor", e);
        }
    }

    public QuarkusPlatformDescriptor resolveBundled() {
        this.ensureLoggerInitialized();
        Model bundledBom = this.loadBundledPom();
        if (bundledBom == null) {
            throw new IllegalStateException("Failed to locate bundled Quarkus platform BOM on the classpath");
        }
        try {
            return this.loadFromBomCoords(null, QuarkusJsonPlatformDescriptorResolver.getGroupId(bundledBom), QuarkusJsonPlatformDescriptorResolver.getArtifactId(bundledBom), QuarkusJsonPlatformDescriptorResolver.getVersion(bundledBom), bundledBom);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load bundled Quarkus platform", e);
        }
    }

    private void ensureLoggerInitialized() {
        if (this.log == null) {
            this.log = new DefaultMessageWriter();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QuarkusPlatformDescriptor loadFromFile(AppModelResolver artifactResolver, Path jsonFile) throws PlatformDescriptorLoadingException, VersionNotAvailableException {
        String quarkusCoreVersion;
        Throwable throwable;
        this.log.debug("Loading Quarkus platform descriptor from %s", new Object[]{jsonFile});
        if (!Files.exists(jsonFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Failed to locate extensions JSON file at " + jsonFile);
        }
        try {
            throwable = null;
            try (BufferedReader reader = Files.newBufferedReader(jsonFile);){
                JsonObject jsonObject = Json.parse((Reader)reader).asObject();
                quarkusCoreVersion = jsonObject.getString("quarkus-core-version", null);
                if (quarkusCoreVersion == null) {
                    throw new IllegalStateException("Failed to determine the Quarkus Core version for " + jsonFile);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | RuntimeException e) {
            throw new PlatformDescriptorLoadingException("Failed to parse extensions JSON file " + jsonFile, e);
        }
        this.log.debug("Loaded Quarkus platform is based on Quarkus %s", new Object[]{quarkusCoreVersion});
        try {
            throwable = null;
            try (InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);){
                QuarkusPlatformDescriptor quarkusPlatformDescriptor = this.loadPlatformDescriptor(this.toLoaderResolver(artifactResolver), is, quarkusCoreVersion);
                return quarkusPlatformDescriptor;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (VersionNotAvailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PlatformDescriptorLoadingException("Failed to load Quarkus platform descriptor from " + jsonFile, e);
        }
    }

    private QuarkusPlatformDescriptor resolveJsonDescriptor(AppModelResolver artifactResolver) throws PlatformDescriptorLoadingException {
        if (!(ToolsUtils.isNullOrEmpty((String)this.bomGroupId) && ToolsUtils.isNullOrEmpty((String)this.bomArtifactId) && ToolsUtils.isNullOrEmpty((String)this.bomVersion) && ToolsUtils.isNullOrEmpty((String)this.bomVersionRange))) {
            if (this.log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Resolving Quarkus platform descriptor from the provided BOM coordinates ");
                QuarkusJsonPlatformDescriptorResolver.appendArg(buf, this.bomGroupId);
                buf.append(":");
                QuarkusJsonPlatformDescriptorResolver.appendArg(buf, this.bomArtifactId);
                buf.append(":");
                if (!ToolsUtils.isNullOrEmpty((String)this.bomVersion)) {
                    QuarkusJsonPlatformDescriptorResolver.appendArg(buf, this.bomVersion);
                } else if (!ToolsUtils.isNullOrEmpty((String)this.bomVersionRange)) {
                    QuarkusJsonPlatformDescriptorResolver.appendArg(buf, this.bomVersionRange);
                } else {
                    QuarkusJsonPlatformDescriptorResolver.appendArg(buf, this.bomVersion);
                }
                this.log.debug(buf.toString());
            }
            return this.resolveJsonArtifactFromBom(artifactResolver);
        }
        try {
            return this.resolveJsonArtifactFromArgs(artifactResolver);
        }
        catch (VersionNotAvailableException e) {
            QuarkusPlatformDescriptor platform = this.resolveJsonArtifactFromBom(artifactResolver);
            this.log.warn(e.getLocalizedMessage() + ", falling back to the bundled platform based on " + platform.getBomGroupId() + ":" + platform.getBomArtifactId() + "::pom:" + platform.getBomVersion() + " and Quarkus version " + platform.getQuarkusVersion());
            return platform;
        }
    }

    private static void appendArg(StringBuilder buf, String arg) {
        buf.append(ToolsUtils.isNullOrEmpty((String)arg) ? "<not-provided>" : arg);
    }

    private QuarkusPlatformDescriptor resolveJsonArtifactFromArgs(AppModelResolver artifactResolver) throws VersionNotAvailableException {
        String jsonGroupId = this.jsonGroupId;
        String jsonArtifactId = this.jsonArtifactId;
        String jsonVersion = this.jsonVersion;
        int defaultCoords = 0;
        if (jsonGroupId == null && (jsonGroupId = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_GROUP_ID)) == null) {
            jsonGroupId = "io.quarkus";
            ++defaultCoords;
        }
        if (jsonArtifactId == null && (jsonArtifactId = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_ARTIFACT_ID)) == null) {
            jsonArtifactId = "quarkus-universe-bom";
            ++defaultCoords;
        }
        if (jsonVersion == null) {
            if (this.jsonVersionRange != null) {
                try {
                    jsonVersion = this.resolveLatestJsonVersion(artifactResolver, jsonGroupId, jsonArtifactId, this.jsonVersionRange);
                }
                catch (VersionNotAvailableException e) {
                    throw new IllegalStateException("Failed to resolve the latest version of " + jsonGroupId + ":" + jsonArtifactId + " from the requested range " + this.jsonVersionRange, e);
                }
            } else {
                jsonVersion = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_VERSION);
                if (jsonVersion == null) {
                    jsonVersion = this.resolveLatestJsonVersion(artifactResolver, jsonGroupId, jsonArtifactId, null);
                    ++defaultCoords;
                }
            }
        }
        try {
            return this.loadFromJsonArtifact(artifactResolver, new AppArtifact(jsonGroupId, jsonArtifactId, null, "json", jsonVersion));
        }
        catch (VersionNotAvailableException e) {
            if (defaultCoords == 3) {
                throw e;
            }
            throw new IllegalStateException("Failed to resolve the JSON artifact with the requested coordinates", e);
        }
    }

    private QuarkusPlatformDescriptor resolveJsonArtifactFromBom(AppModelResolver artifactResolver) throws PlatformDescriptorLoadingException {
        String bomArtifactId;
        boolean tryingDefaultCoords = false;
        String bomGroupId = this.bomGroupId;
        if (bomGroupId == null) {
            bomGroupId = "io.quarkus";
            tryingDefaultCoords = true;
        }
        if ((bomArtifactId = this.bomArtifactId) == null) {
            bomArtifactId = "quarkus-universe-bom";
            tryingDefaultCoords = true;
        }
        String bomVersion = this.bomVersion;
        try {
            return this.loadFromBomCoords(artifactResolver, bomGroupId, bomArtifactId, bomVersion, null);
        }
        catch (VersionNotAvailableException e) {
            if (!tryingDefaultCoords) {
                throw new IllegalStateException("Failed to resolve the platform BOM using the provided coordinates", e);
            }
            this.log.debug("Failed to resolve Quarkus platform BOM using the default coordinates, falling back to the bundled Quarkus platform artifacts");
            Model bundledBom = this.loadBundledPom();
            bomGroupId = this.bomGroupId;
            if (bomGroupId != null) {
                if (!bomGroupId.equals(QuarkusJsonPlatformDescriptorResolver.getGroupId(bundledBom))) {
                    throw new IllegalStateException("Failed to resolve Quarkus platform using the requested BOM groupId " + bomGroupId);
                }
            } else {
                bomGroupId = QuarkusJsonPlatformDescriptorResolver.getGroupId(bundledBom);
            }
            if (bomGroupId == null) {
                this.failedDetermineDefaultPlatformCoords();
            }
            if ((bomArtifactId = this.bomArtifactId) != null) {
                if (!bomArtifactId.equals(QuarkusJsonPlatformDescriptorResolver.getArtifactId(bundledBom))) {
                    throw new IllegalStateException("Failed to resolve Quarkus platform using the requested BOM artifactId " + bomArtifactId);
                }
            } else {
                bomArtifactId = QuarkusJsonPlatformDescriptorResolver.getArtifactId(bundledBom);
            }
            if (bomArtifactId == null) {
                this.failedDetermineDefaultPlatformCoords();
            }
            if ((bomVersion = this.bomVersion) != null) {
                if (!bomVersion.equals(QuarkusJsonPlatformDescriptorResolver.getVersion(bundledBom))) {
                    throw new IllegalStateException("Failed to resolve Quarkus platform using the requested BOM version " + bomVersion);
                }
            } else if (this.bomVersionRange == null) {
                bomVersion = QuarkusJsonPlatformDescriptorResolver.getVersion(bundledBom);
            }
            try {
                return this.loadFromBomCoords(artifactResolver, bomGroupId, bomArtifactId, bomVersion, bundledBom);
            }
            catch (VersionNotAvailableException e2) {
                throw new IllegalStateException("Failed to load the bundled platform artifacts", e2);
            }
        }
    }

    private QuarkusPlatformDescriptor loadFromBomCoords(AppModelResolver artifactResolver, String bomGroupId, String bomArtifactId, String bomVersion, Model bundledBom) throws PlatformDescriptorLoadingException, VersionNotAvailableException {
        if (bomVersion == null) {
            String bomVersionRange = this.bomVersionRange;
            if (bomVersionRange == null) {
                bomVersionRange = QuarkusJsonPlatformDescriptorResolver.getDefaultVersionRange(bomGroupId, bomArtifactId);
            }
            AppArtifact bomArtifact = new AppArtifact(bomGroupId, bomArtifactId, null, "pom", bomVersionRange);
            this.log.debug("Resolving the latest version of %s", new Object[]{bomArtifact});
            try {
                bomVersion = artifactResolver.getLatestVersionFromRange(bomArtifact, bomVersionRange);
            }
            catch (AppModelResolverException e) {
                throw new VersionNotAvailableException("Failed to resolve the latest version of " + bomArtifact, e);
            }
            if (bomVersion == null) {
                throw new VersionNotAvailableException("Failed to resolve the latest version of " + bomArtifact);
            }
        }
        this.log.debug("Resolving Quarkus platform BOM %s:%s::pom:%s", new Object[]{bomGroupId, bomArtifactId, bomVersion});
        Model theBundledBom = this.loadBundledPomIfNull(bundledBom);
        if (theBundledBom != null && bomArtifactId.equals(QuarkusJsonPlatformDescriptorResolver.getArtifactId(theBundledBom)) && bomVersion.equals(QuarkusJsonPlatformDescriptorResolver.getVersion(theBundledBom)) && bomGroupId.equals(QuarkusJsonPlatformDescriptorResolver.getGroupId(theBundledBom))) {
            this.log.debug("The requested Quarkus platform BOM version is available on the classpath");
            InputStream jsonStream = QuarkusJsonPlatformDescriptorResolver.getCpResourceAsStream(BUNDLED_EXTENSIONS_JSON_PATH);
            if (jsonStream != null) {
                String quarkusVersion = QuarkusJsonPlatformDescriptorResolver.getBundledPlatformQuarkusVersionOrNull();
                if (quarkusVersion != null) {
                    return this.loadPlatformDescriptor(this.getBundledResolver(theBundledBom), jsonStream, quarkusVersion);
                }
                this.log.debug("Failed to locate quarkus.properties on the classpath");
            } else {
                this.log.debug("Failed to locate Quarkus platform descriptor on the classpath");
            }
        }
        return this.loadFromJsonArtifact(artifactResolver, new AppArtifact(bomGroupId, bomArtifactId, null, "json", bomVersion));
    }

    private void failedDetermineDefaultPlatformCoords() {
        throw new IllegalStateException("Failed to determine the Maven coordinates of the default Quarkus platform");
    }

    private QuarkusPlatformDescriptor loadFromJsonArtifact(AppModelResolver artifactResolver, AppArtifact jsonArtifact) throws VersionNotAvailableException {
        try {
            this.log.debug("Attempting to resolve Quarkus platform descriptor %s", new Object[]{jsonArtifact});
            return this.loadFromFile(artifactResolver, artifactResolver.resolve(jsonArtifact));
        }
        catch (PlatformDescriptorLoadingException e) {
            throw new IllegalStateException("Failed to load Quarkus platform descriptor " + jsonArtifact, e);
        }
        catch (Exception e) {
            this.log.debug("Failed to load %s due to %s", new Object[]{jsonArtifact, e.getLocalizedMessage()});
            AppArtifact fallbackArtifact = new AppArtifact(jsonArtifact.getGroupId(), jsonArtifact.getArtifactId() + "-descriptor-json", null, "json", jsonArtifact.getVersion());
            this.log.debug("Attempting to resolve Quarkus platform descriptor %s", new Object[]{fallbackArtifact});
            try {
                return this.loadFromFile(artifactResolver, artifactResolver.resolve(fallbackArtifact));
            }
            catch (AppModelResolverException e1) {
                throw new VersionNotAvailableException("Failed to resolve Quarkus platform descriptor " + jsonArtifact, e);
            }
            catch (Exception e2) {
                throw new IllegalStateException("Failed to load Quarkus platform descriptor " + jsonArtifact, e);
            }
        }
    }

    private QuarkusPlatformDescriptor loadPlatformDescriptor(ArtifactResolver mvn, final InputStream jsonStream, String quarkusCoreVersion) throws PlatformDescriptorLoadingException, VersionNotAvailableException {
        ClassLoader jsonDescrLoaderCl = null;
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-platform-descriptor-json/pom.properties";
        InputStream is = QuarkusJsonPlatformDescriptorResolver.getCpResourceAsStream("META-INF/maven/io.quarkus/quarkus-platform-descriptor-json/pom.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new PlatformDescriptorLoadingException("Failed to load META-INF/maven/io.quarkus/quarkus-platform-descriptor-json/pom.properties from the classpath", e);
            }
            String version = props.getProperty("version");
            if (quarkusCoreVersion.equals(version)) {
                jsonDescrLoaderCl = Thread.currentThread().getContextClassLoader();
            } else {
                this.log.debug("Version of the Quarkus JSON platform descriptor loader on the classpath is %s", new Object[]{version});
            }
        }
        ClassPathResourceLoader resourceLoader = null;
        boolean externalLoader = false;
        if (jsonDescrLoaderCl == null) {
            URL jsonDescrUrl;
            AppArtifact jsonDescrArtifact = new AppArtifact("io.quarkus", QUARKUS_PLATFORM_DESCRIPTOR_JSON, null, "jar", quarkusCoreVersion);
            this.log.debug("Resolving Quarkus JSON platform descriptor loader %s", new Object[]{jsonDescrArtifact});
            try {
                Path path = (Path)mvn.process(jsonDescrArtifact.getGroupId(), jsonDescrArtifact.getArtifactId(), jsonDescrArtifact.getClassifier(), jsonDescrArtifact.getType(), jsonDescrArtifact.getVersion(), p -> p);
                resourceLoader = Files.isDirectory(path, new LinkOption[0]) ? new DirectoryResourceLoader(path) : new ZipResourceLoader(path);
                this.log.debug("Quarkus platform resources will be loaded from %s", new Object[]{path});
                jsonDescrUrl = path.toUri().toURL();
            }
            catch (AppModelResolverException e) {
                throw new VersionNotAvailableException("Failed to resolve " + jsonDescrArtifact, e);
            }
            catch (Exception e) {
                throw new PlatformDescriptorLoadingException("Failed to resolve " + jsonDescrArtifact, e);
            }
            jsonDescrLoaderCl = new URLClassLoader(new URL[]{jsonDescrUrl}, Thread.currentThread().getContextClassLoader());
            externalLoader = true;
        }
        try {
            Iterator<QuarkusJsonPlatformDescriptorLoader> i = ServiceLoader.load(QuarkusJsonPlatformDescriptorLoader.class, jsonDescrLoaderCl).iterator();
            if (!i.hasNext()) {
                throw new PlatformDescriptorLoadingException("Failed to locate an implementation of " + QuarkusJsonPlatformDescriptorLoader.class.getName());
            }
            QuarkusJsonPlatformDescriptorLoader jsonDescrLoader = i.next();
            if (i.hasNext()) {
                throw new PlatformDescriptorLoadingException("Located more than one implementation of " + QuarkusJsonPlatformDescriptorLoader.class.getName());
            }
            try {
                QuarkusPlatformDescriptor e = jsonDescrLoader.load((QuarkusPlatformDescriptorLoaderContext)new QuarkusJsonPlatformDescriptorLoaderContext(mvn, (ResourceLoader)(resourceLoader == null ? new ClassPathResourceLoader() : resourceLoader), this.log){

                    public <T> T parseJson(Function<InputStream, T> parser) {
                        return parser.apply(jsonStream);
                    }
                });
                return e;
            }
            catch (Exception e) {
                throw new PlatformDescriptorLoadingException("Failed to load Quarkus platform descriptor", e);
            }
        }
        finally {
            if (externalLoader) {
                try {
                    ((URLClassLoader)jsonDescrLoaderCl).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String resolveLatestJsonVersion(AppModelResolver artifactResolver, String groupId, String artifactId, String versionRange) throws VersionNotAvailableException {
        if (versionRange == null && (versionRange = ToolsUtils.getProperty((String)PROP_PLATFORM_JSON_VERSION_RANGE)) == null) {
            versionRange = QuarkusJsonPlatformDescriptorResolver.getDefaultVersionRange(groupId, artifactId);
        }
        try {
            return this.resolveLatestFromVersionRange(artifactResolver, groupId, artifactId, null, "json", versionRange);
        }
        catch (AppModelResolverException e) {
            throw new VersionNotAvailableException("Failed to resolve the latest JSON platform version of " + groupId + ":" + artifactId + "::json:" + versionRange);
        }
    }

    private String resolveLatestFromVersionRange(AppModelResolver mvn, String groupId, String artifactId, String classifier, String type, String versionRange) throws AppModelResolverException, VersionNotAvailableException {
        AppArtifact appArtifact = new AppArtifact(groupId, artifactId, classifier, type, versionRange);
        this.log.debug("Resolving the latest version of %s", new Object[]{appArtifact});
        String latestVersion = mvn.getLatestVersionFromRange(appArtifact, versionRange);
        if (latestVersion == null) {
            throw new VersionNotAvailableException("Failed to resolve the latest version of " + appArtifact);
        }
        return latestVersion;
    }

    private Model loadBundledPomIfNull(Model model) {
        return model == null ? this.loadBundledPom() : model;
    }

    private Model loadBundledPom() {
        InputStream bomIs = QuarkusJsonPlatformDescriptorResolver.getCpResourceAsStream(BUNDLED_QUARKUS_BOM_PATH);
        if (bomIs == null) {
            this.log.debug("Failed to locate quarkus-bom/pom.xml on the classpath");
            return null;
        }
        try {
            Model model = MojoUtils.readPom((InputStream)bomIs);
            return model;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load POM model from the classpath for quarkus-bom/pom.xml", e);
        }
        finally {
            try {
                bomIs.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getGroupId(Model model) {
        if (model == null) {
            return null;
        }
        String groupId = model.getGroupId();
        if (groupId != null) {
            return groupId;
        }
        Parent parent = model.getParent();
        if (parent != null && (groupId = parent.getGroupId()) != null) {
            return groupId;
        }
        throw new IllegalStateException("Failed to determine the groupId for the POM of " + model.getArtifactId());
    }

    private static String getArtifactId(Model model) {
        if (model == null) {
            return null;
        }
        return model.getArtifactId();
    }

    private static String getVersion(Model model) {
        if (model == null) {
            return null;
        }
        String version = model.getVersion();
        if (version != null) {
            return version;
        }
        Parent parent = model.getParent();
        if (parent != null && (version = parent.getVersion()) != null) {
            return version;
        }
        throw new IllegalStateException("Failed to determine the version for the POM of " + model.getArtifactId());
    }

    private ArtifactResolver toLoaderResolver(final AppModelResolver mvn) {
        return new ArtifactResolver(){

            public <T> T process(String groupId, String artifactId, String classifier, String type, String version, Function<Path, T> processor) throws AppModelResolverException {
                AppArtifact artifact = new AppArtifact(groupId, artifactId, classifier, type, version);
                return processor.apply(mvn.resolve(artifact));
            }

            public List<Dependency> getManagedDependencies(String groupId, String artifactId, String classifier, String type, String version) {
                Path pom;
                if (!"pom".equals(type)) {
                    throw new IllegalStateException("This implementation expects artifacts of type pom");
                }
                AppArtifact pomArtifact = new AppArtifact(groupId, artifactId, classifier, type, version);
                try {
                    pom = mvn.resolve(pomArtifact);
                }
                catch (AppModelResolverException e) {
                    throw new IllegalStateException("Failed to resolve " + pomArtifact, e);
                }
                try {
                    return ModelUtils.readModel((Path)pom).getDependencyManagement().getDependencies();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read model of " + pom, e);
                }
            }
        };
    }

    private ArtifactResolver getBundledResolver(final Model model) {
        Path platformResources;
        try {
            platformResources = MojoUtils.getResourceOrigin((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)BUNDLED_QUARKUS_BOM_PATH);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to locate the bundled Quarkus platform resources on the classpath");
        }
        ArtifactResolver bundledResolver = new ArtifactResolver(){

            public <T> T process(String groupId, String artifactId, String classifier, String type, String version, Function<Path, T> processor) {
                if (QuarkusJsonPlatformDescriptorResolver.QUARKUS_PLATFORM_DESCRIPTOR_JSON.equals(artifactId) && "io.quarkus".equals(groupId) && "jar".equals(type) && StringUtils.isEmpty((CharSequence)classifier) && version.equals(QuarkusJsonPlatformDescriptorResolver.getBundledPlatformQuarkusVersionOrNull())) {
                    return processor.apply(platformResources);
                }
                throw new IllegalArgumentException("Unexpected artifact coordinates " + groupId + ":" + artifactId + ":" + classifier + ":" + type + ":" + version);
            }

            public List<Dependency> getManagedDependencies(String groupId, String artifactId, String classifier, String type, String version) {
                if (QuarkusJsonPlatformDescriptorResolver.getArtifactId(model).equals(artifactId) && "pom".equals(type) && QuarkusJsonPlatformDescriptorResolver.getVersion(model).equals(version) && StringUtils.isEmpty((CharSequence)classifier) && QuarkusJsonPlatformDescriptorResolver.getGroupId(model).equals(groupId)) {
                    return model.getDependencyManagement().getDependencies();
                }
                throw new IllegalArgumentException("Expected " + QuarkusJsonPlatformDescriptorResolver.getGroupId(model) + ":" + QuarkusJsonPlatformDescriptorResolver.getArtifactId(model) + "::pom:" + QuarkusJsonPlatformDescriptorResolver.getVersion(model) + " but received " + groupId + ":" + artifactId + ":" + classifier + ":" + type + ":" + version);
            }
        };
        return bundledResolver;
    }

    private static String getBundledPlatformQuarkusVersionOrNull() {
        InputStream quarkusPropsStream = QuarkusJsonPlatformDescriptorResolver.getCpResourceAsStream(BUNDLED_QUARKUS_PROPERTIES_PATH);
        if (quarkusPropsStream == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(quarkusPropsStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load quarkus.properties from the classpath", e);
        }
        return ToolsUtils.requireQuarkusCoreVersion((Properties)props);
    }

    private static InputStream getCpResourceAsStream(String name) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
    }
}

