/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.quartz.deployment.QuartzJDBCDriverDialectBuildItem;
import io.quarkus.quartz.runtime.QuarkusQuartzConnectionPoolProvider;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzExtensionPointConfig;
import io.quarkus.quartz.runtime.QuartzRecorder;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.QuartzScheduler;
import io.quarkus.quartz.runtime.QuartzSupport;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.inject.Singleton;
import org.jboss.jandex.DotName;
import org.quartz.Job;
import org.quartz.JobListener;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.DB2v8Delegate;
import org.quartz.impl.jdbcjobstore.HSQLDBDelegate;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.SimpleInstanceIdGenerator;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.SchedulerPlugin;

public class QuartzProcessor {
    private static final DotName JOB = DotName.createSimple((String)Job.class.getName());

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.QUARTZ);
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{QuartzScheduler.class});
    }

    @BuildStep
    AutoAddScopeBuildItem addScope() {
        return AutoAddScopeBuildItem.builder().implementsInterface(JOB).requiresContainerServices().defaultScope(BuiltinScope.DEPENDENT).build();
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem connectionProxy(QuartzBuildTimeConfig config) {
        if (config.storeType.isDbStore()) {
            return new NativeImageProxyDefinitionBuildItem(new String[]{Connection.class.getName()});
        }
        return null;
    }

    @BuildStep
    QuartzJDBCDriverDialectBuildItem driver(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, QuartzBuildTimeConfig config, Capabilities capabilities) {
        if (!config.storeType.isDbStore()) {
            if (config.clustered) {
                throw new ConfigurationError("Clustered jobs configured with unsupported job store option");
            }
            return new QuartzJDBCDriverDialectBuildItem(Optional.empty());
        }
        if (capabilities.isMissing(Capability.AGROAL)) {
            throw new ConfigurationError("The Agroal extension is missing and it is required when a Quartz JDBC store is used.");
        }
        Optional<JdbcDataSourceBuildItem> selectedJdbcDataSourceBuildItem = jdbcDataSourceBuildItems.stream().filter(i -> config.dataSourceName.isPresent() ? ((String)config.dataSourceName.get()).equals(i.getName()) : i.isDefault()).findFirst();
        if (!selectedJdbcDataSourceBuildItem.isPresent()) {
            String message = String.format("JDBC Store configured but the '%s' datasource is not configured properly. You can configure your datasource by following the guide available at: https://quarkus.io/guides/datasource", config.dataSourceName.isPresent() ? config.dataSourceName.get() : "default");
            throw new ConfigurationError(message);
        }
        return new QuartzJDBCDriverDialectBuildItem(Optional.of(this.guessDriver(selectedJdbcDataSourceBuildItem)));
    }

    private String guessDriver(Optional<JdbcDataSourceBuildItem> jdbcDataSource) {
        if (!jdbcDataSource.isPresent()) {
            return StdJDBCDelegate.class.getName();
        }
        String dataSourceKind = jdbcDataSource.get().getDbKind();
        if (DatabaseKind.isPostgreSQL((String)dataSourceKind)) {
            return PostgreSQLDelegate.class.getName();
        }
        if (DatabaseKind.isH2((String)dataSourceKind)) {
            return HSQLDBDelegate.class.getName();
        }
        if (DatabaseKind.isMsSQL((String)dataSourceKind)) {
            return MSSQLDelegate.class.getName();
        }
        if (DatabaseKind.isDB2((String)dataSourceKind)) {
            return DB2v8Delegate.class.getName();
        }
        return StdJDBCDelegate.class.getName();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses(QuartzBuildTimeConfig config, QuartzJDBCDriverDialectBuildItem driverDialect) {
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleThreadPool.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleInstanceIdGenerator.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(false, false, new String[]{CascadingClassLoadHelper.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, true, new String[]{config.storeType.clazz}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(false, false, new Class[]{InitThreadContextClassLoadHelper.class}));
        if (config.storeType.isDbStore()) {
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{JobStoreSupport.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, true, new String[]{Connection.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{AbstractTrigger.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleTriggerImpl.class.getName()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{driverDialect.getDriver().get()}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, true, new String[]{"io.quarkus.quartz.runtime.QuartzScheduler$InvokerJob"}));
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{QuarkusQuartzConnectionPoolProvider.class.getName()}));
        }
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.triggerListeners, TriggerListener.class));
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.jobListeners, JobListener.class));
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.plugins, SchedulerPlugin.class));
        return reflectiveClasses;
    }

    private List<ReflectiveClassBuildItem> getAdditionalConfigurationReflectiveClasses(Map<String, QuartzExtensionPointConfig> config, Class<?> clazz) {
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        for (QuartzExtensionPointConfig props : config.values()) {
            try {
                if (!clazz.isAssignableFrom(Class.forName(props.clazz, false, Thread.currentThread().getContextClassLoader()))) {
                    throw new IllegalArgumentException(String.format("%s does not implements %s", props.clazz, clazz));
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{props.clazz}));
        }
        return reflectiveClasses;
    }

    @BuildStep
    public List<LogCleanupFilterBuildItem> logCleanup(QuartzBuildTimeConfig config) {
        ArrayList<LogCleanupFilterBuildItem> logCleanUps = new ArrayList<LogCleanupFilterBuildItem>();
        logCleanUps.add(new LogCleanupFilterBuildItem(StdSchedulerFactory.class.getName(), Level.INFO, new String[]{"Quartz scheduler version:", "Using default implementation for", "Quartz scheduler '"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(org.quartz.core.QuartzScheduler.class.getName(), Level.INFO, new String[]{"Quartz Scheduler v", "JobFactory set to:", "Scheduler meta-data:", "Scheduler "}));
        logCleanUps.add(new LogCleanupFilterBuildItem(config.storeType.clazz, new String[]{config.storeType.simpleName + " initialized.", "Handling", "Using db table-based data access locking", "JDBCJobStore threads will inherit ContextClassLoader of thread", "Couldn't\u00a0rollback\u00a0jdbc\u00a0connection", "Database connection shutdown unsuccessful"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(SchedulerSignalerImpl.class.getName(), new String[]{"Initialized Scheduler Signaller of type"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(QuartzSchedulerThread.class.getName(), new String[]{"QuartzSchedulerThread Inheriting ContextClassLoader"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(SimpleThreadPool.class.getName(), new String[]{"Job execution threads will use class loader of thread"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(AttributeRestoringConnectionInvocationHandler.class.getName(), new String[]{"Failed restore connection's original"}));
        return logCleanUps;
    }

    @BuildStep
    public void start(BuildProducer<ServiceStartBuildItem> serviceStart, List<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("quartz"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void quartzSupportBean(QuartzRuntimeConfig runtimeConfig, QuartzBuildTimeConfig buildTimeConfig, QuartzRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, QuartzJDBCDriverDialectBuildItem driverDialect) {
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuartzSupport.class).scope(Singleton.class)).setRuntimeInit().supplier(recorder.quartzSupportSupplier(runtimeConfig, buildTimeConfig, driverDialect.getDriver())).done());
    }
}

