/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.quartz.Nonconcurrent;
import io.quarkus.quartz.deployment.QuartzJDBCDriverDialectBuildItem;
import io.quarkus.quartz.runtime.QuarkusQuartzConnectionPoolProvider;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzExtensionPointConfig;
import io.quarkus.quartz.runtime.QuartzRecorder;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.QuartzSchedulerImpl;
import io.quarkus.quartz.runtime.QuartzSupport;
import io.quarkus.quartz.runtime.jdbc.QuarkusDBv8Delegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusHSQLDBDelegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusMSSQLDelegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusPostgreSQLDelegate;
import io.quarkus.quartz.runtime.jdbc.QuarkusStdJDBCDelegate;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.deployment.SchedulerImplementationBuildItem;
import jakarta.inject.Singleton;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobListener;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.AttributeRestoringConnectionInvocationHandler;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.SimpleInstanceIdGenerator;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.InstanceIdGenerator;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.ThreadPool;
import org.quartz.utils.DirtyFlagMap;
import org.quartz.utils.StringKeyDirtyFlagMap;

public class QuartzProcessor {
    private static final DotName JOB = DotName.createSimple((String)Job.class.getName());
    private static final DotName DELEGATE_POSTGRESQL = DotName.createSimple((String)QuarkusPostgreSQLDelegate.class.getName());
    private static final DotName DELEGATE_DB2V8 = DotName.createSimple((String)QuarkusDBv8Delegate.class.getName());
    private static final DotName DELEGATE_HSQLDB = DotName.createSimple((String)QuarkusHSQLDBDelegate.class.getName());
    private static final DotName DELEGATE_MSSQL = DotName.createSimple((String)QuarkusMSSQLDelegate.class.getName());
    private static final DotName DELEGATE_STDJDBC = DotName.createSimple((String)QuarkusStdJDBCDelegate.class.getName());
    private static final DotName NONCONCURRENT = DotName.createSimple(Nonconcurrent.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.QUARTZ);
    }

    @BuildStep
    SchedulerImplementationBuildItem implementation() {
        return new SchedulerImplementationBuildItem("QUARTZ", DotName.createSimple(QuartzSchedulerImpl.class), 1);
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{QuartzSchedulerImpl.class});
    }

    @BuildStep
    AutoAddScopeBuildItem addScope() {
        return AutoAddScopeBuildItem.builder().implementsInterface(JOB).requiresContainerServices().defaultScope(BuiltinScope.DEPENDENT).build();
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem connectionProxy(QuartzBuildTimeConfig config) {
        if (config.storeType().isDbStore()) {
            return new NativeImageProxyDefinitionBuildItem(new String[]{Connection.class.getName()});
        }
        return null;
    }

    @BuildStep
    QuartzJDBCDriverDialectBuildItem driver(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, QuartzBuildTimeConfig config, Capabilities capabilities, CombinedIndexBuildItem indexBuildItem) {
        if (!config.storeType().isDbStore()) {
            if (config.clustered()) {
                throw new ConfigurationException("Clustered jobs configured with unsupported job store option");
            }
            return new QuartzJDBCDriverDialectBuildItem(Optional.empty());
        }
        if (capabilities.isMissing("io.quarkus.agroal")) {
            throw new ConfigurationException("The Agroal extension is missing and it is required when a Quartz JDBC store is used.");
        }
        Optional<String> driverDelegate = config.driverDelegate();
        if (driverDelegate.isPresent()) {
            IndexView indexView = indexBuildItem.getIndex();
            ClassInfo customDelegate = indexView.getClassByName((String)driverDelegate.get());
            if (customDelegate == null) {
                String message = String.format("Custom JDBC delegate implementation class '%s' was not found in Jandex index. Make sure the dependency containing this class has proper marker file enabling discovery. Alternatively, you can index a dependency using IndexDependencyBuildItem.", driverDelegate.get());
                throw new ConfigurationException(message);
            }
            boolean implementsKnownDelegate = false;
            block0: for (DotName knownImplementation : Set.of(DELEGATE_MSSQL, DELEGATE_POSTGRESQL, DELEGATE_DB2V8, DELEGATE_STDJDBC, DELEGATE_HSQLDB)) {
                for (ClassInfo classInfo : indexView.getAllKnownSubclasses(knownImplementation)) {
                    if (!classInfo.name().equals((Object)customDelegate.name())) continue;
                    implementsKnownDelegate = true;
                    continue block0;
                }
            }
            if (!implementsKnownDelegate) {
                String message = String.format("Custom JDBC delegate implementation with name '%s' needs to be a subclass of one of the existing Quarkus delegates such as io.quarkus.quartz.runtime.jdbc.QuarkusPostgreSQLDelegate.", driverDelegate.get());
                throw new ConfigurationException(message);
            }
        } else {
            Optional<JdbcDataSourceBuildItem> selectedJdbcDataSourceBuildItem = jdbcDataSourceBuildItems.stream().filter(i -> config.dataSourceName().isPresent() ? ((String)config.dataSourceName().get()).equals(i.getName()) : i.isDefault()).findFirst();
            if (!selectedJdbcDataSourceBuildItem.isPresent()) {
                String message = String.format("JDBC Store configured but the '%s' datasource is not configured properly. You can configure your datasource by following the guide available at: https://quarkus.io/guides/datasource", config.dataSourceName().isPresent() ? config.dataSourceName().get() : "default");
                throw new ConfigurationException(message);
            }
            driverDelegate = Optional.of(this.guessDriver(selectedJdbcDataSourceBuildItem));
        }
        return new QuartzJDBCDriverDialectBuildItem(driverDelegate);
    }

    private String guessDriver(Optional<JdbcDataSourceBuildItem> jdbcDataSource) {
        if (!jdbcDataSource.isPresent()) {
            return QuarkusStdJDBCDelegate.class.getName();
        }
        String dataSourceKind = jdbcDataSource.get().getDbKind();
        if (DatabaseKind.isPostgreSQL((String)dataSourceKind)) {
            return QuarkusPostgreSQLDelegate.class.getName();
        }
        if (DatabaseKind.isH2((String)dataSourceKind)) {
            return QuarkusHSQLDBDelegate.class.getName();
        }
        if (DatabaseKind.isMsSQL((String)dataSourceKind)) {
            return QuarkusMSSQLDelegate.class.getName();
        }
        if (DatabaseKind.isDB2((String)dataSourceKind)) {
            return QuarkusDBv8Delegate.class.getName();
        }
        return QuarkusStdJDBCDelegate.class.getName();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses(QuartzBuildTimeConfig config, QuartzJDBCDriverDialectBuildItem driverDialect) {
        Class<?> threadPoolClass;
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        if (config.serializeJobData()) {
            reflectiveClasses.add(ReflectiveClassBuildItem.builder((Class[])new Class[]{String.class, JobDataMap.class, DirtyFlagMap.class, StringKeyDirtyFlagMap.class, HashMap.class}).reason(this.getClass().getName()).serialization(true).build());
        }
        try {
            threadPoolClass = Class.forName(config.threadPoolClass(), false, Thread.currentThread().getContextClassLoader());
            if (!ThreadPool.class.isAssignableFrom(threadPoolClass)) {
                throw new ConfigurationException("Thread pool class does not implement ThreadPool interface spi: " + config.threadPoolClass());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Thread pool class not found: " + config.threadPoolClass());
        }
        reflectiveClasses.add(ReflectiveClassBuildItem.builder((Class[])new Class[]{threadPoolClass, SimpleInstanceIdGenerator.class}).reason(this.getClass().getName()).methods().build());
        reflectiveClasses.add(ReflectiveClassBuildItem.builder((Class[])new Class[]{CascadingClassLoadHelper.class, InitThreadContextClassLoadHelper.class}).reason(this.getClass().getName()).build());
        reflectiveClasses.add(ReflectiveClassBuildItem.builder((String[])new String[]{config.storeType().clazz}).reason(this.getClass().getName()).methods().fields().build());
        if (config.storeType().isDbStore()) {
            reflectiveClasses.add(ReflectiveClassBuildItem.builder((Class[])new Class[]{JobStoreSupport.class, AbstractTrigger.class, SimpleTriggerImpl.class, QuarkusQuartzConnectionPoolProvider.class}).reason(this.getClass().getName()).methods().build());
            reflectiveClasses.add(ReflectiveClassBuildItem.builder((Class[])new Class[]{Connection.class}).reason(this.getClass().getName()).methods().fields().build());
            reflectiveClasses.add(ReflectiveClassBuildItem.builder((String[])new String[]{driverDialect.getDriver().get()}).reason(this.getClass().getName()).methods().build());
            reflectiveClasses.add(ReflectiveClassBuildItem.builder((String[])new String[]{"io.quarkus.quartz.runtime.QuartzSchedulerImpl$InvokerJob"}).reason(this.getClass().getName()).methods().fields().build());
        }
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.instanceIdGenerators(), InstanceIdGenerator.class));
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.triggerListeners(), TriggerListener.class));
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.jobListeners(), JobListener.class));
        reflectiveClasses.addAll(this.getAdditionalConfigurationReflectiveClasses(config.plugins(), SchedulerPlugin.class));
        return reflectiveClasses;
    }

    private List<ReflectiveClassBuildItem> getAdditionalConfigurationReflectiveClasses(Map<String, QuartzExtensionPointConfig> config, Class<?> clazz) {
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        for (QuartzExtensionPointConfig props : config.values()) {
            try {
                if (!clazz.isAssignableFrom(Class.forName(props.clazz(), false, Thread.currentThread().getContextClassLoader()))) {
                    throw new IllegalArgumentException(String.format("%s does not implements %s", props.clazz(), clazz));
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            reflectiveClasses.add(ReflectiveClassBuildItem.builder((String[])new String[]{props.clazz()}).reason(this.getClass().getName()).methods().build());
        }
        return reflectiveClasses;
    }

    @BuildStep
    public List<LogCleanupFilterBuildItem> logCleanup(QuartzBuildTimeConfig config) {
        ArrayList<LogCleanupFilterBuildItem> logCleanUps = new ArrayList<LogCleanupFilterBuildItem>();
        logCleanUps.add(new LogCleanupFilterBuildItem(StdSchedulerFactory.class.getName(), Level.INFO, new String[]{"Quartz scheduler version:", "Using default implementation for", "Quartz scheduler '"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(QuartzScheduler.class.getName(), Level.INFO, new String[]{"Quartz Scheduler v", "JobFactory set to:", "Scheduler meta-data:", "Scheduler "}));
        logCleanUps.add(new LogCleanupFilterBuildItem(config.storeType().clazz, new String[]{config.storeType().simpleName + " initialized.", "Handling", "Using db table-based data access locking", "JDBCJobStore threads will inherit ContextClassLoader of thread", "Couldn't\u00a0rollback\u00a0jdbc\u00a0connection", "Database connection shutdown unsuccessful"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(SchedulerSignalerImpl.class.getName(), new String[]{"Initialized Scheduler Signaller of type"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(QuartzSchedulerThread.class.getName(), new String[]{"QuartzSchedulerThread Inheriting ContextClassLoader"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(SimpleThreadPool.class.getName(), new String[]{"Job execution threads will use class loader of thread"}));
        logCleanUps.add(new LogCleanupFilterBuildItem(AttributeRestoringConnectionInvocationHandler.class.getName(), new String[]{"Failed restore connection's original"}));
        return logCleanUps;
    }

    @BuildStep
    public void start(BuildProducer<ServiceStartBuildItem> serviceStart, List<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("quartz"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void quartzSupportBean(QuartzRuntimeConfig runtimeConfig, QuartzBuildTimeConfig buildTimeConfig, QuartzRecorder recorder, QuartzJDBCDriverDialectBuildItem driverDialect, List<ScheduledBusinessMethodItem> scheduledMethods, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        HashSet<CallSite> nonconcurrentMethods = new HashSet<CallSite>();
        for (ScheduledBusinessMethodItem m : scheduledMethods) {
            if (!m.getMethod().hasAnnotation(NONCONCURRENT)) continue;
            nonconcurrentMethods.add((CallSite)((Object)(m.getMethod().declaringClass().name() + "#" + m.getMethod().name())));
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuartzSupport.class).scope(Singleton.class)).setRuntimeInit().supplier(recorder.quartzSupportSupplier(runtimeConfig, buildTimeConfig, driverDialect.getDriver(), nonconcurrentMethods)).done());
    }
}

