/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

class CdiAwareJob
implements InterruptableJob {
    private final Instance<? extends Job> jobInstance;

    public CdiAwareJob(Instance<? extends Job> jobInstance) {
        this.jobInstance = jobInstance;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Instance.Handle handle = this.jobInstance.getHandle();
        try {
            ((Job)handle.get()).execute(context);
        }
        finally {
            if (handle.getBean().getScope().equals(Dependent.class)) {
                handle.destroy();
            }
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        Instance.Handle handle = this.jobInstance.getHandle();
        if (InterruptableJob.class.isAssignableFrom(handle.getBean().getBeanClass())) {
            try {
                ((InterruptableJob)handle.get()).interrupt();
            }
            finally {
                if (handle.getBean().getScope().equals(Dependent.class)) {
                    handle.destroy();
                }
            }
        } else {
            throw new UnableToInterruptJobException("Job " + handle.getBean().getBeanClass() + " can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
    }
}

