/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import com.cronutils.mapper.CronMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkus.arc.Subclass;
import io.quarkus.quartz.QuartzScheduler;
import io.quarkus.quartz.runtime.CdiAwareJob;
import io.quarkus.quartz.runtime.InstrumentedJob;
import io.quarkus.quartz.runtime.QuarkusQuartzConnectionPoolProvider;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzExtensionPointConfig;
import io.quarkus.quartz.runtime.QuartzMisfirePolicy;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.QuartzStartMode;
import io.quarkus.quartz.runtime.QuartzSupport;
import io.quarkus.quartz.runtime.StoreType;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.ScheduledJobPaused;
import io.quarkus.scheduler.ScheduledJobResumed;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.SchedulerPaused;
import io.quarkus.scheduler.SchedulerResumed;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.SuccessfulExecution;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.common.runtime.AbstractJobDefinition;
import io.quarkus.scheduler.common.runtime.DefaultInvoker;
import io.quarkus.scheduler.common.runtime.Events;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.common.runtime.SyntheticScheduled;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import io.quarkus.scheduler.runtime.SchedulerRuntimeConfig;
import io.quarkus.scheduler.runtime.SimpleScheduler;
import io.quarkus.scheduler.spi.JobInstrumenter;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Singleton;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

@Typed(value={QuartzScheduler.class, io.quarkus.scheduler.Scheduler.class})
@Singleton
public class QuartzSchedulerImpl
implements QuartzScheduler {
    private static final Logger LOGGER = Logger.getLogger((String)QuartzSchedulerImpl.class.getName());
    private static final String INVOKER_KEY = "invoker";
    private final Scheduler scheduler;
    private final boolean startHalted;
    private final Duration shutdownWaitTime;
    private final boolean enabled;
    private final CronType cronType;
    private final CronParser cronParser;
    private final Duration defaultOverdueGracePeriod;
    private final Map<String, QuartzTrigger> scheduledTasks = new ConcurrentHashMap<String, QuartzTrigger>();
    private final Event<SkippedExecution> skippedExecutionEvent;
    private final Event<SuccessfulExecution> successExecutionEvent;
    private final Event<FailedExecution> failedExecutionEvent;
    private final Event<SchedulerPaused> schedulerPausedEvent;
    private final Event<SchedulerResumed> schedulerResumedEvent;
    private final Event<ScheduledJobPaused> scheduledJobPausedEvent;
    private final Event<ScheduledJobResumed> scheduledJobResumedEvent;
    private final QuartzRuntimeConfig runtimeConfig;
    private final SchedulerConfig schedulerConfig;
    private final Instance<JobInstrumenter> jobInstrumenter;
    private final StoreType storeType;
    static final String SCHEDULED_METADATA = "scheduled_metadata";
    static final String EXECUTION_METADATA_TASK_CLASS = "execution_metadata_task_class";
    static final String EXECUTION_METADATA_ASYNC_TASK_CLASS = "execution_metadata_async_task_class";
    static final String EXECUTION_METADATA_RUN_ON_VIRTUAL_THREAD = "execution_metadata_run_on_virtual_thread";
    static final String EXECUTION_METADATA_SKIP_PREDICATE_CLASS = "execution_metadata_skip_predicate_class";

    public QuartzSchedulerImpl(SchedulerContext context, QuartzSupport quartzSupport, SchedulerRuntimeConfig schedulerRuntimeConfig, Event<SkippedExecution> skippedExecutionEvent, Event<SuccessfulExecution> successExecutionEvent, Event<FailedExecution> failedExecutionEvent, Event<SchedulerPaused> schedulerPausedEvent, Event<SchedulerResumed> schedulerResumedEvent, Event<ScheduledJobPaused> scheduledJobPausedEvent, Event<ScheduledJobResumed> scheduledJobResumedEvent, Instance<Job> jobs, Instance<UserTransaction> userTransaction, Vertx vertx, SchedulerConfig schedulerConfig, Instance<JobInstrumenter> jobInstrumenter) {
        boolean forceStart;
        this.shutdownWaitTime = quartzSupport.getRuntimeConfig().shutdownWaitTime;
        this.skippedExecutionEvent = skippedExecutionEvent;
        this.successExecutionEvent = successExecutionEvent;
        this.failedExecutionEvent = failedExecutionEvent;
        this.schedulerPausedEvent = schedulerPausedEvent;
        this.schedulerResumedEvent = schedulerResumedEvent;
        this.scheduledJobPausedEvent = scheduledJobPausedEvent;
        this.scheduledJobResumedEvent = scheduledJobResumedEvent;
        this.runtimeConfig = quartzSupport.getRuntimeConfig();
        this.enabled = schedulerRuntimeConfig.enabled;
        this.defaultOverdueGracePeriod = schedulerRuntimeConfig.overdueGracePeriod;
        this.schedulerConfig = schedulerConfig;
        this.jobInstrumenter = jobInstrumenter;
        this.storeType = quartzSupport.getBuildTimeConfig().storeType;
        SchedulerRuntimeConfig.StartMode startMode = this.initStartMode(schedulerRuntimeConfig, this.runtimeConfig);
        if (startMode != SchedulerRuntimeConfig.StartMode.NORMAL) {
            this.startHalted = startMode == SchedulerRuntimeConfig.StartMode.HALTED;
            forceStart = this.startHalted || startMode == SchedulerRuntimeConfig.StartMode.FORCED;
        } else {
            this.startHalted = false;
            forceStart = false;
        }
        QuartzRuntimeConfig.TriggerConfig simpleTriggerConfig = this.runtimeConfig.simpleTriggerConfig;
        QuartzRuntimeConfig.TriggerConfig cronTriggerConfig = this.runtimeConfig.cronTriggerConfig;
        if (!QuartzMisfirePolicy.validCronValues().contains((Object)cronTriggerConfig.misfirePolicyConfig.misfirePolicy)) {
            throw new IllegalArgumentException("Global cron trigger misfire policy configured with invalid option. Valid options are: " + QuartzMisfirePolicy.validCronValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
        }
        if (!QuartzMisfirePolicy.validSimpleValues().contains((Object)simpleTriggerConfig.misfirePolicyConfig.misfirePolicy)) {
            throw new IllegalArgumentException("Global simple trigger misfire policy configured with invalid option. Valid options are: " + QuartzMisfirePolicy.validSimpleValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
        }
        this.cronType = context.getCronType();
        CronDefinition def = CronDefinitionBuilder.instanceDefinitionFor((CronType)this.cronType);
        this.cronParser = new CronParser(def);
        JobInstrumenter instrumenter = null;
        if (schedulerConfig.tracingEnabled && jobInstrumenter.isResolvable()) {
            instrumenter = (JobInstrumenter)jobInstrumenter.get();
        }
        if (!this.enabled) {
            LOGGER.info((Object)"Quartz scheduler is disabled by config property and will not be started");
            this.scheduler = null;
        } else if (!forceStart && context.getScheduledMethods().isEmpty() && !context.forceSchedulerStart()) {
            LOGGER.info((Object)"No scheduled business methods found - Quartz scheduler will not be started");
            this.scheduler = null;
        } else {
            UserTransaction transaction = null;
            try {
                boolean manageTx = quartzSupport.getBuildTimeConfig().storeType.isNonManagedTxJobStore();
                if (manageTx && userTransaction.isResolvable()) {
                    transaction = (UserTransaction)userTransaction.get();
                }
                Properties props = this.getSchedulerConfigurationProperties(quartzSupport);
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
                this.scheduler = schedulerFactory.getScheduler();
                this.scheduler.setJobFactory((JobFactory)new InvokerJobFactory(this.scheduledTasks, jobs, vertx, instrumenter));
                if (transaction != null) {
                    transaction.begin();
                }
                Function<TriggerKey, org.quartz.Trigger> triggerFun = new Function<TriggerKey, org.quartz.Trigger>(){

                    @Override
                    public org.quartz.Trigger apply(TriggerKey triggerKey) {
                        try {
                            return QuartzSchedulerImpl.this.scheduler.getTrigger(triggerKey);
                        }
                        catch (SchedulerException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                };
                for (ScheduledMethod method : context.getScheduledMethods()) {
                    int nameSequence = 0;
                    for (Scheduled scheduled : method.getSchedules()) {
                        Object identity = SchedulerUtils.lookUpPropertyValue((String)scheduled.identity());
                        if (((String)identity).isEmpty()) {
                            identity = ++nameSequence + "_" + method.getInvokerClassName();
                        }
                        ScheduledInvoker invoker = SimpleScheduler.initInvoker((ScheduledInvoker)context.createInvoker(method.getInvokerClassName()), skippedExecutionEvent, successExecutionEvent, failedExecutionEvent, (Scheduled.ConcurrentExecution)scheduled.concurrentExecution(), (Scheduled.SkipPredicate)SimpleScheduler.initSkipPredicate((Class)scheduled.skipExecutionIf()), (JobInstrumenter)instrumenter);
                        JobDetail jobDetail = this.createJobDetail((String)identity, method.getInvokerClassName());
                        Optional<TriggerBuilder<?>> triggerBuilder = this.createTrigger((String)identity, scheduled, this.cronType, this.runtimeConfig, jobDetail);
                        if (triggerBuilder.isPresent()) {
                            org.quartz.Trigger trigger = triggerBuilder.get().build();
                            org.quartz.Trigger oldTrigger = this.scheduler.getTrigger(trigger.getKey());
                            if (oldTrigger != null) {
                                trigger = triggerBuilder.get().startAt(oldTrigger.getNextFireTime()).build();
                                this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                                LOGGER.debugf("Rescheduled business method %s with config %s", (Object)method.getMethodDescription(), (Object)scheduled);
                            } else if (!this.scheduler.checkExists(trigger.getKey())) {
                                this.scheduler.scheduleJob(jobDetail, trigger);
                                LOGGER.debugf("Scheduled business method %s with config %s", (Object)method.getMethodDescription(), (Object)scheduled);
                            } else {
                                oldTrigger = this.scheduler.getTrigger(new TriggerKey((String)identity + "_trigger", io.quarkus.scheduler.Scheduler.class.getName()));
                                if (oldTrigger != null) {
                                    this.scheduler.deleteJob(jobDetail.getKey());
                                    trigger = triggerBuilder.get().startAt(oldTrigger.getNextFireTime()).build();
                                    this.scheduler.scheduleJob(jobDetail, trigger);
                                    LOGGER.debugf("Rescheduled business method %s with config %s due to Trigger '%s' record being renamed after removal of '_trigger' suffix", (Object)method.getMethodDescription(), (Object)scheduled, (Object)oldTrigger.getKey().getName());
                                }
                            }
                            this.scheduledTasks.put((String)identity, new QuartzTrigger(trigger.getKey(), triggerFun, invoker, SchedulerUtils.parseOverdueGracePeriod((Scheduled)scheduled, (Duration)this.defaultOverdueGracePeriod), quartzSupport.getRuntimeConfig().runBlockingScheduledMethodOnQuartzThread, false, method.getMethodDescription()));
                            continue;
                        }
                        this.scheduler.deleteJob(new JobKey((String)identity, io.quarkus.scheduler.Scheduler.class.getName()));
                    }
                }
                if (this.storeType.isDbStore()) {
                    Set triggers = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)io.quarkus.scheduler.Scheduler.class.getName()));
                    for (TriggerKey triggerKey : triggers) {
                        JobDetail jobDetail = this.scheduler.getJobDetail(new JobKey(triggerKey.getName(), triggerKey.getGroup()));
                        if (jobDetail == null) {
                            throw new IllegalStateException("Unable to obtain the job detail for " + triggerKey);
                        }
                        String scheduledJson = jobDetail.getJobDataMap().getString(SCHEDULED_METADATA);
                        if (scheduledJson == null) continue;
                        SyntheticScheduled scheduled = SyntheticScheduled.fromJson((String)scheduledJson);
                        org.quartz.Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
                        if (oldTrigger == null) {
                            throw new IllegalStateException("Unable to obtain the trigger for " + triggerKey);
                        }
                        this.createJobDefinitionQuartzTrigger(new SerializedExecutionMetadata(jobDetail), scheduled, oldTrigger);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                }
            }
            catch (Throwable e) {
                if (transaction != null) {
                    try {
                        transaction.rollback();
                    }
                    catch (SystemException ex) {
                        LOGGER.error((Object)"Unable to rollback transaction", (Throwable)ex);
                    }
                }
                throw new IllegalStateException("Unable to create Scheduler", e);
            }
        }
    }

    @Produces
    @Singleton
    Scheduler produceQuartzScheduler() {
        if (this.scheduler == null) {
            throw new IllegalStateException("Quartz scheduler is either explicitly disabled through quarkus.scheduler.enabled=false or no @Scheduled methods were found. If you only need to schedule a job programmatically you can force the start of the scheduler by setting 'quarkus.scheduler.start-mode=forced'.");
        }
        return this.scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void pause() {
        if (!this.enabled) {
            LOGGER.warn((Object)"Quartz Scheduler is disabled and cannot be paused");
        } else {
            try {
                if (this.scheduler != null) {
                    this.scheduler.standby();
                    Events.fire(this.schedulerPausedEvent, (Object)SchedulerPaused.INSTANCE);
                }
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Unable to pause scheduler", e);
            }
        }
    }

    public void pause(String identity) {
        Objects.requireNonNull(identity, "Cannot pause - identity is null");
        if (identity.isEmpty()) {
            LOGGER.warn((Object)"Cannot pause - identity is empty");
            return;
        }
        try {
            String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
            QuartzTrigger trigger = this.scheduledTasks.get(parsedIdentity);
            if (trigger != null) {
                this.scheduler.pauseJob(new JobKey(parsedIdentity, io.quarkus.scheduler.Scheduler.class.getName()));
                Events.fire(this.scheduledJobPausedEvent, (Object)new ScheduledJobPaused((Trigger)trigger));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to pause job", e);
        }
    }

    public boolean isPaused(String identity) {
        Objects.requireNonNull(identity);
        if (identity.isEmpty()) {
            return false;
        }
        try {
            List triggers = this.scheduler.getTriggersOfJob(new JobKey(SchedulerUtils.lookUpPropertyValue((String)identity), io.quarkus.scheduler.Scheduler.class.getName()));
            if (triggers.isEmpty()) {
                return false;
            }
            for (org.quartz.Trigger trigger : triggers) {
                try {
                    if (this.scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED) continue;
                    return false;
                }
                catch (SchedulerException e) {
                    LOGGER.warnf("Cannot obtain the trigger state for %s", (Object)trigger.getKey());
                    return false;
                }
            }
            return true;
        }
        catch (SchedulerException e1) {
            LOGGER.warnf((Throwable)e1, "Cannot obtain triggers for job with identity %s", (Object)identity);
            return false;
        }
    }

    public void resume() {
        if (!this.enabled) {
            LOGGER.warn((Object)"Quartz Scheduler is disabled and cannot be resumed");
        } else {
            try {
                if (this.scheduler != null) {
                    this.scheduler.start();
                    Events.fire(this.schedulerResumedEvent, (Object)SchedulerResumed.INSTANCE);
                }
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Unable to resume scheduler", e);
            }
        }
    }

    public void resume(String identity) {
        Objects.requireNonNull(identity, "Cannot resume - identity is null");
        if (identity.isEmpty()) {
            LOGGER.warn((Object)"Cannot resume - identity is empty");
            return;
        }
        try {
            String parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity);
            QuartzTrigger trigger = this.scheduledTasks.get(parsedIdentity);
            if (trigger != null) {
                this.scheduler.resumeJob(new JobKey(SchedulerUtils.lookUpPropertyValue((String)parsedIdentity), io.quarkus.scheduler.Scheduler.class.getName()));
                Events.fire(this.scheduledJobResumedEvent, (Object)new ScheduledJobResumed((Trigger)trigger));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unable to resume job", e);
        }
    }

    public boolean isRunning() {
        if (!this.enabled || this.scheduler == null) {
            return false;
        }
        try {
            return !this.scheduler.isInStandbyMode();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Could not evaluate standby mode", e);
        }
    }

    public List<Trigger> getScheduledJobs() {
        return List.copyOf(this.scheduledTasks.values());
    }

    public Trigger getScheduledJob(String identity) {
        Objects.requireNonNull(identity);
        if (identity.isEmpty()) {
            return null;
        }
        return this.scheduledTasks.get(SchedulerUtils.lookUpPropertyValue((String)identity));
    }

    public Scheduler.JobDefinition newJob(String identity) {
        Objects.requireNonNull(identity);
        if (this.scheduledTasks.containsKey(identity)) {
            throw new IllegalStateException("A job with this identity is already scheduled: " + identity);
        }
        return new QuartzJobDefinition(identity);
    }

    public Trigger unscheduleJob(String identity) {
        String parsedIdentity;
        QuartzTrigger trigger;
        Objects.requireNonNull(identity);
        if (!identity.isEmpty() && (trigger = this.scheduledTasks.get(parsedIdentity = SchedulerUtils.lookUpPropertyValue((String)identity))) != null && trigger.isProgrammatic && this.scheduledTasks.remove(identity) != null) {
            try {
                this.scheduler.unscheduleJob(trigger.triggerKey);
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Unable to unschedule job with identity: " + identity);
            }
            return trigger;
        }
        return null;
    }

    void start(@Observes @Priority(value=0) StartupEvent startupEvent) {
        if (this.scheduler == null || this.startHalted) {
            return;
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Unable to start Scheduler", e);
        }
    }

    void destroy(@Observes(notifyObserver=Reception.IF_EXISTS) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.scheduler != null) {
            try {
                if (this.shutdownWaitTime.isZero()) {
                    this.scheduler.shutdown(false);
                } else {
                    CompletableFuture.supplyAsync(new Supplier<Object>(){

                        @Override
                        public Void get() {
                            try {
                                QuartzSchedulerImpl.this.scheduler.shutdown(true);
                            }
                            catch (SchedulerException e) {
                                throw new RuntimeException(e);
                            }
                            return null;
                        }
                    }).get(this.shutdownWaitTime.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                LOGGER.warnf("Unable to gracefully shutdown the scheduler", (Object)e);
            }
        }
    }

    @PreDestroy
    void destroy() {
        if (this.scheduler != null) {
            try {
                if (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdown(false);
                }
            }
            catch (SchedulerException e) {
                LOGGER.warnf("Unable to shutdown the scheduler", (Object)e);
            }
        }
    }

    private Properties getSchedulerConfigurationProperties(QuartzSupport quartzSupport) {
        Properties props = new Properties();
        QuartzBuildTimeConfig buildTimeConfig = quartzSupport.getBuildTimeConfig();
        QuartzRuntimeConfig runtimeConfig = quartzSupport.getRuntimeConfig();
        props.put("org.quartz.scheduler.skipUpdateCheck", "true");
        props.put("org.quartz.scheduler.instanceName", runtimeConfig.instanceName);
        props.put("org.quartz.scheduler.batchTriggerAcquisitionFireAheadTimeWindow", "" + runtimeConfig.batchTriggerAcquisitionFireAheadTimeWindow);
        props.put("org.quartz.scheduler.batchTriggerAcquisitionMaxCount", "" + runtimeConfig.batchTriggerAcquisitionMaxCount);
        props.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        props.put("org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer", "true");
        props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        props.put("org.quartz.scheduler.classLoadHelper.class", InitThreadContextClassLoadHelper.class.getName());
        props.put("org.quartz.threadPool.threadCount", "" + runtimeConfig.threadCount);
        props.put("org.quartz.threadPool.threadPriority", "" + runtimeConfig.threadPriority);
        props.put("org.quartz.scheduler.rmi.export", "false");
        props.put("org.quartz.scheduler.rmi.proxy", "false");
        props.put("org.quartz.jobStore.class", buildTimeConfig.storeType.clazz);
        if (buildTimeConfig.storeType.isDbStore()) {
            String dataSource = buildTimeConfig.dataSourceName.orElse("QUARKUS_QUARTZ_DEFAULT_DATASOURCE");
            QuarkusQuartzConnectionPoolProvider.setDataSourceName(dataSource);
            boolean serializeJobData = buildTimeConfig.serializeJobData.orElse(false);
            props.put("org.quartz.jobStore.useProperties", serializeJobData ? "false" : "true");
            props.put("org.quartz.jobStore.misfireThreshold", "" + runtimeConfig.misfireThreshold.toMillis());
            props.put("org.quartz.jobStore.tablePrefix", buildTimeConfig.tablePrefix);
            props.put("org.quartz.jobStore.dataSource", dataSource);
            props.put("org.quartz.jobStore.driverDelegateClass", quartzSupport.getDriverDialect().get());
            props.put("org.quartz.dataSource." + dataSource + ".connectionProvider.class", QuarkusQuartzConnectionPoolProvider.class.getName());
            props.put("org.quartz.jobStore.acquireTriggersWithinLock", "true");
            if (buildTimeConfig.clustered) {
                props.put("org.quartz.jobStore.isClustered", "true");
                props.put("org.quartz.jobStore.clusterCheckinInterval", "" + buildTimeConfig.clusterCheckinInterval);
                if (buildTimeConfig.selectWithLockSql.isPresent()) {
                    props.put("org.quartz.jobStore.selectWithLockSQL", buildTimeConfig.selectWithLockSql.get());
                }
            }
            if (buildTimeConfig.storeType.isNonManagedTxJobStore()) {
                props.put("org.quartz.jobStore.nonManagedTXDataSource", dataSource);
            }
        }
        QuartzExtensionPointConfig instanceIdGenerator = buildTimeConfig.instanceIdGenerators.get(runtimeConfig.instanceId);
        if (runtimeConfig.instanceId.equals("AUTO") || instanceIdGenerator != null) {
            props.put("org.quartz.scheduler.instanceId", "AUTO");
        } else {
            if (runtimeConfig.instanceId.equals("SYS_PROP")) {
                LOGGER.warn((Object)"Prefer to configure the 'SystemPropertyInstanceIdGenerator' within the instance ID generators, so the system property name can be changed and the application can be native.");
            }
            props.put("org.quartz.scheduler.instanceId", runtimeConfig.instanceId);
        }
        if (instanceIdGenerator != null) {
            this.putExtensionConfigurationProperties(props, "org.quartz.scheduler.instanceIdGenerator", instanceIdGenerator);
        }
        this.putExtensionConfigurationProperties(props, "org.quartz.plugin", buildTimeConfig.plugins);
        this.putExtensionConfigurationProperties(props, "org.quartz.jobListener", buildTimeConfig.jobListeners);
        this.putExtensionConfigurationProperties(props, "org.quartz.triggerListener", buildTimeConfig.triggerListeners);
        return props;
    }

    private void putExtensionConfigurationProperties(Properties props, String prefix, Map<String, QuartzExtensionPointConfig> configs) {
        configs.forEach((configKey, config) -> this.putExtensionConfigurationProperties(props, String.format("%s.%s", prefix, configKey), (QuartzExtensionPointConfig)config));
    }

    private void putExtensionConfigurationProperties(Properties props, String prefix, QuartzExtensionPointConfig config) {
        props.put(String.format("%s.class", prefix), config.clazz);
        config.properties.forEach((propName, propValue) -> props.put(String.format("%s.%s", prefix, propName), propValue));
    }

    SchedulerRuntimeConfig.StartMode initStartMode(SchedulerRuntimeConfig schedulerRuntimeConfig, QuartzRuntimeConfig quartzRuntimeConfig) {
        if (schedulerRuntimeConfig.startMode.isPresent()) {
            SchedulerRuntimeConfig.StartMode startMode = (SchedulerRuntimeConfig.StartMode)schedulerRuntimeConfig.startMode.get();
            if (quartzRuntimeConfig.startMode.isPresent()) {
                QuartzStartMode quartzStartMode = quartzRuntimeConfig.startMode.get();
                if (startMode == SchedulerRuntimeConfig.StartMode.NORMAL && quartzStartMode != QuartzStartMode.NORMAL || startMode == SchedulerRuntimeConfig.StartMode.FORCED && quartzStartMode != QuartzStartMode.FORCED || startMode == SchedulerRuntimeConfig.StartMode.HALTED && quartzStartMode != QuartzStartMode.HALTED) {
                    throw new IllegalStateException("Inconsistent scheduler startup mode configuration; quarkus.scheduler.startMode=" + startMode + " does not match quarkus.quartz.startMode=" + quartzStartMode);
                }
            }
            return startMode;
        }
        if (quartzRuntimeConfig.startMode.isPresent()) {
            QuartzStartMode quartzStartMode = quartzRuntimeConfig.startMode.get();
            switch (quartzStartMode) {
                case NORMAL: {
                    return SchedulerRuntimeConfig.StartMode.NORMAL;
                }
                case FORCED: {
                    return SchedulerRuntimeConfig.StartMode.FORCED;
                }
                case HALTED: {
                    return SchedulerRuntimeConfig.StartMode.HALTED;
                }
            }
            throw new IllegalStateException();
        }
        return SchedulerRuntimeConfig.StartMode.NORMAL;
    }

    private JobDetail createJobDetail(String identity, String invokerClassName) {
        return JobBuilder.newJob(InvokerJob.class).withIdentity(identity, io.quarkus.scheduler.Scheduler.class.getName()).usingJobData(INVOKER_KEY, invokerClassName).requestRecovery().build();
    }

    private Optional<TriggerBuilder<?>> createTrigger(String identity, Scheduled scheduled, CronType cronType, QuartzRuntimeConfig runtimeConfig, JobDetail jobDetail) {
        CronScheduleBuilder scheduleBuilder;
        String cron = SchedulerUtils.lookUpPropertyValue((String)scheduled.cron());
        if (!cron.isEmpty()) {
            if (SchedulerUtils.isOff((String)cron)) {
                return Optional.empty();
            }
            if (!CronType.QUARTZ.equals((Object)cronType)) {
                Cron cronExpr = this.cronParser.parse(cron);
                switch (cronType) {
                    case UNIX: {
                        cron = CronMapper.fromUnixToQuartz().map(cronExpr).asString();
                        break;
                    }
                    case CRON4J: {
                        cron = CronMapper.fromCron4jToQuartz().map(cronExpr).asString();
                        break;
                    }
                }
            }
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
            ZoneId timeZone = SchedulerUtils.parseCronTimeZone((Scheduled)scheduled);
            if (timeZone != null) {
                cronScheduleBuilder.inTimeZone(TimeZone.getTimeZone(timeZone));
            }
            QuartzRuntimeConfig.QuartzMisfirePolicyConfig perJobConfig = runtimeConfig.misfirePolicyPerJobs.getOrDefault(identity, runtimeConfig.cronTriggerConfig.misfirePolicyConfig);
            switch (perJobConfig.misfirePolicy) {
                case SMART_POLICY: {
                    break;
                }
                case IGNORE_MISFIRE_POLICY: {
                    cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case FIRE_NOW: {
                    cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
                    break;
                }
                case CRON_TRIGGER_DO_NOTHING: {
                    cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: 
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: 
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: 
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: {
                    throw new IllegalArgumentException("Cron job " + identity + " configured with invalid misfire policy " + perJobConfig.misfirePolicy.dashedName() + "\nValid options are: " + QuartzMisfirePolicy.validCronValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
                }
            }
            scheduleBuilder = cronScheduleBuilder;
        } else if (!scheduled.every().isEmpty()) {
            OptionalLong everyMillis = SchedulerUtils.parseEveryAsMillis((Scheduled)scheduled);
            if (!everyMillis.isPresent()) {
                return Optional.empty();
            }
            SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(everyMillis.getAsLong()).repeatForever();
            QuartzRuntimeConfig.QuartzMisfirePolicyConfig perJobConfig = runtimeConfig.misfirePolicyPerJobs.getOrDefault(identity, runtimeConfig.simpleTriggerConfig.misfirePolicyConfig);
            switch (perJobConfig.misfirePolicy) {
                case SMART_POLICY: {
                    break;
                }
                case IGNORE_MISFIRE_POLICY: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
                    break;
                }
                case FIRE_NOW: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionFireNow();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNowWithExistingCount();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNextWithExistingCount();
                    break;
                }
                case SIMPLE_TRIGGER_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: {
                    simpleScheduleBuilder.withMisfireHandlingInstructionNextWithRemainingCount();
                    break;
                }
                case CRON_TRIGGER_DO_NOTHING: {
                    throw new IllegalArgumentException("Simple job " + identity + " configured with invalid misfire policy " + perJobConfig.misfirePolicy.dashedName() + "\nValid options are: " + QuartzMisfirePolicy.validSimpleValues().stream().map(QuartzMisfirePolicy::dashedName).collect(Collectors.joining(", ")));
                }
            }
            scheduleBuilder = simpleScheduleBuilder;
        } else {
            throw new IllegalArgumentException("Invalid schedule configuration: " + scheduled);
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(identity, io.quarkus.scheduler.Scheduler.class.getName()).forJob(jobDetail).withSchedule((ScheduleBuilder)scheduleBuilder);
        Long millisToAdd = null;
        if (scheduled.delay() > 0L) {
            millisToAdd = scheduled.delayUnit().toMillis(scheduled.delay());
        } else if (!scheduled.delayed().isEmpty()) {
            millisToAdd = SchedulerUtils.parseDelayedAsMillis((Scheduled)scheduled);
        }
        if (millisToAdd != null) {
            triggerBuilder.startAt(new Date(Instant.now().plusMillis(millisToAdd).toEpochMilli()));
        }
        return Optional.of(triggerBuilder);
    }

    QuartzTrigger createJobDefinitionQuartzTrigger(ExecutionMetadata executionMetadata, SyntheticScheduled scheduled, org.quartz.Trigger oldTrigger) {
        org.quartz.Trigger trigger;
        final Consumer<ScheduledExecution> task = executionMetadata.task();
        final Function<ScheduledExecution, Uni<Void>> asyncTask = executionMetadata.asyncTask();
        final boolean runOnVirtualThread = executionMetadata.isRunOnVirtualThread();
        Scheduled.SkipPredicate skipPredicate = executionMetadata.skipPredicate();
        DefaultInvoker invoker = task != null ? new DefaultInvoker(){

            public CompletionStage<Void> invokeBean(ScheduledExecution execution) {
                try {
                    task.accept(execution);
                    return CompletableFuture.completedStage(null);
                }
                catch (Exception e) {
                    return CompletableFuture.failedStage(e);
                }
            }

            public boolean isRunningOnVirtualThread() {
                return runOnVirtualThread;
            }
        } : new DefaultInvoker(){

            public CompletionStage<Void> invokeBean(ScheduledExecution execution) {
                try {
                    return ((Uni)asyncTask.apply(execution)).subscribeAsCompletionStage();
                }
                catch (Exception e) {
                    return CompletableFuture.failedStage(e);
                }
            }

            public boolean isBlocking() {
                return false;
            }
        };
        JobBuilder jobBuilder = JobBuilder.newJob(InvokerJob.class).withIdentity(scheduled.identity(), io.quarkus.scheduler.Scheduler.class.getName()).usingJobData(INVOKER_KEY, QuartzSchedulerImpl.class.getName());
        if (this.storeType.isDbStore()) {
            jobBuilder.usingJobData(SCHEDULED_METADATA, scheduled.toJson()).usingJobData(EXECUTION_METADATA_RUN_ON_VIRTUAL_THREAD, Boolean.toString(runOnVirtualThread));
            if (executionMetadata.taskClass() != null) {
                jobBuilder.usingJobData(EXECUTION_METADATA_TASK_CLASS, executionMetadata.taskClass().getName());
            } else if (executionMetadata.asyncTaskClass() != null) {
                jobBuilder.usingJobData(EXECUTION_METADATA_ASYNC_TASK_CLASS, executionMetadata.asyncTaskClass().getName());
            }
            if (executionMetadata.skipPredicateClass() != null) {
                jobBuilder.usingJobData(EXECUTION_METADATA_SKIP_PREDICATE_CLASS, executionMetadata.skipPredicateClass().getName());
            }
        }
        JobDetail jobDetail = jobBuilder.requestRecovery().build();
        Optional<TriggerBuilder<?>> triggerBuilder = this.createTrigger(scheduled.identity(), (Scheduled)scheduled, this.cronType, this.runtimeConfig, jobDetail);
        if (triggerBuilder.isPresent()) {
            trigger = oldTrigger != null ? triggerBuilder.get().startAt(oldTrigger.getNextFireTime()).build() : triggerBuilder.get().build();
        } else {
            if (oldTrigger != null) {
                throw new IllegalStateException("Job [" + scheduled.identity() + "] that was previously scheduled programmatically cannot be disabled");
            }
            return null;
        }
        JobInstrumenter instrumenter = null;
        if (this.schedulerConfig.tracingEnabled && this.jobInstrumenter.isResolvable()) {
            instrumenter = (JobInstrumenter)this.jobInstrumenter.get();
        }
        invoker = SimpleScheduler.initInvoker((ScheduledInvoker)invoker, this.skippedExecutionEvent, this.successExecutionEvent, this.failedExecutionEvent, (Scheduled.ConcurrentExecution)scheduled.concurrentExecution(), (Scheduled.SkipPredicate)skipPredicate, (JobInstrumenter)instrumenter);
        QuartzTrigger quartzTrigger = new QuartzTrigger(trigger.getKey(), new Function<TriggerKey, org.quartz.Trigger>(){

            @Override
            public org.quartz.Trigger apply(TriggerKey triggerKey) {
                try {
                    return QuartzSchedulerImpl.this.scheduler.getTrigger(triggerKey);
                }
                catch (SchedulerException e) {
                    throw new IllegalStateException(e);
                }
            }
        }, (ScheduledInvoker)invoker, SchedulerUtils.parseOverdueGracePeriod((Scheduled)scheduled, (Duration)this.defaultOverdueGracePeriod), this.runtimeConfig.runBlockingScheduledMethodOnQuartzThread, true, null);
        QuartzTrigger existing = this.scheduledTasks.putIfAbsent(scheduled.identity(), quartzTrigger);
        if (existing != null) {
            throw new IllegalStateException("A job with this identity is already scheduled: " + scheduled.identity());
        }
        try {
            if (oldTrigger != null) {
                this.scheduler.rescheduleJob(trigger.getKey(), trigger);
                LOGGER.debugf("Rescheduled job definition with config %s", (Object)scheduled);
            } else {
                this.scheduler.scheduleJob(jobDetail, trigger);
                LOGGER.debugf("Scheduled job definition with config %s", (Object)scheduled);
            }
        }
        catch (SchedulerException e) {
            throw new IllegalStateException(e);
        }
        return quartzTrigger;
    }

    static class InvokerJobFactory
    extends SimpleJobFactory {
        final Map<String, QuartzTrigger> scheduledTasks;
        final Instance<Job> jobs;
        final Vertx vertx;
        final JobInstrumenter instrumenter;

        InvokerJobFactory(Map<String, QuartzTrigger> scheduledTasks, Instance<Job> jobs, Vertx vertx, JobInstrumenter instrumenter) {
            this.scheduledTasks = scheduledTasks;
            this.jobs = jobs;
            this.vertx = vertx;
            this.instrumenter = instrumenter;
        }

        public Job newJob(TriggerFiredBundle bundle, Scheduler Scheduler2) throws SchedulerException {
            Instance instance;
            Class jobClass = bundle.getJobDetail().getJobClass();
            if (jobClass.equals(InvokerJob.class)) {
                return new InvokerJob(this.scheduledTasks.get(bundle.getJobDetail().getKey().getName()), this.vertx);
            }
            if (Subclass.class.isAssignableFrom(jobClass)) {
                jobClass = jobClass.getSuperclass();
            }
            if ((instance = this.jobs.select(jobClass, new Annotation[0])).isResolvable()) {
                return this.jobWithSpanWrapper((Job)new CdiAwareJob((Instance<? extends Job>)instance));
            }
            return this.jobWithSpanWrapper(super.newJob(bundle, Scheduler2));
        }

        private Job jobWithSpanWrapper(Job job) {
            if (this.instrumenter != null) {
                return new InstrumentedJob(job, this.instrumenter);
            }
            return job;
        }
    }

    static class QuartzTrigger
    implements Trigger {
        private final TriggerKey triggerKey;
        private final Function<TriggerKey, org.quartz.Trigger> triggerFunction;
        private final ScheduledInvoker invoker;
        private final Duration gracePeriod;
        private final boolean isProgrammatic;
        private final String methodDescription;
        final boolean runBlockingMethodOnQuartzThread;

        QuartzTrigger(TriggerKey triggerKey, Function<TriggerKey, org.quartz.Trigger> triggerFunction, ScheduledInvoker invoker, Duration gracePeriod, boolean runBlockingMethodOnQuartzThread, boolean isProgrammatic, String methodDescription) {
            this.triggerKey = triggerKey;
            this.triggerFunction = triggerFunction;
            this.invoker = invoker;
            this.gracePeriod = gracePeriod;
            this.runBlockingMethodOnQuartzThread = runBlockingMethodOnQuartzThread;
            this.isProgrammatic = isProgrammatic;
            this.methodDescription = methodDescription;
        }

        public Instant getNextFireTime() {
            Date nextFireTime = this.trigger().getNextFireTime();
            return nextFireTime != null ? nextFireTime.toInstant() : null;
        }

        public Instant getPreviousFireTime() {
            Date previousFireTime = this.trigger().getPreviousFireTime();
            return previousFireTime != null ? previousFireTime.toInstant() : null;
        }

        public boolean isOverdue() {
            Instant nextFireTime = this.getNextFireTime();
            if (nextFireTime == null) {
                return false;
            }
            return LocalDateTime.ofInstant(nextFireTime, ZoneId.systemDefault()).plus(this.gracePeriod).isBefore(LocalDateTime.now());
        }

        public String getId() {
            return this.trigger().getKey().getName();
        }

        public String getMethodDescription() {
            return this.methodDescription;
        }

        private org.quartz.Trigger trigger() {
            return this.triggerFunction.apply(this.triggerKey);
        }
    }

    static class SerializedExecutionMetadata
    implements ExecutionMetadata {
        private final Class<? extends Consumer<ScheduledExecution>> taskClass;
        private final Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass;
        private final boolean runOnVirtualThread;
        private final Class<? extends Scheduled.SkipPredicate> skipPredicateClass;

        public SerializedExecutionMetadata(JobDetail jobDetail) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            String taskClassStr = jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_TASK_CLASS);
            try {
                this.taskClass = taskClassStr != null ? tccl.loadClass(taskClassStr) : null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load task class: " + taskClassStr);
            }
            String asyncTaskClassStr = jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_ASYNC_TASK_CLASS);
            try {
                this.asyncTaskClass = asyncTaskClassStr != null ? tccl.loadClass(asyncTaskClassStr) : null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load async task class: " + taskClassStr);
            }
            String skipPredicateClassStr = jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_SKIP_PREDICATE_CLASS);
            try {
                this.skipPredicateClass = skipPredicateClassStr != null ? tccl.loadClass(skipPredicateClassStr) : null;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load skip predicate class: " + taskClassStr);
            }
            this.runOnVirtualThread = Boolean.parseBoolean(jobDetail.getJobDataMap().getString(QuartzSchedulerImpl.EXECUTION_METADATA_RUN_ON_VIRTUAL_THREAD));
        }

        @Override
        public Consumer<ScheduledExecution> task() {
            return this.taskClass != null ? (Consumer)SchedulerUtils.instantiateBeanOrClass(this.taskClass) : null;
        }

        @Override
        public Class<? extends Consumer<ScheduledExecution>> taskClass() {
            return this.taskClass;
        }

        @Override
        public Function<ScheduledExecution, Uni<Void>> asyncTask() {
            return this.asyncTaskClass != null ? (Function)SchedulerUtils.instantiateBeanOrClass(this.asyncTaskClass) : null;
        }

        @Override
        public Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass() {
            return this.asyncTaskClass;
        }

        @Override
        public boolean isRunOnVirtualThread() {
            return this.runOnVirtualThread;
        }

        @Override
        public Scheduled.SkipPredicate skipPredicate() {
            return this.skipPredicateClass != null ? (Scheduled.SkipPredicate)SchedulerUtils.instantiateBeanOrClass(this.skipPredicateClass) : null;
        }

        @Override
        public Class<? extends Scheduled.SkipPredicate> skipPredicateClass() {
            return this.skipPredicateClass;
        }
    }

    static interface ExecutionMetadata {
        public Consumer<ScheduledExecution> task();

        public Class<? extends Consumer<ScheduledExecution>> taskClass();

        public Function<ScheduledExecution, Uni<Void>> asyncTask();

        public Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass();

        public boolean isRunOnVirtualThread();

        public Scheduled.SkipPredicate skipPredicate();

        public Class<? extends Scheduled.SkipPredicate> skipPredicateClass();
    }

    class QuartzJobDefinition
    extends AbstractJobDefinition
    implements ExecutionMetadata {
        QuartzJobDefinition(String id) {
            super(id);
        }

        @Override
        public boolean isRunOnVirtualThread() {
            return this.runOnVirtualThread;
        }

        @Override
        public Consumer<ScheduledExecution> task() {
            return this.task;
        }

        @Override
        public Function<ScheduledExecution, Uni<Void>> asyncTask() {
            return this.asyncTask;
        }

        @Override
        public Scheduled.SkipPredicate skipPredicate() {
            return this.skipPredicate;
        }

        @Override
        public Class<? extends Consumer<ScheduledExecution>> taskClass() {
            return this.taskClass;
        }

        @Override
        public Class<? extends Function<ScheduledExecution, Uni<Void>>> asyncTaskClass() {
            return this.asyncTaskClass;
        }

        @Override
        public Class<? extends Scheduled.SkipPredicate> skipPredicateClass() {
            return this.skipPredicateClass;
        }

        public Scheduler.JobDefinition setSkipPredicate(Scheduled.SkipPredicate skipPredicate) {
            if (QuartzSchedulerImpl.this.storeType.isDbStore() && this.skipPredicateClass == null) {
                throw new IllegalStateException("A skip predicate instance cannot be scheduled programmatically if DB store type is used; register a skip predicate class instead");
            }
            return super.setSkipPredicate(skipPredicate);
        }

        public Scheduler.JobDefinition setTask(Consumer<ScheduledExecution> task, boolean runOnVirtualThread) {
            if (QuartzSchedulerImpl.this.storeType.isDbStore() && this.taskClass == null) {
                throw new IllegalStateException("A task instance cannot be scheduled programmatically if DB store type is used; register a task class instead");
            }
            return super.setTask(task, runOnVirtualThread);
        }

        public Scheduler.JobDefinition setAsyncTask(Function<ScheduledExecution, Uni<Void>> asyncTask) {
            if (QuartzSchedulerImpl.this.storeType.isDbStore() && this.asyncTaskClass == null) {
                throw new IllegalStateException("An async task instance cannot be scheduled programmatically if DB store type is used; register an async task class instead");
            }
            return super.setAsyncTask(asyncTask);
        }

        public Trigger schedule() {
            this.checkScheduled();
            if (this.task == null && this.asyncTask == null) {
                throw new IllegalStateException("Either sync or async task must be set");
            }
            this.scheduled = true;
            SyntheticScheduled scheduled = new SyntheticScheduled(this.identity, this.cron, this.every, 0L, TimeUnit.MINUTES, this.delayed, this.overdueGracePeriod, this.concurrentExecution, this.skipPredicate, this.timeZone);
            return QuartzSchedulerImpl.this.createJobDefinitionQuartzTrigger(this, scheduled, null);
        }
    }

    static class InvokerJob
    implements Job {
        final QuartzTrigger trigger;
        final Vertx vertx;

        InvokerJob(QuartzTrigger trigger, Vertx vertx) {
            this.trigger = trigger;
            this.vertx = vertx;
        }

        public void execute(final JobExecutionContext jobExecutionContext) throws JobExecutionException {
            if (this.trigger != null && this.trigger.invoker != null) {
                if (this.trigger.invoker.isBlocking()) {
                    if (this.trigger.runBlockingMethodOnQuartzThread) {
                        try {
                            this.trigger.invoker.invoke((ScheduledExecution)new QuartzScheduledExecution(this.trigger, jobExecutionContext));
                        }
                        catch (Exception exception) {}
                    } else {
                        Context context = VertxContext.getOrCreateDuplicatedContext((Vertx)this.vertx);
                        VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
                        if (this.trigger.invoker.isRunningOnVirtualThread()) {
                            context.runOnContext((Handler)new Handler<Void>(){

                                public void handle(Void event) {
                                    VirtualThreadsRecorder.getCurrent().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                trigger.invoker.invoke((ScheduledExecution)new QuartzScheduledExecution(trigger, jobExecutionContext));
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            context.executeBlocking((Callable)new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    return trigger.invoker.invoke((ScheduledExecution)new QuartzScheduledExecution(trigger, jobExecutionContext));
                                }
                            }, false);
                        }
                    }
                } else {
                    Context context = VertxContext.getOrCreateDuplicatedContext((Vertx)this.vertx);
                    VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
                    context.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            try {
                                trigger.invoker.invoke((ScheduledExecution)new QuartzScheduledExecution(trigger, jobExecutionContext));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            } else {
                String jobName = jobExecutionContext.getJobDetail().getKey().getName();
                LOGGER.warnf("Unable to find corresponding Quartz trigger for job %s. Update your Quartz table by removing all phantom jobs or make sure that there is a Scheduled method with the identity matching the job's name", (Object)jobName);
            }
        }
    }

    static class QuartzScheduledExecution
    implements ScheduledExecution {
        final JobExecutionContext context;
        final QuartzTrigger trigger;

        QuartzScheduledExecution(QuartzTrigger trigger, JobExecutionContext context) {
            this.trigger = trigger;
            this.context = context;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public Instant getFireTime() {
            return this.context.getFireTime().toInstant();
        }

        public Instant getScheduledFireTime() {
            return this.context.getScheduledFireTime().toInstant();
        }
    }
}

