/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.quartz.utils.PoolingConnectionProvider;

public class QuarkusQuartzConnectionPoolProvider
implements PoolingConnectionProvider {
    private AgroalDataSource dataSource;
    private static String dataSourceName;

    public QuarkusQuartzConnectionPoolProvider() {
        ArcContainer container = Arc.container();
        boolean useDefaultDataSource = "QUARKUS_QUARTZ_DEFAULT_DATASOURCE".equals(dataSourceName);
        InstanceHandle instanceHandle = useDefaultDataSource ? container.instance(AgroalDataSource.class, new Annotation[0]) : container.instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(dataSourceName)});
        if (!instanceHandle.isAvailable()) {
            String message = String.format("JDBC Store configured but '%s' datasource is missing. You can configure your datasource by following the guide available at: https://quarkus.io/guides/datasource", useDefaultDataSource ? "default" : dataSourceName);
            throw new IllegalStateException(message);
        }
        this.dataSource = (AgroalDataSource)instanceHandle.get();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void shutdown() {
    }

    public void initialize() {
    }

    static void setDataSourceName(String dataSourceName) {
        QuarkusQuartzConnectionPoolProvider.dataSourceName = dataSourceName;
    }
}

