/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

final class TypeInfos {
    static final String LEFT_ANGLE = "<";
    static final String RIGHT_ANGLE = ">";
    static final String TYPE_INFO_SEPARATOR = "|";

    static List<Info> create(Expression expression, IndexView index, Function<String, String> templateIdToPathFun) {
        if (expression.isLiteral()) {
            Expression.Part literalPart = (Expression.Part)expression.getParts().get(0);
            return Collections.singletonList(TypeInfos.create(literalPart.getTypeInfo(), literalPart, index, templateIdToPathFun, expression.getOrigin()));
        }
        ArrayList<Info> infos = new ArrayList<Info>();
        boolean splitParts = true;
        for (Expression.Part part : expression.getParts()) {
            if (splitParts) {
                List infoParts = Expressions.splitTypeInfoParts((String)part.getTypeInfo());
                for (String infoPart : infoParts) {
                    infos.add(TypeInfos.create(infoPart, part, index, templateIdToPathFun, expression.getOrigin()));
                }
            } else {
                infos.add(TypeInfos.create(part.getTypeInfo(), part, index, templateIdToPathFun, expression.getOrigin()));
            }
            splitParts = false;
        }
        return infos;
    }

    static Info create(String typeInfo, Expression.Part part, IndexView index, Function<String, String> templateIdToPathFun, TemplateNode.Origin expressionOrigin) {
        if (typeInfo.startsWith(TYPE_INFO_SEPARATOR)) {
            int endIdx = typeInfo.substring(1, typeInfo.length()).indexOf(124);
            if (endIdx < 1) {
                throw new IllegalArgumentException("Invalid type info: " + typeInfo);
            }
            String classStr = typeInfo.substring(1, endIdx + 1);
            if (classStr.equals("$$namespace$$")) {
                return new Info(typeInfo, part);
            }
            DotName rawClassName = TypeInfos.rawClassName(classStr);
            ClassInfo rawClass = index.getClassByName(rawClassName);
            if (rawClass == null) {
                throw new TemplateException("Class [" + rawClassName + "] used in the parameter declaration in template [" + templateIdToPathFun.apply(expressionOrigin.getTemplateGeneratedId()) + "] on line " + expressionOrigin.getLine() + " was not found in the application index. Make sure it is spelled correctly.");
            }
            Type resolvedType = TypeInfos.resolveType(classStr);
            return new TypeInfo(typeInfo, part, TypeInfos.helperHint(typeInfo.substring(endIdx, typeInfo.length())), resolvedType, rawClass);
        }
        if (part.isVirtualMethod()) {
            return new VirtualMethodInfo(typeInfo, part.asVirtualMethod());
        }
        String hint = TypeInfos.helperHint(typeInfo);
        if (hint != null) {
            typeInfo = typeInfo.substring(0, typeInfo.indexOf(LEFT_ANGLE));
        }
        return new PropertyInfo(typeInfo, part, hint);
    }

    private static DotName rawClassName(String value) {
        int angleIdx = value.indexOf(LEFT_ANGLE);
        if (angleIdx != -1) {
            return DotName.createSimple((String)value.substring(0, angleIdx));
        }
        return DotName.createSimple((String)value);
    }

    private static String helperHint(String part) {
        int angleIdx = part.indexOf(LEFT_ANGLE);
        if (angleIdx == -1) {
            return null;
        }
        return part.substring(angleIdx, part.length());
    }

    private static Type resolveType(String value) {
        int angleIdx = value.indexOf(LEFT_ANGLE);
        if (angleIdx == -1) {
            return Type.create((DotName)DotName.createSimple((String)value), (Type.Kind)Type.Kind.CLASS);
        }
        String name = value.substring(0, angleIdx);
        DotName rawName = DotName.createSimple((String)name);
        String[] parts = value.substring(angleIdx + 1, value.length() - 1).split(",");
        Type[] arguments = new Type[parts.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = TypeInfos.resolveType(parts[i].trim());
        }
        return ParameterizedType.create((DotName)rawName, (Type[])arguments, null);
    }

    private TypeInfos() {
    }

    static class VirtualMethodInfo
    extends Info {
        final String name;

        public VirtualMethodInfo(String value, Expression.VirtualMethodPart part) {
            super(value, (Expression.Part)part);
            this.name = part.getName();
        }

        @Override
        public boolean isVirtualMethod() {
            return true;
        }

        @Override
        public VirtualMethodInfo asVirtualMethod() {
            return this;
        }
    }

    static class PropertyInfo
    extends HintInfo {
        final String name;

        public PropertyInfo(String name, Expression.Part part, String hint) {
            super(name, part, hint);
            this.name = name;
        }

        @Override
        public boolean isProperty() {
            return true;
        }

        @Override
        public PropertyInfo asProperty() {
            return this;
        }
    }

    static class TypeInfo
    extends HintInfo {
        final Type resolvedType;
        final ClassInfo rawClass;

        public TypeInfo(String value, Expression.Part part, String hint, Type resolvedType, ClassInfo rawClass) {
            super(value, part, hint);
            this.resolvedType = resolvedType;
            this.rawClass = rawClass;
        }

        @Override
        boolean isTypeInfo() {
            return true;
        }

        @Override
        TypeInfo asTypeInfo() {
            return this;
        }
    }

    static abstract class HintInfo
    extends Info {
        final String hint;

        public HintInfo(String value, Expression.Part part, String hint) {
            super(value, part);
            this.hint = hint;
        }
    }

    static class Info {
        final String value;
        final Expression.Part part;

        public Info(String value, Expression.Part part) {
            this.value = value;
            this.part = part;
        }

        boolean isVirtualMethod() {
            return false;
        }

        boolean isProperty() {
            return false;
        }

        boolean isTypeInfo() {
            return false;
        }

        VirtualMethodInfo asVirtualMethod() {
            throw new IllegalArgumentException("Not a virtual method");
        }

        PropertyInfo asProperty() {
            throw new IllegalArgumentException("Not a property");
        }

        TypeInfo asTypeInfo() {
            throw new IllegalArgumentException("Not a type info: " + this.getClass().getName() + ":" + this.toString());
        }

        public String toString() {
            return this.value;
        }
    }
}

