/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.Variant;
import io.quarkus.qute.api.ResourcePath;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.deployment.CheckedTemplateAdapterBuildItem;
import io.quarkus.qute.deployment.CheckedTemplateBuildItem;
import io.quarkus.qute.deployment.GeneratedValueResolverBuildItem;
import io.quarkus.qute.deployment.ImplicitValueResolverBuildItem;
import io.quarkus.qute.deployment.IncorrectExpressionBuildItem;
import io.quarkus.qute.deployment.MessageBundleMethodBuildItem;
import io.quarkus.qute.deployment.Names;
import io.quarkus.qute.deployment.NativeCheckedTemplateEnhancer;
import io.quarkus.qute.deployment.TemplateDataBuilder;
import io.quarkus.qute.deployment.TemplateExtensionMethodBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateVariantsBuildItem;
import io.quarkus.qute.deployment.TemplatesAnalysisBuildItem;
import io.quarkus.qute.deployment.TypeCheckExcludeBuildItem;
import io.quarkus.qute.deployment.TypeInfos;
import io.quarkus.qute.deployment.Types;
import io.quarkus.qute.generator.ExtensionMethodGenerator;
import io.quarkus.qute.generator.ValueResolverGenerator;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.EngineProducer;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.qute.runtime.devmode.QuteDevConsoleRecorder;
import io.quarkus.qute.runtime.extensions.CollectionTemplateExtensions;
import io.quarkus.qute.runtime.extensions.ConfigTemplateExtensions;
import io.quarkus.qute.runtime.extensions.MapTemplateExtensions;
import io.quarkus.qute.runtime.extensions.NumberTemplateExtensions;
import io.quarkus.qute.runtime.extensions.TimeTemplateExtensions;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class QuteProcessor {
    public static final DotName RESOURCE_PATH = Names.RESOURCE_PATH;
    private static final Logger LOGGER = Logger.getLogger(QuteProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.QUTE);
    }

    @BuildStep
    void processTemplateErrors(TemplatesAnalysisBuildItem analysis, List<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ServiceStartBuildItem> serviceStart) {
        ArrayList<TemplateException> errors = new ArrayList<TemplateException>();
        for (IncorrectExpressionBuildItem incorrectExpression : incorrectExpressions) {
            if (incorrectExpression.reason != null) {
                errors.add(new TemplateException(incorrectExpression.origin, String.format("Incorrect expression found: {%s}\n\t- %s\n\t- at %s:%s", incorrectExpression.expression, incorrectExpression.reason, QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId()), incorrectExpression.origin.getLine())));
                continue;
            }
            if (incorrectExpression.clazz != null) {
                errors.add(new TemplateException(incorrectExpression.origin, String.format("Incorrect expression found: {%s}\n\t- property/method [%s] not found on class [%s] nor handled by an extension method\n\t- at %s:%s", incorrectExpression.expression, incorrectExpression.property, incorrectExpression.clazz, QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId()), incorrectExpression.origin.getLine())));
                continue;
            }
            errors.add(new TemplateException(incorrectExpression.origin, String.format("Incorrect expression found: {%s}\n\t- @Named bean not found for [%s]\n\t- at %s:%s", incorrectExpression.expression, incorrectExpression.property, QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId()), incorrectExpression.origin.getLine())));
        }
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder("Found template problems (").append(errors.size()).append("):");
            int idx = 1;
            for (TemplateException error : errors) {
                message.append("\n").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            TemplateException exception = new TemplateException(message.toString());
            for (TemplateException error : errors) {
                exception.addSuppressed((Throwable)error);
            }
            throw exception;
        }
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{EngineProducer.class, TemplateProducer.class, ContentTypes.class, ResourcePath.class, Template.class, TemplateInstance.class, CollectionTemplateExtensions.class, MapTemplateExtensions.class, NumberTemplateExtensions.class, ConfigTemplateExtensions.class, TimeTemplateExtensions.class}).build();
    }

    @BuildStep
    List<CheckedTemplateBuildItem> collectTemplateTypeInfo(BeanArchiveIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, List<TemplatePathBuildItem> templatePaths, List<CheckedTemplateAdapterBuildItem> templateAdaptorBuildItems) {
        String supportedAdaptors;
        ArrayList<CheckedTemplateBuildItem> ret = new ArrayList<CheckedTemplateBuildItem>();
        HashMap<DotName, CheckedTemplateAdapter> adaptors = new HashMap<DotName, CheckedTemplateAdapter>();
        for (CheckedTemplateAdapterBuildItem templateAdaptorBuildItem : templateAdaptorBuildItems) {
            adaptors.put(DotName.createSimple((String)templateAdaptorBuildItem.adapter.templateInstanceBinaryName().replace('/', '.')), templateAdaptorBuildItem.adapter);
        }
        if (adaptors.isEmpty()) {
            supportedAdaptors = Names.TEMPLATE_INSTANCE + " is supported";
        } else {
            StringBuffer strbuf = new StringBuffer(Names.TEMPLATE_INSTANCE.toString());
            ArrayList<String> adaptorsList = new ArrayList<String>(adaptors.size());
            for (DotName dotName : adaptors.keySet()) {
                adaptorsList.add(dotName.toString());
            }
            Collections.sort(adaptorsList);
            for (String string : adaptorsList) {
                strbuf.append(", ").append(string);
            }
            supportedAdaptors = strbuf.append(" are supported").toString();
        }
        HashMap<String, MethodInfo> checkedTemplateMethods = new HashMap<String, MethodInfo>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(Names.CHECKED_TEMPLATE)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = annotation.target().asClass();
            NativeCheckedTemplateEnhancer enhancer = new NativeCheckedTemplateEnhancer();
            for (MethodInfo methodInfo : classInfo.methods()) {
                String templatePath;
                MethodInfo checkedTemplateMethod;
                if (!Modifier.isStatic(methodInfo.flags()) || !Modifier.isNative(methodInfo.flags())) continue;
                if (methodInfo.returnType().kind() != Type.Kind.CLASS) {
                    throw new TemplateException("Incompatible checked template return type: " + methodInfo.returnType() + " only " + supportedAdaptors);
                }
                DotName returnTypeName = methodInfo.returnType().asClassType().name();
                CheckedTemplateAdapter adaptor = null;
                if (!returnTypeName.equals((Object)Names.TEMPLATE_INSTANCE) && (adaptor = (CheckedTemplateAdapter)adaptors.get(returnTypeName)) == null) {
                    throw new TemplateException("Incompatible checked template return type: " + methodInfo.returnType() + " only " + supportedAdaptors);
                }
                StringBuilder templatePathBuilder = new StringBuilder();
                AnnotationValue basePathValue = annotation.value("basePath");
                if (basePathValue != null && !basePathValue.asString().equals("<<defaulted>>")) {
                    templatePathBuilder.append(basePathValue.asString());
                } else if (classInfo.enclosingClass() != null) {
                    ClassInfo enclosingClass = index.getIndex().getClassByName(classInfo.enclosingClass());
                    templatePathBuilder.append(enclosingClass.simpleName());
                }
                if (templatePathBuilder.length() > 0 && templatePathBuilder.charAt(templatePathBuilder.length() - 1) != '/') {
                    templatePathBuilder.append('/');
                }
                if ((checkedTemplateMethod = checkedTemplateMethods.putIfAbsent(templatePath = templatePathBuilder.append(methodInfo.name()).toString(), methodInfo)) != null) {
                    throw new TemplateException(String.format("Multiple checked template methods exist for the template path %s:\n\t- %s: %s\n\t- %s: %s", templatePath, methodInfo.declaringClass().name(), methodInfo, checkedTemplateMethod.declaringClass().name(), checkedTemplateMethod));
                }
                this.checkTemplatePath(templatePath, templatePaths, classInfo, methodInfo);
                HashMap<String, String> bindings = new HashMap<String, String>();
                List parameters = methodInfo.parameters();
                ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
                for (int i = 0; i < parameters.size(); ++i) {
                    Type type = (Type)parameters.get(i);
                    String name = methodInfo.parameterName(i);
                    if (name == null) {
                        throw new TemplateException("Parameter names not recorded for " + classInfo.name() + ": compile the class with -parameters");
                    }
                    bindings.put(name, JandexUtil.getBoxedTypeName((Type)type));
                    parameterNames.add(name);
                }
                ret.add(new CheckedTemplateBuildItem(templatePath, bindings, methodInfo));
                enhancer.implement(methodInfo, templatePath, parameterNames, adaptor);
            }
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
        }
        return ret;
    }

    private void checkTemplatePath(String templatePath, List<TemplatePathBuildItem> templatePaths, ClassInfo enclosingClass, MethodInfo methodInfo) {
        for (TemplatePathBuildItem templatePathBuildItem : templatePaths) {
            if (templatePathBuildItem.getPath().equals(templatePath)) {
                return;
            }
            if (!templatePathBuildItem.getPath().startsWith(templatePath) || templatePathBuildItem.getPath().charAt(templatePath.length()) != '.') continue;
            return;
        }
        throw new TemplateException("Declared template " + templatePath + " could not be found. Either add it or delete its declaration in " + enclosingClass.name().toString('.') + "." + methodInfo.name());
    }

    @BuildStep
    TemplatesAnalysisBuildItem analyzeTemplates(final List<TemplatePathBuildItem> templatePaths, final List<CheckedTemplateBuildItem> checkedTemplates, final List<MessageBundleMethodBuildItem> messageBundleMethods) {
        Template template;
        long start = System.currentTimeMillis();
        ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis> analysis = new ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis>();
        EngineBuilder builder = Engine.builder().addDefaultSectionHelpers();
        for (TemplatePathBuildItem path : templatePaths) {
            if (!path.isTag()) continue;
            String tagPath = path.getPath();
            String tagName = tagPath.substring("tags/".length(), tagPath.length());
            if (tagName.contains(".")) {
                tagName = tagName.substring(0, tagName.lastIndexOf(46));
            }
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, tagPath));
        }
        builder.computeSectionHelper(name -> new SectionHelperFactory<SectionHelper>(){

            public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
                return new SectionHelper(){

                    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                        return ResultNode.NOOP;
                    }
                };
            }
        });
        builder.addLocator(new TemplateLocator(){

            public Optional<TemplateLocator.TemplateLocation> locate(String id) {
                TemplatePathBuildItem found = templatePaths.stream().filter(p -> p.getPath().equals(id)).findAny().orElse(null);
                if (found != null) {
                    try {
                        final byte[] content = Files.readAllBytes(found.getFullPath());
                        return Optional.of(new TemplateLocator.TemplateLocation(){

                            public Reader read() {
                                return new StringReader(new String(content, StandardCharsets.UTF_8));
                            }

                            public Optional<Variant> getVariant() {
                                return Optional.empty();
                            }
                        });
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Unable to read the template from path: " + found.getFullPath()), (Throwable)e);
                    }
                }
                return Optional.empty();
            }
        }).addParserHook(new ParserHook(){

            public void beforeParsing(ParserHelper parserHelper, String id) {
                if (id != null) {
                    for (CheckedTemplateBuildItem checkedTemplate : checkedTemplates) {
                        if (!id.startsWith(checkedTemplate.templateId)) continue;
                        for (Map.Entry<String, String> entry : checkedTemplate.bindings.entrySet()) {
                            parserHelper.addParameter(entry.getKey(), entry.getValue());
                        }
                    }
                    for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
                        if (!id.equals(messageBundleMethod.getTemplateId())) continue;
                        MethodInfo method = messageBundleMethod.getMethod();
                        ListIterator it = method.parameters().listIterator();
                        while (it.hasNext()) {
                            Type paramType = (Type)it.next();
                            parserHelper.addParameter(method.parameterName(it.previousIndex()), JandexUtil.getBoxedTypeName((Type)paramType));
                        }
                        break block2;
                    }
                }
            }
        }).build();
        Engine dummyEngine = builder.build();
        for (TemplatePathBuildItem path : templatePaths) {
            template = dummyEngine.getTemplate(path.getPath());
            if (template == null) continue;
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(null, template.getGeneratedId(), template.getExpressions(), path.getPath()));
        }
        for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
            template = dummyEngine.parse(messageBundleMethod.getTemplate(), null, messageBundleMethod.getTemplateId());
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(messageBundleMethod.getTemplateId(), template.getGeneratedId(), template.getExpressions(), messageBundleMethod.getMethod().declaringClass().name() + "#" + messageBundleMethod.getMethod().name() + "()"));
        }
        LOGGER.debugf("Finished analysis of %s templates in %s ms", (long)analysis.size(), System.currentTimeMillis() - start);
        return new TemplatesAnalysisBuildItem(analysis);
    }

    @BuildStep
    void validateExpressions(final TemplatesAnalysisBuildItem templatesAnalysis, BeanArchiveIndexBuildItem beanArchiveIndex, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ImplicitValueResolverBuildItem> implicitClasses, BeanDiscoveryFinishedBuildItem beanDiscovery) {
        IndexView index = beanArchiveIndex.getIndex();
        Function<String, String> templateIdToPathFun = new Function<String, String>(){

            @Override
            public String apply(String id) {
                return QuteProcessor.findTemplatePath(templatesAnalysis, id);
            }
        };
        Map namedBeans = (Map)beanDiscovery.beanStream().withName().collect(Collectors.toMap(BeanInfo::getName, Function.identity()));
        HashMap<DotName, Set<String>> implicitClassToMembersUsed = new HashMap<DotName, Set<String>>();
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : templatesAnalysis.getAnalysis()) {
            HashMap<Integer, Match> generatedIdsToMatches = new HashMap<Integer, Match>();
            for (Expression expression : templateAnalysis.expressions) {
                if (expression.isLiteral()) continue;
                if (expression.hasNamespace()) {
                    if (!expression.getNamespace().equals("inject")) continue;
                    this.validateInjectExpression(templateAnalysis, expression, index, incorrectExpressions, templateExtensionMethods, excludes, namedBeans, generatedIdsToMatches, implicitClassToMembersUsed, templateIdToPathFun);
                    continue;
                }
                generatedIdsToMatches.put(expression.getGeneratedId(), QuteProcessor.validateNestedExpressions(templateAnalysis, null, new HashMap<String, Match>(), templateExtensionMethods, excludes, incorrectExpressions, expression, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches));
            }
        }
        for (Map.Entry entry : implicitClassToMembersUsed.entrySet()) {
            ClassInfo clazz = index.getClassByName((DotName)entry.getKey());
            if (clazz == null) continue;
            implicitClasses.produce((BuildItem)new ImplicitValueResolverBuildItem(clazz, new TemplateDataBuilder().addIgnore(QuteProcessor.buildIgnorePattern((Iterable)entry.getValue())).build()));
        }
    }

    static String buildIgnorePattern(Iterable<String> names) {
        StringBuilder ignorePattern = new StringBuilder("^(?!");
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String memberName = iterator.next();
            ignorePattern.append(Pattern.quote(memberName));
            if (!iterator.hasNext()) continue;
            ignorePattern.append("|");
        }
        ignorePattern.append(").*$");
        return ignorePattern.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    static Match validateNestedExpressions(TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, ClassInfo rootClazz, Map<String, Match> results, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Expression expression, IndexView index, Map<DotName, Set<String>> implicitClassToMembersUsed, Function<String, String> templateIdToPathFun, Map<Integer, Match> generatedIdsToMatches) {
        Iterator<TypeInfos.Info> iterator;
        Match match;
        block21: {
            block19: {
                TypeInfos.Info root;
                List<TypeInfos.Info> parts;
                block20: {
                    for (Expression.Part part : expression.getParts()) {
                        if (!part.isVirtualMethod()) continue;
                        for (Expression param : part.asVirtualMethod().getParameters()) {
                            if (results.containsKey(param.toOriginalString())) continue;
                            QuteProcessor.validateNestedExpressions(templateAnalysis, null, results, templateExtensionMethods, excludes, incorrectExpressions, param, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches);
                        }
                    }
                    match = new Match(index);
                    if (rootClazz == null && !expression.hasTypeInfo()) {
                        results.put(expression.toOriginalString(), match);
                        return match;
                    }
                    parts = TypeInfos.create(expression, index, templateIdToPathFun);
                    iterator = parts.iterator();
                    root = iterator.next();
                    if (rootClazz != null) break block19;
                    if (!root.isTypeInfo()) break block20;
                    match.setValues(root.asTypeInfo().rawClass, root.asTypeInfo().resolvedType);
                    if (root.asTypeInfo().hint != null) {
                        QuteProcessor.processHints(templateAnalysis, root.asTypeInfo().hint, match, index, expression, generatedIdsToMatches, incorrectExpressions);
                    }
                    break block21;
                }
                if (root.isProperty() && root.asProperty().hint != null) {
                    if (QuteProcessor.processHints(templateAnalysis, root.asProperty().hint, match, index, expression, generatedIdsToMatches, incorrectExpressions)) {
                        iterator = parts.iterator();
                    }
                    break block21;
                } else {
                    results.put(expression.toOriginalString(), match);
                    return match;
                }
            }
            match.setValues(rootClazz, Type.create((DotName)rootClazz.name(), (Type.Kind)Type.Kind.CLASS));
        }
        while (iterator.hasNext()) {
            TypeInfos.Info info = iterator.next();
            if (!match.isEmpty()) {
                String hint;
                TypeCheckExcludeBuildItem.TypeCheck check;
                Set<String> membersUsed = implicitClassToMembersUsed.get(match.clazz().name());
                if (membersUsed == null) {
                    membersUsed = new HashSet<String>();
                    implicitClassToMembersUsed.put(match.clazz().name(), membersUsed);
                }
                AnnotationTarget member = null;
                if (info.isVirtualMethod()) {
                    member = QuteProcessor.findMethod(info.part.asVirtualMethod(), match.clazz(), expression, index, templateIdToPathFun, results);
                    if (member != null) {
                        membersUsed.add(member.asMethod().name());
                    }
                } else if (info.isProperty() && (member = QuteProcessor.findProperty(info.asProperty().name, match.clazz(), index)) != null) {
                    membersUsed.add(member.kind() == AnnotationTarget.Kind.FIELD ? member.asField().name() : member.asMethod().name());
                }
                if (member == null) {
                    member = QuteProcessor.findTemplateExtensionMethod(info, match.clazz(), templateExtensionMethods, expression, index, templateIdToPathFun, results);
                }
                if (member == null && QuteProcessor.isExcluded(check = new TypeCheckExcludeBuildItem.TypeCheck(info.isProperty() ? info.asProperty().name : info.asVirtualMethod().name, match.clazz(), info.part.isVirtualMethod() ? info.part.asVirtualMethod().getParameters().size() : -1), excludes)) {
                    LOGGER.debugf("Expression part [%s] excluded from validation of [%s] against class [%s]", (Object)info.value, (Object)expression.toOriginalString(), (Object)match.clazz());
                    match.clearValues();
                    break;
                }
                if (member == null) {
                    incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), info.value, match.clazz().toString(), expression.getOrigin()));
                    match.clearValues();
                    break;
                }
                Type type = QuteProcessor.resolveType(member, match, index);
                ClassInfo clazz = null;
                if (type.kind() == Type.Kind.CLASS || type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    clazz = index.getClassByName(type.name());
                }
                match.setValues(clazz, type);
                if (info.isProperty() && (hint = info.asProperty().hint) != null) {
                    QuteProcessor.processHints(templateAnalysis, hint, match, index, expression, generatedIdsToMatches, incorrectExpressions);
                }
                if (!match.isPrimitive()) continue;
                break;
            }
            LOGGER.debugf("No match class available - skip further validation for [%s] in expression [%s] in template [%s] on line %s", new Object[]{info.part, expression.toOriginalString(), expression.getOrigin().getTemplateId(), expression.getOrigin().getLine()});
            match.clearValues();
            break;
        }
        results.put(expression.toOriginalString(), match);
        return match;
    }

    @BuildStep
    void collectTemplateExtensionMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods) {
        AnnotationValue namespaceValue;
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<MethodInfo, AnnotationInstance> methods = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<ClassInfo, AnnotationInstance> classes = new HashMap<ClassInfo, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ExtensionMethodGenerator.TEMPLATE_EXTENSION)) {
            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                methods.put(annotationInstance.target().asMethod(), annotationInstance);
                continue;
            }
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            classes.put(annotationInstance.target().asClass(), annotationInstance);
        }
        for (Map.Entry entry : methods.entrySet()) {
            MethodInfo method = (MethodInfo)entry.getKey();
            namespaceValue = ((AnnotationInstance)entry.getValue()).value("namespace");
            ExtensionMethodGenerator.validate((MethodInfo)method, (List)method.parameters(), (String)(namespaceValue != null ? namespaceValue.asString() : null));
            this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
            LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
        }
        for (Map.Entry entry : classes.entrySet()) {
            ClassInfo clazz = (ClassInfo)entry.getKey();
            namespaceValue = ((AnnotationInstance)entry.getValue()).value("namespace");
            String namespace = namespaceValue != null ? namespaceValue.asString() : null;
            for (MethodInfo method : clazz.methods()) {
                if (!Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID || Modifier.isPrivate(method.flags()) || ValueResolverGenerator.isSynthetic((int)method.flags()) || (namespace == null || namespace.isEmpty()) && method.parameters().isEmpty() || methods.containsKey(method)) continue;
                this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
                LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
            }
        }
    }

    private void produceExtensionMethod(IndexView index, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods, MethodInfo method, AnnotationInstance extensionAnnotation) {
        String matchName = null;
        AnnotationValue matchNameValue = extensionAnnotation.value("matchName");
        if (matchNameValue != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null) {
            matchName = method.name();
        }
        int priority = 5;
        AnnotationValue priorityValue = extensionAnnotation.value("priority");
        if (priorityValue != null) {
            priority = priorityValue.asInt();
        }
        String namespace = "";
        AnnotationValue namespaceValue = extensionAnnotation.value("namespace");
        if (namespaceValue != null) {
            namespace = namespaceValue.asString();
        }
        String matchRegex = null;
        AnnotationValue matchRegexValue = extensionAnnotation.value("matchRegex");
        if (matchRegexValue != null) {
            matchRegex = matchRegexValue.asString();
        }
        extensionMethods.produce((BuildItem)new TemplateExtensionMethodBuildItem(method, matchName, matchRegex, namespace.isEmpty() ? index.getClassByName(((Type)method.parameters().get(0)).name()) : null, priority, namespace));
    }

    private void validateInjectExpression(TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, Expression expression, IndexView index, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> excludes, Map<String, BeanInfo> namedBeans, Map<Integer, Match> generatedIdsToMatches, Map<DotName, Set<String>> implicitClassToMembersUsed, Function<String, String> templateIdToPathFun) {
        String beanName;
        Expression.Part firstPart = (Expression.Part)expression.getParts().get(0);
        if (firstPart.isVirtualMethod()) {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "The inject: namespace must be followed by a bean name", expression.getOrigin()));
            return;
        }
        if (expression.hasNamespace()) {
            beanName = firstPart.getName();
        } else {
            String firstInfoPart = (String)Expressions.splitTypeInfoParts((String)firstPart.getTypeInfo()).get(0);
            beanName = firstInfoPart.substring("inject".length() + 1, firstInfoPart.length());
        }
        BeanInfo bean = namedBeans.get(beanName);
        if (bean != null) {
            if (expression.getParts().size() == 1) {
                return;
            }
            generatedIdsToMatches.put(expression.getGeneratedId(), QuteProcessor.validateNestedExpressions(templateAnalysis, bean.getImplClazz(), new HashMap<String, Match>(), templateExtensionMethods, excludes, incorrectExpressions, expression, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches));
        } else {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), beanName, null, expression.getOrigin()));
        }
    }

    static String findTemplatePath(TemplatesAnalysisBuildItem analysis, String id) {
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : analysis.getAnalysis()) {
            if (!templateAnalysis.generatedId.equals(id)) continue;
            return templateAnalysis.path;
        }
        return null;
    }

    @BuildStep
    void generateValueResolvers(QuteConfig config, BuildProducer<GeneratedClassBuildItem> generatedClasses, CombinedIndexBuildItem combinedIndex, BeanArchiveIndexBuildItem beanArchiveIndex, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<TemplatePathBuildItem> templatePaths, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<ImplicitValueResolverBuildItem> implicitClasses, TemplatesAnalysisBuildItem templatesAnalysis, BuildProducer<GeneratedValueResolverBuildItem> generatedResolvers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = beanArchiveIndex.getIndex();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String name) {
                QuarkusClassLoader cl;
                String className;
                int idx = name.lastIndexOf("_Namespace_Extension_ValueResolver");
                if (idx == -1) {
                    idx = name.lastIndexOf("_Extension_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_ValueResolver");
                }
                if ((className = name.substring(0, idx)).contains("$_")) {
                    className = className.replace("$_", "$");
                }
                return !(cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader()).getElementsWithResource(className + ".class", true).isEmpty();
            }
        });
        ValueResolverGenerator.Builder builder = ValueResolverGenerator.builder().setIndex(index).setClassOutput((ClassOutput)classOutput);
        HashSet<DotName> controlled = new HashSet<DotName>();
        HashMap<DotName, AnnotationInstance> uncontrolled = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance templateData : index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA)) {
            this.processsTemplateData(index, templateData, templateData.target(), controlled, uncontrolled, builder);
        }
        for (AnnotationInstance containerInstance : index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA_CONTAINER)) {
            for (AnnotationInstance templateData : containerInstance.value().asNestedArray()) {
                this.processsTemplateData(index, templateData, containerInstance.target(), controlled, uncontrolled, builder);
            }
        }
        for (ImplicitValueResolverBuildItem implicit : implicitClasses) {
            DotName implicitClassName = implicit.getClazz().name();
            if (controlled.contains(implicitClassName)) {
                LOGGER.debugf("Implicit value resolver for %s ignored: class is annotated with @TemplateData", (Object)implicitClassName);
                continue;
            }
            if (uncontrolled.containsKey(implicitClassName)) {
                LOGGER.debugf("Implicit value resolver for %d ignored: %s declared on %s", uncontrolled.get(implicitClassName), (Object)((AnnotationInstance)uncontrolled.get(implicitClassName)).target());
                continue;
            }
            builder.addClass(implicit.getClazz(), implicit.getTemplateData());
        }
        ValueResolverGenerator generator = builder.build();
        generator.generate();
        HashSet generatedTypes = new HashSet();
        generatedTypes.addAll(generator.getGeneratedTypes());
        ExtensionMethodGenerator extensionMethodGenerator = new ExtensionMethodGenerator(index, (ClassOutput)classOutput);
        HashMap classToNamespaceExtensions = new HashMap();
        HashMap<String, DotName> namespaceToClass = new HashMap<String, DotName>();
        for (TemplateExtensionMethodBuildItem templateExtensionMethodBuildItem : templateExtensionMethods) {
            if (templateExtensionMethodBuildItem.hasNamespace()) {
                ArrayList<TemplateExtensionMethodBuildItem> namespaceMethods;
                DotName declaringClassName = templateExtensionMethodBuildItem.getMethod().declaringClass().name();
                DotName namespaceClassName = (DotName)namespaceToClass.get(templateExtensionMethodBuildItem.getNamespace());
                if (namespaceClassName == null) {
                    namespaceToClass.put(templateExtensionMethodBuildItem.getNamespace(), namespaceClassName);
                } else if (!namespaceClassName.equals((Object)declaringClassName)) {
                    throw new IllegalStateException("Template extension methods that share the namespace " + templateExtensionMethodBuildItem.getNamespace() + " must be declared on the same class; but declared on " + namespaceClassName + " and " + declaringClassName);
                }
                HashMap<String, ArrayList<TemplateExtensionMethodBuildItem>> namespaceToExtensions = (HashMap<String, ArrayList<TemplateExtensionMethodBuildItem>>)classToNamespaceExtensions.get(declaringClassName);
                if (namespaceToExtensions == null) {
                    namespaceToExtensions = new HashMap<String, ArrayList<TemplateExtensionMethodBuildItem>>();
                    classToNamespaceExtensions.put(declaringClassName, namespaceToExtensions);
                }
                if ((namespaceMethods = (ArrayList<TemplateExtensionMethodBuildItem>)namespaceToExtensions.get(templateExtensionMethodBuildItem.getNamespace())) == null) {
                    namespaceMethods = new ArrayList<TemplateExtensionMethodBuildItem>();
                    namespaceToExtensions.put(templateExtensionMethodBuildItem.getNamespace(), namespaceMethods);
                }
                namespaceMethods.add(templateExtensionMethodBuildItem);
                continue;
            }
            extensionMethodGenerator.generate(templateExtensionMethodBuildItem.getMethod(), templateExtensionMethodBuildItem.getMatchName(), templateExtensionMethodBuildItem.getMatchRegex(), Integer.valueOf(templateExtensionMethodBuildItem.getPriority()));
        }
        for (Map.Entry entry : classToNamespaceExtensions.entrySet()) {
            Map namespaceToMethods = (Map)entry.getValue();
            for (Map.Entry entry2 : namespaceToMethods.entrySet()) {
                List methods = (List)entry2.getValue();
                methods.sort(Comparator.comparingInt(TemplateExtensionMethodBuildItem::getPriority).reversed());
                ExtensionMethodGenerator.NamespaceResolverCreator namespaceResolverCreator = extensionMethodGenerator.createNamespaceResolver(((TemplateExtensionMethodBuildItem)((Object)methods.get(0))).getMethod().declaringClass(), (String)entry2.getKey());
                Throwable throwable = null;
                try {
                    ExtensionMethodGenerator.NamespaceResolverCreator.ResolveCreator resolveCreator = namespaceResolverCreator.implementResolve();
                    Throwable throwable2 = null;
                    try {
                        for (TemplateExtensionMethodBuildItem method : methods) {
                            resolveCreator.addMethod(method.getMethod(), method.getMatchName(), method.getMatchRegex());
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resolveCreator == null) continue;
                        if (throwable2 != null) {
                            try {
                                resolveCreator.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resolveCreator.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (namespaceResolverCreator == null) continue;
                    if (throwable != null) {
                        try {
                            namespaceResolverCreator.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    namespaceResolverCreator.close();
                }
            }
        }
        generatedTypes.addAll(extensionMethodGenerator.getGeneratedTypes());
        LOGGER.debugf("Generated types: %s", generatedTypes);
        for (String string : generatedTypes) {
            generatedResolvers.produce((BuildItem)new GeneratedValueResolverBuildItem(string));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{string}));
        }
    }

    @BuildStep
    void collectTemplates(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) throws IOException {
        String basePath;
        ApplicationArchive applicationArchive = applicationArchivesBuildItem.getRootArchive();
        Path templatesPath = applicationArchive.getChildPath(basePath = "templates");
        if (templatesPath != null) {
            this.scan(templatesPath, templatesPath, basePath + "/", watchedPaths, templatePaths, nativeImageResources);
        }
    }

    @BuildStep
    void validateTemplateInjectionPoints(QuteConfig config, List<TemplatePathBuildItem> templatePaths, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        HashSet<String> filePaths = new HashSet<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            String path2 = templatePath.getPath();
            filePaths.add(path2);
            for (String suffix : config.suffixes) {
                if (!path2.endsWith(suffix)) continue;
                filePaths.add(path2.substring(0, path2.length() - (suffix.length() + 1)));
            }
        }
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            AnnotationInstance resourcePath;
            String name;
            if (!injectionPoint.getRequiredType().name().equals((Object)Names.TEMPLATE) || (name = (resourcePath = injectionPoint.getRequiredQualifier(Names.RESOURCE_PATH)) != null ? resourcePath.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName(injectionPoint) : null)) == null || !filePaths.stream().noneMatch(path -> path.endsWith(name))) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException("No template found for " + injectionPoint.getTargetInfo())}));
        }
    }

    @BuildStep
    TemplateVariantsBuildItem collectTemplateVariants(List<TemplatePathBuildItem> templatePaths) throws IOException {
        Set allPaths = templatePaths.stream().map(TemplatePathBuildItem::getPath).collect(Collectors.toSet());
        HashMap<String, List<String>> baseToVariants = new HashMap<String, List<String>>();
        for (String path : allPaths) {
            int idx = path.lastIndexOf(46);
            if (idx == -1) continue;
            String base = path.substring(0, idx);
            ArrayList<String> variants = (ArrayList<String>)baseToVariants.get(base);
            if (variants == null) {
                variants = new ArrayList<String>();
                baseToVariants.put(base, variants);
            }
            variants.add(path);
        }
        LOGGER.debugf("Template variants found: %s", baseToVariants);
        return new TemplateVariantsBuildItem(baseToVariants);
    }

    @BuildStep
    void excludeTypeChecks(BuildProducer<TypeCheckExcludeBuildItem> excludes) {
        final List<String> skipOperators = Arrays.asList("?:", "or", ":", "?", "&&", "||");
        excludes.produce((BuildItem)new TypeCheckExcludeBuildItem(new Predicate<TypeCheckExcludeBuildItem.TypeCheck>(){

            @Override
            public boolean test(TypeCheckExcludeBuildItem.TypeCheck check) {
                if (check.isProperty() && ("raw".equals(check.name) || "safe".equals(check.name))) {
                    return true;
                }
                if (check.numberOfParameters == 1 && skipOperators.contains(check.name)) {
                    return true;
                }
                return check.numberOfParameters == 1 && check.classNameEquals(Names.COLLECTION) && check.name.equals("contains");
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initialize(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, QuteRecorder recorder, List<GeneratedValueResolverBuildItem> generatedValueResolvers, List<TemplatePathBuildItem> templatePaths, Optional<TemplateVariantsBuildItem> templateVariants) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            if (templatePath.isTag()) {
                String tagPath = templatePath.getPath();
                tags.add(tagPath.substring("tags/".length(), tagPath.length()));
                continue;
            }
            templates.add(templatePath.getPath());
        }
        Map<Object, Object> variants = templateVariants.isPresent() ? templateVariants.get().getVariants() : Collections.emptyMap();
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(QuteRecorder.QuteContext.class).supplier(recorder.createContext(generatedValueResolvers.stream().map(GeneratedValueResolverBuildItem::getClassName).collect(Collectors.toList()), templates, tags, variants)).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    DevConsoleRouteBuildItem invokeEndpoint(QuteDevConsoleRecorder recorder) {
        recorder.setupRenderer();
        return new DevConsoleRouteBuildItem("preview", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(final RoutingContext context) {
                context.request().setExpectMultipart(true);
                context.request().endHandler((Handler)new Handler<Void>(){

                    public void handle(Void ignore) {
                        int dotIdx;
                        MultiMap form = context.request().formAttributes();
                        String templatePath = form.get("template-path");
                        String testJsonData = form.get("template-data");
                        String contentType = null;
                        String fileName = templatePath;
                        int slashIdx = fileName.lastIndexOf(47);
                        if (slashIdx != -1) {
                            fileName = fileName.substring(slashIdx, fileName.length());
                        }
                        if ((dotIdx = fileName.lastIndexOf(46)) != -1) {
                            String suffix = fileName.substring(dotIdx + 1, fileName.length());
                            contentType = suffix.equalsIgnoreCase("json") ? "application/json" : URLConnection.getFileNameMap().getContentTypeFor(fileName);
                        }
                        try {
                            BiFunction renderer = (BiFunction)DevConsoleManager.getGlobal((String)QuteDevConsoleRecorder.RENDER_HANDLER);
                            Object testData = Json.decodeValue((String)testJsonData);
                            testData = QuteProcessor.this.translate(testData);
                            context.response().setStatusCode(200).putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType).end((String)renderer.apply(templatePath, testData));
                        }
                        catch (DecodeException e) {
                            context.response().setStatusCode(500).putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/plain; charset=UTF-8").end("Failed to parse JSON: " + e.getMessage());
                        }
                        catch (Throwable e) {
                            context.fail(e);
                        }
                    }
                });
            }
        });
    }

    private Object translate(Object testData) {
        if (testData instanceof JsonArray) {
            return this.translate((JsonArray)testData);
        }
        if (testData instanceof JsonObject) {
            return this.translate((JsonObject)testData);
        }
        return testData;
    }

    private Object translate(JsonArray testData) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object i : testData.getList()) {
            ret.add(this.translate(i));
        }
        return ret;
    }

    private Object translate(JsonObject testData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map data = testData.getMap();
        for (String i : testData.fieldNames()) {
            map.put(i, this.translate(data.get(i)));
        }
        return map;
    }

    private static Type resolveType(AnnotationTarget member, Match match, IndexView index) {
        Type matchType;
        if (member.kind() == AnnotationTarget.Kind.FIELD) {
            matchType = member.asField().type();
        } else if (member.kind() == AnnotationTarget.Kind.METHOD) {
            matchType = member.asMethod().returnType();
        } else {
            throw new IllegalStateException("Unsupported member type: " + member);
        }
        if (Types.containsTypeVariable(matchType)) {
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.getParameterizedTypeArguments(), match.getTypeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            DotName declaringClassName = member.kind() == AnnotationTarget.Kind.METHOD ? member.asMethod().declaringClass().name() : member.asField().declaringClass().name();
            Type declaringType = closure.stream().filter(t -> t.name().equals((Object)declaringClassName)).findAny().orElse(null);
            if (declaringType != null && declaringType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                matchType = Types.resolveTypeParam(matchType, Types.buildResolvedMap(declaringType.asParameterizedType().arguments(), index.getClassByName(declaringType.name()).typeParameters(), Collections.emptyMap(), index), index);
            }
        }
        return matchType;
    }

    static boolean processHints(TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, String helperHint, Match match, IndexView index, Expression expression, Map<Integer, Match> generatedIdsToMatches, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        Match valueExprMatch;
        Expression valueExpr;
        if (helperHint == null || helperHint.isEmpty()) {
            return false;
        }
        if (helperHint.equals("<loop-element>")) {
            QuteProcessor.processLoopElementHint(match, index, expression, incorrectExpressions);
        } else if (helperHint.startsWith("<loop#")) {
            Match valueExprMatch2;
            Expression valueExpr2 = QuteProcessor.findExpression(helperHint, "<loop#", templateAnalysis);
            if (valueExpr2 != null && (valueExprMatch2 = generatedIdsToMatches.get(valueExpr2.getGeneratedId())) != null) {
                match.setValues(valueExprMatch2.clazz, valueExprMatch2.type);
            }
        } else if (helperHint.startsWith("<when#")) {
            Match valueExprMatch3;
            Expression valueExpr3 = QuteProcessor.findExpression(helperHint, "<when#", templateAnalysis);
            if (valueExpr3 != null && (valueExprMatch3 = generatedIdsToMatches.get(valueExpr3.getGeneratedId())) != null && valueExprMatch3.clazz.isEnum()) {
                match.setValues(valueExprMatch3.clazz, valueExprMatch3.type);
                return true;
            }
        } else if (helperHint.startsWith("<set#") && (valueExpr = QuteProcessor.findExpression(helperHint, "<set#", templateAnalysis)) != null && (valueExprMatch = generatedIdsToMatches.get(valueExpr.getGeneratedId())) != null) {
            match.setValues(valueExprMatch.clazz, valueExprMatch.type);
        }
        return false;
    }

    private static Expression findExpression(String helperHint, String hintPrefix, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis) {
        return templateAnalysis.findExpression(Integer.parseInt(helperHint.substring(hintPrefix.length(), helperHint.length() - 1)));
    }

    static void processLoopElementHint(Match match, IndexView index, Expression expression, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (match.type().name().equals((Object)DotNames.INTEGER)) {
            return;
        }
        Type matchType = null;
        if (match.isArray()) {
            matchType = match.type().asArrayType().component();
        } else if (match.isClass() || match.isParameterizedType()) {
            Function<Type, Type> firstParamType;
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.getParameterizedTypeArguments(), match.getTypeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            matchType = QuteProcessor.extractMatchType(closure, Names.ITERABLE, firstParamType = t -> (Type)t.asParameterizedType().arguments().get(0));
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.STREAM, firstParamType);
            }
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.MAP, t -> {
                    Type[] args = new Type[]{(Type)t.asParameterizedType().arguments().get(0), (Type)t.asParameterizedType().arguments().get(1)};
                    return ParameterizedType.create((DotName)Names.MAP_ENTRY, (Type[])args, null);
                });
            }
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.ITERATOR, firstParamType);
            }
        }
        if (matchType != null) {
            match.setValues(index.getClassByName(matchType.name()), matchType);
        } else {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Unsupported iterable type found: " + match.type, expression.getOrigin()));
            match.clearValues();
        }
    }

    static Type extractMatchType(Set<Type> closure, DotName matchName, Function<Type, Type> extractFun) {
        Type type = closure.stream().filter(t -> t.name().equals((Object)matchName)).findFirst().orElse(null);
        return type != null ? extractFun.apply(type) : null;
    }

    private static AnnotationTarget findTemplateExtensionMethod(TypeInfos.Info info, ClassInfo matchClass, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, Match> results) {
        if (!info.isProperty() && !info.isVirtualMethod()) {
            return null;
        }
        String name = info.isProperty() ? info.asProperty().name : info.asVirtualMethod().name;
        for (TemplateExtensionMethodBuildItem extensionMethod : templateExtensionMethods) {
            if (extensionMethod.hasNamespace() || !Types.isAssignableFrom(extensionMethod.getMatchClass().name(), matchClass.name(), index) || !extensionMethod.matchesName(name)) continue;
            List parameters = extensionMethod.getMethod().parameters();
            int realParamSize = parameters.size() - ("*".equals(extensionMethod.getMatchName()) ? 2 : 1);
            if (realParamSize > 0 && !info.isVirtualMethod()) continue;
            if (info.isVirtualMethod()) {
                Expression.VirtualMethodPart virtualMethod = info.part.asVirtualMethod();
                boolean isVarArgs = ValueResolverGenerator.isVarArgs((MethodInfo)extensionMethod.getMethod());
                int lastParamIdx = parameters.size() - 1;
                if (isVarArgs ? realParamSize - 1 > virtualMethod.getParameters().size() : virtualMethod.getParameters().size() != realParamSize) continue;
                boolean matches = true;
                int idx = "*".equals(extensionMethod.getMatchName()) ? 2 : 1;
                for (Expression param : virtualMethod.getParameters()) {
                    Match result = results.get(param.toOriginalString());
                    if (result != null && !result.isEmpty()) {
                        Type paramType = isVarArgs && idx >= lastParamIdx ? ((Type)parameters.get(lastParamIdx)).asArrayType().component() : (Type)parameters.get(idx);
                        if (!Types.isAssignableFrom(paramType, result.type, index)) {
                            matches = false;
                            break;
                        }
                    } else {
                        LOGGER.debugf("Type info not available - skip validation for parameter [%s] of extension method [%s] for expression [%s] in template [%s] on line %s", new Object[]{extensionMethod.getMethod().parameterName(idx), extensionMethod.getMethod().declaringClass().name() + "#" + extensionMethod.getMethod(), expression.toOriginalString(), templateIdToPathFun.apply(expression.getOrigin().getTemplateId()), expression.getOrigin().getLine()});
                    }
                    ++idx;
                }
                if (!matches) continue;
            }
            return extensionMethod.getMethod();
        }
        return null;
    }

    private static AnnotationTarget findProperty(String name, ClassInfo clazz, IndexView index) {
        while (clazz != null) {
            for (FieldInfo field : clazz.fields()) {
                if (!Modifier.isPublic(field.flags()) || ValueResolverGenerator.isSynthetic((int)field.flags()) || !field.name().equals(name) || !field.isEnumConstant() && Modifier.isStatic(field.flags())) continue;
                return field;
            }
            for (MethodInfo method : clazz.methods()) {
                if (method.returnType().kind() == Type.Kind.VOID || !Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags()) || ValueResolverGenerator.isSynthetic((int)method.flags()) || !method.name().equals(name) && !ValueResolverGenerator.getPropertyName((String)method.name()).equals(name)) continue;
                return method;
            }
            DotName superName = clazz.superName();
            if (superName == null) {
                clazz = null;
                continue;
            }
            clazz = index.getClassByName(clazz.superName());
        }
        return null;
    }

    private static AnnotationTarget findMethod(Expression.VirtualMethodPart virtualMethod, ClassInfo clazz, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, Match> results) {
        while (clazz != null) {
            for (MethodInfo method : clazz.methods()) {
                if (!Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags()) || ValueResolverGenerator.isSynthetic((int)method.flags()) || !method.name().equals(virtualMethod.getName())) continue;
                boolean isVarArgs = ValueResolverGenerator.isVarArgs((MethodInfo)method);
                List parameters = method.parameters();
                int lastParamIdx = parameters.size() - 1;
                if (isVarArgs ? lastParamIdx > virtualMethod.getParameters().size() : virtualMethod.getParameters().size() != parameters.size()) continue;
                boolean matches = true;
                int idx = 0;
                for (Expression param : virtualMethod.getParameters()) {
                    Match result = results.get(param.toOriginalString());
                    if (result != null && !result.isEmpty()) {
                        Type paramType = isVarArgs && idx >= lastParamIdx ? ((Type)parameters.get(lastParamIdx)).asArrayType().component() : (Type)parameters.get(idx);
                        if (!Types.isAssignableFrom(paramType, result.type, index)) {
                            matches = false;
                            break;
                        }
                    } else {
                        LOGGER.debugf("Type info not available - skip validation for parameter [%s] of method [%s] for expression [%s] in template [%s] on line %s", new Object[]{method.parameterName(idx), method.declaringClass().name() + "#" + method, expression.toOriginalString(), templateIdToPathFun.apply(expression.getOrigin().getTemplateId()), expression.getOrigin().getLine()});
                    }
                    idx = (byte)(idx + 1);
                }
                return matches ? method : null;
            }
            DotName superName = clazz.superName();
            if (superName == null || DotNames.OBJECT.equals((Object)superName)) {
                clazz = null;
                continue;
            }
            clazz = index.getClassByName(clazz.superName());
        }
        return null;
    }

    private void processsTemplateData(IndexView index, AnnotationInstance templateData, AnnotationTarget annotationTarget, Set<DotName> controlled, Map<DotName, AnnotationInstance> uncontrolled, ValueResolverGenerator.Builder builder) {
        AnnotationValue targetValue = templateData.value("target");
        if (targetValue == null || targetValue.asClass().name().equals((Object)ValueResolverGenerator.TEMPLATE_DATA)) {
            ClassInfo annotationTargetClass = annotationTarget.asClass();
            controlled.add(annotationTargetClass.name());
            builder.addClass(annotationTargetClass, templateData);
        } else {
            ClassInfo uncontrolledClass = index.getClassByName(targetValue.asClass().name());
            if (uncontrolledClass != null) {
                uncontrolled.compute(uncontrolledClass.name(), (c, v) -> {
                    if (v == null) {
                        builder.addClass(uncontrolledClass, templateData);
                        return templateData;
                    }
                    if (!(Objects.equals(v.value("ignore"), templateData.value("ignore")) && Objects.equals(v.value("properties"), templateData.value("properties")) && Objects.equals(v.value("ignoreSuperclasses"), templateData.value("ignoreSuperclasses")))) {
                        throw new IllegalStateException("Multiple unequal @TemplateData declared for " + c + ": " + v + " and " + templateData);
                    }
                    return v;
                });
            } else {
                LOGGER.warnf("@TemplateData#target() not available: %s", (Object)annotationTarget.asClass().name());
            }
        }
    }

    static Map<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> collectNamespaceExpressions(TemplatesAnalysisBuildItem analysis, String namespace) {
        HashMap<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> namespaceExpressions = new HashMap<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>>();
        for (TemplatesAnalysisBuildItem.TemplateAnalysis template : analysis.getAnalysis()) {
            HashSet<Expression> expressions = null;
            for (Expression expr : QuteProcessor.collectNamespaceExpressions(template, namespace)) {
                if (expressions == null) {
                    expressions = new HashSet<Expression>();
                }
                expressions.add(expr);
            }
            if (expressions == null) continue;
            namespaceExpressions.put(template, expressions);
        }
        return namespaceExpressions;
    }

    static Set<Expression> collectNamespaceExpressions(TemplatesAnalysisBuildItem.TemplateAnalysis analysis, String namespace) {
        HashSet<Expression> namespaceExpressions = new HashSet<Expression>();
        for (Expression expression : analysis.expressions) {
            QuteProcessor.collectNamespaceExpressions(expression, namespaceExpressions, namespace);
        }
        return namespaceExpressions;
    }

    static void collectNamespaceExpressions(Expression expression, Set<Expression> namespaceExpressions, String namespace) {
        if (expression.isLiteral()) {
            return;
        }
        if (QuteProcessor.includeNamespaceExpression(expression, namespace)) {
            namespaceExpressions.add(expression);
        }
        for (Expression.Part part : expression.getParts()) {
            if (!part.isVirtualMethod()) continue;
            for (Expression param : part.asVirtualMethod().getParameters()) {
                QuteProcessor.collectNamespaceExpressions(param, namespaceExpressions, namespace);
            }
        }
    }

    private static boolean includeNamespaceExpression(Expression expression, String namespace) {
        if (namespace.equals(expression.getNamespace())) {
            return true;
        }
        String typeInfo = ((Expression.Part)expression.getParts().get(0)).getTypeInfo();
        return typeInfo != null ? typeInfo.startsWith(namespace) : false;
    }

    public static String getName(InjectionPointInfo injectionPoint) {
        if (injectionPoint.isField()) {
            return injectionPoint.getTarget().asField().name();
        }
        if (injectionPoint.isParam()) {
            String name = injectionPoint.getTarget().asMethod().parameterName(injectionPoint.getPosition());
            return name == null ? injectionPoint.getTarget().asMethod().name() : name;
        }
        throw new IllegalArgumentException();
    }

    private static void produceTemplateBuildItems(BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, String basePath, String filePath, Path originalPath) {
        if (filePath.isEmpty()) {
            return;
        }
        String fullPath = basePath + filePath;
        LOGGER.debugf("Produce template build items [filePath: %s, fullPath: %s, originalPath: %s", (Object)filePath, (Object)fullPath, (Object)originalPath);
        watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(fullPath, true));
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fullPath}));
        templatePaths.produce((BuildItem)new TemplatePathBuildItem(filePath, originalPath));
    }

    private void scan(Path root, Path directory, String basePath, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    LOGGER.debugf("Found template: %s", (Object)filePath);
                    String templatePath = root.relativize(filePath).toString();
                    if (File.separatorChar != '/') {
                        templatePath = templatePath.replace(File.separatorChar, '/');
                    }
                    QuteProcessor.produceTemplateBuildItems(templatePaths, watchedPaths, nativeImageResources, basePath, templatePath, filePath);
                    continue;
                }
                if (!Files.isDirectory(filePath, new LinkOption[0])) continue;
                LOGGER.debugf("Scan directory: %s", (Object)filePath);
                this.scan(root, filePath, basePath, watchedPaths, templatePaths, nativeImageResources);
            }
        }
    }

    private static boolean isExcluded(TypeCheckExcludeBuildItem.TypeCheck check, List<TypeCheckExcludeBuildItem> excludes) {
        for (TypeCheckExcludeBuildItem exclude : excludes) {
            if (!exclude.getPredicate().test(check)) continue;
            return true;
        }
        return false;
    }

    static class Match {
        private final IndexView index;
        private ClassInfo clazz;
        private Type type;

        Match(IndexView index) {
            this.index = index;
        }

        List<Type> getParameterizedTypeArguments() {
            return this.type.kind() == Type.Kind.PARAMETERIZED_TYPE ? this.type.asParameterizedType().arguments() : Collections.emptyList();
        }

        List<TypeVariable> getTypeParameters() {
            return this.clazz.typeParameters();
        }

        ClassInfo clazz() {
            return this.clazz;
        }

        Type type() {
            return this.type;
        }

        boolean isPrimitive() {
            return this.type != null && this.type.kind() == Type.Kind.PRIMITIVE;
        }

        boolean isArray() {
            return this.type != null && this.type.kind() == Type.Kind.ARRAY;
        }

        boolean isParameterizedType() {
            return this.type != null && this.type.kind() == Type.Kind.PARAMETERIZED_TYPE;
        }

        boolean isClass() {
            return this.type != null && this.type.kind() == Type.Kind.CLASS;
        }

        void setValues(ClassInfo clazz, Type type) {
            this.clazz = clazz;
            this.type = type;
            this.autoExtractType();
        }

        void clearValues() {
            this.clazz = null;
            this.type = null;
        }

        boolean isEmpty() {
            return this.clazz == null;
        }

        void autoExtractType() {
            boolean hasUni;
            boolean hasCompletionStage = ValueResolverGenerator.hasCompletionStageInTypeClosure((ClassInfo)this.clazz, (IndexView)this.index);
            boolean bl = hasUni = hasCompletionStage ? false : ValueResolverGenerator.hasClassInTypeClosure((ClassInfo)this.clazz, (DotName)Names.UNI, (IndexView)this.index);
            if (hasCompletionStage || hasUni) {
                Set<Type> closure = Types.getTypeClosure(this.clazz, Types.buildResolvedMap(this.getParameterizedTypeArguments(), this.getTypeParameters(), new HashMap<TypeVariable, Type>(), this.index), this.index);
                Function<Type, Type> firstParamType = t -> (Type)t.asParameterizedType().arguments().get(0);
                this.type = QuteProcessor.extractMatchType(closure, hasCompletionStage ? Names.COMPLETION_STAGE : Names.UNI, firstParamType);
                this.clazz = this.index.getClassByName(this.type.name());
            }
        }
    }
}

