/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.TemplateException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

class TypeCheckInfo {
    static final String LEFT_ANGLE = "<";
    static final String RIGHT_ANGLE = ">";
    static final String ROOT_HINT = "$$root$$";
    static final String TYPE_INFO_SEPARATOR = "|";
    final List<Part> parts;

    static TypeCheckInfo create(Expression expression, IndexView index, Function<String, String> templateIdToPathFun) {
        String value = expression.typeCheckInfo;
        ArrayList<Part> parts = new ArrayList<Part>();
        for (String partStr : Expressions.splitTypeCheckParts((String)value)) {
            parts.add(TypeCheckInfo.createPart(partStr, index, templateIdToPathFun, expression));
        }
        return new TypeCheckInfo(parts);
    }

    private static Part createPart(String value, IndexView index, Function<String, String> templateIdToPathFun, Expression expression) {
        if (value.startsWith(TYPE_INFO_SEPARATOR)) {
            int endIdx = value.substring(1, value.length()).indexOf(124);
            if (endIdx < 1) {
                throw new IllegalArgumentException("Invalid type info: " + value);
            }
            String classStr = value.substring(1, endIdx + 1);
            if (classStr.equals("$$namespace$$")) {
                return new Part(value);
            }
            DotName rawClassName = TypeCheckInfo.rawClassName(classStr);
            ClassInfo rawClass = index.getClassByName(rawClassName);
            if (rawClass == null) {
                throw new TemplateException("Class [" + rawClassName + "] used in the parameter declaration in template [" + templateIdToPathFun.apply(expression.origin.getTemplateGeneratedId()) + "] on line " + expression.origin.getLine() + " was not found in the application index. Make sure it is spelled correctly.");
            }
            Type resolvedType = TypeCheckInfo.resolveType(classStr);
            return new TypeInfoPart(value, TypeCheckInfo.helperHint(value.substring(endIdx, value.length())), resolvedType, rawClass);
        }
        if (Expressions.isVirtualMethod((String)value)) {
            List params = Expressions.parseVirtualMethodParams((String)value);
            ArrayList<Part> paramParts = new ArrayList<Part>(params.size());
            for (String param : params) {
                paramParts.add(TypeCheckInfo.createPart(param, index, templateIdToPathFun, expression));
            }
            return new VirtualMethodPart(value, Expressions.parseVirtualMethodName((String)value), paramParts);
        }
        String hint = TypeCheckInfo.helperHint(value);
        if (hint != null) {
            value = value.substring(0, value.indexOf(LEFT_ANGLE));
        }
        return new PropertyPart(value, hint);
    }

    TypeCheckInfo(List<Part> parts) {
        this.parts = parts;
    }

    TypeInfoPart getRoot() {
        return this.parts.get(0).asTypeInfo();
    }

    private static DotName rawClassName(String value) {
        int angleIdx = value.indexOf(LEFT_ANGLE);
        if (angleIdx != -1) {
            return DotName.createSimple((String)value.substring(0, angleIdx));
        }
        return DotName.createSimple((String)value);
    }

    private static String helperHint(String part) {
        int angleIdx = part.indexOf(LEFT_ANGLE);
        if (angleIdx == -1) {
            return null;
        }
        return part.substring(angleIdx, part.length());
    }

    private static Type resolveType(String value) {
        int angleIdx = value.indexOf(LEFT_ANGLE);
        if (angleIdx == -1) {
            return Type.create((DotName)DotName.createSimple((String)value), (Type.Kind)Type.Kind.CLASS);
        }
        String name = value.substring(0, angleIdx);
        DotName rawName = DotName.createSimple((String)name);
        String[] parts = value.substring(angleIdx + 1, value.length() - 1).split(",");
        Type[] arguments = new Type[parts.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = TypeCheckInfo.resolveType(parts[i]);
        }
        return ParameterizedType.create((DotName)rawName, (Type[])arguments, null);
    }

    static class VirtualMethodPart
    extends Part {
        final String name;
        final List<Part> parameters;

        public VirtualMethodPart(String value, String name, List<Part> parameters) {
            super(value);
            this.name = name;
            this.parameters = parameters;
        }

        @Override
        public boolean isVirtualMethod() {
            return true;
        }

        @Override
        public VirtualMethodPart asVirtualMethod() {
            return this;
        }
    }

    static class PropertyPart
    extends HintPart {
        final String name;

        public PropertyPart(String name, String hint) {
            super(name, hint);
            this.name = name;
        }

        @Override
        public boolean isProperty() {
            return true;
        }

        @Override
        public PropertyPart asProperty() {
            return this;
        }
    }

    static class TypeInfoPart
    extends HintPart {
        final Type resolvedType;
        final ClassInfo rawClass;

        public TypeInfoPart(String value, String hint, Type resolvedType, ClassInfo rawClass) {
            super(value, hint);
            this.resolvedType = resolvedType;
            this.rawClass = rawClass;
        }

        @Override
        boolean isTypeInfo() {
            return true;
        }

        @Override
        TypeInfoPart asTypeInfo() {
            return this;
        }
    }

    static abstract class HintPart
    extends Part {
        final String hint;

        public HintPart(String value, String hint) {
            super(value);
            this.hint = hint;
        }
    }

    static class Part {
        final String value;

        public Part(String value) {
            this.value = value;
        }

        boolean isVirtualMethod() {
            return false;
        }

        boolean isProperty() {
            return false;
        }

        boolean isTypeInfo() {
            return false;
        }

        VirtualMethodPart asVirtualMethod() {
            throw new IllegalArgumentException("Not a virtual method");
        }

        PropertyPart asProperty() {
            throw new IllegalArgumentException("Not a property");
        }

        TypeInfoPart asTypeInfo() {
            throw new IllegalArgumentException("Not a type info");
        }

        public String toString() {
            return this.value;
        }
    }
}

