/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.processor.DotNames;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public final class Types {
    static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final Logger LOG = Logger.getLogger(Types.class);

    static Set<Type> getTypeClosure(ClassInfo classInfo, Map<TypeVariable, Type> resolvedTypeParameters, IndexView index) {
        ClassInfo superClassInfo;
        HashSet<Type> types = new HashSet<Type>();
        List typeParameters = classInfo.typeParameters();
        if (typeParameters.isEmpty() || !resolvedTypeParameters.keySet().containsAll(typeParameters)) {
            types.add(Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS));
        } else {
            Type[] typeParams = new Type[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = resolvedTypeParameters.get(typeParameters.get(i));
            }
            types.add((Type)ParameterizedType.create((DotName)classInfo.name(), (Type[])typeParams, null));
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
            if (interfaceClassInfo == null) continue;
            Map<TypeVariable, Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)interfaceType.kind())) {
                resolved = Types.buildResolvedMap(interfaceType.asParameterizedType().arguments(), interfaceClassInfo.typeParameters(), resolvedTypeParameters, index);
            }
            types.addAll(Types.getTypeClosure(interfaceClassInfo, resolved, index));
        }
        if (classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null) {
            Map<TypeVariable, Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)classInfo.superClassType().kind())) {
                resolved = Types.buildResolvedMap(classInfo.superClassType().asParameterizedType().arguments(), superClassInfo.typeParameters(), resolvedTypeParameters, index);
            }
            types.addAll(Types.getTypeClosure(superClassInfo, resolved, index));
        }
        return types;
    }

    static <T extends Type> Map<TypeVariable, Type> buildResolvedMap(List<T> resolvedArguments, List<TypeVariable> typeVariables, Map<TypeVariable, Type> resolvedTypeParameters, IndexView index) {
        HashMap<TypeVariable, Type> resolvedMap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < resolvedArguments.size(); ++i) {
            resolvedMap.put(typeVariables.get(i), Types.resolveTypeParam((Type)resolvedArguments.get(i), resolvedTypeParameters, index));
        }
        return resolvedMap;
    }

    static Type resolveTypeParam(Type typeParam, Map<TypeVariable, Type> resolvedTypeParameters, IndexView index) {
        if (typeParam.kind() == Type.Kind.CLASS) {
            ClassInfo classInfo = index.getClassByName(typeParam.name());
            if (classInfo == null && !typeParam.name().toString().contains(".") && (classInfo = index.getClassByName(DotName.createSimple((String)(JAVA_LANG_PREFIX + typeParam.name().toString())))) != null) {
                return Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS);
            }
            return typeParam;
        }
        if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
            return resolvedTypeParameters.getOrDefault(typeParam, typeParam);
        }
        if (typeParam.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = typeParam.asParameterizedType();
            ClassInfo classInfo = index.getClassByName(parameterizedType.name());
            if (classInfo == null && !parameterizedType.name().toString().contains(".")) {
                classInfo = index.getClassByName(DotName.createSimple((String)(JAVA_LANG_PREFIX + parameterizedType.name().toString())));
            }
            if (classInfo != null) {
                List typeParameters = classInfo.typeParameters();
                List arguments = parameterizedType.arguments();
                Type[] typeParams = new Type[typeParameters.size()];
                for (int i = 0; i < typeParameters.size(); ++i) {
                    typeParams[i] = Types.resolveTypeParam((Type)arguments.get(i), resolvedTypeParameters, index);
                }
                return ParameterizedType.create((DotName)parameterizedType.name(), (Type[])typeParams, null);
            }
        }
        return typeParam;
    }

    static boolean containsTypeVariable(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            for (Type t : type.asParameterizedType().arguments()) {
                if (!Types.containsTypeVariable(t)) continue;
                return true;
            }
        }
        if (type.kind() == Type.Kind.ARRAY) {
            return Types.containsTypeVariable(type.asArrayType().component());
        }
        return false;
    }

    static boolean isAssignableFrom(Type type1, Type type2, IndexView index, Map<DotName, AssignableInfo> assignableCache) {
        if (type1.kind() == Type.Kind.ARRAY && type2.kind() == Type.Kind.ARRAY) {
            return Types.isAssignableFrom(type1.asArrayType().component(), type2.asArrayType().component(), index, assignableCache);
        }
        return Types.isAssignableFrom(Types.box(type1).name(), Types.box(type2).name(), index, assignableCache);
    }

    static boolean isAssignableFrom(DotName className1, DotName className2, IndexView index, Map<DotName, AssignableInfo> assignableCache) {
        if (className1.equals((Object)DotNames.OBJECT)) {
            return true;
        }
        if (className1.equals((Object)className2)) {
            return true;
        }
        ClassInfo class1 = index.getClassByName(className1);
        AssignableInfo assignableInfo = assignableCache.get(className1);
        if (assignableInfo == null) {
            assignableInfo = AssignableInfo.from(class1, index);
            assignableCache.put(className1, assignableInfo);
            return assignableInfo.isAssignableFrom(className2);
        }
        if (assignableInfo.isAssignableFrom(className2)) {
            return true;
        }
        assignableInfo = AssignableInfo.from(class1, index);
        if (assignableInfo.isAssignableFrom(className2)) {
            assignableCache.put(className1, assignableInfo);
            return true;
        }
        return false;
    }

    static Type box(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return Types.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + primitive);
    }

    static class HierarchyIndexer {
        final IndexView index;
        final Set<DotName> processed;

        public HierarchyIndexer(IndexView index) {
            this.index = Objects.requireNonNull(index);
            this.processed = new HashSet<DotName>();
        }

        void indexHierarchy(ClassInfo classInfo) {
            if (classInfo != null && this.processed.add(classInfo.name())) {
                LOG.debugf("Index hierarchy of: %s", (Object)classInfo);
                for (DotName interfaceName : classInfo.interfaceNames()) {
                    this.indexHierarchy(this.index.getClassByName(interfaceName));
                }
                DotName superName = classInfo.superName();
                if (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
                    this.indexHierarchy(this.index.getClassByName(superName));
                }
            }
        }
    }

    static class AssignableInfo {
        final Set<DotName> subclasses;
        final Set<DotName> implementors;
        final Set<DotName> subInterfaces;

        static AssignableInfo from(ClassInfo classInfo, IndexView index) {
            if (classInfo.isInterface()) {
                return new AssignableInfo(null, AssignableInfo.toNames(index.getAllKnownImplementors(classInfo.name())), AssignableInfo.toNames(index.getAllKnownSubinterfaces(classInfo.name())));
            }
            return new AssignableInfo(AssignableInfo.toNames(index.getAllKnownSubclasses(classInfo.name())), null, null);
        }

        private static Set<DotName> toNames(Collection<ClassInfo> classes) {
            return classes.stream().map(ClassInfo::name).collect(Collectors.toSet());
        }

        AssignableInfo(Set<DotName> subclasses, Set<DotName> implementors, Set<DotName> subInterfaces) {
            this.subclasses = subclasses;
            this.implementors = implementors;
            this.subInterfaces = subInterfaces;
        }

        boolean isAssignableFrom(DotName clazz) {
            if (this.subclasses != null && this.subclasses.contains(clazz)) {
                return true;
            }
            if (this.implementors != null && this.implementors.contains(clazz)) {
                return true;
            }
            return this.subInterfaces != null && this.subInterfaces.contains(clazz);
        }
    }
}

