/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.qute.Expression;
import java.util.List;
import java.util.Objects;

public final class TemplatesAnalysisBuildItem
extends SimpleBuildItem {
    private final List<TemplateAnalysis> analysis;

    public TemplatesAnalysisBuildItem(List<TemplateAnalysis> analysis) {
        this.analysis = analysis;
    }

    public List<TemplateAnalysis> getAnalysis() {
        return this.analysis;
    }

    public static final class TemplateAnalysis {
        public final String id;
        public final String generatedId;
        public final List<Expression> expressions;
        public final String path;

        public TemplateAnalysis(String id, String generatedId, List<Expression> expressions, String path) {
            this.id = id;
            this.generatedId = generatedId;
            this.expressions = expressions;
            this.path = path;
        }

        Expression findExpression(int id) {
            for (Expression expression : this.expressions) {
                if (expression.getGeneratedId() != id) continue;
                return expression;
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.generatedId == null ? 0 : this.generatedId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateAnalysis other = (TemplateAnalysis)obj;
            return Objects.equals(this.generatedId, other.generatedId);
        }
    }
}

