/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.EvaluatedParams;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Namespaces;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.deployment.CheckedTemplateBuildItem;
import io.quarkus.qute.deployment.Descriptors;
import io.quarkus.qute.deployment.ImplicitValueResolverBuildItem;
import io.quarkus.qute.deployment.IncorrectExpressionBuildItem;
import io.quarkus.qute.deployment.MessageBundleBuildItem;
import io.quarkus.qute.deployment.MessageBundleException;
import io.quarkus.qute.deployment.MessageBundleMethodBuildItem;
import io.quarkus.qute.deployment.Names;
import io.quarkus.qute.deployment.QuteProcessor;
import io.quarkus.qute.deployment.TemplateDataBuildItem;
import io.quarkus.qute.deployment.TemplateDataBuilder;
import io.quarkus.qute.deployment.TemplateExpressionMatchesBuildItem;
import io.quarkus.qute.deployment.TemplateExtensionMethodBuildItem;
import io.quarkus.qute.deployment.TemplateGlobalBuildItem;
import io.quarkus.qute.deployment.TemplatesAnalysisBuildItem;
import io.quarkus.qute.deployment.TypeCheckExcludeBuildItem;
import io.quarkus.qute.deployment.Types;
import io.quarkus.qute.i18n.Localized;
import io.quarkus.qute.i18n.Message;
import io.quarkus.qute.i18n.MessageBundle;
import io.quarkus.qute.i18n.MessageBundles;
import io.quarkus.qute.i18n.MessageTemplateLocator;
import io.quarkus.qute.runtime.MessageBundleRecorder;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.util.StringUtil;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class MessageBundleProcessor {
    private static final Logger LOG = Logger.getLogger(MessageBundleProcessor.class);
    private static final String SUFFIX = "_Bundle";
    private static final String BUNDLE_DEFAULT_KEY = "defaultKey";
    private static final String BUNDLE_LOCALE = "locale";
    private static final String MESSAGES = "messages";
    private static final String MESSAGE = "message";

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{MessageBundles.class, MessageBundle.class, Message.class, Localized.class, MessageTemplateLocator.class});
    }

    @BuildStep
    List<MessageBundleBuildItem> processBundles(BeanArchiveIndexBuildItem beanArchiveIndex, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClasses, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators, BuildProducer<MessageBundleMethodBuildItem> messageTemplateMethods, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, LocalesBuildTimeConfig locales) throws IOException {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<String, ClassInfo> found = new HashMap<String, ClassInfo>();
        ArrayList<MessageBundleBuildItem> bundles = new ArrayList<MessageBundleBuildItem>();
        ArrayList<DotName> localizedInterfaces = new ArrayList<DotName>();
        List<Path> messageFiles = this.findMessageFiles(applicationArchivesBuildItem, watchedFiles);
        for (AnnotationInstance bundleAnnotation : index.getAnnotations(Names.BUNDLE)) {
            if (bundleAnnotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo bundleClass = bundleAnnotation.target().asClass();
            if (Modifier.isInterface(bundleClass.flags())) {
                Object implementor22;
                String name;
                AnnotationValue nameValue = bundleAnnotation.value();
                String string = name = nameValue != null ? nameValue.asString() : "<<defaulted name>>";
                if (name.equals("<<defaulted name>>")) {
                    if (bundleClass.nestingType() == ClassInfo.NestingType.TOP_LEVEL) {
                        name = "msg";
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(DotNames.simpleName((ClassInfo)bundleClass));
                        DotName enclosingName = bundleClass.enclosingClass();
                        while (enclosingName != null) {
                            ClassInfo enclosingClass = index.getClassByName(enclosingName);
                            if (enclosingClass == null) continue;
                            arrayList.add(DotNames.simpleName((ClassInfo)enclosingClass));
                            enclosingName = enclosingClass.nestingType() == ClassInfo.NestingType.TOP_LEVEL ? null : enclosingClass.enclosingClass();
                        }
                        Collections.reverse(arrayList);
                        name = String.join((CharSequence)"_", arrayList);
                    }
                    LOG.debugf("Message bundle %s: name defaulted to %s", (Object)bundleClass, (Object)name);
                }
                if (!Namespaces.isValidNamespace((String)name)) {
                    throw new MessageBundleException(String.format("Message bundle name [%s] declared on %s must be a valid namespace - the value can only consist of alphanumeric characters and underscores", name, bundleClass));
                }
                if (found.containsKey(name)) {
                    throw new MessageBundleException(String.format("Message bundle interface name conflict - [%s] is used for both [%s] and [%s]", name, bundleClass, found.get(name)));
                }
                found.put(name, bundleClass);
                String string2 = this.getDefaultLocale(bundleAnnotation, locales);
                ArrayList<Object> localized = new ArrayList<Object>();
                for (Object implementor22 : index.getKnownDirectImplementors(bundleClass.name())) {
                    if (!Modifier.isInterface(implementor22.flags())) continue;
                    localized.add(implementor22);
                }
                HashMap<String, ClassInfo> localeToInterface = new HashMap<String, ClassInfo>();
                implementor22 = localized.iterator();
                while (implementor22.hasNext()) {
                    ClassInfo localizedInterface = (ClassInfo)implementor22.next();
                    String locale = localizedInterface.declaredAnnotation(Names.LOCALIZED).value().asString();
                    if (string2.equals(locale)) {
                        throw new MessageBundleException(String.format("Locale of [%s] conflicts with the locale [%s] of the default message bundle [%s]", localizedInterface, locale, bundleClass));
                    }
                    ClassInfo previous = localeToInterface.put(locale, localizedInterface);
                    if (previous != null) {
                        throw new MessageBundleException(String.format("Cannot register [%s] - a localized message bundle interface exists for locale [%s]: %s", localizedInterface, locale, previous));
                    }
                    localizedInterfaces.add(localizedInterface.name());
                }
                HashMap<String, Path> localeToFile = new HashMap<String, Path>();
                HashMap<String, Path> localeToMergeCandidate = new HashMap<String, Path>();
                for (Path messageFile : messageFiles) {
                    String fileName = messageFile.getFileName().toString();
                    if (!MessageBundleProcessor.bundleNameMatchesFileName(fileName, name)) continue;
                    int postfixIdx = fileName.indexOf(46);
                    String locale = postfixIdx == name.length() ? string2 : fileName.substring(name.length() + 1, postfixIdx).replace('_', '-');
                    ClassInfo localizedInterface = (ClassInfo)localeToInterface.get(locale);
                    if (string2.equals(locale) || localizedInterface != null) {
                        Path previous = localeToMergeCandidate.put(locale, messageFile);
                        if (previous == null) continue;
                        throw new MessageBundleException(String.format("Cannot register [%s] - a localized file already exists for locale [%s]: [%s]", fileName, locale, previous.getFileName().toString()));
                    }
                    localeToFile.put(locale, messageFile);
                }
                bundles.add(new MessageBundleBuildItem(name, bundleClass, localeToInterface, localeToFile, localeToMergeCandidate, string2));
                continue;
            }
            throw new MessageBundleException("@MessageBundle must be declared on an interface: " + String.valueOf(bundleClass));
        }
        for (AnnotationInstance localizedAnnotation : index.getAnnotations(Names.LOCALIZED)) {
            if (localizedAnnotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo localized = localizedAnnotation.target().asClass();
            if (Modifier.isInterface(localized.flags())) {
                if (localizedInterfaces.contains(localized.name())) continue;
                throw new MessageBundleException("A localized message bundle interface must extend a message bundle interface: " + String.valueOf(localized));
            }
            throw new MessageBundleException("@Localized must be declared on an interface: " + String.valueOf(localized));
        }
        Map<String, String> generatedImplementations = this.generateImplementations(bundles, generatedClasses, messageTemplateMethods, index);
        for (MessageBundleBuildItem bundle : bundles) {
            ClassInfo bundleInterface = bundle.getDefaultBundleInterface();
            ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(bundleInterface.name()).addType(bundle.getDefaultBundleInterface().name())).addQualifier(DotNames.DEFAULT)).addQualifier().annotation(Names.LOCALIZED).addValue("value", (Object)this.getDefaultLocale(bundleInterface.declaredAnnotation(Names.BUNDLE), locales)).done()).unremovable()).scope(Singleton.class)).creator(mc -> mc.returnValue(mc.newInstance(MethodDescriptor.ofConstructor((String)((String)generatedImplementations.get(bundleInterface.name().toString())), (String[])new String[0]), new ResultHandle[0])))).done();
            for (ClassInfo classInfo : bundle.getLocalizedInterfaces().values()) {
                ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(classInfo.name()).addType(bundle.getDefaultBundleInterface().name())).addQualifier(classInfo.declaredAnnotation(Names.LOCALIZED))).unremovable()).scope(Singleton.class)).creator(mc -> mc.returnValue(mc.newInstance(MethodDescriptor.ofConstructor((String)((String)generatedImplementations.get(localizedInterface.name().toString())), (String[])new String[0]), new ResultHandle[0])))).done();
            }
            for (Map.Entry entry : bundle.getLocalizedFiles().entrySet()) {
                ((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(bundle.getDefaultBundleInterface().name()).addType(bundle.getDefaultBundleInterface().name())).addQualifier().annotation(Names.LOCALIZED).addValue("value", entry.getKey()).done()).unremovable()).scope(Singleton.class)).creator(mc -> mc.returnValue(mc.newInstance(MethodDescriptor.ofConstructor((String)((String)generatedImplementations.get(((Path)entry.getValue()).toString())), (String[])new String[0]), new ResultHandle[0])))).done();
            }
        }
        return bundles;
    }

    static boolean bundleNameMatchesFileName(String fileName, String name) {
        String[] nameParts;
        String[] fileNameParts;
        int fileSeparatorIdx = fileName.indexOf(46);
        if (fileSeparatorIdx > -1) {
            fileName = fileName.substring(0, fileSeparatorIdx);
        }
        if ((fileNameParts = fileName.split("_")).length < (nameParts = name.split("_")).length) {
            return false;
        }
        for (int i = 0; i < nameParts.length; ++i) {
            if (fileNameParts[i].equals(nameParts[i])) continue;
            return false;
        }
        return true;
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void initBundleContext(MessageBundleRecorder recorder, List<MessageBundleMethodBuildItem> messageBundleMethods, List<MessageBundleBuildItem> bundles, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) throws ClassNotFoundException {
        if (bundles.isEmpty()) {
            return;
        }
        HashMap bundleInterfaces = new HashMap();
        for (MessageBundleBuildItem bundle : bundles) {
            Class<?> bundleClass = Class.forName(bundle.getDefaultBundleInterface().toString(), true, Thread.currentThread().getContextClassLoader());
            HashMap localeToInterface = new HashMap();
            localeToInterface.put("<<default>>", bundleClass);
            for (String locale : bundle.getLocalizedInterfaces().keySet()) {
                localeToInterface.put(locale, bundleClass);
            }
            for (String locale : bundle.getLocalizedFiles().keySet()) {
                localeToInterface.put(locale, bundleClass);
            }
            bundleInterfaces.put(bundle.getName(), localeToInterface);
        }
        Map<String, String> templateIdToContent = messageBundleMethods.stream().filter(MessageBundleMethodBuildItem::isValidatable).collect(Collectors.toMap(MessageBundleMethodBuildItem::getTemplateId, MessageBundleMethodBuildItem::getTemplate));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MessageBundleRecorder.BundleContext.class).scope(BuiltinScope.DEPENDENT.getInfo())).supplier(recorder.createContext(templateIdToContent, bundleInterfaces)).done());
    }

    @BuildStep
    void validateMessageBundleMethods(TemplatesAnalysisBuildItem templatesAnalysis, List<MessageBundleMethodBuildItem> messageBundleMethods, List<TemplateGlobalBuildItem> templateGlobals, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (messageBundleMethods.isEmpty()) {
            return;
        }
        Map bundleMethods = messageBundleMethods.stream().filter(MessageBundleMethodBuildItem::isValidatable).collect(Collectors.toMap(MessageBundleMethodBuildItem::getTemplateId, Function.identity()));
        Set<String> globals = templateGlobals.stream().map(TemplateGlobalBuildItem::getName).collect(Collectors.toUnmodifiableSet());
        for (TemplatesAnalysisBuildItem.TemplateAnalysis analysis : templatesAnalysis.getAnalysis()) {
            MessageBundleMethodBuildItem messageBundleMethod = (MessageBundleMethodBuildItem)((Object)bundleMethods.get(analysis.id));
            if (messageBundleMethod == null) continue;
            HashSet<String> usedParamNames = new HashSet<String>();
            Set<String> paramNames = messageBundleMethod.hasMethod() ? IntStream.range(0, messageBundleMethod.getMethod().parametersCount()).mapToObj(idx -> MessageBundleProcessor.getParameterName(messageBundleMethod.getMethod(), idx)).collect(Collectors.toSet()) : Set.of();
            for (Expression expression : analysis.expressions) {
                this.validateExpression(incorrectExpressions, messageBundleMethod, expression, paramNames, usedParamNames, globals);
            }
            for (String paramName : paramNames) {
                if (usedParamNames.contains(paramName)) continue;
                LOG.warnf("Unused parameter found [%s] in the message template of: %s", (Object)paramName, (Object)(String.valueOf(messageBundleMethod.getMethod().declaringClass().name()) + "#" + messageBundleMethod.getMethod().name() + "()"));
            }
        }
    }

    private void validateExpression(BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, MessageBundleMethodBuildItem messageBundleMethod, Expression expression, Set<String> paramNames, Set<String> usedParamNames, Set<String> globals) {
        if (expression.isLiteral()) {
            return;
        }
        if (!expression.hasNamespace()) {
            boolean hasDerivedTypeInfo;
            Expression.Part firstPart = (Expression.Part)expression.getParts().get(0);
            String name = firstPart.getName();
            String typeInfo = firstPart.getTypeInfo();
            boolean isGlobal = globals.contains(name);
            boolean isLoopMetadata = typeInfo != null && typeInfo.endsWith("<metadata>");
            boolean bl = hasDerivedTypeInfo = typeInfo != null && !typeInfo.startsWith("|");
            if (!(isGlobal || isLoopMetadata || hasDerivedTypeInfo)) {
                if (typeInfo == null || !paramNames.contains(name)) {
                    incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), name + " is not a parameter of the message bundle method: " + messageBundleMethod.getPathForAnalysis(), expression.getOrigin()));
                } else {
                    usedParamNames.add(name);
                }
            }
        }
        for (Expression.Part part : expression.getParts()) {
            if (!part.isVirtualMethod()) continue;
            for (Expression param : part.asVirtualMethod().getParameters()) {
                this.validateExpression(incorrectExpressions, messageBundleMethod, param, paramNames, usedParamNames, globals);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @BuildStep
    void validateMessageBundleMethodsInTemplates(final TemplatesAnalysisBuildItem analysis, BeanArchiveIndexBuildItem beanArchiveIndex, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> typeCheckExcludeBuildItems, List<MessageBundleBuildItem> messageBundles, List<MessageBundleMethodBuildItem> messageBundleMethods, List<TemplateExpressionMatchesBuildItem> expressionMatches, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ImplicitValueResolverBuildItem> implicitClasses, List<CheckedTemplateBuildItem> checkedTemplates, BeanDiscoveryFinishedBuildItem beanDiscovery, List<TemplateDataBuildItem> templateData, QuteConfig config, List<TemplateGlobalBuildItem> globals) {
        if (messageBundles.isEmpty()) {
            return;
        }
        IndexView index = beanArchiveIndex.getIndex();
        Function<String, String> templateIdToPathFun = new Function<String, String>(){

            @Override
            public String apply(String id) {
                return QuteProcessor.findTemplatePath(analysis, id);
            }
        };
        Map namedBeans = (Map)beanDiscovery.beanStream().withName().collect(Collectors.toMap(BeanInfo::getName, Function.identity()));
        Map<String, TemplateDataBuildItem> namespaceTemplateData = templateData.stream().filter(TemplateDataBuildItem::hasNamespace).collect(Collectors.toMap(TemplateDataBuildItem::getNamespace, Function.identity()));
        Map<String, List<TemplateExtensionMethodBuildItem>> namespaceExtensionMethods = templateExtensionMethods.stream().filter(TemplateExtensionMethodBuildItem::hasNamespace).sorted(Comparator.comparingInt(TemplateExtensionMethodBuildItem::getPriority).reversed()).collect(Collectors.groupingBy(TemplateExtensionMethodBuildItem::getNamespace));
        List<TemplateExtensionMethodBuildItem> regularExtensionMethods = templateExtensionMethods.stream().filter(Predicate.not(TemplateExtensionMethodBuildItem::hasNamespace)).collect(Collectors.toUnmodifiableList());
        QuteProcessor.FixedJavaMemberLookupConfig lookupConfig = new QuteProcessor.FixedJavaMemberLookupConfig(index, QuteProcessor.initDefaultMembersFilter(), false);
        Types.AssignabilityCheck assignabilityCheck = new Types.AssignabilityCheck(index);
        HashMap bundleToMethods = new HashMap();
        for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
            void var26_26;
            Map map = (Map)bundleToMethods.get(messageBundleMethod.getBundleName());
            if (map == null) {
                HashMap hashMap = new HashMap();
                bundleToMethods.put(messageBundleMethod.getBundleName(), hashMap);
            }
            var26_26.put(messageBundleMethod.getKey(), messageBundleMethod.getMethod());
        }
        HashMap<String, ClassInfo> bundlesMap = new HashMap<String, ClassInfo>();
        for (MessageBundleBuildItem messageBundleBuildItem : messageBundles) {
            bundlesMap.put(messageBundleBuildItem.getName(), messageBundleBuildItem.getDefaultBundleInterface());
        }
        for (Map.Entry entry : bundleToMethods.entrySet()) {
            Map<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> expressions = QuteProcessor.collectNamespaceExpressions(analysis, (String)entry.getKey());
            Map methods = (Map)entry.getValue();
            ClassInfo defaultBundleInterface = (ClassInfo)bundlesMap.get(entry.getKey());
            if (expressions.isEmpty()) continue;
            HashMap<DotName, Set<String>> implicitClassToMembersUsed = new HashMap<DotName, Set<String>>();
            for (Map.Entry<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> entry2 : expressions.entrySet()) {
                Object suffix22;
                TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis = entry2.getKey();
                String path = templateAnalysis.path;
                for (Object suffix22 : config.suffixes) {
                    if (!path.endsWith((String)suffix22)) continue;
                    path = path.substring(0, path.length() - (((String)suffix22).length() + 1));
                    break;
                }
                CheckedTemplateBuildItem checkedTemplate = null;
                suffix22 = checkedTemplates.iterator();
                while (suffix22.hasNext()) {
                    CheckedTemplateBuildItem item = (CheckedTemplateBuildItem)((Object)suffix22.next());
                    if (item.isFragment() || !item.templateId.equals(path)) continue;
                    checkedTemplate = item;
                    break;
                }
                Map<Integer, QuteProcessor.MatchResult> generatedIdsToMatches = Collections.emptyMap();
                for (TemplateExpressionMatchesBuildItem templateExpressionMatchesBuildItem : expressionMatches) {
                    if (!templateExpressionMatchesBuildItem.templateGeneratedId.equals(templateAnalysis.generatedId)) continue;
                    generatedIdsToMatches = templateExpressionMatchesBuildItem.getGeneratedIdsToMatches();
                    break;
                }
                for (Expression expression : entry2.getValue()) {
                    Expression.Part methodPart = (Expression.Part)expression.getParts().get(0);
                    if (methodPart.getName().equals(MESSAGE)) continue;
                    MethodInfo method = (MethodInfo)methods.get(methodPart.getName());
                    if (method == null) {
                        if (methods.containsKey(methodPart.getName())) continue;
                        if (!methodPart.isVirtualMethod() || methodPart.asVirtualMethod().getParameters().isEmpty()) {
                            method = defaultBundleInterface.method(methodPart.getName(), new Type[0]);
                        }
                        if (method == null) {
                            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Message bundle [name=" + (String)entry.getKey() + ", interface=" + String.valueOf(defaultBundleInterface) + "] does not define a method for key: " + methodPart.getName(), expression.getOrigin()));
                            continue;
                        }
                    }
                    if (!methodPart.isVirtualMethod()) continue;
                    List params = methodPart.asVirtualMethod().getParameters();
                    List methodParams = method.parameterTypes();
                    if (methodParams.size() != params.size()) {
                        incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Message bundle [name=" + (String)entry.getKey() + ", interface=" + String.valueOf(defaultBundleInterface) + "] - wrong number of parameters for method: " + method.toString(), expression.getOrigin()));
                        continue;
                    }
                    int idx = 0;
                    for (Expression param : params) {
                        if (param.hasTypeInfo()) {
                            HashMap<String, QuteProcessor.MatchResult> results = new HashMap<String, QuteProcessor.MatchResult>();
                            ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> excludes = new ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>>();
                            ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> extensionMethodExcludes = new ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>>();
                            for (TypeCheckExcludeBuildItem exclude : typeCheckExcludeBuildItems) {
                                excludes.add(exclude.getPredicate());
                                if (!exclude.isExtensionMethodPredicate()) continue;
                                extensionMethodExcludes.add(exclude.getPredicate());
                            }
                            QuteProcessor.validateNestedExpressions(config, entry2.getKey(), defaultBundleInterface, results, excludes, incorrectExpressions, expression, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches, extensionMethodExcludes, checkedTemplate, lookupConfig, namedBeans, namespaceTemplateData, regularExtensionMethods, namespaceExtensionMethods, assignabilityCheck, globals);
                            QuteProcessor.MatchResult match = (QuteProcessor.MatchResult)results.get(param.toOriginalString());
                            if (match != null && !match.isEmpty() && !assignabilityCheck.isAssignableFrom(match.type(), (Type)methodParams.get(idx))) {
                                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Message bundle method " + String.valueOf(method.declaringClass().name()) + "#" + method.name() + "() parameter [" + method.parameterName(idx) + "] does not match the type: " + String.valueOf(match.type()), expression.getOrigin()));
                            }
                        } else if (checkedTemplate != null && checkedTemplate.requireTypeSafeExpressions) {
                            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Only type-safe expressions are allowed in the checked template defined via: " + checkedTemplate.getDescription() + "; an expression must be based on a checked template parameter " + String.valueOf(checkedTemplate.bindings.keySet()) + ", or bound via a param declaration, or the requirement must be relaxed via @CheckedTemplate(requireTypeSafeExpressions = false)", expression.getOrigin()));
                        }
                        ++idx;
                    }
                }
            }
            for (Map.Entry<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Object>> entry3 : implicitClassToMembersUsed.entrySet()) {
                ClassInfo clazz;
                if (entry3.getValue().isEmpty() || (clazz = index.getClassByName((DotName)entry3.getKey())) == null) continue;
                implicitClasses.produce((BuildItem)new ImplicitValueResolverBuildItem(clazz, new TemplateDataBuilder().addIgnore(QuteProcessor.buildIgnorePattern((Iterable<String>)entry3.getValue())).build()));
            }
        }
    }

    @BuildStep(onlyIf={IsNormal.class})
    void generateExamplePropertiesFiles(List<MessageBundleMethodBuildItem> messageBundleMethods, BuildSystemTargetBuildItem target, BuildProducer<GeneratedResourceBuildItem> dummy) throws IOException {
        if (messageBundleMethods.isEmpty()) {
            return;
        }
        HashMap<String, ArrayList<MessageBundleMethodBuildItem>> bundles = new HashMap<String, ArrayList<MessageBundleMethodBuildItem>>();
        for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
            if (!messageBundleMethod.isDefaultBundle()) continue;
            ArrayList<MessageBundleMethodBuildItem> methods = (ArrayList<MessageBundleMethodBuildItem>)bundles.get(messageBundleMethod.getBundleName());
            if (methods == null) {
                methods = new ArrayList<MessageBundleMethodBuildItem>();
                bundles.put(messageBundleMethod.getBundleName(), methods);
            }
            methods.add(messageBundleMethod);
        }
        Path generatedExamplesDir = target.getOutputDirectory().resolve("qute-i18n-examples");
        Files.createDirectories(generatedExamplesDir, new FileAttribute[0]);
        for (Map.Entry entry : bundles.entrySet()) {
            List messages = (List)entry.getValue();
            messages.sort(Comparator.comparing(MessageBundleMethodBuildItem::getKey));
            Path exampleProperties = generatedExamplesDir.resolve((String)entry.getKey() + ".properties");
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            for (MessageBundleMethodBuildItem m : messages) {
                if (m.hasMethod()) {
                    if (m.hasGeneratedTemplate()) continue;
                    lines.add((CallSite)((Object)(m.getMethod().name() + "=" + m.getTemplate())));
                    continue;
                }
                lines.add((CallSite)((Object)(m.getKey() + "=" + m.getTemplate())));
            }
            Files.write(exampleProperties, lines, new OpenOption[0]);
        }
    }

    private Map<String, String> generateImplementations(List<MessageBundleBuildItem> bundles, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<MessageBundleMethodBuildItem> messageTemplateMethods, IndexView index) throws IOException {
        HashMap<String, String> generatedTypes = new HashMap<String, String>();
        GeneratedClassGizmoAdaptor defaultClassOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Predicate)new AppClassPredicate());
        for (MessageBundleBuildItem bundle : bundles) {
            ClassInfo bundleInterface = bundle.getDefaultBundleInterface();
            Map<String, String> defaultKeyToMap = this.getLocalizedFileKeyToTemplate(bundle, bundleInterface, bundle.getDefaultLocale(), bundleInterface.methods(), null, index);
            MergeClassInfoWrapper bundleInterfaceWrapper = new MergeClassInfoWrapper(bundleInterface, null, null);
            String bundleImpl = this.generateImplementation(bundle, null, null, bundleInterfaceWrapper, (ClassOutput)defaultClassOutput, messageTemplateMethods, defaultKeyToMap, null, index);
            generatedTypes.put(bundleInterface.name().toString(), bundleImpl);
            for (Map.Entry<String, ClassInfo> entry : bundle.getLocalizedInterfaces().entrySet()) {
                ClassInfo localizedInterface = entry.getValue();
                Map<String, String> keyToMap = this.getLocalizedFileKeyToTemplate(bundle, bundleInterface, entry.getKey(), localizedInterface.methods(), localizedInterface, index);
                MergeClassInfoWrapper localizedInterfaceWrapper = new MergeClassInfoWrapper(localizedInterface, bundleInterface, keyToMap);
                generatedTypes.put(entry.getValue().name().toString(), this.generateImplementation(bundle, bundleInterface, bundleImpl, localizedInterfaceWrapper, (ClassOutput)defaultClassOutput, messageTemplateMethods, keyToMap, null, index));
            }
            for (Map.Entry<String, Object> entry : bundle.getLocalizedFiles().entrySet()) {
                Path localizedFile = (Path)entry.getValue();
                Map<String, String> keyToTemplate = this.parseKeyToTemplateFromLocalizedFile(bundleInterface, localizedFile, index);
                final String locale = entry.getKey();
                GeneratedClassGizmoAdaptor localeAwareGizmoAdaptor = new GeneratedClassGizmoAdaptor(generatedClasses, (Predicate)new AppClassPredicate(new Function<String, String>(){

                    @Override
                    public String apply(String className) {
                        String localeSuffix = "_" + locale;
                        if (className.endsWith(localeSuffix)) {
                            return className.replace(localeSuffix, "");
                        }
                        return className;
                    }
                }));
                generatedTypes.put(localizedFile.toString(), this.generateImplementation(bundle, bundleInterface, bundleImpl, new SimpleClassInfoWrapper(bundleInterface), (ClassOutput)localeAwareGizmoAdaptor, messageTemplateMethods, keyToTemplate, locale, index));
            }
        }
        return generatedTypes;
    }

    private Map<String, String> getLocalizedFileKeyToTemplate(MessageBundleBuildItem bundle, ClassInfo bundleInterface, String locale, List<MethodInfo> methods, ClassInfo localizedInterface, IndexView index) throws IOException {
        Map<String, String> keyToTemplate;
        Path localizedFile = bundle.getMergeCandidates().get(locale);
        if (localizedFile != null && !(keyToTemplate = this.parseKeyToTemplateFromLocalizedFile(bundleInterface, localizedFile, index)).isEmpty()) {
            methods.stream().filter(method -> keyToTemplate.containsKey(method.name())).filter(method -> {
                AnnotationInstance messageAnnotation;
                if (localizedInterface != null) {
                    MethodInfo defaultBundleMethod = localizedInterface.method(method.name(), method.parameterTypes().toArray(new Type[0]));
                    if (defaultBundleMethod == null) {
                        return true;
                    }
                    messageAnnotation = defaultBundleMethod.annotation(Names.MESSAGE);
                } else {
                    messageAnnotation = method.annotation(Names.MESSAGE);
                }
                if (messageAnnotation == null) {
                    messageAnnotation = AnnotationInstance.builder((DotName)Names.MESSAGE).value("<<default value>>").add("name", "<<default>>").build();
                }
                return this.getMessageAnnotationValue(messageAnnotation) != null;
            }).map(MethodInfo::name).forEach(keyToTemplate::remove);
            return keyToTemplate;
        }
        return Collections.emptyMap();
    }

    private Map<String, String> parseKeyToTemplateFromLocalizedFile(ClassInfo bundleInterface, Path localizedFile, IndexView index) throws IOException {
        HashMap<String, String> keyToTemplate = new HashMap<String, String>();
        ListIterator<String> it = Files.readAllLines(localizedFile).listIterator();
        while (it.hasNext()) {
            String line = it.next();
            if (line.isBlank() || (line = line.strip()).startsWith("#")) continue;
            int eqIdx = line.indexOf(61);
            if (eqIdx == -1) {
                throw new MessageBundleException("Missing key/value separator\n\t- file: " + String.valueOf(localizedFile) + "\n\t- line " + it.previousIndex());
            }
            String key = line.substring(0, eqIdx).strip();
            if (!this.hasMessageBundleMethod(bundleInterface, key) && !this.isEnumConstantMessageKey(key, index, bundleInterface)) {
                throw new MessageBundleException("Message bundle method " + key + "() not found on: " + String.valueOf(bundleInterface) + "\n\t- file: " + String.valueOf(localizedFile) + "\n\t- line " + it.previousIndex());
            }
            String value = this.adaptLine(line.substring(eqIdx + 1, line.length()));
            if (value.endsWith("\\")) {
                StringBuilder builder = new StringBuilder(value.substring(0, value.length() - 1));
                this.constructLine(builder, it);
                keyToTemplate.put(key, builder.toString());
                continue;
            }
            keyToTemplate.put(key, value);
        }
        return keyToTemplate;
    }

    boolean isEnumConstantMessageKey(String key, IndexView index, ClassInfo bundleInterface) {
        if (key.isBlank()) {
            return false;
        }
        int lastIdx = key.lastIndexOf("_");
        if (lastIdx != -1 && lastIdx != key.length()) {
            ClassInfo maybeEnum;
            Type paramType;
            String methodName = key.substring(0, lastIdx);
            String constant = key.substring(lastIdx + 1, key.length());
            MethodInfo method = this.messageBundleMethod(bundleInterface, methodName);
            if (method != null && method.parametersCount() == 1 && (paramType = method.parameterType(0)).kind() == Type.Kind.CLASS && (maybeEnum = index.getClassByName(paramType.name())) != null && maybeEnum.isEnum()) {
                if (maybeEnum.fields().stream().filter(FieldInfo::isEnumConstant).map(FieldInfo::name).anyMatch(constant::equals)) {
                    return true;
                }
                throw new MessageBundleException(String.format("%s is not an enum constant of %s: %s", constant, maybeEnum, key));
            }
        }
        return false;
    }

    private void constructLine(StringBuilder builder, Iterator<String> it) {
        if (it.hasNext()) {
            String nextLine = this.adaptLine(it.next());
            if (nextLine.endsWith("\\")) {
                builder.append(nextLine.substring(0, nextLine.length() - 1));
                this.constructLine(builder, it);
            } else {
                builder.append(nextLine);
            }
        }
    }

    private String adaptLine(String line) {
        return line.stripLeading().replace("\\n", "\n");
    }

    private boolean hasMessageBundleMethod(ClassInfo bundleInterface, String name) {
        return this.messageBundleMethod(bundleInterface, name) != null;
    }

    private MethodInfo messageBundleMethod(ClassInfo bundleInterface, String name) {
        for (MethodInfo method : bundleInterface.methods()) {
            if (!method.name().equals(name)) continue;
            return method;
        }
        return null;
    }

    private String generateImplementation(MessageBundleBuildItem bundle, ClassInfo defaultBundleInterface, String defaultBundleImpl, ClassInfoWrapper bundleInterfaceWrapper, ClassOutput classOutput, BuildProducer<MessageBundleMethodBuildItem> messageTemplateMethods, Map<String, String> messageTemplates, String locale, IndexView index) {
        ClassInfo bundleInterface = bundleInterfaceWrapper.getClassInfo();
        LOG.debugf("Generate bundle implementation for %s", (Object)bundleInterface);
        AnnotationInstance bundleAnnotation = defaultBundleInterface != null ? defaultBundleInterface.declaredAnnotation(Names.BUNDLE) : bundleInterface.declaredAnnotation(Names.BUNDLE);
        String bundleName = bundle.getName();
        AnnotationValue defaultKeyValue = bundleAnnotation.value(BUNDLE_DEFAULT_KEY);
        Object baseName = bundleInterface.enclosingClass() != null ? DotNames.simpleName((DotName)bundleInterface.enclosingClass()) + "$_" + DotNames.simpleName((ClassInfo)bundleInterface) : DotNames.simpleName((ClassInfo)bundleInterface);
        if (locale != null) {
            baseName = (String)baseName + "_" + locale;
        }
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)bundleInterface.name());
        String generatedName = targetPackage + (String)baseName + SUFFIX;
        ClassCreator.Builder builder = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new String[]{bundleInterface.name().toString(), Resolver.class.getName()});
        if (defaultBundleImpl != null) {
            builder.superClass(defaultBundleImpl);
        }
        ClassCreator bundleCreator = builder.build();
        LinkedHashMap<String, MessageMethod> keyMap = new LinkedHashMap<String, MessageMethod>();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>(bundleInterfaceWrapper.methods());
        methods.sort(Comparator.comparing(MethodInfo::name).thenComparing(Comparator.comparing(MethodInfo::toString)));
        for (MethodInfo method : methods) {
            List paramTypes;
            ClassInfo maybeEnum;
            Type paramType;
            String key;
            AnnotationInstance messageAnnotation;
            if (!method.returnType().name().equals((Object)DotNames.STRING)) {
                throw new MessageBundleException(String.format("A message bundle method must return java.lang.String: %s#%s", bundleInterface, method.name()));
            }
            LOG.debugf("Found message bundle method %s on %s", (Object)method, (Object)bundleInterface);
            MethodCreator bundleMethod = bundleCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)method));
            if (defaultBundleInterface != null) {
                MethodInfo defaultBundleMethod = bundleInterfaceWrapper.method(method.name(), method.parameterTypes().toArray(new Type[0]));
                if (defaultBundleMethod == null) {
                    throw new MessageBundleException(String.format("Default bundle method not found on %s: %s", bundleInterface, method));
                }
                messageAnnotation = defaultBundleMethod.annotation(Names.MESSAGE);
            } else {
                messageAnnotation = method.annotation(Names.MESSAGE);
            }
            if (messageAnnotation == null) {
                LOG.debugf("@Message not declared on %s#%s - using the default key/value", (Object)bundleInterface, (Object)method);
                messageAnnotation = AnnotationInstance.builder((DotName)Names.MESSAGE).value("<<default value>>").add("name", "<<default>>").build();
            }
            if ((key = this.getKey(method, messageAnnotation, defaultKeyValue)).equals(MESSAGE)) {
                throw new MessageBundleException(String.format("A message bundle interface method must not use the key 'message' which is reserved for dynamic lookup; defined for %s#%s()", bundleInterface, method.name()));
            }
            if (keyMap.containsKey(key)) {
                throw new MessageBundleException(String.format("Duplicate key [%s] found on %s", key, bundleInterface));
            }
            keyMap.put(key, new SimpleMessageMethod(method));
            boolean generatedTemplate = false;
            String messageTemplate = messageTemplates.get(method.name());
            if (messageTemplate == null) {
                messageTemplate = this.getMessageAnnotationValue(messageAnnotation);
            }
            if (messageTemplate == null && defaultBundleInterface != null) {
                messageTemplate = this.getMessageAnnotationValue(defaultBundleInterface.method(method.name(), method.parameterTypes().toArray(new Type[0])).annotation(Names.MESSAGE));
            }
            if (messageTemplate == null && method.parametersCount() == 1 && (paramType = method.parameterType(0)).kind() == Type.Kind.CLASS && (maybeEnum = index.getClassByName(paramType.name())) != null && maybeEnum.isEnum()) {
                StringBuilder generatedMessageTemplate = new StringBuilder("{#when ").append(MessageBundleProcessor.getParameterName(method, 0)).append("}");
                Set enumConstants = maybeEnum.fields().stream().filter(FieldInfo::isEnumConstant).map(FieldInfo::name).collect(Collectors.toSet());
                for (String enumConstant : enumConstants) {
                    String enumConstantKey = this.toEnumConstantKey(method.name(), enumConstant);
                    String enumConstantTemplate = messageTemplates.get(enumConstantKey);
                    if (enumConstantTemplate == null) {
                        throw new TemplateException(String.format("Enum constant message not found in bundle [%s] for key: %s", bundleName + (String)(locale != null ? "_" + locale : ""), enumConstantKey));
                    }
                    generatedMessageTemplate.append("{#is ").append(enumConstant).append("}{").append(bundle.getName()).append(":").append(enumConstantKey).append("}");
                    this.generateEnumConstantMessageMethod(bundleCreator, bundleName, locale, bundleInterface, defaultBundleInterface, enumConstantKey, keyMap, enumConstantTemplate, messageTemplateMethods);
                }
                generatedMessageTemplate.append("{/when}");
                messageTemplate = generatedMessageTemplate.toString();
                generatedTemplate = true;
            }
            if (messageTemplate == null) {
                throw new MessageBundleException(String.format("Message template for key [%s] is missing for default locale [%s]", key, bundle.getDefaultLocale()));
            }
            String templateId = null;
            if (messageTemplate.contains("}")) {
                if (defaultBundleInterface != null) {
                    if (locale == null) {
                        AnnotationInstance localizedAnnotation = bundleInterface.declaredAnnotation(Names.LOCALIZED);
                        locale = localizedAnnotation.value().asString();
                    }
                    templateId = bundleName + "_" + locale + "_" + key;
                } else {
                    templateId = bundleName + "_" + key;
                }
            }
            MessageBundleMethodBuildItem messageBundleMethod = new MessageBundleMethodBuildItem(bundleName, key, templateId, method, messageTemplate, defaultBundleInterface == null, generatedTemplate);
            messageTemplateMethods.produce((BuildItem)messageBundleMethod);
            if (!messageBundleMethod.isValidatable()) {
                bundleMethod.returnValue(bundleMethod.load(messageTemplate));
                continue;
            }
            ResultHandle template = bundleMethod.invokeStaticMethod(Descriptors.BUNDLES_GET_TEMPLATE, new ResultHandle[]{bundleMethod.load(templateId)});
            ResultHandle templateInstance = bundleMethod.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE, template, new ResultHandle[0]);
            if (locale != null) {
                bundleMethod.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"setLocale", TemplateInstance.class, (Class[])new Class[]{String.class}), templateInstance, new ResultHandle[]{bundleMethod.load(locale)});
            }
            if (!(paramTypes = method.parameterTypes()).isEmpty()) {
                int i = 0;
                Iterator it = paramTypes.iterator();
                while (it.hasNext()) {
                    String name = MessageBundleProcessor.getParameterName(method, i);
                    bundleMethod.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE_DATA, templateInstance, new ResultHandle[]{bundleMethod.load(name), bundleMethod.getMethodParam(i)});
                    ++i;
                    it.next();
                }
            }
            bundleMethod.returnValue(bundleMethod.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE_RENDER, templateInstance, new ResultHandle[0]));
        }
        this.implementResolve(defaultBundleImpl, bundleCreator, keyMap);
        bundleCreator.close();
        return generatedName.replace('/', '.');
    }

    private String toEnumConstantKey(String methodName, String enumConstant) {
        return methodName + "_" + enumConstant;
    }

    private void generateEnumConstantMessageMethod(ClassCreator bundleCreator, String bundleName, String locale, ClassInfo bundleInterface, ClassInfo defaultBundleInterface, String enumConstantKey, Map<String, MessageMethod> keyMap, String messageTemplate, BuildProducer<MessageBundleMethodBuildItem> messageTemplateMethods) {
        String templateId = null;
        if (messageTemplate.contains("}")) {
            if (defaultBundleInterface != null) {
                if (locale == null) {
                    AnnotationInstance localizedAnnotation = bundleInterface.declaredAnnotation(Names.LOCALIZED);
                    locale = localizedAnnotation.value().asString();
                }
                templateId = bundleName + "_" + locale + "_" + enumConstantKey;
            } else {
                templateId = bundleName + "_" + enumConstantKey;
            }
        }
        MessageBundleMethodBuildItem messageBundleMethod = new MessageBundleMethodBuildItem(bundleName, enumConstantKey, templateId, null, messageTemplate, defaultBundleInterface == null, true);
        messageTemplateMethods.produce((BuildItem)messageBundleMethod);
        MethodCreator enumConstantMethod = bundleCreator.getMethodCreator(enumConstantKey, String.class, new Class[0]);
        if (!messageBundleMethod.isValidatable()) {
            enumConstantMethod.returnValue(enumConstantMethod.load(messageTemplate));
        } else {
            ResultHandle template = enumConstantMethod.invokeStaticMethod(Descriptors.BUNDLES_GET_TEMPLATE, new ResultHandle[]{enumConstantMethod.load(templateId)});
            ResultHandle templateInstance = enumConstantMethod.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE, template, new ResultHandle[0]);
            if (locale != null) {
                enumConstantMethod.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"setLocale", TemplateInstance.class, (Class[])new Class[]{String.class}), templateInstance, new ResultHandle[]{enumConstantMethod.load(locale)});
            }
            enumConstantMethod.returnValue(enumConstantMethod.invokeInterfaceMethod(Descriptors.TEMPLATE_INSTANCE_RENDER, templateInstance, new ResultHandle[0]));
        }
        keyMap.put(enumConstantKey, new EnumConstantMessageMethod(enumConstantMethod.getMethodDescriptor()));
    }

    private String getMessageAnnotationValue(AnnotationInstance messageAnnotation) {
        AnnotationValue messageValue = messageAnnotation.value();
        if (messageValue == null || messageValue.asString().equals("<<default value>>")) {
            return null;
        }
        return messageValue.asString();
    }

    static String getParameterName(MethodInfo method, int position) {
        AnnotationValue paramAnnotationValue;
        String name = method.parameterName(position);
        AnnotationInstance paramAnnotation = Annotations.find((Collection)Annotations.getParameterAnnotations((Collection)method.annotations()).stream().filter(a -> a.target().asMethodParameter().position() == position).collect(Collectors.toList()), (DotName)Names.MESSAGE_PARAM);
        if (paramAnnotation != null && (paramAnnotationValue = paramAnnotation.value()) != null && !paramAnnotationValue.asString().equals("<<element name>>")) {
            name = paramAnnotationValue.asString();
        }
        if (name == null) {
            throw new MessageBundleException("Unable to determine the name of the parameter at position " + position + " in method " + String.valueOf(method.declaringClass().name()) + "#" + method.name() + "() - compile the class with debug info enabled (-g) or parameter names recorded (-parameters), or use @MessageParam to specify the value");
        }
        return name;
    }

    private void implementResolve(String defaultBundleImpl, ClassCreator bundleCreator, Map<String, MessageMethod> keyMap) {
        MethodCreator resolve = bundleCreator.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class});
        String resolveMethodPrefix = bundleCreator.getClassName().contains("/") ? bundleCreator.getClassName().substring(bundleCreator.getClassName().lastIndexOf(47) + 1) : bundleCreator.getClassName();
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle name = resolve.invokeInterfaceMethod(io.quarkus.qute.generator.Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        ResultHandle ret = resolve.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
        BytecodeCreator dynamicMessage = resolve.ifTrue(Gizmo.equals((BytecodeCreator)resolve, (ResultHandle)resolve.load(MESSAGE), (ResultHandle)name)).trueBranch();
        ResultHandle evaluatedMessageKey = dynamicMessage.invokeStaticMethod(io.quarkus.qute.generator.Descriptors.EVALUATED_PARAMS_EVALUATE_MESSAGE_KEY, new ResultHandle[]{evalContext});
        ResultHandle paramsReady = dynamicMessage.readInstanceField(io.quarkus.qute.generator.Descriptors.EVALUATED_PARAMS_STAGE, evaluatedMessageKey);
        FunctionCreator whenCompleteFun = dynamicMessage.createFunction(BiConsumer.class);
        dynamicMessage.invokeInterfaceMethod(io.quarkus.qute.generator.Descriptors.CF_WHEN_COMPLETE, paramsReady, new ResultHandle[]{whenCompleteFun.getInstance()});
        BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
        AssignableResultHandle whenThis = whenComplete.createVariable(DescriptorUtils.extToInt((String)bundleCreator.getClassName()));
        whenComplete.assign(whenThis, dynamicMessage.getThis());
        AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
        whenComplete.assign(whenRet, ret);
        AssignableResultHandle whenEvalContext = whenComplete.createVariable(EvalContext.class);
        whenComplete.assign(whenEvalContext, evalContext);
        BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
        BytecodeCreator success = throwableIsNull.trueBranch();
        ResultHandle resultNotFound = success.invokeStaticMethod(io.quarkus.qute.generator.Descriptors.NOT_FOUND_FROM_EC, new ResultHandle[]{whenEvalContext});
        BytecodeCreator nameIsNull = success.ifNull(whenComplete.getMethodParam(0)).trueBranch();
        nameIsNull.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{resultNotFound});
        nameIsNull.returnValue(null);
        BytecodeCreator nameNotFound = success.ifTrue(Gizmo.equals((BytecodeCreator)success, (ResultHandle)whenComplete.getMethodParam(0), (ResultHandle)resultNotFound)).trueBranch();
        nameNotFound.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{resultNotFound});
        nameNotFound.returnValue(null);
        ResultHandle evaluatedMessageParams = success.invokeStaticMethod(io.quarkus.qute.generator.Descriptors.EVALUATED_PARAMS_EVALUATE_MESSAGE_PARAMS, new ResultHandle[]{whenEvalContext});
        ResultHandle res0Ret = success.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bundleCreator.getClassName(), (String)(resolveMethodPrefix + "_resolve_0"), CompletableFuture.class, (Object[])new Object[]{String.class, EvaluatedParams.class, CompletableFuture.class}), (ResultHandle)whenThis, new ResultHandle[]{whenComplete.getMethodParam(0), evaluatedMessageParams, whenRet});
        BytecodeCreator ret0Null = success.ifNull(res0Ret).trueBranch();
        ret0Null.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{resultNotFound});
        BytecodeCreator failure = throwableIsNull.falseBranch();
        failure.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
        whenComplete.returnValue(null);
        dynamicMessage.returnValue(ret);
        ResultHandle evaluatedParams = resolve.invokeStaticMethod(io.quarkus.qute.generator.Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{evalContext});
        int groupLimit = 300;
        int groupIndex = 0;
        int resolveIndex = 0;
        MethodCreator resolveGroup = null;
        for (Map.Entry<String, MessageMethod> entry : keyMap.entrySet()) {
            if (resolveGroup == null || groupIndex++ >= 300) {
                groupIndex = 0;
                String resolveMethodName = resolveMethodPrefix + "_resolve_" + resolveIndex++;
                if (resolveGroup != null) {
                    resolveGroup.returnValue(resolveGroup.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bundleCreator.getClassName(), (String)resolveMethodName, CompletableFuture.class, (Object[])new Object[]{String.class, EvaluatedParams.class, CompletableFuture.class}), resolveGroup.getThis(), new ResultHandle[]{resolveGroup.getMethodParam(0), resolveGroup.getMethodParam(1), resolveGroup.getMethodParam(2)}));
                }
                resolveGroup = (MethodCreator)bundleCreator.getMethodCreator(resolveMethodName, CompletableFuture.class, new Class[]{String.class, EvaluatedParams.class, CompletableFuture.class}).setModifiers(0);
                if (resolveIndex == 1) {
                    ResultHandle resRet = resolve.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bundleCreator.getClassName(), (String)resolveMethodName, CompletableFuture.class, (Object[])new Object[]{String.class, EvaluatedParams.class, CompletableFuture.class}), resolve.getThis(), new ResultHandle[]{name, evaluatedParams, ret});
                    resolve.ifNotNull(resRet).trueBranch().returnValue(resRet);
                }
            }
            this.addMessageMethod(resolveGroup, entry.getKey(), entry.getValue(), resolveGroup.getMethodParam(0), resolveGroup.getMethodParam(1), resolveGroup.getMethodParam(2), bundleCreator.getClassName());
        }
        if (resolveGroup != null) {
            resolveGroup.returnValue(resolveGroup.loadNull());
        }
        if (defaultBundleImpl != null) {
            resolve.returnValue(resolve.invokeSpecialMethod(MethodDescriptor.ofMethod((Object)defaultBundleImpl, (String)"resolve", CompletionStage.class, (Object[])new Object[]{EvalContext.class}), resolve.getThis(), new ResultHandle[]{evalContext}));
        } else {
            resolve.returnValue(resolve.invokeStaticMethod(io.quarkus.qute.generator.Descriptors.RESULTS_NOT_FOUND_EC, new ResultHandle[]{evalContext}));
        }
    }

    private void addMessageMethod(MethodCreator resolve, String key, MessageMethod method, ResultHandle name, ResultHandle evaluatedParams, ResultHandle ret, String bundleClass) {
        List<Type> methodParams = method.parameterTypes();
        BytecodeCreator matched = resolve.ifTrue(Gizmo.equals((BytecodeCreator)resolve, (ResultHandle)resolve.load(key), (ResultHandle)name)).trueBranch();
        if (methodParams.isEmpty()) {
            matched.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE, ret, new ResultHandle[]{method.isMessageBundleInterfaceMethod() ? matched.invokeInterfaceMethod(method.descriptor(), matched.getThis(), new ResultHandle[0]) : matched.invokeVirtualMethod(method.descriptor(), matched.getThis(), new ResultHandle[0])});
            matched.returnValue(ret);
        } else {
            ResultHandle paramsReady = matched.readInstanceField(io.quarkus.qute.generator.Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParams);
            FunctionCreator whenCompleteFun = matched.createFunction(BiConsumer.class);
            matched.invokeInterfaceMethod(io.quarkus.qute.generator.Descriptors.CF_WHEN_COMPLETE, paramsReady, new ResultHandle[]{whenCompleteFun.getInstance()});
            BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
            AssignableResultHandle whenThis = whenComplete.createVariable(DescriptorUtils.extToInt((String)bundleClass));
            whenComplete.assign(whenThis, matched.getThis());
            AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
            whenComplete.assign(whenRet, ret);
            BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
            BytecodeCreator success = throwableIsNull.trueBranch();
            ResultHandle[] paramsHandle = new ResultHandle[methodParams.size()];
            if (methodParams.size() == 1) {
                paramsHandle[0] = whenComplete.getMethodParam(0);
            } else {
                for (int i = 0; i < methodParams.size(); ++i) {
                    paramsHandle[i] = success.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.EVALUATED_PARAMS_GET_RESULT, evaluatedParams, new ResultHandle[]{success.load(i)});
                }
            }
            AssignableResultHandle invokeRet = success.createVariable(Object.class);
            TryBlock tryCatch = success.tryBlock();
            CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
            exception.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
            tryCatch.assign(invokeRet, method.isMessageBundleInterfaceMethod() ? tryCatch.invokeInterfaceMethod(method.descriptor(), (ResultHandle)whenThis, paramsHandle) : tryCatch.invokeVirtualMethod(method.descriptor(), (ResultHandle)whenThis, paramsHandle));
            tryCatch.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
            BytecodeCreator failure = throwableIsNull.falseBranch();
            failure.invokeVirtualMethod(io.quarkus.qute.generator.Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
            whenComplete.returnValue(null);
            matched.returnValue(ret);
        }
    }

    private String getKey(final MethodInfo method, AnnotationInstance messageAnnotation, AnnotationValue defaultKeyValue) {
        AnnotationValue keyValue = messageAnnotation.value("key");
        String key = keyValue == null ? (defaultKeyValue != null ? defaultKeyValue.asString() : "<<element name>>") : keyValue.asString();
        switch (key) {
            case "<<element name>>": {
                return method.name();
            }
            case "<<hyphenated element name>>": {
                return StringUtil.hyphenate((String)method.name());
            }
            case "<<underscored element name>>": {
                return String.join((CharSequence)"_", (Iterable<? extends CharSequence>)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)method.name()));
                    }
                });
            }
        }
        return keyValue.asString();
    }

    private String getDefaultLocale(AnnotationInstance bundleAnnotation, LocalesBuildTimeConfig locales) {
        AnnotationValue localeValue = bundleAnnotation.value(BUNDLE_LOCALE);
        String defaultLocale = localeValue == null || localeValue.asString().equals("<<default locale>>") ? locales.defaultLocale.toLanguageTag() : localeValue.asString();
        return defaultLocale;
    }

    private List<Path> findMessageFiles(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) throws IOException {
        HashMap messageFileNameToPath = new HashMap();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            archive.accept(tree -> {
                Path messagesPath = tree.getPath(MESSAGES);
                if (messagesPath == null) {
                    return;
                }
                try (Stream<Path> files = Files.list(messagesPath);){
                    Iterator iter = files.iterator();
                    while (iter.hasNext()) {
                        ArrayList<Path> paths;
                        Path filePath = (Path)iter.next();
                        if (!Files.isRegularFile(filePath, new LinkOption[0])) continue;
                        String messageFileName = messagesPath.relativize(filePath).toString();
                        if (File.separatorChar != '/') {
                            messageFileName = messageFileName.replace(File.separatorChar, '/');
                        }
                        if ((paths = (ArrayList<Path>)messageFileNameToPath.get(messageFileName)) == null) {
                            paths = new ArrayList<Path>();
                            messageFileNameToPath.put(messageFileName, paths);
                        }
                        paths.add(filePath);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        if (messageFileNameToPath.isEmpty()) {
            return Collections.emptyList();
        }
        List duplicates = messageFileNameToPath.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            StringBuilder builder = new StringBuilder("Duplicate localized files found:");
            for (Map.Entry e2 : duplicates) {
                builder.append("\n\t- ").append((String)e2.getKey()).append(": ").append(e2.getValue());
            }
            throw new IllegalStateException(builder.toString());
        }
        for (String messageFileName : messageFileNameToPath.keySet()) {
            watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("messages/" + messageFileName));
        }
        ArrayList<Path> messageFiles = new ArrayList<Path>();
        messageFileNameToPath.values().forEach(messageFiles::addAll);
        return messageFiles;
    }

    private static class AppClassPredicate
    implements Predicate<String> {
        private final Function<String, String> additionalClassNameSanitizer;

        public AppClassPredicate() {
            this(Function.identity());
        }

        public AppClassPredicate(Function<String, String> additionalClassNameSanitizer) {
            this.additionalClassNameSanitizer = additionalClassNameSanitizer;
        }

        @Override
        public boolean test(String name) {
            int idx = name.lastIndexOf(MessageBundleProcessor.SUFFIX);
            String className = name.substring(0, idx).replace("/", ".");
            if (className.contains("$_")) {
                className = className.replace("$_", "$");
            }
            className = this.additionalClassNameSanitizer.apply(className);
            return GeneratedClassGizmoAdaptor.isApplicationClass((String)className);
        }
    }

    private static class MergeClassInfoWrapper
    implements ClassInfoWrapper {
        private final ClassInfo classInfo;
        private final ClassInfo interfaceClassInfo;
        private final Map<String, MethodInfo> interfaceKeyToMethodInfo;

        MergeClassInfoWrapper(ClassInfo classInfo, ClassInfo interfaceClassInfo, Map<String, String> localizedFileKeyToTemplate) {
            this.classInfo = classInfo;
            this.interfaceClassInfo = interfaceClassInfo;
            if (interfaceClassInfo != null && localizedFileKeyToTemplate != null) {
                List classInfoMethods = classInfo.methods();
                this.interfaceKeyToMethodInfo = interfaceClassInfo.methods().stream().filter(method -> localizedFileKeyToTemplate.containsKey(method.name())).filter(method -> classInfoMethods.stream().noneMatch(m -> m.name().equals(method.name()))).collect(Collectors.toMap(MethodInfo::name, Function.identity()));
            } else {
                this.interfaceKeyToMethodInfo = Collections.emptyMap();
            }
        }

        @Override
        public ClassInfo getClassInfo() {
            return this.classInfo;
        }

        @Override
        public final List<MethodInfo> methods() {
            return Stream.concat(this.interfaceKeyToMethodInfo.values().stream(), this.classInfo.methods().stream()).collect(Collectors.toCollection(ArrayList::new));
        }

        @Override
        public final MethodInfo method(String name, Type ... parameters) {
            if (this.interfaceKeyToMethodInfo.containsKey(name)) {
                return this.interfaceClassInfo.method(name, parameters);
            }
            return this.classInfo.method(name, parameters);
        }
    }

    private static interface ClassInfoWrapper {
        public ClassInfo getClassInfo();

        public List<MethodInfo> methods();

        public MethodInfo method(String var1, Type ... var2);
    }

    private static class SimpleClassInfoWrapper
    implements ClassInfoWrapper {
        private final ClassInfo classInfo;

        SimpleClassInfoWrapper(ClassInfo classInfo) {
            this.classInfo = classInfo;
        }

        @Override
        public ClassInfo getClassInfo() {
            return this.classInfo;
        }

        @Override
        public final List<MethodInfo> methods() {
            return this.classInfo.methods();
        }

        @Override
        public final MethodInfo method(String name, Type ... parameters) {
            return this.classInfo.method(name, parameters);
        }
    }

    static class SimpleMessageMethod
    implements MessageMethod {
        final MethodInfo method;

        SimpleMessageMethod(MethodInfo method) {
            this.method = method;
        }

        @Override
        public List<Type> parameterTypes() {
            return this.method.parameterTypes();
        }

        @Override
        public MethodDescriptor descriptor() {
            return MethodDescriptor.of((MethodInfo)this.method);
        }
    }

    static class EnumConstantMessageMethod
    implements MessageMethod {
        final MethodDescriptor descriptor;

        EnumConstantMessageMethod(MethodDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public List<Type> parameterTypes() {
            return List.of();
        }

        @Override
        public MethodDescriptor descriptor() {
            return this.descriptor;
        }

        @Override
        public boolean isMessageBundleInterfaceMethod() {
            return false;
        }
    }

    static interface MessageMethod {
        public List<Type> parameterTypes();

        public MethodDescriptor descriptor();

        default public boolean isMessageBundleInterfaceMethod() {
            return true;
        }
    }
}

